/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.converters.UConverter;
import com.adobe.agl.converters.UErrorCode;
import com.adobe.agl.impl.AliasesEnumeration;
import com.adobe.agl.impl.ICUData;
import com.adobe.agl.impl.UConverterAliasDataReader;
import com.adobe.agl.impl.UConverterUtility;
import com.adobe.agl.impl.UDataMemory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class UConverterAlias {
    public static final int UCNV_AMBIGUOUS_ALIAS_MAP_BIT = 32768;
    public static final int UCNV_CONVERTER_INDEX_MASK = 4095;
    public static final int UCNV_NUM_RESERVED_TAGS = 2;
    public static final int UCNV_NUM_HIDDEN_TAGS = 1;
    static int[] gConverterListArray = null;
    static int gConverterListArrayIndex;
    static int[] gTagListArray;
    static int gTagListArrayIndex;
    static int[] gAliasListArray;
    static int gAliasListArrayIndex;
    static int[] gUntaggedConvArrayArray;
    static int gUntaggedConvArrayArrayIndex;
    static int[] gTaggedAliasArrayArray;
    static int gTaggedAliasArrayArrayIndex;
    static int[] gTaggedAliasListsArray;
    static int gTaggedAliasListsArrayIndex;
    static byte[] gStringTableArray;
    static int gStringTableArrayIndex;
    static long gConverterListSize;
    static long gTagListSize;
    static long gAliasListSize;
    static long gUntaggedConvArraySize;
    static long gTaggedAliasArraySize;
    static long gTaggedAliasListsSize;
    static long gStringTableSize;
    static String[] gAvailableConverters;
    static int gAvailableConverterCount;
    static byte[] gDefaultConverterNameBuffer;
    static String gDefaultConverterName;
    public static final int tocLengthIndex = 0;
    public static final int converterListIndex = 1;
    public static final int tagListIndex = 2;
    public static final int aliasListIndex = 3;
    public static final int untaggedConvArrayIndex = 4;
    public static final int taggedAliasArrayIndex = 5;
    public static final int taggedAliasListsIndex = 6;
    public static final int reservedIndex1 = 7;
    public static final int stringTableIndex = 8;
    public static final int minTocLength = 8;
    public static final int offsetsCount = 9;
    static UDataMemory gAliasData;
    private static final String CNVALIAS_DATA_FILE_NAME = "data/icudt32b/cnvalias.icu";
    private static final int CNVALIAS_DATA_BUFFER_SIZE = 25000;

    static final String GET_STRING(int idx) {
        return new String(gStringTableArray, 2 * idx, UConverterUtility.uprv_strlen(gStringTableArray, 2 * idx));
    }

    private static final boolean isAlias(String alias, int[] pErrorCode) {
        if (alias == null) {
            pErrorCode[0] = 1;
            return false;
        }
        return alias.length() != 0;
    }

    private static final boolean haveAliasData(int[] pErrorCode) {
        boolean haveData;
        if (pErrorCode == null || UErrorCode.U_FAILURE(pErrorCode[0])) {
            return false;
        }
        boolean bl = haveData = gAliasData == null;
        if (haveData) {
            UDataMemory data = null;
            long[] tableArray = null;
            byte[] reservedBytes = null;
            try {
                InputStream i = ICUData.getRequiredStream(CNVALIAS_DATA_FILE_NAME);
                BufferedInputStream b = new BufferedInputStream(i, 25000);
                UConverterAliasDataReader reader = new UConverterAliasDataReader(b);
                tableArray = reader.readToc(9);
                long tableStart = tableArray[0];
                if (tableStart < 8L) {
                    pErrorCode[0] = 3;
                    return false;
                }
                gConverterListSize = tableArray[1];
                gTagListSize = tableArray[2];
                gAliasListSize = tableArray[3];
                gUntaggedConvArraySize = tableArray[4];
                gTaggedAliasArraySize = tableArray[5];
                gTaggedAliasListsSize = tableArray[6];
                long reservedSize1 = tableArray[7] * 2L;
                gStringTableSize = tableArray[8] * 2L;
                gConverterListArray = new int[(int)gConverterListSize];
                gTagListArray = new int[(int)gTagListSize];
                gAliasListArray = new int[(int)gAliasListSize];
                gUntaggedConvArrayArray = new int[(int)gUntaggedConvArraySize];
                gTaggedAliasArrayArray = new int[(int)gTaggedAliasArraySize];
                gTaggedAliasListsArray = new int[(int)gTaggedAliasListsSize];
                reservedBytes = new byte[(int)reservedSize1];
                gStringTableArray = new byte[(int)gStringTableSize];
                reader.read(gConverterListArray, gTagListArray, gAliasListArray, gUntaggedConvArrayArray, gTaggedAliasArrayArray, gTaggedAliasListsArray, reservedBytes, gStringTableArray);
            }
            catch (IOException e) {
                System.err.println("Caught IOException: " + e.getMessage());
                pErrorCode[0] = 3;
            }
            if (UErrorCode.U_FAILURE(pErrorCode[0])) {
                return false;
            }
            data = new UDataMemory();
            if (gAliasData == null) {
                gAliasData = data;
                data = null;
            }
            if (data != null) {
                // empty if block
            }
        }
        return true;
    }

    public static final String ucnv_io_getConverterName(String alias, int[] pErrorCode) {
        long convNum;
        if (UConverterAlias.haveAliasData(pErrorCode) && UConverterAlias.isAlias(alias, pErrorCode) && (convNum = UConverterAlias.findConverter(alias, pErrorCode)) < gConverterListSize) {
            return UConverterAlias.GET_STRING(gConverterListArray[(int)convNum]);
        }
        return null;
    }

    private static final long findConverter(String alias, int[] pErrorCode) {
        long limit;
        long start = 0L;
        long mid = limit = gUntaggedConvArraySize;
        long lastMid = 0xFFFFFFFFL;
        while (lastMid != (mid = (start + limit) / 2L)) {
            lastMid = mid;
            long result = UConverterAlias.ucnv_compareNames(alias, UConverterAlias.GET_STRING(gAliasListArray[(int)mid]));
            if (result < 0L) {
                limit = mid;
                continue;
            }
            if (result > 0L) {
                start = mid;
                continue;
            }
            if ((gUntaggedConvArrayArray[(int)mid] & 0x8000) != 0) {
                pErrorCode[0] = -122;
            }
            return gUntaggedConvArrayArray[(int)mid] & 0xFFF;
        }
        return 0xFFFFFFFFL;
    }

    public static final StringBuffer ucnv_io_stripForCompare(StringBuffer dst, String name) {
        return UConverterAlias.ucnv_io_stripASCIIForCompare(dst, name);
    }

    static final StringBuffer ucnv_io_stripASCIIForCompare(StringBuffer dst, String name) {
        name = name.concat("\u0000");
        int nameIndex = 0;
        char c1 = name.charAt(0);
        int dstItr = 0;
        while (c1 != '\u0000') {
            while ((c1 = name.charAt(nameIndex)) == '-' || c1 == '_' || c1 == ' ') {
                ++nameIndex;
            }
            dst.append(UConverterUtility.uprv_asciitolower(c1));
            ++dstItr;
            ++nameIndex;
        }
        if (dst.length() > 0) {
            dst.deleteCharAt(dst.length() - 1);
        }
        return dst;
    }

    public static final int ucnv_compareNames(String name1_, String name2_) {
        String name1 = name1_.concat("\u0000");
        String name2 = name2_.concat("\u0000");
        int name1idx = 0;
        int name2idx = 0;
        while (true) {
            char c2;
            char c1;
            if ((c1 = name1.charAt(name1idx)) == '-' || c1 == '_' || c1 == ' ') {
                ++name1idx;
                continue;
            }
            while ((c2 = name2.charAt(name2idx)) == '-' || c2 == '_' || c2 == ' ') {
                ++name2idx;
            }
            if (c1 == '\u0000' && c2 == '\u0000') {
                return 0;
            }
            int rc = UConverterUtility.uprv_tolower(c1) - UConverterUtility.uprv_tolower(c2);
            if (rc != 0) {
                return rc;
            }
            ++name1idx;
            ++name2idx;
        }
    }

    public static final String ucnv_io_getDefaultConverterName() {
        String name = gDefaultConverterName;
        if (name == null) {
            int[] errorCode = new int[]{0};
            UConverter cnv = null;
            long length = 0L;
            name = UConverterUtility.uprv_getDefaultCodepage();
            if (name != null) {
                cnv = UConverter.ucnv_open(name, errorCode);
                if (UErrorCode.U_SUCCESS(errorCode[0]) && cnv != null) {
                    name = UConverter.ucnv_getName(cnv, errorCode);
                }
            }
            if (name == null || name.length() == 0 || UErrorCode.U_FAILURE(errorCode[0]) || cnv == null || length >= (long)gDefaultConverterNameBuffer.length) {
                name = new String("US-ASCII");
            }
            name = gDefaultConverterName;
            cnv.ucnv_close();
        }
        return name;
    }

    public static int ucnv_io_countAliases(String alias, int[] pErrorCode) {
        int listOffset;
        long convNum;
        if (UConverterAlias.haveAliasData(pErrorCode) && UConverterAlias.isAlias(alias, pErrorCode) && (convNum = UConverterAlias.findConverter(alias, pErrorCode)) < gConverterListSize && (listOffset = gTaggedAliasArrayArray[(int)((gTagListSize - 1L) * gConverterListSize + convNum)]) != 0) {
            return gTaggedAliasListsArray[listOffset];
        }
        return 0;
    }

    public static int ucnv_io_countAvailableAliases(int[] pErrorCode) {
        if (UConverterAlias.haveAliasData(pErrorCode)) {
            return (int)gAliasListSize;
        }
        return 0;
    }

    public static int ucnv_io_countAvailableConverters(int[] pErrorCode) {
        if (UConverterAlias.haveAvailableConverterList(pErrorCode)) {
            return gAvailableConverterCount;
        }
        return 0;
    }

    static boolean haveAvailableConverterList(int[] pErrorCode) {
        if (gAvailableConverters == null) {
            int[] status = new int[1];
            if (!UConverterAlias.haveAliasData(pErrorCode)) {
                return false;
            }
            String[] localConverterList = new String[(int)gConverterListSize];
            if (localConverterList == null) {
                pErrorCode[0] = 7;
                return false;
            }
            int localConverterCount = 0;
            int idx = 0;
            while ((long)idx < gConverterListSize) {
                status[0] = 0;
                String converterName = UConverterAlias.GET_STRING(gConverterListArray[idx]);
                UConverter cnv = UConverter.ucnv_open(converterName, status);
                if (UErrorCode.U_SUCCESS(status[0])) {
                    cnv.ucnv_close();
                    localConverterList[localConverterCount++] = converterName;
                }
                ++idx;
            }
            if (gAvailableConverters == null) {
                gAvailableConverters = localConverterList;
                gAvailableConverterCount = localConverterCount;
            }
        }
        return true;
    }

    public static String ucnv_io_getAlias(String alias, int n, int[] pErrorCode) {
        int listOffset;
        long convNum;
        if (UConverterAlias.haveAliasData(pErrorCode) && UConverterAlias.isAlias(alias, pErrorCode) && (convNum = UConverterAlias.findConverter(alias, pErrorCode)) < gConverterListSize && (listOffset = gTaggedAliasArrayArray[(int)((gTagListSize - 1L) * gConverterListSize + convNum)]) != 0) {
            long listCount = gTaggedAliasListsArray[listOffset];
            int[] currListArray = gTaggedAliasListsArray;
            int currListArrayIndex = listOffset + 1;
            if ((long)n < listCount) {
                return UConverterAlias.GET_STRING(currListArray[currListArrayIndex + n]);
            }
            pErrorCode[0] = 8;
        }
        return null;
    }

    public static String ucnv_io_getAvailableConverter(int n, int[] pErrorCode) {
        if (UConverterAlias.haveAvailableConverterList(pErrorCode)) {
            if (n < gAvailableConverterCount) {
                return gAvailableConverters[n];
            }
            pErrorCode[0] = 8;
        }
        return null;
    }

    public static int ucnv_io_countStandards(int[] pErrorCode) {
        if (UConverterAlias.haveAliasData(pErrorCode)) {
            return (int)(gTagListSize - 1L);
        }
        return 0;
    }

    public static String ucnv_io_getStandard(int n, int[] pErrorCode) {
        if (UConverterAlias.haveAliasData(pErrorCode)) {
            if ((long)n < gTagListSize - 1L) {
                return UConverterAlias.GET_STRING(gTagListArray[n]);
            }
            pErrorCode[0] = 8;
        }
        return null;
    }

    public static final String ucnv_io_getStandardName(String alias, String standard, int[] pErrorCode) {
        long listOffset;
        if (UConverterAlias.haveAliasData(pErrorCode) && UConverterAlias.isAlias(alias, pErrorCode) && 0L < (listOffset = UConverterAlias.findTaggedAliasListsOffset(alias, standard, pErrorCode)) && listOffset < gTaggedAliasListsSize) {
            int[] currListArray = gTaggedAliasListsArray;
            long currListArrayIndex = listOffset + 1L;
            if (currListArray[0] != 0) {
                return UConverterAlias.GET_STRING(currListArray[(int)currListArrayIndex]);
            }
        }
        return null;
    }

    public static final AliasesEnumeration ucnv_io_openStandardNames(String convName, String standard, int[] pErrorCode) {
        long listOffset;
        AliasesEnumeration aliasesEnumeration = null;
        if (UConverterAlias.haveAliasData(pErrorCode) && UConverterAlias.isAlias(convName, pErrorCode) && (listOffset = UConverterAlias.findTaggedAliasListsOffset(convName, standard, pErrorCode)) < gTaggedAliasListsSize) {
            AliasesEnumeration.UAliasContext context = new AliasesEnumeration.UAliasContext(listOffset, 0L);
            aliasesEnumeration = new AliasesEnumeration();
            aliasesEnumeration.setContext(context);
        }
        return aliasesEnumeration;
    }

    private static long getTagNumber(String tagName) {
        if (gTagListArray != null) {
            for (long tagNum = 0L; tagNum < gTagListSize; ++tagNum) {
                if (!tagName.equals(UConverterAlias.GET_STRING(gTagListArray[(int)tagNum]))) continue;
                return tagNum;
            }
        }
        return 0xFFFFFFFFL;
    }

    private static long findTaggedAliasListsOffset(String alias, String standard, int[] pErrorCode) {
        int[] myErr = new int[]{0};
        long tagNum = UConverterAlias.getTagNumber(standard);
        long convNum = UConverterAlias.findConverter(alias, myErr);
        if (myErr[0] != 0) {
            pErrorCode = myErr;
        }
        if (tagNum < gTagListSize - 1L && convNum < gConverterListSize) {
            long listOffset = gTaggedAliasArrayArray[(int)(tagNum * gConverterListSize + convNum)];
            if (listOffset != 0L && gTaggedAliasListsArray[(int)listOffset + 1] != 0) {
                return listOffset;
            }
            if (myErr[0] == -122) {
                for (long idx = 0L; idx < gTaggedAliasArraySize; ++idx) {
                    long currTagNum;
                    long currConvNum;
                    long tempListOffset;
                    listOffset = gTaggedAliasArrayArray[(int)idx];
                    if (listOffset == 0L || !UConverterAlias.isAliasInList(alias, listOffset) || (tempListOffset = (long)gTaggedAliasArrayArray[(int)(tagNum * gConverterListSize + (currConvNum = idx - (currTagNum = idx / gConverterListSize) * gConverterListSize))]) == 0L || gTaggedAliasListsArray[(int)tempListOffset + 1] == 0) continue;
                    return tempListOffset;
                }
            }
            return 0L;
        }
        return 0xFFFFFFFFL;
    }

    private static boolean isAliasInList(String alias, long listOffset) {
        if (listOffset != 0L) {
            long listCount = gTaggedAliasListsArray[(int)listOffset];
            int[] currList = gTaggedAliasListsArray;
            long currListArrayIndex = listOffset + 1L;
            for (long currAlias = 0L; currAlias < listCount; ++currAlias) {
                if (currList[(int)(currAlias + currListArrayIndex)] == 0 || UConverterAlias.ucnv_compareNames(alias, UConverterAlias.GET_STRING(currList[(int)(currAlias + currListArrayIndex)])) != 0) continue;
                return true;
            }
        }
        return false;
    }

    static {
        gTagListArray = null;
        gAliasListArray = null;
        gUntaggedConvArrayArray = null;
        gTaggedAliasArrayArray = null;
        gTaggedAliasListsArray = null;
        gStringTableArray = null;
        gAvailableConverters = null;
        gAvailableConverterCount = 0;
        gDefaultConverterName = null;
        gAliasData = null;
    }
}

