/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.Mapping;
import flex2.compiler.util.NSStack;
import flex2.compiler.util.QName;
import flex2.compiler.util.UTF8Encoder;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;

public class XMLStringSerializer {
    private Writer writer;
    private boolean writingStartTag = false;
    private boolean noNamespaceMappings = true;
    private Stack elementStack = new Stack();
    private NSStack nsStack = null;
    private int lastPrefixIndex = 1;
    private UTF8Encoder encoder;
    public static final String NS_PREFIX_SOAP_ENV = "soapenv";
    public static final String NS_PREFIX_SOAP_ENC = "soapenc";
    public static final String NS_PREFIX_SCHEMA_XSI = "xsi";
    public static final String NS_PREFIX_SCHEMA_XSD = "xsd";
    public static final String NS_PREFIX_WSDL = "wsdl";
    public static final String NS_PREFIX_WSDL_SOAP = "wsdlsoap";
    public static final String NS_PREFIX_XMLSOAP = "apachesoap";
    public static final String NS_PREFIX_XML = "xml";
    public static final String NS_URI_XML = "http://www.w3.org/XML/1998/namespace";
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String URI_SOAP11_ENC = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String URI_1999_SCHEMA_XSD = "http://www.w3.org/1999/XMLSchema";
    public static final String URI_1999_SCHEMA_XSI = "http://www.w3.org/1999/XMLSchema-instance";
    public static final String URI_2000_SCHEMA_XSD = "http://www.w3.org/2000/10/XMLSchema";
    public static final String URI_2000_SCHEMA_XSI = "http://www.w3.org/2000/10/XMLSchema-instance";
    public static final String URI_2001_SCHEMA_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String URI_2001_SCHEMA_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_TYPE_ATTR_NAME = "type";
    public static final String URI_SOAP11_ENV = "http://schemas.xmlsoap.org/soap/envelope/";
    HashMap preferredPrefixes = new HashMap();

    public XMLStringSerializer(Writer writer) {
        this.writer = writer;
        this.initialize();
    }

    private void initialize() {
        this.preferredPrefixes.put(URI_SOAP11_ENC, NS_PREFIX_SOAP_ENC);
        this.preferredPrefixes.put(NS_URI_XML, NS_PREFIX_XML);
        this.preferredPrefixes.put(URI_1999_SCHEMA_XSD, NS_PREFIX_SCHEMA_XSD);
        this.preferredPrefixes.put(URI_1999_SCHEMA_XSI, NS_PREFIX_SCHEMA_XSI);
        this.preferredPrefixes.put(URI_2000_SCHEMA_XSD, NS_PREFIX_SCHEMA_XSD);
        this.preferredPrefixes.put(URI_2000_SCHEMA_XSI, NS_PREFIX_SCHEMA_XSI);
        this.preferredPrefixes.put(URI_2001_SCHEMA_XSD, NS_PREFIX_SCHEMA_XSD);
        this.preferredPrefixes.put(URI_2001_SCHEMA_XSI, NS_PREFIX_SCHEMA_XSI);
        this.preferredPrefixes.put(URI_SOAP11_ENV, NS_PREFIX_SOAP_ENV);
        this.nsStack = new NSStack(false);
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null, false);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        return this.getPrefixForURI(uri, defaultPrefix, false);
    }

    public String getPrefixForURI(String uri, String defaultPrefix, boolean attribute) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = this.nsStack.getPrefix(uri, attribute);
        if (prefix == null) {
            prefix = (String)this.preferredPrefixes.get(uri);
            if (prefix == null) {
                if (defaultPrefix == null) {
                    prefix = "ns" + this.lastPrefixIndex++;
                    while (this.nsStack.getNamespaceURI(prefix) != null) {
                        prefix = "ns" + this.lastPrefixIndex++;
                    }
                } else {
                    prefix = defaultPrefix;
                }
            }
            this.registerPrefixForURI(prefix, uri);
        }
        return prefix;
    }

    public void registerPrefixForURI(String prefix, String uri) {
        if (uri != null && prefix != null) {
            String activePrefix;
            if (this.noNamespaceMappings) {
                this.nsStack.push();
                this.noNamespaceMappings = false;
            }
            if ((activePrefix = this.nsStack.getPrefix(uri, true)) == null || !activePrefix.equals(prefix)) {
                this.nsStack.add(uri, prefix);
            }
        }
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        ArrayList<String> vecQNames = null;
        if (this.writingStartTag) {
            this.writer.write(62);
        }
        String elementQName = this.qName2String(qName, true);
        this.writer.write(60);
        this.writer.write(elementQName);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String qname = attributes.getQName(i);
                this.writer.write(32);
                String prefix = "";
                String uri = attributes.getURI(i);
                if (uri != null && uri.length() > 0) {
                    if (qname.length() == 0) {
                        prefix = this.getPrefixForURI(uri);
                    } else {
                        int idx = qname.indexOf(58);
                        if (idx > -1) {
                            prefix = qname.substring(0, idx);
                            prefix = this.getPrefixForURI(uri, prefix, true);
                        }
                    }
                    qname = prefix.length() > 0 ? prefix + ':' + attributes.getLocalName(i) : attributes.getLocalName(i);
                } else {
                    qname = attributes.getQName(i);
                    if (qname.length() == 0) {
                        qname = attributes.getLocalName(i);
                    }
                }
                if (qname.startsWith("xmlns")) {
                    if (vecQNames == null) {
                        vecQNames = new ArrayList<String>();
                    }
                    vecQNames.add(qname);
                }
                this.writer.write(qname);
                this.writer.write("=\"");
                this.getEncoder().writeEncoded(this.writer, attributes.getValue(i));
                this.writer.write(34);
            }
        }
        if (this.noNamespaceMappings) {
            this.nsStack.push();
        } else {
            Mapping map = this.nsStack.topOfFrame();
            while (map != null) {
                if (!(map.getNamespaceURI().equals(NS_URI_XMLNS) && map.getPrefix().equals("xmlns") || map.getNamespaceURI().equals(NS_URI_XML) && map.getPrefix().equals(NS_PREFIX_XML))) {
                    StringBuffer sb = new StringBuffer("xmlns");
                    if (map.getPrefix().length() > 0) {
                        sb.append(':');
                        sb.append(map.getPrefix());
                    }
                    if (vecQNames == null || vecQNames.indexOf(sb.toString()) == -1) {
                        this.writer.write(32);
                        sb.append("=\"");
                        sb.append(map.getNamespaceURI());
                        sb.append('\"');
                        this.writer.write(sb.toString());
                    }
                }
                map = this.nsStack.next();
            }
            this.noNamespaceMappings = true;
        }
        this.writingStartTag = true;
        this.elementStack.push(elementQName);
    }

    public UTF8Encoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new UTF8Encoder();
        }
        return this.encoder;
    }

    public void writeString(String string) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writer.write(string);
    }

    public void endElement() throws IOException {
        String elementQName = (String)this.elementStack.pop();
        this.nsStack.pop();
        if (this.writingStartTag) {
            this.writer.write("/>");
            this.writingStartTag = false;
            return;
        }
        this.writer.write("</");
        this.writer.write(elementQName);
        this.writer.write(62);
    }

    public static String getLastLocalPart(String localPart) {
        int anonymousDelimitorIndex = localPart.lastIndexOf(62);
        if (anonymousDelimitorIndex > -1 && anonymousDelimitorIndex < localPart.length() - 1) {
            localPart = localPart.substring(anonymousDelimitorIndex + 1);
        }
        return localPart;
    }

    public String qName2String(QName qName, boolean writeNS) {
        String prefix = null;
        String namespaceURI = qName.getNamespace();
        String localPart = qName.getLocalPart();
        if (localPart != null && localPart.length() > 0) {
            int index = localPart.indexOf(58);
            if (index != -1) {
                prefix = localPart.substring(0, index);
                if (prefix.length() > 0 && !prefix.equals("urn")) {
                    this.registerPrefixForURI(prefix, namespaceURI);
                    localPart = localPart.substring(index + 1);
                } else {
                    prefix = null;
                }
            }
            localPart = XMLStringSerializer.getLastLocalPart(localPart);
        }
        if (namespaceURI.length() == 0) {
            String defaultNS;
            if (writeNS && (defaultNS = this.nsStack.getNamespaceURI("")) != null && defaultNS.length() > 0) {
                this.registerPrefixForURI("", "");
            }
        } else {
            prefix = this.getPrefixForURI(namespaceURI, qName.getPreferredPrefix());
        }
        if (prefix == null || prefix.length() == 0) {
            return localPart;
        }
        return prefix + ':' + localPart;
    }
}

