/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.events;

import flex.webtier.server.j2ee.events.BaseOutputHandler;
import flex.webtier.server.j2ee.events.CompileEvent;
import flex.webtier.server.j2ee.events.SourceCodeLoader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.servlet.ServletException;

public class HtmlOutputHandler
extends BaseOutputHandler {
    protected PrintWriter out;
    private int uniqueIdValue = 0;
    protected String webRoot;
    private boolean showAllWarnings;

    public HtmlOutputHandler(String mxmlFileName, String webRoot, PrintWriter out, Vector events, boolean showAllWarnings, SourceCodeLoader sourceCodeLoader) {
        super(mxmlFileName, webRoot, events, sourceCodeLoader);
        this.out = out;
        this.webRoot = webRoot;
        this.showAllWarnings = showAllWarnings;
    }

    protected String alignRight(int number, int width) {
        StringBuffer result = new StringBuffer();
        String value = String.valueOf(number);
        if ((width -= value.length()) < 0) {
            width = 0;
        }
        while (width-- > 0) {
            result.append(" ");
        }
        result.append(value);
        return result.toString();
    }

    protected String entitize(String s) {
        StringBuffer stringBuffer = null;
        if (s == null) {
            return null;
        }
        stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block5;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block5;
                }
                default: {
                    stringBuffer.append(s.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private String emitCollapsibleText(PrintWriter out, String text, String caption) {
        String id = new String("Hidden_" + this.uniqueId());
        out.print(" <a href=\"javascript:;\" onMouseOver=\"window.status='Click to expand';return true;\"");
        out.print("onMouseOut=\"window.status='';return true;\" ");
        out.print("onClick=\"showHide('" + id + "');return true;\">" + caption + "</a>");
        out.print("<table width=\"500\" cellpadding=\"0\" cellspacing=\"0\">");
        out.print("   <tr><td valign=\"top\">");
        out.print("    </td></tr>\n<td id='" + id + "' style=\"display:none\">");
        out.print("<pre>");
        out.print(text);
        out.print("</pre></td>");
        out.print(" </tr>");
        out.print("</table>");
        return id;
    }

    protected void emitError(CompileEvent ce, PrintWriter out) {
        String desc = ce.description;
        desc = this.quoteLeadingSpaces(this.entitize(desc));
        String lineRef = ce.line == 0 ? "" : ":" + ce.line;
        out.println("<span class='header'>" + ce.getEventTypeName() + " <span class='reference'>" + this.normalizePath(ce.path) + lineRef + "</span></span>");
        out.println("<div class='indent'>" + desc + "<br>");
        if (this.keepGeneratedAS && ce.asPath != null) {
            out.println("at <span class='reference'>" + this.normalizePath(ce.asPath) + ":" + ce.asLine + "</span><br>&nbsp;");
        }
        out.println("<br></div>");
        if (ce.sourceSnippet != null) {
            out.print("<div class='indent'><table class='code'>");
            for (int j = 0; j < ce.sourceSnippet.lines.length; ++j) {
                String srcLine = ce.sourceSnippet.lines[j];
                if (srcLine != null) {
                    out.print("<tr><td align='right' valign='top'>" + this.alignRight(ce.sourceSnippet.startingLine + j, 4) + ":</td><td>");
                    String formattedLine = this.quoteLeadingSpaces(this.expandTabs(this.entitize(srcLine)));
                    if (ce.sourceSnippet.startingLine + j == ce.line) {
                        out.print("<span class='highlight'>" + formattedLine + "</span>");
                    } else {
                        out.println(formattedLine);
                    }
                }
                out.println("</td></tr>");
            }
            out.print("</table></div>");
        }
        out.println("<br>");
    }

    protected void emitException(Throwable throwable, PrintWriter out) {
        String msg;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String desc = throwable.toString();
        int pos = desc.indexOf(":");
        if (pos > -1) {
            desc = desc.substring(0, pos);
        }
        if ((msg = throwable.getMessage()) == null) {
            msg = "";
        }
        msg = this.quoteLeadingSpaces(this.entitize(msg));
        out.println("Exception <span class='reference'>" + desc + "</span>");
        out.println("<div class='indent'>" + msg);
        if (this.showStacktrace) {
            Throwable rootCause;
            throwable.printStackTrace(pw);
            pos = sw.toString().indexOf(10);
            String stackTrace = sw.toString().substring(pos + 1);
            if (throwable instanceof ServletException && (rootCause = ((ServletException)throwable).getRootCause()) != null) {
                pw.flush();
                sw.flush();
                desc = rootCause.toString();
                pos = desc.indexOf(":");
                if (pos > -1) {
                    desc = desc.substring(0, pos);
                }
                if ((msg = throwable.getMessage()) == null) {
                    msg = "";
                }
                String header = "<br>&nbsp;<br>Root Cause Exception <span class='reference'>" + desc + "</span><br><div class='indent'>" + this.quoteLeadingSpaces(this.entitize(msg)) + "<br>";
                rootCause.printStackTrace(pw);
                pos = sw.toString().indexOf(10);
                String tmp = "<pre>" + this.entitize(sw.toString().substring(pos + 1)) + "</pre></div>";
                stackTrace = stackTrace + header + tmp;
            }
            this.emitCollapsibleText(out, stackTrace, "(View stack trace)");
        }
        out.println("</div><br>");
    }

    protected String expandTabs(String s) {
        StringBuffer result = new StringBuffer();
        int column = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                column = 0;
            }
            if (c == '\t') {
                int curCol = column;
                column = column + 4 & 0xFFFFFFFC;
                while (curCol != column) {
                    ++curCol;
                    result.append(" ");
                }
                continue;
            }
            result.append(c);
            ++column;
        }
        return result.toString();
    }

    protected String normalizePath(String path) {
        int i = 0;
        if (path == null || path.equals(this.defaultPath)) {
            path = this.sourceFileName;
        }
        if (path.startsWith(this.webRoot)) {
            if (this.webRoot.endsWith("/") || this.webRoot.endsWith("\\")) {
                i = 1;
            }
            path = path.substring(this.webRoot.length() - i).replace('\\', '/');
        }
        return path;
    }

    protected String quoteLeadingSpaces(String s) {
        boolean leadingWhiteSpace = true;
        if (s != null) {
            StringBuffer stringbuffer = new StringBuffer(s.length());
            block4: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\n': {
                        leadingWhiteSpace = true;
                        stringbuffer.append("<br>");
                        continue block4;
                    }
                    case ' ': {
                        if (leadingWhiteSpace) {
                            stringbuffer.append("&nbsp;");
                            continue block4;
                        }
                        stringbuffer.append(c);
                        continue block4;
                    }
                    default: {
                        stringbuffer.append(c);
                        leadingWhiteSpace = false;
                    }
                }
            }
            s = stringbuffer.toString();
        }
        return s;
    }

    public void outputEvents() {
        this.out.println("<span class='title'>Compilation Results</span>");
        this.out.println("<br>");
        this.out.println("&nbsp;");
        this.out.println("<br>");
        this.out.println("Errors, warnings or exceptions were found while compiling <span class='reference'>" + this.entitize(this.normalizePath(this.sourceFileName)) + "</span>.");
        this.out.println("Visit the online Flex <a href=\"http://www.adobe.com/go/flex2_apps\">documentation</a> or <a href=\"http://www.adobe.com/go/flex2_reference\">API reference</a> for further information.");
        this.out.println("<br>&nbsp;<br>");
        this.out.println("<hr>");
        this.out.println("<br>");
        StringWriter deprecatedBuffer = new StringWriter(4096);
        PrintWriter deprecatedWriter = new PrintWriter(deprecatedBuffer);
        StringWriter errorBuffer = new StringWriter(4096);
        PrintWriter errorWriter = new PrintWriter(errorBuffer);
        for (int i = 0; i < this.events.size(); ++i) {
            CompileEvent ce = (CompileEvent)this.events.get(i);
            if (ce.eventType == 3) {
                this.emitException(ce.exception, errorWriter);
                continue;
            }
            if (this.showAllWarnings && this.isDeprecatedWarning(ce)) {
                this.emitError(ce, deprecatedWriter);
                continue;
            }
            if (this.showAllWarnings && this.isWarning(ce)) {
                this.emitError(ce, errorWriter);
                continue;
            }
            this.emitError(ce, errorWriter);
        }
        deprecatedWriter.flush();
        errorWriter.flush();
        String deprecatedText = deprecatedBuffer.toString();
        if (deprecatedText != null && deprecatedText.length() > 0) {
            this.out.print("Deprecated features were used in this application.");
            this.emitCollapsibleText(this.out, deprecatedText, " Click here to see the list of deprecated features.<br>");
        }
        this.out.println("<br>");
        this.out.println(this.summary());
        this.out.println("<br>&nbsp;<br>");
        String errorText = errorBuffer.toString();
        this.out.print(errorText);
        this.out.println("<br>&nbsp;<br>");
        this.out.println("<br><hr><br>");
    }

    public String summary() {
        int[] arr = new int[4];
        String[] names = new String[4];
        StringBuffer buf = new StringBuffer();
        int totalEvents = this.events.size();
        CompileEvent ce = null;
        for (int i = 0; i < this.events.size(); ++i) {
            ce = (CompileEvent)this.events.get(i);
            if (!this.showAllWarnings || !this.isDeprecatedWarning(ce)) {
                int n = ce.eventType;
                arr[n] = arr[n] + 1;
                names[ce.eventType] = ce.getEventTypeName();
                continue;
            }
            --totalEvents;
        }
        boolean eventReported = false;
        for (int i = 0; i < 4; ++i) {
            if (arr[i] <= 0) continue;
            eventReported = true;
            buf.append(arr[i]);
            buf.append(" ");
            buf.append(names[i]);
            if (arr[i] > 1) {
                buf.append("s");
            }
            if ((totalEvents -= arr[i]) <= 0) continue;
            buf.append(", ");
        }
        if (eventReported) {
            buf.append(" found.");
        }
        return buf.toString();
    }

    public boolean isDeprecatedWarning(CompileEvent ce) {
        return ce.eventType == 2 && (ce.code == 2000 || ce.code == 1999);
    }

    public boolean isWarning(CompileEvent ce) {
        return ce.eventType == 2;
    }

    private int uniqueId() {
        return this.uniqueIdValue++;
    }
}

