/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.CScan;
import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.EmbeddingPermission;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.StemFinder;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.TTScan;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.CFFScaler;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.opentype.Base;
import com.adobe.fontengine.font.opentype.Cff;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.Cvt;
import com.adobe.fontengine.font.opentype.Fpgm;
import com.adobe.fontengine.font.opentype.Gasp;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.Glyf;
import com.adobe.fontengine.font.opentype.GlyfRaw;
import com.adobe.fontengine.font.opentype.GlyphNames;
import com.adobe.fontengine.font.opentype.Gpos;
import com.adobe.fontengine.font.opentype.Gsub;
import com.adobe.fontengine.font.opentype.Head;
import com.adobe.fontengine.font.opentype.Hhea;
import com.adobe.fontengine.font.opentype.Hmtx;
import com.adobe.fontengine.font.opentype.HmtxRaw;
import com.adobe.fontengine.font.opentype.Kern;
import com.adobe.fontengine.font.opentype.LocaRaw;
import com.adobe.fontengine.font.opentype.Ltsh;
import com.adobe.fontengine.font.opentype.Maxp;
import com.adobe.fontengine.font.opentype.Name;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OTSubset;
import com.adobe.fontengine.font.opentype.OpticalSizeData;
import com.adobe.fontengine.font.opentype.Orientation;
import com.adobe.fontengine.font.opentype.Os2;
import com.adobe.fontengine.font.opentype.Post;
import com.adobe.fontengine.font.opentype.Prep;
import com.adobe.fontengine.font.opentype.TTParser;
import com.adobe.fontengine.font.opentype.TTScaler;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.font.opentype.TrueTypeGlyphBBoxCalculator;
import com.adobe.fontengine.font.opentype.Vhea;
import com.adobe.fontengine.font.opentype.Vmtx;
import com.adobe.fontengine.font.opentype.VmtxRaw;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class OpenTypeFont
extends FontData {
    public final Head head;
    public final Hhea hhea;
    public final Hmtx hmtx;
    public final Maxp maxp;
    public final Name name;
    public final Os2 os2;
    public final Cmap cmap;
    public final Post post;
    public final Gpos gpos;
    public final Gsub gsub;
    public final Gdef gdef;
    public final Base base;
    public final Glyf glyf;
    public final Cff cff;
    public final Vhea vhea;
    public final Vmtx vmtx;
    public final Cvt cvt;
    public final Fpgm fpgm;
    public final Prep prep;
    public final Kern kern;
    public final Gasp gasp;
    public final Ltsh ltsh;
    private final Object invertedcmapMutex = new Object();
    private boolean invertedcmapHasBeenComputed = false;
    private int[] invertedcmap;
    private final String base14CSSName;
    private final String base14PSName;
    private final OTXDCFontDescription xdcDescription;

    public OpenTypeFont(Map map, byte[] byArray, String string, String string2) throws InvalidFontException, UnsupportedFontException {
        super(byArray);
        this.base14CSSName = string;
        this.base14PSName = string2;
        this.head = (Head)map.get(new Integer(1751474532));
        this.hhea = (Hhea)map.get(new Integer(1751672161));
        this.maxp = (Maxp)map.get(new Integer(1835104368));
        this.name = (Name)map.get(new Integer(1851878757));
        this.os2 = (Os2)map.get(new Integer(1330851634));
        this.cmap = (Cmap)map.get(new Integer(1668112752));
        this.post = (Post)map.get(new Integer(1886352244));
        this.cff = (Cff)map.get(new Integer(1128678944));
        this.gpos = (Gpos)map.get(new Integer(1196445523));
        this.gsub = (Gsub)map.get(new Integer(1196643650));
        this.gdef = (Gdef)map.get(new Integer(1195656518));
        this.base = (Base)map.get(new Integer(1111577413));
        this.vhea = (Vhea)map.get(new Integer(1986553185));
        this.cvt = (Cvt)map.get(new Integer(1668707360));
        this.fpgm = (Fpgm)map.get(new Integer(1718642541));
        this.prep = (Prep)map.get(new Integer(1886545264));
        this.kern = (Kern)map.get(new Integer(1801810542));
        this.gasp = (Gasp)map.get(new Integer(1734439792));
        this.ltsh = (Ltsh)map.get(new Integer(1280594760));
        Table table = (HmtxRaw)map.get(new Integer(1752003704));
        this.hmtx = table != null && this.hhea != null ? new Hmtx((HmtxRaw)table, this.hhea.getNumberOfHMetrics()) : null;
        table = (VmtxRaw)map.get(new Integer(1986884728));
        this.vmtx = table != null && this.vhea != null ? new Vmtx((VmtxRaw)table, this.vhea.getNumberOfVMetrics()) : null;
        table = (GlyfRaw)map.get(new Integer(1735162214));
        LocaRaw locaRaw = (LocaRaw)map.get(new Integer(1819239265));
        this.glyf = table != null && locaRaw != null && this.head != null ? new Glyf((GlyfRaw)table, locaRaw, this.head.getIndexToLocFormat()) : null;
        this.xdcDescription = new OTXDCFontDescription();
    }

    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException {
        if (this.cmap != null) {
            return this.cmap.isSymbolic();
        }
        return true;
    }

    public int getNumGlyphs() throws InvalidFontException {
        if (this.maxp == null) {
            throw new InvalidFontException("required table (maxp) is missing");
        }
        return this.maxp.getNumGlyphs();
    }

    public double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException {
        if (this.head != null) {
            return this.head.getUnitsPerEm();
        }
        throw new InvalidFontException("No way to know units per em");
    }

    public double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException {
        if (this.head != null) {
            return this.head.getUnitsPerEm();
        }
        throw new InvalidFontException("No way to know units per em");
    }

    public double getCoolTypeUnitsPerEm() throws UnsupportedFontException, InvalidFontException {
        if (this.head != null) {
            return this.head.getUnitsPerEm();
        }
        if (this.glyf != null) {
            return 2048.0;
        }
        return 1000.0;
    }

    public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
        if (this.head != null) {
            return this.head.getFontBBox();
        }
        throw new InvalidFontException("No bbox in font");
    }

    public Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException {
        if (this.cff != null) {
            return this.cff.getFontBBox();
        }
        return this.getFontBBox();
    }

    private CoolTypeScript computeCoolTypeScriptFromCmapSubtables() throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            return null;
        }
        ScriptFromCmapSelector scriptFromCmapSelector = new ScriptFromCmapSelector();
        this.cmap.enumerateCmaps(scriptFromCmapSelector);
        return scriptFromCmapSelector.getScript();
    }

    private CoolTypeScript computeCoolTypeScriptFromOs2CodePage(CoolTypeScript coolTypeScript, int n) throws InvalidFontException, UnsupportedFontException {
        int n2;
        if (this.os2 != null) {
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1250_LATIN_2_EE)) {
                ++n;
                if (coolTypeScript == null) {
                    coolTypeScript = CoolTypeScript.ROMAN;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1251_CYRILLIC) || this.os2.supportsCodePage(Os2.CodePage.CP_866_MSDOS_RUSSIAN) || this.os2.supportsCodePage(Os2.CodePage.CP_855_IBM_CYRILLIC)) {
                ++n;
                if (coolTypeScript == null) {
                    coolTypeScript = CoolTypeScript.CYRILLIC;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1253_GREEK) || this.os2.supportsCodePage(Os2.CodePage.CP_869_IBM_GREEK) || this.os2.supportsCodePage(Os2.CodePage.CP_737_GREEK)) {
                ++n;
                if (coolTypeScript == null) {
                    coolTypeScript = CoolTypeScript.ROMAN;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1255_HEBREW) || this.os2.supportsCodePage(Os2.CodePage.CP_862_HEBREW)) {
                ++n;
                if (coolTypeScript == null) {
                    coolTypeScript = CoolTypeScript.HEBREW;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1256_ARABIC) || this.os2.supportsCodePage(Os2.CodePage.CP_864_ARABIC) || this.os2.supportsCodePage(Os2.CodePage.CP_708_ARABIC)) {
                ++n;
                if (coolTypeScript == null) {
                    coolTypeScript = CoolTypeScript.ARABIC;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_874_THAI)) {
                ++n;
                if (coolTypeScript == null) {
                    coolTypeScript = CoolTypeScript.THAI;
                }
            }
            if (this.os2.supportsCodePage(Os2.CodePage.CP_1252_LATIN_1) || this.os2.supportsCodePage(Os2.CodePage.CP_863_MSDOS_CANADIAN) || this.os2.supportsCodePage(Os2.CodePage.CP_861_MSDOS_ICELANDIC) || this.os2.supportsCodePage(Os2.CodePage.CP_860_MSDOS_PORTUGUESE) || this.os2.supportsCodePage(Os2.CodePage.CP_852_LATIN_2) || this.os2.supportsCodePage(Os2.CodePage.CP_850_WE_LATIN_1) || this.os2.supportsCodePage(Os2.CodePage.CP_437_US)) {
                ++n;
                if (coolTypeScript == null) {
                    coolTypeScript = CoolTypeScript.ROMAN;
                }
            }
        }
        if (coolTypeScript != null && n > 1 && (n2 = this.getCoolTypeUnicodeCmapIndex()) != -1 && !this.computeCoolTypeCmapSupportsScript(coolTypeScript, n2)) {
            return null;
        }
        return coolTypeScript;
    }

    private CoolTypeScript computeCoolTypeScriptFromOs2CodePageNotNameKeyed() throws InvalidFontException, UnsupportedFontException {
        if (this.os2 == null) {
            return null;
        }
        CoolTypeScript coolTypeScript = null;
        int n = 0;
        if (this.os2.supportsCodePage(Os2.CodePage.CP_949_KOREAN_WANSUNG) || this.os2.supportsCodePage(Os2.CodePage.CP_1361_KOREAN_JOHAB)) {
            ++n;
            if (coolTypeScript == null) {
                coolTypeScript = CoolTypeScript.KOREAN;
            }
        }
        if (this.os2.supportsCodePage(Os2.CodePage.CP_932_JAPANESE)) {
            ++n;
            if (coolTypeScript == null) {
                coolTypeScript = CoolTypeScript.JAPANESE;
            }
        }
        if (this.os2.supportsCodePage(Os2.CodePage.CP_936_CHINESE_SIMPLIFIED)) {
            ++n;
            if (coolTypeScript == null) {
                coolTypeScript = CoolTypeScript.SIMPLIFIED_CHINESE;
            }
        }
        if (this.os2.supportsCodePage(Os2.CodePage.CP_950_CHINESE_TRADITIONAL)) {
            ++n;
            if (coolTypeScript == null) {
                coolTypeScript = CoolTypeScript.TRADITIONAL_CHINESE;
            }
        }
        return this.computeCoolTypeScriptFromOs2CodePage(coolTypeScript, n);
    }

    private CoolTypeScript computeCoolTypeScriptFromOs2UnicodeRange() throws InvalidFontException {
        if (this.os2 == null) {
            return null;
        }
        if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.HANGUL_COMPATIBILITY_JAMO) || this.os2.supportsUnicodeRange(Os2.UnicodeRange.HANGUL_SYLLABLES)) {
            return CoolTypeScript.KOREAN;
        }
        if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.BOPOMOFO)) {
            int n = 0;
            if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_UNIFIED_IDEOGRAPHS)) {
                ++n;
            }
            if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_COMPATIBILITY_IDEOGRAPHS)) {
                ++n;
            }
            if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_COMPATIBILITY_FORMS)) {
                ++n;
            }
            if (n >= 2) {
                return CoolTypeScript.TRADITIONAL_CHINESE;
            }
            return CoolTypeScript.SIMPLIFIED_CHINESE;
        }
        if (this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_SYMBOLS_AND_PUNCTUATION) || this.os2.supportsUnicodeRange(Os2.UnicodeRange.CJK_UNIFIED_IDEOGRAPHS) || this.os2.supportsUnicodeRange(Os2.UnicodeRange.HIRAGANA) || this.os2.supportsUnicodeRange(Os2.UnicodeRange.KATAKANA)) {
            return CoolTypeScript.JAPANESE;
        }
        return null;
    }

    private int getCoolTypeUnicodeCmapIndex() throws InvalidFontException {
        int[][] nArrayArray = new int[][]{{3, 1}, {0, 4}, {0, 3}, {0, 2}, {0, 1}, {0, 0}};
        int n = -1;
        for (int i = 0; i < nArrayArray.length && (n = this.cmap.getCmapSubtableIndex(nArrayArray[i][0], nArrayArray[i][1])) == -1; ++i) {
        }
        return n;
    }

    private boolean computeCoolTypeCmapSupportsScript(CoolTypeScript coolTypeScript, int n) throws UnsupportedFontException, InvalidFontException {
        if (coolTypeScript == CoolTypeScript.JAPANESE) {
            return this.cmap.char2glyph(12450, n) > 0;
        }
        if (coolTypeScript == CoolTypeScript.ARABIC) {
            return this.cmap.char2glyph(1570, n) > 0;
        }
        if (coolTypeScript == CoolTypeScript.HEBREW) {
            return this.cmap.char2glyph(1488, n) > 0;
        }
        if (coolTypeScript == CoolTypeScript.EAST_EUROPEAN_ROMAN) {
            return this.cmap.char2glyph(268, n) > 0 || this.cmap.char2glyph(328, n) > 0 || this.cmap.char2glyph(371, n) > 0;
        }
        if (coolTypeScript == CoolTypeScript.CYRILLIC) {
            return this.cmap.char2glyph(1071, n) > 0 || this.cmap.char2glyph(1105, n) > 0;
        }
        if (coolTypeScript == CoolTypeScript.GREEK) {
            return this.cmap.char2glyph(971, n) > 0;
        }
        if (coolTypeScript == CoolTypeScript.ROMAN) {
            return this.cmap.char2glyph(234, n) > 0;
        }
        if (coolTypeScript == CoolTypeScript.THAI) {
            return this.cmap.char2glyph(3585, n) > 0;
        }
        if (coolTypeScript == CoolTypeScript.VIETNAMESE) {
            return this.cmap.char2glyph(8363, n) > 0;
        }
        return true;
    }

    private CoolTypeScript computeCoolTypeScriptFromUnicodeCmap() throws UnsupportedFontException, InvalidFontException {
        if (this.cmap == null) {
            return null;
        }
        int n = this.getCoolTypeUnicodeCmapIndex();
        if (n == -1) {
            return null;
        }
        if (this.cmap.char2glyph(12450, n) != 0) {
            return CoolTypeScript.JAPANESE;
        }
        if (this.cmap.char2glyph(1570, n) != 0) {
            return CoolTypeScript.ARABIC;
        }
        if (this.cmap.char2glyph(1488, n) != 0) {
            return CoolTypeScript.HEBREW;
        }
        if (this.cmap.char2glyph(328, n) != 0 || this.cmap.char2glyph(371, n) != 0) {
            if (this.cmap.char2glyph(234, n) != 0) {
                return CoolTypeScript.ROMAN;
            }
            return CoolTypeScript.EAST_EUROPEAN_ROMAN;
        }
        if (this.cmap.char2glyph(1071, n) != 0 || this.cmap.char2glyph(1105, n) != 0) {
            return CoolTypeScript.CYRILLIC;
        }
        if (this.cmap.char2glyph(971, n) != 0) {
            return CoolTypeScript.GREEK;
        }
        if (this.cmap.char2glyph(234, n) != 0) {
            return CoolTypeScript.ROMAN;
        }
        if (this.cmap.char2glyph(3585, n) != 0) {
            return CoolTypeScript.THAI;
        }
        if (this.cmap.char2glyph(8363, n) != 0) {
            return CoolTypeScript.VIETNAMESE;
        }
        return null;
    }

    private CoolTypeScript computeCoolTypeScriptFromOs2fsSelection() throws InvalidFontException {
        if (this.os2 == null) {
            return null;
        }
        int n = this.os2.getSelection() >> 8;
        if (n == 178 || n == 179) {
            return CoolTypeScript.ARABIC;
        }
        if (n == 177) {
            return CoolTypeScript.HEBREW;
        }
        return null;
    }

    private CoolTypeScript computeCoolTypeScriptFromNameEntriesLanguages() throws InvalidFontException {
        if (this.os2 == null || this.name == null) {
            return null;
        }
        long l = this.os2.getVendor();
        if (l == 1279611986L || l == 1146703425L || l == 1212239443L) {
            if (this.name.hasName(3, -1, 1042, 4) || this.name.hasName(3, -1, 1042, 0)) {
                return CoolTypeScript.KOREAN;
            }
            if (this.name.hasName(3, -1, 1028, 4) || this.name.hasName(3, -1, 1028, 0)) {
                return CoolTypeScript.TRADITIONAL_CHINESE;
            }
            if (this.name.hasName(3, -1, 2052, 4) || this.name.hasName(3, -1, 2052, 0)) {
                return CoolTypeScript.SIMPLIFIED_CHINESE;
            }
            if (this.name.hasName(3, -1, 1041, 4) || this.name.hasName(3, -1, 1041, 0)) {
                return CoolTypeScript.JAPANESE;
            }
        }
        return null;
    }

    public CoolTypeScript getCoolTypeScript() throws UnsupportedFontException, InvalidFontException {
        CoolTypeScript coolTypeScript;
        ROS rOS = null;
        if (this.cff != null) {
            rOS = this.cff.getROS();
        }
        if ((coolTypeScript = CoolTypeScript.fromWellKnownROS(rOS)) != null) {
            return coolTypeScript;
        }
        coolTypeScript = this.computeCoolTypeScriptFromCmapSubtables();
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        if (this.glyf != null || this.cff.getCFFFont() instanceof CIDKeyedFont ? (coolTypeScript = this.computeCoolTypeScriptFromOs2CodePageNotNameKeyed()) != null : (coolTypeScript = this.computeCoolTypeScriptFromOs2CodePage(null, 0)) != null) {
            return coolTypeScript;
        }
        coolTypeScript = this.computeCoolTypeScriptFromOs2UnicodeRange();
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        coolTypeScript = this.computeCoolTypeScriptFromOs2fsSelection();
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        coolTypeScript = this.computeCoolTypeScriptFromNameEntriesLanguages();
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        coolTypeScript = this.computeCoolTypeScriptFromUnicodeCmap();
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        coolTypeScript = CoolTypeScript.fromAnyROS(rOS);
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        return CoolTypeScript.ROMAN;
    }

    public double getCoolTypeCapHeight() throws InvalidFontException, UnsupportedFontException {
        int n;
        if (this.os2 != null && (n = this.os2.getCapHeight()) != Integer.MAX_VALUE && n != 0) {
            return n;
        }
        return this.getCoolTypeCapHeightFromGlyphs();
    }

    private Rect computeCoolTypeIdeoEmBoxFromBaseTable() throws UnsupportedFontException, InvalidFontException {
        if (this.base == null) {
            return null;
        }
        int n = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_ideo);
        if (n == Integer.MAX_VALUE) {
            return null;
        }
        int n2 = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_romn);
        if (n2 != Integer.MAX_VALUE && n2 < n) {
            return null;
        }
        double d = n;
        int n3 = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_idtp);
        double d2 = n3 != Integer.MAX_VALUE ? (double)n3 : d + this.getUnitsPerEmY();
        double d3 = 0.0;
        int n4 = this.base.getBaselinePosition(Orientation.VERTICAL, Tag.script_DFLT, Tag.baseline_idtp);
        double d4 = n4 != Integer.MAX_VALUE ? (double)n4 : d3 + this.getUnitsPerEmX();
        return new Rect(d3, d, d4, d2);
    }

    private boolean validateOs2OrHheaIdeoEmBox(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        for (int i = 0; i < typicalCharactersForIdeoEmBoxComputation.length; ++i) {
            int n3 = this.getCoolTypeGlyphForChar(typicalCharactersForIdeoEmBoxComputation[i]);
            if (n3 == 0) continue;
            Rect rect = this.getGlyphBBox(n3);
            double d = Math.abs((double)n - rect.ymax - (rect.ymin - (double)n2));
            double d2 = this.getUnitsPerEmY();
            return (double)n2 <= rect.ymin && rect.ymax <= (double)n && d <= 0.003 * d2;
        }
        return false;
    }

    private Rect computeCoolTypeIdeoEmBoxFromOs2OrHhea() throws UnsupportedFontException, InvalidFontException {
        int n = -1;
        int n2 = 0;
        if (this.os2 != null) {
            n = this.os2.getTypoAscender();
            n2 = this.os2.getTypoDescender();
        }
        if (n <= n2 && (n = this.hhea.getAscender()) <= (n2 = this.hhea.getDescender())) {
            return null;
        }
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        if (this.cff != null || (double)(n - n2) == d2 || this.validateOs2OrHheaIdeoEmBox(n, n2)) {
            return new Rect(0.0, n2, d, n);
        }
        return null;
    }

    private Rect computeCoolTypeIdeoEmBoxFromCapHeight() throws InvalidFontException, UnsupportedFontException {
        int n;
        double d = this.getCoolTypeCapHeight();
        if (Double.isNaN(d)) {
            return null;
        }
        if (this.base != null && (n = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_romn)) != Integer.MAX_VALUE) {
            d -= (double)n;
        }
        double d2 = this.getUnitsPerEmX();
        double d3 = this.getUnitsPerEmY();
        double d4 = -(d3 - d) / 2.0;
        return new Rect(0.0, d4, d2, d4 + d3);
    }

    public Rect getCoolTypeIdeoEmBox() throws InvalidFontException, UnsupportedFontException {
        Rect rect = this.computeCoolTypeIdeoEmBoxFromBaseTable();
        if (rect != null) {
            return rect;
        }
        if (this.useCoolTypeCJKHeuristics()) {
            rect = this.computeCoolTypeIdeoEmBoxFromOs2OrHhea();
            if (rect != null) {
                return rect;
            }
            rect = this.getCoolTypeIdeoEmBoxFromFullBoxCharacter();
            if (rect != null) {
                return rect;
            }
            rect = this.getCoolTypeIdeoEmBoxFromTypicalCharacter();
            if (rect != null) {
                return rect;
            }
        } else {
            rect = this.computeCoolTypeIdeoEmBoxFromCapHeight();
            if (rect != null) {
                return rect;
            }
        }
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        return new Rect(0.0, -0.12 * d2, d, 0.88 * d2);
    }

    private Rect computeCoolTypeIcfBoxFromBaseTable(Rect rect) throws InvalidFontException, UnsupportedFontException {
        double d;
        if (this.base == null) {
            return null;
        }
        int n = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_icfb);
        if (n == Integer.MAX_VALUE) {
            return null;
        }
        int n2 = this.base.getBaselinePosition(Orientation.VERTICAL, Tag.script_DFLT, Tag.baseline_icfb);
        int n3 = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_icft);
        int n4 = this.base.getBaselinePosition(Orientation.VERTICAL, Tag.script_DFLT, Tag.baseline_icft);
        double d2 = n;
        double d3 = n3 != Integer.MAX_VALUE ? (double)n3 : rect.ymax - (d2 - rect.ymin);
        double d4 = n2 != Integer.MAX_VALUE ? (double)n2 : d2 - rect.ymin;
        double d5 = d = n4 != Integer.MAX_VALUE ? (double)n4 : rect.xmax - (d4 - rect.xmin);
        if (this.useCoolTypeCJKHeuristics() && (d2 < rect.ymin || rect.ymax < d3 || d4 < rect.xmin || rect.xmax < d)) {
            return null;
        }
        return new Rect(d4, d2, d, d3);
    }

    public Rect getCoolTypeIcfBox() throws InvalidFontException, UnsupportedFontException {
        Rect rect = this.getCoolTypeIdeoEmBox();
        Rect rect2 = this.computeCoolTypeIcfBoxFromBaseTable(rect);
        if (rect2 != null) {
            return rect2;
        }
        if (this.useCoolTypeCJKHeuristics() && (rect2 = this.getCoolTypeIcfBoxFromTypicalCharacter(rect)) != null) {
            return rect2;
        }
        return this.getCoolTypeIcfBoxFromIdeoEmBox(rect);
    }

    private boolean useOs2() throws InvalidFontException {
        if (this.os2 == null) {
            return false;
        }
        int n = this.os2.getTypoAscender();
        int n2 = this.os2.getTypoDescender();
        if (n2 > 0 && this.head != null && this.head.getYMin() <= 0) {
            n2 = -n2;
        }
        return n2 < n;
    }

    private double computeCoolTypeLineGapForCJK() throws UnsupportedFontException, InvalidFontException {
        if ((this.cff == null || this.head == null || !this.head.isConverted()) && this.useOs2()) {
            return Math.abs(this.os2.getTypoLineGap());
        }
        if (this.cff == null) {
            return Math.abs(this.hhea.getLineGap());
        }
        return this.getUnitsPerEmY() / 2.0;
    }

    private LineMetrics computeCoolTypeLineMetricsFromTypicalCharacters(double d) throws UnsupportedFontException, InvalidFontException {
        double d2;
        double d3;
        int n = this.getCoolTypeGlyphForChar(100);
        int n2 = this.getCoolTypeGlyphForChar(112);
        if (n != 0 && n2 != 0 && (d3 = this.getGlyphBBox((int)n2).ymin) < (d2 = this.getGlyphBBox((int)n).ymax)) {
            return new LineMetrics(d2, d3, d);
        }
        return null;
    }

    private LineMetrics computeCoolTypeLineMetricsFromICFBox(double d) throws UnsupportedFontException, InvalidFontException {
        Rect rect = this.getCoolTypeIcfBox();
        return new LineMetrics(rect.ymax, rect.ymax - this.getUnitsPerEmY(), d);
    }

    private LineMetrics computeCoolTypeLineMetricsFromOs2() throws UnsupportedFontException, InvalidFontException {
        if (this.os2 == null) {
            return null;
        }
        int n = this.os2.getTypoAscender();
        int n2 = this.os2.getTypoDescender();
        if (n2 > 0 && this.head != null && this.head.getYMin() <= 0) {
            n2 = -n2;
        }
        if (n2 < n) {
            return new LineMetrics(n, n2, Math.abs(this.os2.getTypoLineGap()));
        }
        return null;
    }

    private LineMetrics computeCoolTypeLineMetricsFromHhea() throws UnsupportedFontException, InvalidFontException {
        int n = this.hhea.getAscender();
        int n2 = this.hhea.getDescender();
        if (n2 < n) {
            return new LineMetrics(n, n2, Math.abs(this.hhea.getLineGap()));
        }
        return null;
    }

    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        LineMetrics lineMetrics;
        if (this.useCoolTypeCJKHeuristics()) {
            double d = this.computeCoolTypeLineGapForCJK();
            LineMetrics lineMetrics2 = this.computeCoolTypeLineMetricsFromTypicalCharacters(d);
            if (lineMetrics2 != null) {
                return lineMetrics2;
            }
            return this.computeCoolTypeLineMetricsFromICFBox(d);
        }
        if (!(this.cff != null && this.head != null && this.head.isConverted() || (lineMetrics = this.computeCoolTypeLineMetricsFromOs2()) == null)) {
            return lineMetrics;
        }
        if (this.glyf != null && (lineMetrics = this.computeCoolTypeLineMetricsFromHhea()) != null) {
            return lineMetrics;
        }
        return this.getCoolTypeLineMetricsFromFontBbox();
    }

    public LineMetrics getLineMetrics() throws UnsupportedFontException, InvalidFontException {
        if (this.os2 != null) {
            return this.os2.getLineMetrics();
        }
        return null;
    }

    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException {
        int n;
        double d = this.getUnitsPerEmY();
        if (this.cff != null) {
            return this.cff.getCoolTypeUnderlineMetrics(this.getCoolTypeUnitsPerEm(), d);
        }
        if (this.post != null) {
            n = this.post.getUnderlinePosition();
            int n2 = this.post.getUnderlineThickness();
            if (n != 0 || n2 != 0) {
                return new UnderlineMetrics(n, Math.abs(n2));
            }
        }
        if (this.glyf != null && this.useCoolTypeCJKHeuristics() && (n = this.getCoolTypeGlyphForChar(26412)) != 0) {
            Rect rect = this.getGlyphBBox(n);
            return new UnderlineMetrics(rect.ymin - 0.05 * d / 2.0, 0.05 * d);
        }
        if (this.useCoolTypeCJKHeuristics()) {
            return new UnderlineMetrics(-0.1 * d, 0.05 * d);
        }
        return new UnderlineMetrics(-0.15 * d, 0.05 * d);
    }

    public boolean getCoolTypeProportionalRomanFromFontProperties() throws InvalidFontException {
        if (this.os2 != null) {
            switch (this.os2.panoseIndicatesProportional()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.cff != null) {
            return this.cff.getCFFFont().getCoolTypeProportionalRomanFromFontProperties();
        }
        return false;
    }

    public int computeRomanBaselineH() throws InvalidFontException {
        if (this.base != null) {
            int n = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_romn);
            if (n == Integer.MAX_VALUE) {
                return 0;
            }
            int n2 = this.base.getBaselinePosition(Orientation.HORIZONTAL, Tag.script_DFLT, Tag.baseline_ideo);
            if (n2 == Integer.MAX_VALUE || n >= n2) {
                return n;
            }
        }
        return 0;
    }

    public double computeRomanBaselineV() throws UnsupportedFontException, InvalidFontException {
        int n;
        if (this.base != null && (n = this.base.getBaselinePosition(Orientation.VERTICAL, Tag.script_DFLT, Tag.baseline_romn)) != Integer.MAX_VALUE) {
            return n;
        }
        Rect rect = this.getCoolTypeIdeoEmBox();
        int n2 = this.computeRomanBaselineH();
        return -rect.ymin - (double)n2 + rect.xmin;
    }

    public int getGlyphForChar(int n) throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            return 0;
        }
        return this.cmap.unicodeChar2glyph(n);
    }

    public int getCoolTypeGlyphForChar(int n) throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            return 0;
        }
        return this.cmap.coolTypeUnicodeChar2glyph(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCharForGlyph(int n) throws UnsupportedFontException, InvalidFontException {
        Object object = this.invertedcmapMutex;
        synchronized (object) {
            if (!this.invertedcmapHasBeenComputed) {
                int n2 = this.cmap.getCmapSubtableIndex(3, 1);
                this.invertedcmap = (int[])(n2 != -1 ? this.cmap.glyph2char(this.getNumGlyphs(), n2) : null);
                this.invertedcmapHasBeenComputed = true;
            }
            if (this.invertedcmap != null) {
                return this.invertedcmap[n];
            }
            return -1;
        }
    }

    public double getHorizontalAdvance(int n) throws InvalidFontException {
        return this.hmtx.getHorizontalAdvance(n);
    }

    public void getGlyphOutline(int n, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidFontException {
        if (this.cff != null) {
            this.cff.getOutline(n, outlineConsumer);
        } else {
            TTParser tTParser = new TTParser();
            tTParser.parse(this, n, outlineConsumer);
        }
    }

    public Rect getGlyphBBox(int n) throws UnsupportedFontException, InvalidFontException {
        if (this.cff != null) {
            Rect rect = this.cff.getGlyphBoundingBoxInMetricSpace(n);
            if (Math.abs(this.getUnitsPerEmX() - this.cff.getCFFFont().getUnitsPerEmX()) < 0.1 && Math.abs(this.getUnitsPerEmY() - this.cff.getCFFFont().getUnitsPerEmY()) < 0.1) {
                return rect;
            }
            double d = this.cff.getCFFFont().getUnitsPerEmX();
            double d2 = this.cff.getCFFFont().getUnitsPerEmY();
            return new Rect(rect.xmin * this.getUnitsPerEmX() / d, rect.ymin * this.getUnitsPerEmY() / d2, rect.xmax * this.getUnitsPerEmX() / d, rect.ymax * this.getUnitsPerEmY() / d2);
        }
        return this.glyf.getGlyphBoundingBox(n);
    }

    public Scaler getScaler(ScanConverter scanConverter) throws InvalidFontException, UnsupportedFontException {
        if (this.glyf != null) {
            if (scanConverter == null) {
                scanConverter = new TTScan();
            }
            return new TTScaler(this, scanConverter);
        }
        if (scanConverter == null) {
            scanConverter = new CScan(false, 1.0, true);
        }
        return new CFFScaler(this.cff.cffFont, scanConverter);
    }

    public String getGlyphName(int n) throws UnsupportedFontException, InvalidFontException {
        String string = null;
        if (this.post != null) {
            string = this.post.getGlyphName(n);
        }
        if (string == null && this.cff != null) {
            string = this.cff.getGlyphName(n);
        }
        return string;
    }

    public ROS getROS() {
        if (this.cff != null) {
            return this.cff.getROS();
        }
        return null;
    }

    public int getGlyphCid(int n) throws InvalidFontException, UnsupportedFontException {
        if (this.cff != null) {
            return this.cff.getGlyphCid(n);
        }
        return -1;
    }

    public SWFFontDescription getSWFFontDescription(boolean bl) throws UnsupportedFontException, InvalidFontException {
        return new OTSWFFont3Description(bl);
    }

    public PDFFontDescription getPDFFontDescription(Font font) {
        return this.xdcDescription;
    }

    public XDCFontDescription getXDCFontDescription(Font font) {
        return this.xdcDescription;
    }

    public Permission getEmbeddingPermission(boolean bl) throws InvalidFontException, UnsupportedFontException {
        if (this.os2 == null) {
            if (this.cff != null) {
                return this.cff.getEmbeddingPermission(bl);
            }
            return EmbeddingPermission.getTrueTypeDefaultPermission();
        }
        return this.os2.getEmbeddingPermission();
    }

    public Subset createSubset() throws UnsupportedFontException, InvalidFontException {
        return new OTSubset(this);
    }

    public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
        this.subsetAndStream(subset, null, outputStream, bl);
    }

    private void subsetAndStream(Subset subset, SubsetSimpleTrueType subsetSimpleTrueType, OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
        Object object;
        if (this.cff != null) {
            this.cff.subsetAndStream(subset, outputStream, bl, this.os2 != null ? new Integer(this.os2.getRawFSType()) : null);
            return;
        }
        if (this.glyf == null) {
            throw new InvalidFontException("cff or glyf table required");
        }
        TreeMap treeMap = new TreeMap();
        if (this.hmtx != null) {
            this.hmtx.subsetAndStream(subset, treeMap);
        }
        if (this.hhea != null) {
            this.hhea.subsetAndStream(subset, treeMap);
        }
        if (this.maxp != null) {
            this.maxp.subsetAndStream(subset, treeMap);
        }
        if (this.os2 != null) {
            this.os2.subsetAndStream(subset, treeMap);
        }
        this.glyf.subsetAndStream(subset, treeMap);
        if (this.name != null) {
            this.name.subsetAndStream(subset, treeMap);
        }
        if (this.cmap != null) {
            this.cmap.subsetAndStream(subset, subsetSimpleTrueType, treeMap);
        }
        if (this.cvt != null) {
            this.cvt.subsetAndStream(subset, treeMap);
        }
        if (this.fpgm != null) {
            this.fpgm.subsetAndStream(subset, treeMap);
        }
        if (this.prep != null) {
            this.prep.subsetAndStream(subset, treeMap);
        }
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = null;
        if (this.head != null) {
            oTByteArrayBuilder = this.head.subsetAndStream(subset, treeMap);
        }
        int n = 12 + 16 * treeMap.size();
        int n2 = 1;
        int n3 = 0;
        while (n2 <= treeMap.size()) {
            n2 *= 2;
            ++n3;
        }
        --n3;
        int n4 = treeMap.size() * 16 - (n2 *= 8);
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder2 = OTByteArray.getOTByteArrayBuilderInstance(n);
        oTByteArrayBuilder2.setFixed(0, 1, 0);
        oTByteArrayBuilder2.setuint16(4, treeMap.size());
        oTByteArrayBuilder2.setuint16(6, n2);
        oTByteArrayBuilder2.setuint16(8, n3);
        oTByteArrayBuilder2.setuint16(10, n4);
        long l = n;
        int n5 = 12;
        long l2 = 0L;
        if (this.head != null) {
            Head.clearChecksumAdjust(oTByteArrayBuilder);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n6 = (Integer)iterator.next();
            object = (OTByteArray.OTByteArrayBuilder)treeMap.get(n6);
            long l3 = ((OTByteArray.OTByteArrayBuilder)object).checksum(0, ((FontByteArray.FontByteArrayBuilder)object).getSize(), 0L);
            l2 = l2 + l3 & 0xFFFFFFFFL;
            oTByteArrayBuilder2.setuint32(n5, n6);
            oTByteArrayBuilder2.setuint32(n5 + 4, (int)l3);
            oTByteArrayBuilder2.setuint32(n5 + 8, (int)l);
            oTByteArrayBuilder2.setuint32(n5 + 12, ((FontByteArray.FontByteArrayBuilder)object).getSize());
            n5 += 16;
            l += (long)((FontByteArray.FontByteArrayBuilder)object).getSize();
            if (((FontByteArray.FontByteArrayBuilder)object).getSize() % 4 == 0) continue;
            l += (long)(4 - ((FontByteArray.FontByteArrayBuilder)object).getSize() % 4);
        }
        l2 = l2 + oTByteArrayBuilder2.checksum(0, oTByteArrayBuilder2.getSize(), 0L) & 0xFFFFFFFFL;
        long l4 = 2981146554L - l2 & 0xFFFFFFFFL;
        Head.setChecksumAdjust(oTByteArrayBuilder, l4);
        object = oTByteArrayBuilder2.toOTByteArray();
        ((FontByteArray)object).write(outputStream);
        Iterator iterator2 = treeMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Integer n7 = (Integer)iterator2.next();
            OTByteArray.OTByteArrayBuilder oTByteArrayBuilder3 = (OTByteArray.OTByteArrayBuilder)treeMap.get(n7);
            OTByteArray oTByteArray = oTByteArrayBuilder3.toOTByteArray();
            oTByteArray.write(outputStream);
            if (oTByteArray.getSize() % 4 == 0) continue;
            int n8 = (oTByteArray.getSize() / 4 + 1) * 4 - oTByteArray.getSize();
            for (int i = 0; i < n8; ++i) {
                outputStream.write(0);
            }
        }
    }

    public PostscriptFontDescription[] getPostscriptFontDescription() throws InvalidFontException, UnsupportedFontException {
        if (this.name == null) {
            if (this.cff != null) {
                return this.cff.cffFont.getPostscriptFontDescription();
            }
            return null;
        }
        Set set = this.name.getPostscriptNames();
        int n = set.size();
        PostscriptFontDescription[] postscriptFontDescriptionArray = new PostscriptFontDescription[n];
        Iterator iterator = set.iterator();
        for (int i = 0; i < n; ++i) {
            postscriptFontDescriptionArray[i] = new PostscriptFontDescription((String)iterator.next());
        }
        return postscriptFontDescriptionArray;
    }

    public Set getCSSFamilyNames() throws InvalidFontException, UnsupportedFontException {
        if (this.base14CSSName != null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(this.base14CSSName);
            return hashSet;
        }
        if (this.name != null) {
            return this.name.getFamilyNames();
        }
        return new HashSet();
    }

    public String getPreferredCSSFamilyName() throws InvalidFontException, UnsupportedFontException {
        if (this.base14CSSName != null) {
            return this.base14CSSName;
        }
        if (this.name != null) {
            return this.name.getPreferredCSSFamilyName();
        }
        return null;
    }

    public boolean isCSSStyleNormal() throws InvalidFontException, UnsupportedFontException {
        return this.os2 == null || (this.os2.getSelection() & 1) == 0 || this.gsub != null && this.gsub.featureIsPresent(Tag.feature_ital);
    }

    public boolean isCSSStyleItalic() throws InvalidFontException, UnsupportedFontException {
        return this.os2 != null && (this.os2.getSelection() & 1) != 0 || this.gsub != null && this.gsub.featureIsPresent(Tag.feature_ital);
    }

    public boolean isCSSStyleOblique() throws InvalidFontException, UnsupportedFontException {
        return this.isCSSStyleItalic();
    }

    public boolean isCSSVariantNormal() {
        return true;
    }

    public boolean isCSSVariantSmallCaps() {
        return true;
    }

    public int getCSSWeight() throws InvalidFontException {
        if (this.os2 != null) {
            return this.os2.getWeightClass();
        }
        return 400;
    }

    protected CSS20Attribute.CSSStretchValue getCSSStretchValue() throws InvalidFontException {
        if (this.os2 != null) {
            switch (this.os2.getWidthClass()) {
                case 1: {
                    return CSS20Attribute.CSSStretchValue.ULTRACONDENSED;
                }
                case 2: {
                    return CSS20Attribute.CSSStretchValue.EXTRACONDENSED;
                }
                case 3: {
                    return CSS20Attribute.CSSStretchValue.CONDENSED;
                }
                case 4: {
                    return CSS20Attribute.CSSStretchValue.SEMICONDENSED;
                }
                case 5: {
                    return CSS20Attribute.CSSStretchValue.NORMAL;
                }
                case 6: {
                    return CSS20Attribute.CSSStretchValue.SEMIEXPANDED;
                }
                case 7: {
                    return CSS20Attribute.CSSStretchValue.EXPANDED;
                }
                case 8: {
                    return CSS20Attribute.CSSStretchValue.EXTRAEXPANDED;
                }
                case 9: {
                    return CSS20Attribute.CSSStretchValue.ULTRAEXPANDED;
                }
            }
        }
        return CSS20Attribute.CSSStretchValue.NORMAL;
    }

    public OpticalSizeData getOpticalSizeData() throws InvalidFontException {
        if (this.gpos == null) {
            return null;
        }
        OpticalSizeData opticalSizeData = this.gpos.getOpticalSizeData(false);
        if (opticalSizeData == null) {
            return null;
        }
        boolean bl = opticalSizeData.designSize == 0 ? false : (opticalSizeData.subfamilyId == 0 && opticalSizeData.nameId == 0 && opticalSizeData.minSize == 0 && opticalSizeData.maxSize == 0 ? true : opticalSizeData.designSize >= opticalSizeData.minSize && opticalSizeData.maxSize >= opticalSizeData.designSize && opticalSizeData.nameId >= 256 && opticalSizeData.nameId <= Short.MAX_VALUE && (this.name == null || this.name.getName(-1, opticalSizeData.nameId) != null));
        if (!bl) {
            opticalSizeData = this.gpos.getOpticalSizeData(true);
        }
        return opticalSizeData;
    }

    public double[] getPointSizeRange() throws InvalidFontException {
        OpticalSizeData opticalSizeData = this.getOpticalSizeData();
        if (opticalSizeData == null) {
            return new double[]{0.0, Double.POSITIVE_INFINITY};
        }
        return new double[]{opticalSizeData.minSize, opticalSizeData.maxSize};
    }

    private String getVersion() throws InvalidFontException, UnsupportedFontException {
        int n;
        int n2;
        String string = null;
        try {
            if (this.name == null) {
                return "";
            }
            string = this.name.getName(3, 1, 1033, 5);
            if (string == null) {
                string = this.name.getName(3, 0, 1033, 5);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (string == null) {
            return "";
        }
        for (n2 = 0; n2 < string.length() && (string.charAt(n2) < '0' || '9' < string.charAt(n2)); ++n2) {
        }
        for (n = n2; n < string.length() && '0' <= string.charAt(n) && string.charAt(n) <= '9'; ++n) {
        }
        if (n2 == n) {
            return string;
        }
        if (n < string.length() && '.' == string.charAt(n)) {
            ++n;
            while (n < string.length() && '0' <= string.charAt(n) && string.charAt(n) <= '9') {
                ++n;
            }
        }
        return string.substring(n2, n);
    }

    public CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException {
        final HashSet<String> hashSet = new HashSet<String>();
        if (this.name != null) {
            NameConsumer nameConsumer = new NameConsumer(){

                public boolean nameFound(String string, int n, int n2, int n3) throws InvalidFontException, UnsupportedFontException {
                    String string2 = null;
                    try {
                        string2 = OpenTypeFont.this.name.getName(n, n2, n3, 2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (string2 == null) {
                        string2 = "Regular";
                    }
                    string = string + ", " + string2;
                    if (this.bestName == null || n3 == 1033) {
                        this.bestName = string;
                        this.bestNameLanguage = n3;
                    }
                    hashSet.add(string);
                    return false;
                }
            };
            this.name.enumerateNames(nameConsumer, 1);
            NameConsumer nameConsumer2 = new NameConsumer(){

                public boolean nameFound(String string, int n, int n2, int n3) throws InvalidFontException, UnsupportedFontException {
                    String string2 = null;
                    try {
                        string2 = OpenTypeFont.this.name.getName(n, n2, n3, 17);
                        if (string2 == null) {
                            string2 = OpenTypeFont.this.name.getName(n, n2, n3, 2);
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (string2 == null) {
                        string2 = "Regular";
                    }
                    hashSet.add(string + ", " + string2);
                    return false;
                }
            };
            this.name.enumerateNames(nameConsumer2, 16);
            String string = nameConsumer2.bestName != null ? nameConsumer2.bestName : nameConsumer.bestName;
            return new CatalogDescription("OT", hashSet, string, this.getVersion());
        }
        hashSet.add("<no name table>");
        return new CatalogDescription("OT", hashSet, "<no best name>", "<no version>");
    }

    public Rect getCoolTypeGlyphBBox(int n) throws UnsupportedFontException, InvalidFontException {
        if (this.cff != null) {
            return this.getGlyphBBox(n);
        }
        TrueTypeGlyphBBoxCalculator trueTypeGlyphBBoxCalculator = new TrueTypeGlyphBBoxCalculator(true, 1000);
        Rect rect = trueTypeGlyphBBoxCalculator.calculateBBox(this, n);
        Rect rect2 = new Rect(rect.xmin * this.getUnitsPerEmX() / 1000.0, rect.ymin * this.getUnitsPerEmX() / 1000.0, rect.xmax * this.getUnitsPerEmX() / 1000.0, rect.ymax * this.getUnitsPerEmX() / 1000.0);
        return rect2;
    }

    public CFFFont getCFFFont() {
        if (this.cff == null) {
            return null;
        }
        return this.cff.getCFFFont();
    }

    static class NameConsumer
    implements Name.NameSelector {
        public String bestName;
        public int bestNameLanguage;

        NameConsumer() {
        }

        public boolean nameFound(String string, int n, int n2, int n3) throws InvalidFontException, UnsupportedFontException {
            return false;
        }
    }

    private class OTXDCFontDescription
    extends XDCFontDescription {
        private OTXDCFontDescription() {
        }

        public int getGlyphCid(int n) throws UnsupportedFontException, InvalidFontException {
            return OpenTypeFont.this.getGlyphCid(n);
        }

        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            if (this.getBase14Name() != null) {
                return this.getBase14Name();
            }
            if (OpenTypeFont.this.name == null) {
                return null;
            }
            SinglePostscriptName singlePostscriptName = new SinglePostscriptName();
            OpenTypeFont.this.name.enumerateNames(singlePostscriptName, 6);
            return singlePostscriptName.getSelection();
        }

        public String getFontFamily() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.name == null) {
                return null;
            }
            SingleFamilyName singleFamilyName = new SingleFamilyName();
            OpenTypeFont.this.name.enumerateNames(singleFamilyName, OpenTypeFont.this.name.selectFamilyNameId());
            return singleFamilyName.getSelection();
        }

        public int getNumGlyphs() throws UnsupportedFontException, InvalidFontException {
            return OpenTypeFont.this.getNumGlyphs();
        }

        public double getAdvance(int n) throws InvalidFontException, UnsupportedFontException {
            return OpenTypeFont.this.getHorizontalAdvance(n) * 1000.0 / OpenTypeFont.this.getUnitsPerEmX();
        }

        public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.head == null) {
                return null;
            }
            Rect rect = OpenTypeFont.this.head.getFontBBox();
            int n = OpenTypeFont.this.head.getUnitsPerEm();
            return new Rect(rect.xmin * 1000.0 / (double)n, rect.ymin * 1000.0 / (double)n, rect.xmax * 1000.0 / (double)n, rect.ymax * 1000.0 / (double)n);
        }

        public double getCapHeight() throws UnsupportedFontException, InvalidFontException {
            double d = OpenTypeFont.this.getCoolTypeCapHeight();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d * (1000.0 / OpenTypeFont.this.getUnitsPerEmY());
        }

        public double getXHeight() throws UnsupportedFontException, InvalidFontException {
            double d = OpenTypeFont.this.getCoolTypeXHeight();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d * (1000.0 / OpenTypeFont.this.getUnitsPerEmY());
        }

        public double getItalicAngle() throws InvalidFontException {
            double d = 0.0;
            if (OpenTypeFont.this.hhea == null) {
                return 0.0;
            }
            int n = OpenTypeFont.this.hhea.getRise();
            int n2 = OpenTypeFont.this.hhea.getRun();
            if (n != 0 && n2 != 0) {
                d = Math.atan((double)(-n2) / (double)n) / Math.PI * 180.0;
                if (n2 < 0) {
                    d += 180.0;
                }
            }
            return d;
        }

        public ROS getROS() throws UnsupportedFontException, InvalidFontException {
            if (OpenTypeFont.this.cff != null) {
                return OpenTypeFont.this.getROS();
            }
            return null;
        }

        public boolean pdfFontIsTrueType() {
            return OpenTypeFont.this.cff == null;
        }

        private double calculateTTStemV() throws UnsupportedFontException, InvalidFontException {
            double d;
            StemFinder stemFinder = new StemFinder(true, true);
            TTParser tTParser = new TTParser();
            int n = OpenTypeFont.this.getGlyphForChar(104);
            int n2 = OpenTypeFont.this.getGlyphForChar(108);
            int n3 = OpenTypeFont.this.getGlyphForChar(49);
            int n4 = OpenTypeFont.this.getGlyphForChar(52);
            double d2 = 0.0;
            double d3 = this.getItalicAngle();
            if (n2 != 0) {
                stemFinder.reset();
                tTParser.parse(OpenTypeFont.this, n2, stemFinder);
                d2 = stemFinder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(n2), d3);
            }
            if (n != 0) {
                stemFinder.reset();
                tTParser.parse(OpenTypeFont.this, n, stemFinder);
                d = stemFinder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(n), d3);
                if (d2 == 0.0 || d < d2 && d != 0.0 && d2 - d > 20.0 && d2 - d < 70.0) {
                    d2 = d;
                }
            }
            if (d2 == 0.0 && n3 != 0) {
                stemFinder.reset();
                tTParser.parse(OpenTypeFont.this, n3, stemFinder);
                d2 = stemFinder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(n3), d3);
                if (d2 == 0.0 && n4 != 0) {
                    stemFinder.reset();
                    tTParser.parse(OpenTypeFont.this, n4, stemFinder);
                    d2 = stemFinder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(n4), d3);
                } else if (n4 != 0) {
                    stemFinder.reset();
                    tTParser.parse(OpenTypeFont.this, n4, stemFinder);
                    d = stemFinder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(n4), d3);
                    if (d != 0.0 && d2 - d > 50.0) {
                        d2 = d;
                    }
                }
            } else if (n3 != 0) {
                stemFinder.reset();
                tTParser.parse(OpenTypeFont.this, n3, stemFinder);
                d = stemFinder.getComputedStem(OpenTypeFont.this.getHorizontalAdvance(n3), d3);
                if (d != 0.0 && d2 - d > 50.0) {
                    d2 = d;
                }
            }
            return d2;
        }

        public double getStemV() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.cff != null) {
                int n = OpenTypeFont.this.getGlyphForChar(108);
                if (n == 0) {
                    n = OpenTypeFont.this.getGlyphForChar(73);
                }
                if (n == 0) {
                    return 0.0;
                }
                return OpenTypeFont.this.cff.getCFFFont().getStemVForGlyph(n);
            }
            return this.calculateTTStemV();
        }

        public String getBase14Name() {
            return OpenTypeFont.this.base14PSName;
        }

        public String getGlyphName(int n) throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.cff != null) {
                return OpenTypeFont.this.getGlyphName(n);
            }
            int n2 = OpenTypeFont.this.getCharForGlyph(n);
            return GlyphNames.resolveUSVToAGNCName(n2);
        }

        public boolean isSerifFont() throws InvalidFontException, UnsupportedFontException {
            int n = OpenTypeFont.this.getGlyphForChar(108);
            int n2 = OpenTypeFont.this.getGlyphForChar(73);
            return OpenTypeFont.this.isSerifFont(n, n2, this.getItalicAngle());
        }

        public boolean isSmallCapFont() throws InvalidFontException, UnsupportedFontException {
            if (!this.isAllCapFont()) {
                double d;
                int n = OpenTypeFont.this.getGlyphForChar(104);
                int n2 = OpenTypeFont.this.getGlyphForChar(120);
                if (n2 != 0) {
                    d = OpenTypeFont.this.getGlyphBBox((int)n2).ymax;
                } else if (OpenTypeFont.this.os2 != null) {
                    d = OpenTypeFont.this.os2.getxHeight();
                } else {
                    return false;
                }
                return OpenTypeFont.this.isSmallCapFont(n, d);
            }
            return false;
        }

        public boolean isAllCapFont() throws InvalidFontException, UnsupportedFontException {
            int n = OpenTypeFont.this.getGlyphForChar(75);
            int n2 = OpenTypeFont.this.getGlyphForChar(107);
            return OpenTypeFont.this.isAllCapFont(n, n2);
        }

        public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
            OpenTypeFont.this.subsetAndStream(subset, outputStream, bl);
        }

        public void subsetAndStream(SubsetSimpleType1 subsetSimpleType1, OutputStream outputStream) throws InvalidFontException, UnsupportedFontException, IOException {
            if (OpenTypeFont.this.cff == null || !(OpenTypeFont.this.cff.getCFFFont() instanceof NameKeyedFont)) {
                throw new UnsupportedFontException("Not a name-keyed font");
            }
            ((NameKeyedFont)OpenTypeFont.this.cff.getCFFFont()).subsetAndStream(subsetSimpleType1, outputStream, OpenTypeFont.this.os2 != null ? new Integer(OpenTypeFont.this.os2.getRawFSType()) : null);
        }

        public void subsetAndStream(SubsetSimpleTrueType subsetSimpleTrueType, OutputStream outputStream) throws InvalidFontException, UnsupportedFontException, IOException {
            if (OpenTypeFont.this.cff != null) {
                throw new UnsupportedFontException("Not a TrueType font");
            }
            if (OpenTypeFont.this.cmap == null) {
                throw new UnsupportedFontException("Font contains no cmaps");
            }
            int n = OpenTypeFont.this.cmap.offsetToIndex(subsetSimpleTrueType.getCmap());
            if (n < 0) {
                throw new InvalidFontException("Invalid cmap offset");
            }
            Subset subset = OpenTypeFont.this.createSubset();
            int[] nArray = subsetSimpleTrueType.getCodePoints();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = OpenTypeFont.this.cmap.char2glyph(nArray[i], n);
                if (n2 <= 0) {
                    throw new InvalidFontException("Font does not contain required codepoint");
                }
                subset.getSubsetGid(n2);
            }
            OpenTypeFont.this.subsetAndStream(subset, subsetSimpleTrueType, outputStream, false);
        }

        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            int n;
            HashSet<CodePage> hashSet = new HashSet<CodePage>();
            CoolTypeScript coolTypeScript = OpenTypeFont.this.getCoolTypeScript();
            if (coolTypeScript == CoolTypeScript.ROMAN) {
                if (OpenTypeFont.this.cmap != null && (n = OpenTypeFont.this.getCoolTypeUnicodeCmapIndex()) != -1 && OpenTypeFont.this.cmap.char2glyph(65, n) != 0) {
                    hashSet.add(CodePage.ROMAN1);
                }
            } else if (coolTypeScript == CoolTypeScript.EAST_EUROPEAN_ROMAN) {
                hashSet.add(CodePage.ROMAN2);
            } else if (coolTypeScript == CoolTypeScript.JAPANESE) {
                hashSet.add(CodePage.JAPANESE);
            } else if (coolTypeScript == CoolTypeScript.KOREAN) {
                hashSet.add(CodePage.KOREAN);
            } else if (coolTypeScript == CoolTypeScript.SIMPLIFIED_CHINESE) {
                hashSet.add(CodePage.SIMPLIFIED_CHINESE);
            } else if (coolTypeScript == CoolTypeScript.TRADITIONAL_CHINESE) {
                hashSet.add(CodePage.TRADITIONAL_CHINESE);
            }
            if (OpenTypeFont.this.os2 != null && OpenTypeFont.this.os2.getTableVersion() > 0) {
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_1252_LATIN_1)) {
                    hashSet.add(CodePage.ROMAN1);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_1250_LATIN_2_EE)) {
                    hashSet.add(CodePage.ROMAN2);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_932_JAPANESE)) {
                    hashSet.add(CodePage.JAPANESE);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_949_KOREAN_WANSUNG)) {
                    hashSet.add(CodePage.KOREAN);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_936_CHINESE_SIMPLIFIED)) {
                    hashSet.add(CodePage.SIMPLIFIED_CHINESE);
                }
                if (OpenTypeFont.this.os2.supportsCodePage(Os2.CodePage.CP_950_CHINESE_TRADITIONAL)) {
                    hashSet.add(CodePage.TRADITIONAL_CHINESE);
                }
            } else {
                if (OpenTypeFont.this.cff != null) {
                    CodePage[] codePageArray = OpenTypeFont.this.cff.getCFFFont().getXDCFontDescription(null).getXDCCodePages();
                    for (int i = 0; i < codePageArray.length; ++i) {
                        hashSet.add(codePageArray[i]);
                    }
                }
                if (OpenTypeFont.this.cmap != null && (n = OpenTypeFont.this.getCoolTypeUnicodeCmapIndex()) >= 0) {
                    if (OpenTypeFont.this.cmap.char2glyph(234, n) != 0) {
                        hashSet.add(CodePage.ROMAN1);
                    }
                    if (OpenTypeFont.this.cmap.char2glyph(268, n) != 0 || OpenTypeFont.this.cmap.char2glyph(328, n) != 0) {
                        hashSet.add(CodePage.ROMAN2);
                    }
                    if (OpenTypeFont.this.cmap.char2glyph(12450, n) != 0) {
                        hashSet.add(CodePage.JAPANESE);
                    }
                }
            }
            CodePage[] codePageArray = new CodePage[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                codePageArray[n2++] = (CodePage)iterator.next();
            }
            return codePageArray;
        }
    }

    private class OTSWFFont3Description
    implements SWFFontDescription {
        private final boolean wasEmbedded;

        public OTSWFFont3Description(boolean bl) throws InvalidFontException, UnsupportedFontException {
            this.wasEmbedded = bl;
        }

        public boolean canDisplay(char c) throws UnsupportedFontException, InvalidFontException {
            try {
                return OpenTypeFont.this.cmap.unicodeChar2glyph(c) != 0;
            }
            catch (NullPointerException nullPointerException) {
                throw new InvalidFontException("Missing required table", nullPointerException);
            }
        }

        public double getAscent() throws InvalidFontException {
            if (OpenTypeFont.this.os2 != null) {
                return OpenTypeFont.this.os2.getWinAscent();
            }
            if (OpenTypeFont.this.hhea != null) {
                return OpenTypeFont.this.hhea.getAscender();
            }
            return 0.0;
        }

        public double getDescent() throws InvalidFontException {
            if (OpenTypeFont.this.os2 != null) {
                return OpenTypeFont.this.os2.getWinDescent();
            }
            if (OpenTypeFont.this.hhea != null) {
                return -OpenTypeFont.this.hhea.getDescender();
            }
            return 0.0;
        }

        public double getLineGap() throws InvalidFontException {
            if (OpenTypeFont.this.os2 != null) {
                return OpenTypeFont.this.os2.getTypoLineGap();
            }
            if (OpenTypeFont.this.hhea != null) {
                return OpenTypeFont.this.hhea.getLineGap();
            }
            return 0.0;
        }

        public double getEmScale() throws InvalidFontException {
            if (OpenTypeFont.this.head != null) {
                return OpenTypeFont.this.head.getUnitsPerEm();
            }
            throw new InvalidFontException("Cannot determine em");
        }

        public String getFamily() throws InvalidFontException, UnsupportedFontException {
            return OpenTypeFont.this.name.getFirstName(1);
        }

        public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.os2 != null) {
                int n = OpenTypeFont.this.os2.getFirstChar();
                try {
                    n = OpenTypeFont.this.cmap.removeSymbolModifier(n);
                }
                catch (NullPointerException nullPointerException) {
                    throw new InvalidFontException("Missing required table", nullPointerException);
                }
                return n;
            }
            return 0;
        }

        public int getLastChar() throws InvalidFontException, UnsupportedFontException {
            try {
                if (OpenTypeFont.this.cmap.symbolSubtableOffset != -1) {
                    return OpenTypeFont.this.cmap.getHighestMappedCode(OpenTypeFont.this.cmap.symbolSubtableOffset, true);
                }
                if (OpenTypeFont.this.cmap.unicodeSubtableOffset != -1) {
                    return OpenTypeFont.this.cmap.getHighestMappedCode(OpenTypeFont.this.cmap.unicodeSubtableOffset, true);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw new InvalidFontException("Missing required table", nullPointerException);
            }
            return 65535;
        }

        public double getHorizontalAdvance(char c) throws InvalidFontException, UnsupportedFontException {
            try {
                return OpenTypeFont.this.hmtx.getHorizontalAdvance(OpenTypeFont.this.cmap.unicodeChar2glyph(c));
            }
            catch (NullPointerException nullPointerException) {
                throw new InvalidFontException("Missing required table", nullPointerException);
            }
        }

        public int getNumGlyphs() throws InvalidFontException {
            return OpenTypeFont.this.getNumGlyphs();
        }

        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.name == null) {
                return null;
            }
            return OpenTypeFont.this.name.getFirstName(6);
        }

        public String getCopyright() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.name == null) {
                return null;
            }
            return OpenTypeFont.this.name.getFirstName(0);
        }

        public String getTrademark() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.name == null) {
                return null;
            }
            return OpenTypeFont.this.name.getFirstName(7);
        }

        public String getFullName() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.name == null) {
                return null;
            }
            try {
                return OpenTypeFont.this.name.getName(1, 0, 0, 4);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }

        public boolean isBold() throws InvalidFontException, UnsupportedFontException {
            return OpenTypeFont.this.os2 != null && (OpenTypeFont.this.os2.getSelection() & 0x20) != 0;
        }

        public boolean isItalic() throws InvalidFontException, UnsupportedFontException {
            return OpenTypeFont.this.os2 != null && (OpenTypeFont.this.os2.getSelection() & 1) != 0;
        }

        public Permission getPermissions() throws InvalidFontException, UnsupportedFontException {
            Permission permission = OpenTypeFont.this.getEmbeddingPermission(this.wasEmbedded);
            if (permission == Permission.ILLEGAL_VALUE) {
                return Permission.EDITABLE;
            }
            return permission;
        }

        public void getOutline(char c, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidFontException {
            try {
                OpenTypeFont.this.getGlyphOutline(OpenTypeFont.this.cmap.unicodeChar2glyph(c), outlineConsumer);
            }
            catch (NullPointerException nullPointerException) {
                throw new InvalidFontException("Missing required table", nullPointerException);
            }
        }

        public String getSubFamily() throws InvalidFontException, UnsupportedFontException {
            if (OpenTypeFont.this.name == null) {
                return null;
            }
            return OpenTypeFont.this.name.getFirstName(2);
        }
    }

    static class SinglePostscriptName
    extends SingleNameSelector {
        SinglePostscriptName() {
        }

        public boolean nameFound(String string, int n, int n2, int n3) {
            if (this.currentPlatformID == -1) {
                this.currentSelection = string;
                this.currentPlatformID = n;
                this.currentEncoding = n2;
                this.currentLanguage = n3;
                return false;
            }
            if (this.currentPlatformID == 3 && n == 1 && (this.currentLanguage == 1033 || n2 != 0) || this.currentPlatformID == 1 && n == 3 && n3 != 1033 && this.currentEncoding == 0) {
                return false;
            }
            if (this.currentPlatformID != n) {
                this.currentSelection = string;
                this.currentPlatformID = n;
                this.currentEncoding = n2;
                this.currentLanguage = n3;
                return false;
            }
            if (this.currentPlatformID == 3) {
                if (this.pickMSLanguage(n3)) {
                    this.currentSelection = string;
                    this.currentPlatformID = n;
                    this.currentEncoding = n2;
                    this.currentLanguage = n3;
                }
                return false;
            }
            if (this.pickMacName(n2)) {
                this.currentSelection = string;
                this.currentPlatformID = n;
                this.currentEncoding = n2;
                this.currentLanguage = n3;
            }
            return false;
        }

        String getSelection() {
            return this.currentSelection;
        }
    }

    static class SingleFamilyName
    extends SingleNameSelector {
        SingleFamilyName() {
        }

        protected boolean pickMSName(int n, int n2) {
            if (this.currentEncoding == n) {
                return this.pickMSLanguage(n2);
            }
            if (this.currentEncoding == 10) {
                return false;
            }
            if (n == 10) {
                return true;
            }
            if (this.currentEncoding == 1) {
                return false;
            }
            return n == 1;
        }

        public boolean nameFound(String string, int n, int n2, int n3) {
            if (this.currentPlatformID == -1) {
                this.currentSelection = string;
                this.currentPlatformID = n;
                this.currentEncoding = n2;
                this.currentLanguage = n3;
                return false;
            }
            if (this.currentPlatformID == 3 && n == 1) {
                return false;
            }
            if (n == 3 && this.currentPlatformID == 1) {
                this.currentSelection = string;
                this.currentPlatformID = n;
                this.currentEncoding = n2;
                this.currentLanguage = n3;
                return false;
            }
            if (this.currentPlatformID == 3) {
                if (this.pickMSName(n2, n3)) {
                    this.currentSelection = string;
                    this.currentPlatformID = n;
                    this.currentEncoding = n2;
                    this.currentLanguage = n3;
                }
                return false;
            }
            if (this.pickMacName(n2)) {
                this.currentSelection = string;
                this.currentPlatformID = n;
                this.currentEncoding = n2;
                this.currentLanguage = n3;
            }
            return false;
        }

        String getSelection() {
            return this.currentSelection;
        }
    }

    static abstract class SingleNameSelector
    implements Name.NameSelector {
        protected String currentSelection = null;
        protected int currentPlatformID = -1;
        protected int currentEncoding;
        protected int currentLanguage;

        SingleNameSelector() {
        }

        protected boolean pickMSLanguage(int n) {
            return this.currentLanguage != 1033 && n == 1033;
        }

        protected boolean pickMacName(int n) {
            return n == 0 && this.currentEncoding != 0;
        }
    }

    private class ScriptFromCmapSelector
    implements Cmap.CmapSelector {
        int macCount = 0;
        int msCount = 0;
        CoolTypeScript macScript = null;
        CoolTypeScript msScript = null;

        private ScriptFromCmapSelector() {
        }

        public void cmapFound(int n, int n2, int n3) throws InvalidFontException, UnsupportedFontException {
            if (n == 1) {
                if (n2 == 1) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.JAPANESE;
                } else if (n2 == 2) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.TRADITIONAL_CHINESE;
                } else if (n2 == 3) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.KOREAN;
                } else if (n2 == 5) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.HEBREW;
                } else if (n2 == 4) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.ARABIC;
                } else if (n2 == 25) {
                    ++this.macCount;
                    this.macScript = CoolTypeScript.SIMPLIFIED_CHINESE;
                }
            } else if (n == 3) {
                if (n2 == 2) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.JAPANESE;
                } else if (n2 == 4) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.TRADITIONAL_CHINESE;
                } else if (n2 == 3) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.SIMPLIFIED_CHINESE;
                } else if (n2 == 6) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.KOREAN;
                } else if (n2 == 5) {
                    ++this.msCount;
                    this.msScript = CoolTypeScript.KOREAN;
                }
            }
        }

        CoolTypeScript getScript() {
            if (this.macCount <= 1 && this.msCount <= 1) {
                if (this.msCount == 0) {
                    return this.macScript;
                }
                if (this.macCount == 0 || this.macScript == this.msScript) {
                    return this.msScript;
                }
            }
            return null;
        }
    }

    static interface ScriptHeuristicChars {
        public static final int ARABIC = 1570;
        public static final int CYRILLIC1 = 1071;
        public static final int CYRILLIC2 = 1105;
        public static final int EASTERNEUROPEAN1 = 268;
        public static final int EASTERNEUROPEAN2 = 328;
        public static final int EASTERNEUROPEAN3 = 371;
        public static final int GREEK = 971;
        public static final int HEBREW = 1488;
        public static final int JAPANESE = 12450;
        public static final int ROMAN1 = 328;
        public static final int ROMAN2 = 371;
        public static final int ROMAN3 = 234;
        public static final int THAI = 3585;
        public static final int VIETNAMESE = 8363;
    }
}

