/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.CScan;
import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.EmbeddingPermission;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.Type2CStringGenerator;
import com.adobe.fontengine.font.postscript.GlyphNamesAccessor;
import com.adobe.fontengine.font.postscript.NameHeuristics;
import com.adobe.fontengine.font.postscript.ScriptHeuristics;
import com.adobe.fontengine.font.postscript.StandardEncoding;
import com.adobe.fontengine.font.postscript.SubArrays;
import com.adobe.fontengine.font.postscript.Token;
import com.adobe.fontengine.font.postscript.TokenType;
import com.adobe.fontengine.font.postscript.Tokenizer;
import com.adobe.fontengine.font.postscript.UnicodeCmap;
import com.adobe.fontengine.font.type1.AFM;
import com.adobe.fontengine.font.type1.AsciiEexecReader;
import com.adobe.fontengine.font.type1.BinaryEexecReader;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.PFBInputStream;
import com.adobe.fontengine.font.type1.PFM;
import com.adobe.fontengine.font.type1.Type1CStringParser;
import com.adobe.fontengine.font.type1.Type1Glyph;
import com.adobe.fontengine.font.type1.Type1GlyphBBoxCalculator;
import com.adobe.fontengine.font.type1.Type1OutlineParser;
import com.adobe.fontengine.font.type1.Type1Scaler;
import com.adobe.fontengine.font.type1.Type1Subset;
import com.adobe.fontengine.font.type1.Type1WidthFetcher;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Type1Font
extends FontData {
    private Map keyVal;
    private byte[][] subrs;
    private Type1Glyph[] charStrings;
    private MetricFile metricFile;
    private final URL fontLocation;
    private boolean seenPrivate;
    private Map syntheticBaseMap;
    private Map currentMap;
    private static final int maxIntArrayLen = 16;
    private static final int maxDoubleArrayLen = 64;
    private static final Map literals;
    private static final int defaultLenIV = 4;
    static final Matrix defaultFontMatrix;
    static final double[] defaultKernValue;
    private final T1XDCFontDescription xdcDescription;
    UnicodeCmap cmap = null;
    Object cmapMutex = new Object();

    Type1Font(FontInputStream fontInputStream, URL uRL) throws IOException, InvalidFontException, UnsupportedFontException {
        super(null);
        this.keyVal = new HashMap();
        this.currentMap = this.keyVal;
        this.fontLocation = uRL;
        this.parse(fontInputStream);
        this.xdcDescription = new T1XDCFontDescription();
    }

    public MetricFile getMetricFile() {
        return this.metricFile;
    }

    public URL getFontLocation() {
        return this.fontLocation;
    }

    private boolean pickFromEqualMetricFiles(MetricFile metricFile) {
        if (this.metricFile instanceof AFM && metricFile instanceof PFM) {
            this.metricFile = metricFile;
            return true;
        }
        return false;
    }

    private void removeLastFileFromPath(StringBuffer stringBuffer) {
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != '/') continue;
            stringBuffer.delete(i, stringBuffer.length());
            return;
        }
    }

    public boolean setMetricFile(MetricFile metricFile) {
        if (this.metricFile == null) {
            this.metricFile = metricFile;
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer(this.metricFile.getLocation().getPath());
        StringBuffer stringBuffer2 = new StringBuffer(metricFile.getLocation().getPath());
        if (this.fontLocation == null) {
            return this.pickFromEqualMetricFiles(metricFile);
        }
        StringBuffer stringBuffer3 = new StringBuffer(this.fontLocation.getPath());
        this.removeLastFileFromPath(stringBuffer3);
        for (int i = 0; i < 2; ++i) {
            this.removeLastFileFromPath(stringBuffer);
            this.removeLastFileFromPath(stringBuffer2);
            if (stringBuffer.length() == stringBuffer3.length() && SubArrays.stringBufferCompare(stringBuffer, 0, stringBuffer3, 0, stringBuffer3.length())) {
                if (stringBuffer2.length() == stringBuffer3.length() && SubArrays.stringBufferCompare(stringBuffer2, 0, stringBuffer3, 0, stringBuffer3.length())) {
                    return this.pickFromEqualMetricFiles(metricFile);
                }
                return false;
            }
            if (stringBuffer2.length() != stringBuffer3.length() || !SubArrays.stringBufferCompare(stringBuffer2, 0, stringBuffer3, 0, stringBuffer3.length())) continue;
            this.metricFile = metricFile;
            return true;
        }
        return this.pickFromEqualMetricFiles(metricFile);
    }

    private Integer parseInteger(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kINTEGER) {
            return new Integer(token.convertInteger(0));
        }
        return null;
    }

    private Double parseNumber(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kINTEGER) {
            return new Double(token.convertInteger(0));
        }
        if (token.tokenType == TokenType.kREAL) {
            return new Double(Double.parseDouble(new String(token.buff, 0, token.tokenLength)));
        }
        return null;
    }

    private byte[] parseBytes(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kSTRING) {
            byte[] byArray = new byte[token.tokenLength - 2];
            System.arraycopy(token.buff, 1, byArray, 0, token.tokenLength - 2);
            return byArray;
        }
        return new byte[0];
    }

    private String parseString(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kSTRING) {
            char[] cArray = new char[token.tokenLength - 2];
            for (int i = 1; i < token.tokenLength - 1; ++i) {
                cArray[i - 1] = (char)token.buff[i];
            }
            return new String(cArray);
        }
        return null;
    }

    private String parseName(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kSTRING) {
            return token.stringTokenToString(1, token.tokenLength - 1);
        }
        if (token.tokenType == TokenType.kLITERAL) {
            return token.stringTokenToString(1, token.tokenLength);
        }
        return null;
    }

    private Boolean parseBool(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kOPERATOR) {
            if (SubArrays.arrayCompare(token.buff, 0, Operators.kTRUE, 0, Operators.kTRUE.length)) {
                return true;
            }
            if (SubArrays.arrayCompare(token.buff, 0, Operators.kFALSE, 0, Operators.kFALSE.length)) {
                return false;
            }
        }
        return null;
    }

    private OrigFontType parseOrigFontType(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kLITERAL) {
            if (SubArrays.arrayCompare(token.buff, 0, Literals.kTRUETYPE_LITERAL, 0, token.tokenLength)) {
                return OrigFontType.kTRUETYPE;
            }
            if (SubArrays.arrayCompare(token.buff, 0, Literals.kTYPE1_LITERAL, 0, token.tokenLength)) {
                return OrigFontType.kTYPE1;
            }
            if (SubArrays.arrayCompare(token.buff, 0, Literals.kCID_LITERAL, 0, token.tokenLength)) {
                return OrigFontType.kCID;
            }
            if (SubArrays.arrayCompare(token.buff, 0, Literals.kOCF_LITERAL, 0, token.tokenLength)) {
                return OrigFontType.kOCF;
            }
        }
        return null;
    }

    private int[] parseIntArray(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kARRAY || token.tokenType == TokenType.kPROCEDURE) {
            int[] nArray = new int[17];
            int n = 0;
            boolean bl = false;
            block4: for (int i = 0; i < token.tokenLength; ++i) {
                switch (token.buff[i]) {
                    default: {
                        bl = false;
                        continue block4;
                    }
                    case 43: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (bl) continue block4;
                        nArray[n++] = token.convertInteger(i);
                        bl = true;
                    }
                    case 35: 
                }
            }
            if (n > 0) {
                int[] nArray2 = new int[n];
                System.arraycopy(nArray, 0, nArray2, 0, n);
                return nArray2;
            }
        }
        return new int[0];
    }

    private double[] parseNumArray(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kARRAY || token.tokenType == TokenType.kPROCEDURE) {
            double[] dArray = new double[65];
            int n = 0;
            for (int i = 0; i < token.tokenLength; ++i) {
                switch (token.buff[i]) {
                    case 43: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        int n2;
                        boolean bl = false;
                        block9: for (n2 = i + 1; n2 < token.tokenLength && !bl; ++n2) {
                            switch (token.buff[n2]) {
                                case 43: 
                                case 45: 
                                case 46: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 69: 
                                case 101: {
                                    continue block9;
                                }
                                default: {
                                    bl = true;
                                }
                            }
                        }
                        String string = new String(token.buff, i, n2 - i - 1, "US-ASCII");
                        try {
                            dArray[n++] = Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidFontException(numberFormatException);
                        }
                        i = n2 - 1;
                    }
                }
            }
            if (n > 0) {
                double[] dArray2 = new double[n];
                System.arraycopy(dArray, 0, dArray2, 0, n);
                return dArray2;
            }
        }
        return new double[0];
    }

    private void parseEncoding(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (SubArrays.arrayCompare(token.buff, 0, Operators.kSTANDARDENCODING, 0, Operators.kSTANDARDENCODING.length)) {
            this.keyVal.put(Type1Keys.StandardEncoding, true);
            return;
        }
        byte[][] byArrayArray = new byte[256][];
        for (int i = 0; i < 256; ++i) {
            byArrayArray[i] = Operators.kNOTDEF;
        }
        while (true) {
            if (SubArrays.arrayCompare(token.buff, 0, Operators.kDUP, 0, Operators.kDUP.length)) {
                int n;
                token = tokenizer.getNextPSToken();
                if (token.tokenType != TokenType.kINTEGER || (n = token.convertInteger(0)) < 0 || n > 255) continue;
                token = tokenizer.getNextPSToken();
                if (token.tokenType != TokenType.kLITERAL) continue;
                byte[] byArray = new byte[token.tokenLength - 1];
                System.arraycopy(token.buff, 1, byArray, 0, byArray.length);
                token = tokenizer.getNextPSToken();
                if (!SubArrays.arrayCompare(token.buff, 0, Operators.kPUT, 0, Operators.kPUT.length)) continue;
                byArrayArray[n] = byArray;
            } else if (SubArrays.arrayCompare(token.buff, 0, Operators.kDEF, 0, Operators.kDEF.length) || SubArrays.arrayCompare(token.buff, 0, Operators.kREADONLY, 0, Operators.kREADONLY.length)) {
                this.keyVal.put(Type1Keys.Encoding, byArrayArray);
                return;
            }
            token = tokenizer.getNextPSToken();
        }
    }

    private int readCharStringLen(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType != TokenType.kINTEGER) {
            return 0;
        }
        int n = token.convertInteger(0);
        if (n < 1 || n > 65535) {
            return 0;
        }
        token = tokenizer.getNextPSToken();
        if (token.tokenType != TokenType.kOPERATOR) {
            return 0;
        }
        return n;
    }

    private void readLenIVBytes(byte[] byArray, Tokenizer tokenizer) throws IOException, InvalidFontException {
        tokenizer.read();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)tokenizer.read();
        }
    }

    private byte[] readCharString(Tokenizer tokenizer, int n) throws IOException, InvalidFontException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)tokenizer.read();
        }
        return byArray;
    }

    private void decryptCharString(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        int n2 = 4330;
        for (n = 0; n < byArray.length; ++n) {
            n2 = ((byArray[n] & 0xFF) + n2) * 52845 + 22719 & 0xFFFF;
        }
        for (n = 0; n < byArray2.length; ++n) {
            int n3 = byArray2[n] & 0xFF;
            byArray3[n] = (byte)(n3 ^ n2 >> 8);
            n2 = (n3 + n2) * 52845 + 22719 & 0xFFFF;
        }
    }

    private void parseChars(Tokenizer tokenizer) throws IOException, InvalidFontException {
        byte[] byArray;
        boolean bl = false;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[]{32};
        Object v = this.keyVal.get(Type1Keys.lenIV);
        int n = v == null ? 4 : (Integer)v;
        if (n >= 0) {
            byArray2 = new byte[n];
        }
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType != TokenType.kINTEGER) {
            return;
        }
        int n2 = token.convertInteger(0);
        if (n2 < 0) {
            return;
        }
        ArrayList<Type1Glyph> arrayList = new ArrayList<Type1Glyph>(n2);
        tokenizer.findToken(Operators.kBEGIN);
        for (int i = 0; i < n2 && !(token = tokenizer.getNextPSToken()).matches(Operators.kEND); ++i) {
            byte[] byArray4;
            if (token.tokenType != TokenType.kLITERAL) continue;
            if (token.tokenLength > 1) {
                byArray4 = new byte[token.tokenLength - 1];
                System.arraycopy(token.buff, 1, byArray4, 0, token.tokenLength - 1);
            } else {
                byArray4 = byArray3;
            }
            int n3 = this.readCharStringLen(tokenizer) - (byArray2 != null ? n : 0);
            if (n3 < 1 || n3 > 65535) continue;
            if (byArray2 != null) {
                this.readLenIVBytes(byArray2, tokenizer);
            }
            byArray = this.readCharString(tokenizer, n3);
            if (byArray2 != null) {
                this.decryptCharString(byArray2, byArray, byArray);
            }
            if (byArray4.length == Literals.kNOTDEF.length && SubArrays.arrayCompare(byArray4, 0, Literals.kNOTDEF, 0, Literals.kNOTDEF.length)) {
                bl = true;
            }
            arrayList.add(new Type1Glyph(byArray4, byArray));
            token = tokenizer.getNextPSToken();
        }
        if (!bl) {
            byArray = new byte[]{-117, -9, -114, 13, 14};
            arrayList.add(new Type1Glyph(Literals.kNOTDEF, byArray));
        }
        this.charStrings = new Type1Glyph[arrayList.size()];
        arrayList.toArray(this.charStrings);
        Arrays.sort(this.charStrings, CharstringCompare.comparator);
    }

    private void parseSubrs(Tokenizer tokenizer) throws IOException, InvalidFontException {
        byte[] byArray = null;
        Object v = this.keyVal.get(Type1Keys.lenIV);
        int n = v == null ? 4 : (Integer)v;
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType != TokenType.kINTEGER) {
            return;
        }
        int n2 = token.convertInteger(0);
        if (n2 < 0 || n2 > 65535) {
            return;
        }
        this.subrs = new byte[n2][];
        if (n >= 0) {
            byArray = new byte[n];
        }
        tokenizer.findToken(Operators.kARRAY);
        int n3 = 0;
        while (true) {
            if (!(token = tokenizer.getNextPSToken()).matches(Operators.kDUP)) {
                return;
            }
            token = tokenizer.getNextPSToken();
            if (token.tokenType != TokenType.kINTEGER) {
                return;
            }
            int n4 = token.convertInteger(0);
            if (n4 < 0 || n4 >= n2) {
                return;
            }
            int n5 = this.readCharStringLen(tokenizer) - (byArray != null ? n : 0);
            if (byArray != null) {
                this.readLenIVBytes(byArray, tokenizer);
            }
            byte[] byArray2 = this.readCharString(tokenizer, n5);
            if (byArray != null) {
                this.decryptCharString(byArray, byArray2, byArray2);
            }
            this.subrs[n4] = byArray2;
            token = tokenizer.getNextPSToken();
            if (token.tokenType != TokenType.kOPERATOR) {
                return;
            }
            if (token.matches(Operators.kNOACCESS)) {
                token = tokenizer.getNextPSToken();
                if (token.tokenType != TokenType.kOPERATOR) break;
            }
            ++n3;
        }
    }

    private void parseFontMatrix(Tokenizer tokenizer) throws IOException, InvalidFontException {
        double[] dArray = this.parseNumArray(tokenizer);
        if (dArray.length == 6 && (dArray[0] != 0.001 || dArray[1] != 0.0 || dArray[2] != 0.0 || dArray[3] != 0.001 || dArray[4] != 0.0 || dArray[5] != 0.0)) {
            if (dArray[4] != 0.0 || dArray[5] != 0.0) {
                throw new InvalidFontException("non-zero translation components in the font matrix");
            }
            double d = dArray[0] * dArray[3] - dArray[2] * dArray[1];
            double d2 = Math.abs(d);
            if (d2 < 1.0) {
                double d3 = Double.MAX_VALUE * d2;
                if (Math.abs(dArray[0]) >= d3 || Math.abs(dArray[1]) >= d3 || Math.abs(dArray[2]) >= d3 || Math.abs(dArray[3]) >= d3) {
                    throw new InvalidFontException("non-invertible font matrix");
                }
            }
            this.currentMap.put(Type1Keys.FontMatrix, new Matrix(dArray));
            Matrix matrix = new Matrix(dArray[3] / d, -dArray[1] / d, -dArray[2] / d, dArray[0] / d, 0.0, 0.0);
            this.currentMap.put(Type1Keys.InvertedFontMatrix, matrix);
        }
    }

    private void parseErodeProc(Tokenizer tokenizer) throws IOException, InvalidFontException {
        if (this.keyVal.get(Type1Keys.StdVW) != null) {
            return;
        }
        Token token = tokenizer.getNextPSToken();
        int n = 0;
        if (token.tokenType == TokenType.kPROCEDURE) {
            for (int i = 1; i < token.tokenLength; ++i) {
                while (i < token.tokenLength && Tokenizer.isWhite(token.buff[i])) {
                    ++i;
                }
                if (i == token.tokenLength || token.buff[i] == 125) break;
                if (++n == 16) {
                    Double d = new Double(token.convertInteger(i));
                    this.keyVal.put(Type1Keys.StdVW, d);
                    break;
                }
                while (i < token.tokenLength && !Tokenizer.isWhite(token.buff[i])) {
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doLiteral(Tokenizer tokenizer, Token token) throws IOException, InvalidFontException, UnsupportedFontException {
        String string = new String(token.buff, 1, token.tokenLength - 1, "ISO-8859-1");
        ArgumentType argumentType = (ArgumentType)literals.get(string);
        if (argumentType == null) {
            return false;
        }
        if (argumentType == ArgumentType.kBOOL) {
            Boolean bl = this.parseBool(tokenizer);
            if (bl == null) return false;
            this.keyVal.put(string, bl);
            return false;
        } else if (argumentType == ArgumentType.kSTRING) {
            String string2 = this.parseString(tokenizer);
            if (string2 == null) return false;
            this.currentMap.put(string, string2);
            return false;
        } else if (argumentType == ArgumentType.kBYTES) {
            byte[] byArray = this.parseBytes(tokenizer);
            if (byArray.length == 0) return false;
            this.keyVal.put(string, byArray);
            return false;
        } else if (argumentType == ArgumentType.kNAME) {
            String string3 = this.parseName(tokenizer);
            if (string3 == null) return false;
            this.currentMap.put(string, string3);
            return false;
        } else if (argumentType == ArgumentType.kNUMARRAY) {
            double[] dArray = this.parseNumArray(tokenizer);
            if (dArray.length == 0) return false;
            this.keyVal.put(string, dArray);
            return false;
        } else if (argumentType == ArgumentType.kBBOX) {
            double[] dArray = this.parseNumArray(tokenizer);
            if (dArray.length != 4) return false;
            this.keyVal.put(string, new Rect(dArray[0], dArray[1], dArray[2], dArray[3]));
            return false;
        } else if (argumentType == ArgumentType.kINTARRAY) {
            int[] nArray = this.parseIntArray(tokenizer);
            if (nArray.length == 0) return false;
            this.keyVal.put(string, nArray);
            return false;
        } else if (argumentType == ArgumentType.kINTEGER) {
            Integer n = this.parseInteger(tokenizer);
            if (n == null) return false;
            this.keyVal.put(string, n);
            return false;
        } else if (argumentType == ArgumentType.kNUMBER) {
            Double d = this.parseNumber(tokenizer);
            if (d == null) return false;
            this.keyVal.put(string, d);
            return false;
        } else if (argumentType == ArgumentType.kARRAYOF1) {
            double[] dArray = this.parseNumArray(tokenizer);
            if (dArray.length != 1) return false;
            this.keyVal.put(string, new Double(dArray[0]));
            return false;
        } else if (argumentType == ArgumentType.kITALICANGLE) {
            Double d = this.parseNumber(tokenizer);
            if (d == null) return false;
            this.currentMap.put(string, d);
            return false;
        } else {
            if (argumentType == ArgumentType.kCHARSTRINGS) {
                this.parseChars(tokenizer);
                return true;
            }
            if (argumentType == ArgumentType.kSUBRS) {
                this.parseSubrs(tokenizer);
                return false;
            } else if (argumentType == ArgumentType.kERODE) {
                this.parseErodeProc(tokenizer);
                return false;
            } else if (argumentType == ArgumentType.kFONTTYPE) {
                Integer n = this.parseInteger(tokenizer);
                if (n == null || n != 1) throw new UnsupportedFontException("Fonttype not supported");
                this.keyVal.put(string, n);
                return false;
            } else if (argumentType == ArgumentType.kORIGFONTTYPE) {
                OrigFontType origFontType = this.parseOrigFontType(tokenizer);
                if (origFontType == null) return false;
                this.keyVal.put(string, origFontType);
                return false;
            } else if (argumentType == ArgumentType.kENCODING) {
                this.parseEncoding(tokenizer);
                return false;
            } else if (argumentType == ArgumentType.kFONTMATRIX) {
                this.parseFontMatrix(tokenizer);
                return false;
            } else if (argumentType == ArgumentType.kRNDSTEMUP) {
                this.keyVal.put(Type1Keys.LanguageGroup, new Integer(1));
                return false;
            } else if (argumentType == ArgumentType.kPRIVATE) {
                this.seenPrivate = true;
                return false;
            } else {
                if (argumentType != ArgumentType.kUNSUPPORTEDFONT) return false;
                throw new UnsupportedFontException("unsupported fonttype");
            }
        }
    }

    private void setupEexec(Tokenizer tokenizer) throws IOException, InvalidFontException {
        int n;
        boolean bl = false;
        byte[] byArray = new byte[8];
        int n2 = tokenizer.read();
        for (n = 0; n < 4; ++n) {
            n2 = tokenizer.read();
            if (!Tokenizer.isHex(n2) && n2 != 32 && n2 != 9 && n2 != 10 && n2 != 13) {
                bl = true;
            }
            byArray[n] = (byte)n2;
        }
        if (bl) {
            BinaryEexecReader binaryEexecReader = new BinaryEexecReader();
            binaryEexecReader.decryptBuffer(byArray, 4);
            tokenizer.setReader(binaryEexecReader);
        } else {
            while (Tokenizer.isWhite(byArray[0])) {
                for (n = 0; n < 3; ++n) {
                    byArray[n] = byArray[n + 1];
                }
                n2 = tokenizer.read();
                byArray[3] = (byte)n2;
            }
            for (n = 4; n < 8; ++n) {
                n2 = tokenizer.read();
                byArray[n] = (byte)n2;
            }
            AsciiEexecReader asciiEexecReader = new AsciiEexecReader();
            asciiEexecReader.decryptBuffer(byArray, 8);
            tokenizer.setReader(asciiEexecReader);
        }
    }

    private void doOperator(Tokenizer tokenizer, Token token) throws IOException, InvalidFontException {
        if (SubArrays.arrayCompare(token.buff, 0, Operators.kCURRENTFILE, 0, Operators.kCURRENTFILE.length)) {
            Token token2 = tokenizer.getNextPSToken();
            if (SubArrays.arrayCompare(token2.buff, 0, Operators.kEEXEC, 0, Operators.kEEXEC.length)) {
                this.setupEexec(tokenizer);
            }
        } else if (this.seenPrivate && SubArrays.arrayCompare(token.buff, 0, Operators.kFONTDIRECTORY, 0, Operators.kCURRENTFILE.length)) {
            this.syntheticBaseMap = new HashMap();
            this.currentMap = this.syntheticBaseMap;
        }
    }

    private void parse(FontInputStream fontInputStream) throws IOException, InvalidFontException, UnsupportedFontException {
        int n = fontInputStream.read();
        fontInputStream.unread(n);
        if (n == 128) {
            fontInputStream = new PFBInputStream(fontInputStream);
        }
        this.seenPrivate = false;
        Tokenizer tokenizer = new Tokenizer(fontInputStream);
        while (true) {
            Token token = tokenizer.getNextPSToken();
            if (token.tokenType == TokenType.kLITERAL) {
                if (!this.doLiteral(tokenizer, token)) continue;
                break;
            }
            if (token.tokenType != TokenType.kOPERATOR) continue;
            this.doOperator(tokenizer, token);
        }
        Object v = this.keyVal.get(Type1Keys.FullName);
        if (v != null) {
            String string = (String)v;
            this.keyVal.put(Type1Keys.CSSWeight, new Integer(NameHeuristics.fullNameToWeight(string)));
            this.keyVal.put(Type1Keys.CSSWidth, NameHeuristics.fullNameToWidth(string, (String)this.keyVal.get("FamilyName")));
            this.keyVal.put(Type1Keys.IsSmallCaps, NameHeuristics.fullNameIndicatesSmallCaps(string));
        }
    }

    Object getValue(String string) {
        return this.keyVal.get(string);
    }

    public int glyphName2gid(String string) {
        Type1Glyph type1Glyph = new Type1Glyph(string);
        int n = Arrays.binarySearch(this.charStrings, type1Glyph, CharstringCompare.comparator);
        if (n < 0) {
            return 0;
        }
        if (this.charStrings[n].glyphName.equals(string)) {
            return n;
        }
        return 0;
    }

    private String charCode2GlyphName(int n) {
        Object object = this.getValue(Type1Keys.StandardEncoding);
        if (object != null && ((Boolean)object).booleanValue()) {
            if (0 <= n && n < StandardEncoding.names.length) {
                return StandardEncoding.names[n];
            }
            return ".notdef";
        }
        object = this.getValue(Type1Keys.Encoding);
        if (object != null) {
            byte[][] byArray = (byte[][])object;
            byte[] byArray2 = byArray[n];
            return this.bytesToString(byArray2);
        }
        return ".notdef";
    }

    public int charCode2gid(int n) {
        return this.glyphName2gid(this.charCode2GlyphName(n));
    }

    public int getNumGlyphs() {
        return this.charStrings.length;
    }

    byte[] getCharstring(int n) {
        return this.charStrings[n].charString;
    }

    public ROS getROS() {
        return null;
    }

    public String getGlyphName(int n) {
        return this.charStrings[n].glyphName;
    }

    int getNumSubrs() {
        return this.subrs.length;
    }

    byte[] getSubr(int n) {
        return this.subrs[n];
    }

    public String getPostscriptName() {
        Object object = this.getValue(Type1Keys.FontName);
        if (object != null) {
            return (String)object;
        }
        return null;
    }

    public double getStemV() {
        Object object = (Double)this.getValue(Type1Keys.StdVW);
        if (object != null) {
            return (Double)object * this.getFontMatrix().a * this.getUnitsPerEmX();
        }
        object = (double[])this.getValue(Type1Keys.StemSnapV);
        if (object != null && ((Object)object).length != 0) {
            return (double)(object[0] * this.getFontMatrix().a * this.getUnitsPerEmX());
        }
        return 0.0;
    }

    public Matrix getFontMatrix() {
        Matrix matrix = (Matrix)this.getValue(Type1Keys.FontMatrix);
        if (matrix != null) {
            return matrix;
        }
        return defaultFontMatrix;
    }

    public double getUnitsPerEmX() {
        return 1.0 / this.getFontMatrix().a;
    }

    public double getUnitsPerEmY() {
        return 1.0 / this.getFontMatrix().d;
    }

    private Matrix getFontToMetricsMatrix() {
        Matrix matrix = this.getFontMatrix();
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        return new Matrix(d * matrix.a, d2 * matrix.b, d * matrix.c, d2 * matrix.d, d * matrix.tx, d2 * matrix.ty);
    }

    public Rect getFontBBox() {
        Rect rect = (Rect)this.getValue("FontBBox");
        if (rect == null) {
            return null;
        }
        return rect.applyMatrix(this.getFontToMetricsMatrix());
    }

    public Rect getCoolTypeRawFontBBox() {
        return this.getFontBBox();
    }

    public CoolTypeScript getCoolTypeScript() throws UnsupportedFontException, InvalidFontException {
        return ScriptHeuristics.getCoolTypeScript(this.getPostscriptName(), 256, new GlyphNamesAccessor(){

            public String getAGlyphName(int n) throws UnsupportedFontException, InvalidFontException {
                return Type1Font.this.charCode2GlyphName(n);
            }
        });
    }

    private Rect getCoolTypeIdeoEmBoxFromCapHeight() throws InvalidFontException, UnsupportedFontException {
        double d = this.getCoolTypeCapHeight();
        if (Double.isNaN(d)) {
            return null;
        }
        double d2 = this.getUnitsPerEmX();
        double d3 = this.getUnitsPerEmY();
        double d4 = -(d3 - d) / 2.0;
        return new Rect(0.0, d4, d2, d4 + d3);
    }

    public Rect getCoolTypeIdeoEmBox() throws InvalidFontException, UnsupportedFontException {
        if (this.useCoolTypeCJKHeuristics()) {
            Rect rect = this.getCoolTypeIdeoEmBoxFromFullBoxCharacter();
            if (rect != null) {
                return rect;
            }
            rect = this.getCoolTypeIdeoEmBoxFromTypicalCharacter();
            if (rect != null) {
                return rect;
            }
        } else {
            Rect rect = this.getCoolTypeIdeoEmBoxFromCapHeight();
            if (rect != null) {
                return rect;
            }
        }
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        return new Rect(0.0, -0.12 * d2, d, 0.88 * d2);
    }

    public Rect getCoolTypeIcfBox() throws InvalidFontException, UnsupportedFontException {
        Rect rect = this.getCoolTypeIdeoEmBox();
        Rect rect2 = this.getCoolTypeIcfBoxFromTypicalCharacter(rect);
        if (rect2 != null) {
            return rect2;
        }
        return this.getCoolTypeIcfBoxFromIdeoEmBox(rect);
    }

    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeLineMetricsFromFontBbox();
    }

    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException {
        double d = -150.0;
        Object object = this.getValue("UnderlinePosition");
        if (object != null) {
            d = (Double)object;
        }
        double d2 = 50.0;
        object = this.getValue("UnderlineThickness");
        if (object != null) {
            d2 = (Double)object;
        }
        double d3 = this.getCoolTypeUnitsPerEm();
        double d4 = this.getUnitsPerEmY();
        return new UnderlineMetrics(d * d4 / d3, d2 * d4 / d3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFirstChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getFirstSupportedChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLastChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getLastSupportedChar();
        }
    }

    private boolean isDingbat() {
        Object object = this.getValue(Type1Keys.FullName);
        return NameHeuristics.fullNameIndicatesDingbats(object != null ? (String)object : null);
    }

    private void initCmap() throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            this.cmap = UnicodeCmap.computeCmapFromGlyphNames(this.getNumGlyphs(), this.isDingbat(), new GlyphNamesAccessor(){

                public String getAGlyphName(int n) throws UnsupportedFontException, InvalidFontException {
                    return Type1Font.this.getGlyphName(n);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGlyphForChar(int n) throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getGlyphForChar(n);
        }
    }

    public double getHorizontalAdvance(int n) throws InvalidGlyphException, UnsupportedFontException {
        Type1WidthFetcher type1WidthFetcher = new Type1WidthFetcher();
        Type1CStringParser type1CStringParser = new Type1CStringParser();
        type1CStringParser.parse(type1WidthFetcher, this, n);
        return type1WidthFetcher.getWidth() * (this.getFontMatrix().a * this.getUnitsPerEmX());
    }

    public double getKernValue(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        if (this.metricFile == null) {
            return 0.0;
        }
        double d = this.metricFile.getKernValue(this.getGlyphName(n), this.getGlyphName(n2));
        return d * this.getUnitsPerEmX() / 1000.0;
    }

    public void getGlyphOutline(int n, OutlineConsumer outlineConsumer) throws InvalidFontException, UnsupportedFontException {
        Type1OutlineParser type1OutlineParser = new Type1OutlineParser();
        type1OutlineParser.parse(this, n, outlineConsumer);
    }

    public Rect getGlyphBBox(int n) throws UnsupportedFontException, InvalidFontException {
        Matrix matrix = new Matrix(this.getUnitsPerEmX(), 0.0, 0.0, this.getUnitsPerEmY(), 0.0, 0.0);
        return new Type1GlyphBBoxCalculator(matrix).calculateBBox(this, n);
    }

    public Scaler getScaler(ScanConverter scanConverter) throws InvalidFontException, UnsupportedFontException {
        if (scanConverter == null) {
            scanConverter = new CScan(false, 1.0, true);
        }
        return new Type1Scaler(this, scanConverter);
    }

    public Set getCSSFamilyNames() {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        String string = null;
        if (this.metricFile != null && (string = this.metricFile.getFamilyName()) != null) {
            hashSet.add(string);
        }
        if ((object = this.getValue(Type1Keys.FamilyName)) != null) {
            hashSet.add(object);
        }
        return hashSet;
    }

    public String getPreferredCSSFamilyName() {
        Object object;
        if (this.metricFile != null && (object = this.metricFile.getFamilyName()) != null) {
            return object;
        }
        object = this.getValue(Type1Keys.FamilyName);
        if (object != null) {
            return (String)object;
        }
        return null;
    }

    public boolean isCSSStyleNormal() {
        if (this.metricFile != null && this.metricFile instanceof PFM) {
            return !((PFM)this.metricFile).isItalic();
        }
        Object object = this.getValue(Type1Keys.ItalicAngle);
        if (object == null) {
            return true;
        }
        Double d = (Double)object;
        return d == 0.0;
    }

    public boolean isCSSStyleItalic() {
        return !this.isCSSStyleNormal();
    }

    public boolean isCSSStyleOblique() {
        return !this.isCSSStyleNormal();
    }

    public boolean isCSSVariantNormal() {
        Object object = this.getValue(Type1Keys.IsSmallCaps);
        if (object != null) {
            return (Boolean)object == false;
        }
        return true;
    }

    public boolean isCSSVariantSmallCaps() {
        Object object = this.getValue(Type1Keys.IsSmallCaps);
        if (object != null) {
            return (Boolean)object;
        }
        return false;
    }

    public int getCSSWeight() {
        int n;
        if (this.metricFile != null && (n = this.metricFile.getWeight()) != 0) {
            return n;
        }
        Object object = this.getValue(Type1Keys.CSSWeight);
        if (object != null) {
            return (Integer)object;
        }
        return 400;
    }

    public CSS20Attribute.CSSStretchValue getCSSStretchValue() {
        Object object = this.getValue(Type1Keys.CSSWidth);
        if (object != null) {
            return (CSS20Attribute.CSSStretchValue)object;
        }
        return CSS20Attribute.CSSStretchValue.NORMAL;
    }

    public PostscriptFontDescription[] getPostscriptFontDescription() {
        String string = this.getPostscriptName();
        if (string != null) {
            return new PostscriptFontDescription[]{new PostscriptFontDescription(string)};
        }
        return new PostscriptFontDescription[0];
    }

    public PDFFontDescription getPDFFontDescription(Font font) {
        return this.xdcDescription;
    }

    public XDCFontDescription getXDCFontDescription(Font font) {
        return this.xdcDescription;
    }

    public boolean getCoolTypeProportionalRomanFromFontProperties() throws InvalidFontException {
        Boolean bl = (Boolean)this.getValue(Type1Keys.isFixedPitch);
        if (bl != null) {
            return bl == false;
        }
        return true;
    }

    public Permission getEmbeddingPermission(boolean bl) {
        Integer n = (Integer)this.getValue(Type1Keys.FSType);
        if (n != null) {
            return EmbeddingPermission.interpretFSType(n);
        }
        OrigFontType origFontType = (OrigFontType)this.getValue(Type1Keys.OrigFontType);
        if (origFontType == null || origFontType == OrigFontType.kTYPE1) {
            String string = this.getPostscriptName();
            byte[] byArray = (byte[])this.getValue(Type1Keys.Notice);
            String string2 = byArray == null ? null : this.bytesToString(byArray);
            return EmbeddingPermission.getType1DefaultPermission(string2, string);
        }
        if (bl) {
            return EmbeddingPermission.getDefaultWasEmbeddedPermission();
        }
        if (origFontType == OrigFontType.kCID) {
            int[] nArray = (int[])this.getValue(Type1Keys.XUID);
            return EmbeddingPermission.getCIDDefaultPermission(nArray);
        }
        if (origFontType == OrigFontType.kTRUETYPE) {
            return EmbeddingPermission.getTrueTypeDefaultPermission();
        }
        return EmbeddingPermission.getOCFDefaultPermission();
    }

    public Subset createSubset() throws UnsupportedFontException, InvalidFontException {
        return new Type1Subset(this);
    }

    private String bytesToString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    private Dict createTopDict() throws InvalidFontException {
        byte[] byArray = (byte[])this.getValue(Type1Keys.version);
        String string = byArray == null ? null : this.bytesToString(byArray);
        byArray = (byte[])this.getValue(Type1Keys.Notice);
        String string2 = byArray == null ? null : this.bytesToString(byArray);
        byArray = (byte[])this.getValue(Type1Keys.Copyright);
        String string3 = byArray == null ? null : this.bytesToString(byArray);
        byArray = (byte[])this.getValue(Type1Keys.PostScript);
        String string4 = byArray == null ? null : this.bytesToString(byArray);
        OrigFontType origFontType = (OrigFontType)this.getValue(Type1Keys.OrigFontType);
        string4 = origFontType != null ? (string4 == null ? "/OrigFontType /" + origFontType.toString() + " def" : string4 + " /OrigFontType /" + origFontType.toString() + " def") : (string4 == null ? "/OrigFontType /Type1 def" : string4 + " /OrigFontType /Type1 def");
        String string5 = (String)this.getValue(Type1Keys.FullName);
        String string6 = (String)this.getValue(Type1Keys.FamilyName);
        String string7 = (String)this.getValue(Type1Keys.Weight);
        Boolean bl = (Boolean)this.getValue(Type1Keys.isFixedPitch);
        Double d = (Double)this.getValue(Type1Keys.ItalicAngle);
        Double d2 = (Double)this.getValue(Type1Keys.UnderlinePosition);
        Double d3 = (Double)this.getValue(Type1Keys.UnderlineThickness);
        Integer n = (Integer)this.getValue(Type1Keys.PaintType);
        Integer n2 = (Integer)this.getValue(Type1Keys.UniqueID);
        Rect rect = (Rect)this.getValue(Type1Keys.FontBBox);
        Double d4 = (Double)this.getValue(Type1Keys.StrokeWidth);
        int[] nArray = (int[])this.getValue(Type1Keys.XUID);
        Integer n3 = (Integer)this.getValue(Type1Keys.FSType);
        int[] nArray2 = (int[])this.getValue(Type1Keys.BaseFontBlend);
        String string8 = (String)this.getValue(Type1Keys.BaseFontName);
        String string9 = (String)this.getValue(Type1Keys.FontName);
        return new Dict("Adobe", "Identity", 0, string, string2, string3, string5, string9, string6, string7, bl, d, d2, d3, n, n2, rect, d4, nArray, string4, n3, nArray2, string8);
    }

    private Dict createPrivateDict(double d, double d2) {
        double[] dArray = (double[])this.getValue(Type1Keys.BlueValues);
        double[] dArray2 = (double[])this.getValue(Type1Keys.OtherBlues);
        double[] dArray3 = (double[])this.getValue(Type1Keys.FamilyBlues);
        double[] dArray4 = (double[])this.getValue(Type1Keys.FamilyOtherBlues);
        Double d3 = (Double)this.getValue(Type1Keys.BlueScale);
        Double d4 = (Double)this.getValue(Type1Keys.BlueShift);
        Integer n = (Integer)this.getValue(Type1Keys.BlueFuzz);
        Double d5 = (Double)this.getValue(Type1Keys.StdHW);
        Double d6 = (Double)this.getValue(Type1Keys.StdVW);
        double[] dArray5 = (double[])this.getValue(Type1Keys.StemSnapH);
        double[] dArray6 = (double[])this.getValue(Type1Keys.StemSnapV);
        Boolean bl = (Boolean)this.getValue(Type1Keys.ForceBold);
        Integer n2 = (Integer)this.getValue(Type1Keys.LanguageGroup);
        Double d7 = (Double)this.getValue(Type1Keys.ExpansionFactor);
        Integer n3 = (Integer)this.getValue(Type1Keys.initialRandomSeed);
        return new Dict(dArray, dArray2, dArray3, dArray4, d3, d4, n, d5, d6, dArray5, dArray6, bl, n2, d7, n3, new Double(d), new Double(d2));
    }

    private Type2CStringGenerator seedGenerator(Subset subset) throws InvalidFontException, UnsupportedFontException {
        int n = subset == null ? this.getNumGlyphs() : subset.getNumGlyphs();
        Type2CStringGenerator type2CStringGenerator = new Type2CStringGenerator(n, 1);
        Type1CStringParser type1CStringParser = new Type1CStringParser();
        for (int i = 0; i < n; ++i) {
            int n2 = subset == null ? i : subset.getFullGid(i);
            type2CStringGenerator.newGlyph(i, 0, 0.0, 0.0);
            type1CStringParser.parse(type2CStringGenerator, this, n2);
        }
        return type2CStringGenerator;
    }

    private CIDKeyedFont toCID(Subset subset) throws InvalidFontException, UnsupportedFontException {
        Dict dict = this.createTopDict();
        Type2CStringGenerator type2CStringGenerator = this.seedGenerator(subset);
        double d = type2CStringGenerator.calculateNominalWidth(0);
        double d2 = type2CStringGenerator.calculateDefaultWidth(0);
        CharStrings charStrings = type2CStringGenerator.getCharstringIndex();
        Matrix matrix = (Matrix)this.getValue(Type1Keys.FontMatrix);
        Dict dict2 = new Dict(matrix);
        Dict dict3 = this.createPrivateDict(d, d2);
        String string = (String)this.getValue(Type1Keys.FontName);
        return new CIDKeyedFont(string, dict, charStrings, subset.getNumGlyphs(), dict2, dict3);
    }

    public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
        CIDKeyedFont cIDKeyedFont = this.toCID(subset);
        Integer n = (Integer)this.getValue(Type1Keys.FSType);
        SubsetDefaultImpl subsetDefaultImpl = new SubsetDefaultImpl(subset.getNumGlyphs(), false);
        cIDKeyedFont.subsetAndStream(subsetDefaultImpl, outputStream, false, n);
    }

    public CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        if (this.metricFile != null && (string = this.metricFile.getFamilyName()) != null) {
            string2 = string;
            hashSet.add(string);
        }
        if ((string = (String)this.getValue(Type1Keys.FullName)) != null) {
            string2 = string;
            hashSet.add(string);
        }
        return new CatalogDescription("T1", hashSet, string2, "");
    }

    public SWFFontDescription getSWFFontDescription(boolean bl) throws UnsupportedFontException, InvalidFontException {
        return new T1SWFFont3Description(bl);
    }

    static {
        defaultFontMatrix = new Matrix(0.001, 0.0, 0.0, 0.001, 0.0, 0.0);
        defaultKernValue = new double[]{0.0, 0.0};
        literals = new HashMap(72);
        literals.put(Type1Keys.BaseFontBlend, ArgumentType.kINTARRAY);
        literals.put(Type1Keys.BaseFontName, ArgumentType.kNAME);
        literals.put(Type1Keys.Blend, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.BlendDesignMap, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.BlendDesignPositions, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.BlueFuzz, ArgumentType.kINTEGER);
        literals.put(Type1Keys.BlueScale, ArgumentType.kNUMBER);
        literals.put(Type1Keys.BlueShift, ArgumentType.kNUMBER);
        literals.put(Type1Keys.BlueValues, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.CIDInit, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.Chameleon, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.CharStrings, ArgumentType.kCHARSTRINGS);
        literals.put(Type1Keys.Copyright, ArgumentType.kBYTES);
        literals.put(Type1Keys.Encoding, ArgumentType.kENCODING);
        literals.put(Type1Keys.Erode, ArgumentType.kERODE);
        literals.put(Type1Keys.ExpansionFactor, ArgumentType.kNUMBER);
        literals.put(Type1Keys.FSType, ArgumentType.kINTEGER);
        literals.put(Type1Keys.FamilyBlues, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.FamilyName, ArgumentType.kSTRING);
        literals.put(Type1Keys.FamilyOtherBlues, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.FontBBox, ArgumentType.kBBOX);
        literals.put(Type1Keys.FontMatrix, ArgumentType.kFONTMATRIX);
        literals.put(Type1Keys.FontName, ArgumentType.kNAME);
        literals.put(Type1Keys.FontType, ArgumentType.kFONTTYPE);
        literals.put(Type1Keys.ForceBold, ArgumentType.kBOOL);
        literals.put(Type1Keys.ForceBoldThreshold, ArgumentType.kNUMBER);
        literals.put(Type1Keys.FullName, ArgumentType.kSTRING);
        literals.put(Type1Keys.GlyphDirectory, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.ItalicAngle, ArgumentType.kITALICANGLE);
        literals.put(Type1Keys.LanguageGroup, ArgumentType.kINTEGER);
        literals.put(Type1Keys.Notice, ArgumentType.kBYTES);
        literals.put(Type1Keys.OrigFontType, ArgumentType.kORIGFONTTYPE);
        literals.put(Type1Keys.OtherBlues, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.PaintType, ArgumentType.kINTEGER);
        literals.put(Type1Keys.Private, ArgumentType.kPRIVATE);
        literals.put(Type1Keys.PostScript, ArgumentType.kBYTES);
        literals.put(Type1Keys.RndStemUp, ArgumentType.kRNDSTEMUP);
        literals.put(Type1Keys.StdHW, ArgumentType.kARRAYOF1);
        literals.put(Type1Keys.StdVW, ArgumentType.kARRAYOF1);
        literals.put(Type1Keys.StemSnapH, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.StemSnapV, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.StrokeWidth, ArgumentType.kNUMBER);
        literals.put(Type1Keys.Subrs, ArgumentType.kSUBRS);
        literals.put(Type1Keys.UnderlinePosition, ArgumentType.kNUMBER);
        literals.put(Type1Keys.UnderlineThickness, ArgumentType.kNUMBER);
        literals.put(Type1Keys.UniqueID, ArgumentType.kINTEGER);
        literals.put(Type1Keys.WasEmbedded, ArgumentType.kBOOL);
        literals.put(Type1Keys.Weight, ArgumentType.kSTRING);
        literals.put(Type1Keys.WeightVector, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.XUID, ArgumentType.kINTARRAY);
        literals.put(Type1Keys.hires, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.initialRandomSeed, ArgumentType.kINTEGER);
        literals.put(Type1Keys.isFixedPitch, ArgumentType.kBOOL);
        literals.put(Type1Keys.lenIV, ArgumentType.kINTEGER);
        literals.put(Type1Keys.version, ArgumentType.kBYTES);
    }

    private class T1XDCFontDescription
    extends XDCFontDescription {
        private T1XDCFontDescription() {
        }

        public int getNumGlyphs() throws UnsupportedFontException, InvalidFontException {
            return Type1Font.this.getNumGlyphs();
        }

        public String getGlyphName(int n) throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getGlyphName(n);
        }

        public int getGlyphCid(int n) throws UnsupportedFontException, InvalidFontException {
            return -1;
        }

        public ROS getROS() {
            return null;
        }

        public boolean pdfFontIsTrueType() {
            return false;
        }

        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getPostscriptName();
        }

        public String getFontFamily() throws InvalidFontException, UnsupportedFontException {
            Object object = Type1Font.this.getValue(Type1Keys.FamilyName);
            if (object != null) {
                return (String)object;
            }
            return null;
        }

        public double getAdvance(int n) throws InvalidGlyphException, UnsupportedFontException, InvalidFontException {
            return Type1Font.this.getHorizontalAdvance(n) * 1000.0 / Type1Font.this.getUnitsPerEmX();
        }

        public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
            Rect rect = (Rect)Type1Font.this.getValue("FontBBox");
            if (rect == null) {
                return null;
            }
            return rect.applyMatrix(Type1Font.this.getFontMatrix().multiply(1000.0));
        }

        public double getStemV() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getStemV() * 1000.0 / Type1Font.this.getUnitsPerEmX();
        }

        public double getCapHeight() throws UnsupportedFontException, InvalidFontException {
            double d = Type1Font.this.getCoolTypeCapHeight();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d * 1000.0 / Type1Font.this.getUnitsPerEmY();
        }

        public double getXHeight() throws UnsupportedFontException, InvalidFontException {
            double d = Type1Font.this.getCoolTypeXHeight();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d * 1000.0 / Type1Font.this.getUnitsPerEmY();
        }

        public double getItalicAngle() throws InvalidFontException, UnsupportedFontException {
            Object object = Type1Font.this.getValue("ItalicAngle");
            if (object != null) {
                return (Double)object;
            }
            return 0.0;
        }

        public String getBase14Name() {
            return null;
        }

        public boolean isSerifFont() throws InvalidFontException, UnsupportedFontException {
            int n = Type1Font.this.getGlyphForChar(108);
            if (n == 0) {
                n = Type1Font.this.glyphName2gid("Lsmall");
            }
            int n2 = Type1Font.this.getGlyphForChar(73);
            return Type1Font.this.isSerifFont(n, n2, this.getItalicAngle());
        }

        public boolean isSmallCapFont() throws InvalidFontException, UnsupportedFontException {
            if (!this.isAllCapFont()) {
                int n;
                int n2 = Type1Font.this.getGlyphForChar(104);
                if (n2 == 0) {
                    n2 = Type1Font.this.glyphName2gid("Hsmall");
                }
                if ((n = Type1Font.this.getGlyphForChar(120)) == 0) {
                    n = Type1Font.this.glyphName2gid("Xsmall");
                }
                if (n != 0) {
                    Rect rect = Type1Font.this.getGlyphBBox(n);
                    return Type1Font.this.isSmallCapFont(n2, rect.ymax);
                }
            }
            return false;
        }

        public boolean isAllCapFont() throws InvalidFontException, UnsupportedFontException {
            int n = Type1Font.this.getGlyphForChar(75);
            int n2 = Type1Font.this.getGlyphForChar(107);
            if (n2 == 0) {
                n2 = Type1Font.this.glyphName2gid("Ksmall");
            }
            return Type1Font.this.isAllCapFont(n, n2);
        }

        public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
            Type1Font.this.subsetAndStream(subset, outputStream, bl);
        }

        public void subsetAndStream(SubsetSimpleType1 subsetSimpleType1, OutputStream outputStream) throws InvalidFontException, UnsupportedFontException, IOException {
        }

        public void subsetAndStream(SubsetSimpleTrueType subsetSimpleTrueType, OutputStream outputStream) throws UnsupportedFontException {
            throw new UnsupportedFontException("Not a TrueType font");
        }

        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            HashSet<CodePage> hashSet = new HashSet<CodePage>();
            CoolTypeScript coolTypeScript = Type1Font.this.getCoolTypeScript();
            if (coolTypeScript == CoolTypeScript.ROMAN) {
                if (Type1Font.this.getGlyphForChar(65) > 0) {
                    hashSet.add(CodePage.ROMAN1);
                }
            } else if (coolTypeScript == CoolTypeScript.EAST_EUROPEAN_ROMAN) {
                hashSet.add(CodePage.ROMAN2);
            } else if (coolTypeScript == CoolTypeScript.JAPANESE) {
                hashSet.add(CodePage.JAPANESE);
            } else if (coolTypeScript == CoolTypeScript.KOREAN) {
                hashSet.add(CodePage.KOREAN);
            } else if (coolTypeScript == CoolTypeScript.SIMPLIFIED_CHINESE) {
                hashSet.add(CodePage.SIMPLIFIED_CHINESE);
            } else if (coolTypeScript == CoolTypeScript.TRADITIONAL_CHINESE) {
                hashSet.add(CodePage.TRADITIONAL_CHINESE);
            }
            if (Type1Font.this.glyphName2gid("ecircumflex") > 0) {
                hashSet.add(CodePage.ROMAN1);
            }
            if (Type1Font.this.glyphName2gid("Ccaron") > 0 || Type1Font.this.glyphName2gid("ncaron") > 0) {
                hashSet.add(CodePage.ROMAN2);
            }
            if (Type1Font.this.glyphName2gid("akatakana") > 0) {
                hashSet.add(CodePage.JAPANESE);
            }
            CodePage[] codePageArray = new CodePage[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                codePageArray[n++] = (CodePage)iterator.next();
            }
            return codePageArray;
        }
    }

    private class T1SWFFont3Description
    implements SWFFontDescription {
        private final boolean wasEmbedded;
        private final LineMetrics metrics;

        T1SWFFont3Description(boolean bl) throws UnsupportedFontException, InvalidFontException {
            this.wasEmbedded = bl;
            this.metrics = Type1Font.this.getCoolTypeLineMetrics();
        }

        public boolean canDisplay(char c) throws UnsupportedFontException, InvalidFontException {
            return Type1Font.this.getGlyphForChar(c) != 0;
        }

        public double getAscent() throws InvalidFontException, UnsupportedFontException {
            return this.metrics.ascender * Type1Font.this.getUnitsPerEmX() / Type1Font.this.getUnitsPerEmY();
        }

        public double getDescent() throws InvalidFontException, UnsupportedFontException {
            return -this.metrics.descender * Type1Font.this.getUnitsPerEmX() / Type1Font.this.getUnitsPerEmY();
        }

        public double getLineGap() throws InvalidFontException, UnsupportedFontException {
            return this.metrics.linegap * Type1Font.this.getUnitsPerEmX() / Type1Font.this.getUnitsPerEmY();
        }

        public double getEmScale() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getUnitsPerEmX();
        }

        public String getFullName() throws InvalidFontException, UnsupportedFontException {
            return (String)Type1Font.this.getValue(Type1Keys.FullName);
        }

        public String getFamily() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getPreferredCSSFamilyName();
        }

        public String getCopyright() throws InvalidFontException, UnsupportedFontException {
            byte[] byArray = (byte[])Type1Font.this.getValue(Type1Keys.Copyright);
            return byArray == null ? null : Type1Font.this.bytesToString(byArray);
        }

        public String getTrademark() throws InvalidFontException, UnsupportedFontException {
            byte[] byArray = (byte[])Type1Font.this.getValue(Type1Keys.Notice);
            return byArray == null ? null : Type1Font.this.bytesToString(byArray);
        }

        public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getFirstChar();
        }

        public double getHorizontalAdvance(char c) throws UnsupportedFontException, InvalidFontException {
            int n = Type1Font.this.getGlyphForChar(c);
            return Type1Font.this.getHorizontalAdvance(n);
        }

        public int getLastChar() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getLastChar();
        }

        public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getNumGlyphs();
        }

        public void getOutline(char c, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidFontException {
            int n = Type1Font.this.getGlyphForChar(c);
            Type1Font.this.getGlyphOutline(n, outlineConsumer);
        }

        public Permission getPermissions() throws InvalidFontException, UnsupportedFontException {
            Permission permission = Type1Font.this.getEmbeddingPermission(this.wasEmbedded);
            if (permission == Permission.ILLEGAL_VALUE) {
                permission = Permission.EDITABLE;
            }
            return permission;
        }

        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getPostscriptName();
        }

        public boolean isBold() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getCSSWeight() >= 700;
        }

        public boolean isItalic() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.isCSSStyleItalic();
        }

        public String getSubFamily() throws InvalidFontException, UnsupportedFontException {
            return null;
        }
    }

    private static class CharstringCompare
    implements Comparator {
        static final CharstringCompare comparator = new CharstringCompare();

        private CharstringCompare() {
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                if (object2 == null) {
                    return 0;
                }
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
            Type1Glyph type1Glyph = (Type1Glyph)object;
            Type1Glyph type1Glyph2 = (Type1Glyph)object2;
            if (type1Glyph.glyphName.equals(".notdef")) {
                if (type1Glyph2.glyphName.equals(".notdef")) {
                    return 0;
                }
                return -1;
            }
            if (type1Glyph2.glyphName.equals(".notdef")) {
                return 1;
            }
            return type1Glyph.glyphName.compareTo(type1Glyph2.glyphName);
        }
    }

    private static class ArgumentType {
        private String description;
        static ArgumentType kINTEGER = new ArgumentType("Integer");
        static ArgumentType kNUMBER = new ArgumentType("Number");
        static ArgumentType kSTRING = new ArgumentType("String");
        static ArgumentType kBYTES = new ArgumentType("Bytes");
        static ArgumentType kBOOL = new ArgumentType("Bool");
        static ArgumentType kNUMARRAY = new ArgumentType("NumArray");
        static ArgumentType kARRAYOF1 = new ArgumentType("Array of 1");
        static ArgumentType kINTARRAY = new ArgumentType("IntArray");
        static ArgumentType kNAME = new ArgumentType("Name");
        static ArgumentType kUNSUPPORTEDFONT = new ArgumentType("Unsupported font");
        static ArgumentType kFONTTYPE = new ArgumentType("FontType");
        static ArgumentType kORIGFONTTYPE = new ArgumentType("OrigFontType");
        static ArgumentType kENCODING = new ArgumentType("Encoding");
        static ArgumentType kERODE = new ArgumentType("ErodeProcedure");
        static ArgumentType kCHARSTRINGS = new ArgumentType("CharStrings");
        static ArgumentType kSUBRS = new ArgumentType("Subroutines");
        static ArgumentType kFONTMATRIX = new ArgumentType("FontMatrix");
        static ArgumentType kRNDSTEMUP = new ArgumentType("RndStemUp");
        static ArgumentType kITALICANGLE = new ArgumentType("ItalicAngle");
        static ArgumentType kBBOX = new ArgumentType("BoundingBox");
        static ArgumentType kPRIVATE = new ArgumentType("Private Dictionary");

        private ArgumentType(String string) {
            this.description = string;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class Type1Keys {
        static String BaseFontBlend = "BaseFontBlend";
        static String BaseFontName = "BaseFontName";
        static String Blend = "Blend";
        static String BlendDesignMap = "BlendDesignMap";
        static String BlendDesignPositions = "BlendDesignPositions";
        static String BlueFuzz = "BlueFuzz";
        static String BlueScale = "BlueScale";
        static String BlueShift = "BlueShift";
        static String BlueValues = "BlueValues";
        static String CIDInit = "CIDInit";
        static String Chameleon = "Chameleon";
        static String CharStrings = "CharStrings";
        static String Copyright = "Copyright";
        static String CSSWeight = "CSSWeight";
        static String CSSWidth = "CSSWidth";
        static String Encoding = "Encoding";
        static String Erode = "Erode";
        static String ExpansionFactor = "ExpansionFactor";
        static String FSType = "FSType";
        static String FamilyBlues = "FamilyBlues";
        static String FamilyName = "FamilyName";
        static String FamilyOtherBlues = "FamilyOtherBlues";
        static String FontBBox = "FontBBox";
        static String FontMatrix = "FontMatrix";
        static String FontName = "FontName";
        static String FontType = "FontType";
        static String ForceBold = "ForceBold";
        static String ForceBoldThreshold = "ForceBoldThreshold";
        static String FullName = "FullName";
        static String GlyphDirectory = "GlyphDirectory";
        static String InvertedFontMatrix = "InvertedFontMatrix";
        static String IsSmallCaps = "IsSmallCaps";
        static String ItalicAngle = "ItalicAngle";
        static String LanguageGroup = "LanguageGroup";
        static String Notice = "Notice";
        static String OrigFontType = "OrigFontType";
        static String OtherBlues = "OtherBlues";
        static String PaintType = "PaintType";
        static String Private = "Private";
        static String PostScript = "PostScript";
        static String RndStemUp = "RndStemUp";
        static String StandardEncoding = "StandardEncoding";
        static String StdHW = "StdHW";
        static String StdVW = "StdVW";
        static String StemSnapH = "StemSnapH";
        static String StemSnapV = "StemSnapV";
        static String StrokeWidth = "StrokeWidth";
        static String Subrs = "Subrs";
        static String UnderlinePosition = "UnderlinePosition";
        static String UnderlineThickness = "UnderlineThickness";
        static String UniqueID = "UniqueID";
        static String WasEmbedded = "WasEmbedded";
        static String Weight = "Weight";
        static String WeightVector = "WeightVector";
        static String XUID = "XUID";
        static String hires = "hires";
        static String initialRandomSeed = "initialRandomSeed";
        static String isFixedPitch = "isFixedPitch";
        static String lenIV = "lenIV";
        static String version = "version";

        private Type1Keys() {
        }
    }

    private static class Literals {
        static final byte[] kCID_LITERAL = new byte[]{47, 67, 73, 68};
        static final byte[] kTRUETYPE_LITERAL = new byte[]{47, 84, 114, 117, 101, 84, 121, 112, 101};
        static final byte[] kTYPE1_LITERAL = new byte[]{47, 84, 121, 112, 101, 49};
        static final byte[] kOCF_LITERAL = new byte[]{47, 79, 67, 70};
        static final byte[] kNOTDEF = new byte[]{46, 110, 111, 116, 100, 101, 102};

        private Literals() {
        }
    }

    private static class Operators {
        static final byte[] kTRUE = new byte[]{116, 114, 117, 101};
        static final byte[] kFALSE = new byte[]{102, 97, 108, 115, 101};
        static final byte[] kCURRENTFILE = new byte[]{99, 117, 114, 114, 101, 110, 116, 102, 105, 108, 101};
        static final byte[] kCLOSEFILE = new byte[]{99, 108, 111, 115, 101, 102, 105, 108, 101};
        static final byte[] kEEXEC = new byte[]{101, 101, 120, 101, 99};
        static final byte[] kSTANDARDENCODING = new byte[]{83, 116, 97, 110, 100, 97, 114, 100, 69, 110, 99, 111, 100, 105, 110, 103};
        static final byte[] kNOTDEF = new byte[]{46, 110, 111, 116, 100, 101, 102};
        static final byte[] kDUP = new byte[]{100, 117, 112};
        static final byte[] kPUT = new byte[]{112, 117, 116};
        static final byte[] kDEF = new byte[]{100, 101, 102};
        static final byte[] kREADONLY = new byte[]{114, 101, 97, 100, 111, 110, 108, 121};
        static final byte[] kBEGIN = new byte[]{98, 101, 103, 105, 110};
        static final byte[] kEND = new byte[]{101, 110, 100};
        static final byte[] kARRAY = new byte[]{97, 114, 114, 97, 121};
        static final byte[] kNOACCESS = new byte[]{110, 111, 97, 99, 99, 101, 115, 115};
        static final byte[] kFONTDIRECTORY = new byte[]{70, 111, 110, 116, 68, 105, 114, 101, 99, 116, 111, 114, 121};

        private Operators() {
        }
    }
}

