/*
 * Decompiled with CFR 0.152.
 */
package flex.bootstrap;

import flex.bootstrap.BootstrapBodyTag;
import flex.bootstrap.BootstrapTag;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

public class TagGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ClassNotFoundException, IOException {
        if (args.length < 2) {
            System.err.println("usage: TagGenerator destdir class1 class2 ...");
            System.exit(1);
        }
        String destdir = args[0];
        for (int i = 1; i < args.length; ++i) {
            String className = args[i];
            Class<?> api = Class.forName(className);
            String filename = className.replace('.', '/') + "Impl.java";
            String pkgdir = filename.substring(0, filename.lastIndexOf(47));
            new File(destdir, pkgdir).mkdirs();
            System.out.println("generating " + filename);
            PrintWriter out = new PrintWriter(new FileWriter(new File(destdir, filename)));
            try {
                TagGenerator.generateTag(api, out);
                out.flush();
                continue;
            }
            finally {
                out.close();
            }
        }
    }

    private static void generateTag(Class api, PrintWriter out) {
        Class baseApi;
        Class baseImpl;
        String implName = api.getName() + "Impl";
        String packageName = implName.substring(0, implName.lastIndexOf(46));
        String className = implName.substring(implName.lastIndexOf(46) + 1);
        HashSet<MethodKey> done = new HashSet<MethodKey>();
        if (BodyTag.class.isAssignableFrom(api)) {
            baseImpl = BootstrapBodyTag.class;
            baseApi = BodyTag.class;
        } else {
            baseImpl = BootstrapTag.class;
            baseApi = Tag.class;
        }
        out.println("package " + packageName + ";");
        out.println("public class " + className + " extends " + baseImpl.getName());
        out.println("   implements " + api.getName());
        out.println("{");
        String tagName = TagGenerator.createTagName(api);
        out.println(api.getName() + " " + tagName + " = (" + api.getName() + ") tag;");
        Method[] methods = api.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodKey key = new MethodKey(methods[i]);
            try {
                if (done.contains(key)) continue;
                baseApi.getMethod(key.name, key.paramTypes);
                continue;
            }
            catch (NoSuchMethodException e) {
                TagGenerator.generateMethod(out, methods[i], tagName);
                done.add(key);
            }
        }
        out.println("}");
    }

    private static void generateMethod(PrintWriter out, Method method, String tagName) {
        int i;
        out.print("public ");
        Class<?> returnType = method.getReturnType();
        out.print(returnType.getName());
        out.print(" ");
        out.print(method.getName());
        out.print("(");
        Class<?>[] params = method.getParameterTypes();
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (i2 > 0) {
                out.print(", ");
            }
            out.print(params[i2].getName());
            out.print(" p");
            out.print(i2);
        }
        out.println(")");
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            out.print(" throws ");
            for (i = 0; i < exceptionTypes.length; ++i) {
                if (i > 0) {
                    out.print(", ");
                }
                out.print(exceptionTypes[i].getName());
            }
        }
        out.println("{");
        out.println("  Thread thread = Thread.currentThread();");
        out.println("  ClassLoader oldLoader = thread.getContextClassLoader();");
        out.println("  thread.setContextClassLoader(bootstrap);");
        out.println("  try {");
        out.print("    ");
        if (returnType != Void.TYPE) {
            out.print("return ");
        }
        out.print(tagName);
        out.print(".");
        out.print(method.getName());
        out.print("(");
        for (i = 0; i < params.length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print("p");
            out.print(i);
        }
        out.println(");");
        out.println("  } finally {");
        out.println("    thread.setContextClassLoader(oldLoader);");
        out.println("  }");
        out.println("}");
    }

    private static String createTagName(Class api) {
        String name = api.getName();
        StringBuffer b = new StringBuffer(name);
        b.delete(0, name.lastIndexOf(46) + 1);
        b.setCharAt(0, Character.toLowerCase(b.charAt(0)));
        return b.toString();
    }

    private static class MethodKey {
        Method method;
        String name;
        Class[] paramTypes;

        public MethodKey(Method method) {
            this.method = method;
            this.name = method.getName();
            this.paramTypes = method.getParameterTypes();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (this.paramTypes.length != other.paramTypes.length) {
                return false;
            }
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (this.paramTypes[i] == other.paramTypes[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int c = this.name.hashCode();
            for (int i = 0; i < this.paramTypes.length; ++i) {
                c ^= this.paramTypes[i].hashCode();
            }
            return c;
        }

        public String toString() {
            return this.method.toString();
        }
    }
}

