/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.parser.DefaultPreserveAspectRatioHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PreserveAspectRatioHandler;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGPreserveAspectRatio;

public abstract class AbstractSVGPreserveAspectRatio
implements SVGPreserveAspectRatio {
    protected short align = (short)6;
    protected short meetOrSlice = 1;

    public short getAlign() {
        return this.align;
    }

    public short getMeetOrSlice() {
        return this.meetOrSlice;
    }

    public void setAlign(short align) {
        this.align = align;
        this.setAttributeValue(this.getValueAsString());
    }

    public void setMeetOrSlice(short meetOrSlice) {
        this.meetOrSlice = meetOrSlice;
        this.setAttributeValue(this.getValueAsString());
    }

    public void reset() {
        this.align = (short)6;
        this.meetOrSlice = 1;
    }

    protected abstract void setAttributeValue(String var1) throws DOMException;

    protected abstract DOMException createDOMException(short var1, String var2, Object[] var3);

    protected void setValueAsString(String value) throws DOMException {
        PreserveAspectRatioParserHandler ph = new PreserveAspectRatioParserHandler();
        try {
            PreserveAspectRatioParser p = new PreserveAspectRatioParser();
            p.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)ph);
            p.parse(value);
            this.align = ph.getAlign();
            this.meetOrSlice = ph.getMeetOrSlice();
        }
        catch (ParseException ex) {
            throw this.createDOMException((short)0, "invalid value for preserveAspectRatio", null);
        }
    }

    protected String getValueAsString() {
        String value = null;
        switch (this.align) {
            case 1: {
                value = "none";
                return value;
            }
            case 2: {
                value = "xMinYMin";
                break;
            }
            case 3: {
                value = "xMidYMin";
                break;
            }
            case 4: {
                value = "xMaxYMin";
                break;
            }
            case 5: {
                value = "xMinYMid";
                break;
            }
            case 6: {
                value = "xMidYMid";
                break;
            }
            case 7: {
                value = "xMaxYMid";
                break;
            }
            case 8: {
                value = "xMinYMax";
                break;
            }
            case 9: {
                value = "xMidYMax";
                break;
            }
            case 10: {
                value = "xMaxYMax";
                break;
            }
            default: {
                throw this.createDOMException((short)0, "invalid value for preserveAspectRatio", null);
            }
        }
        switch (this.meetOrSlice) {
            case 1: {
                value = value + " " + "meet";
                break;
            }
            case 2: {
                value = value + " " + "slice";
                break;
            }
            default: {
                throw this.createDOMException((short)0, "invalid value for preserveAspectRatio", null);
            }
        }
        return value;
    }

    protected class PreserveAspectRatioParserHandler
    extends DefaultPreserveAspectRatioHandler {
        public short align = (short)6;
        public short meetOrSlice = 1;

        protected PreserveAspectRatioParserHandler() {
        }

        public short getAlign() {
            return this.align;
        }

        public short getMeetOrSlice() {
            return this.meetOrSlice;
        }

        public void none() throws ParseException {
            this.align = 1;
        }

        public void xMaxYMax() throws ParseException {
            this.align = (short)10;
        }

        public void xMaxYMid() throws ParseException {
            this.align = (short)7;
        }

        public void xMaxYMin() throws ParseException {
            this.align = (short)4;
        }

        public void xMidYMax() throws ParseException {
            this.align = (short)9;
        }

        public void xMidYMid() throws ParseException {
            this.align = (short)6;
        }

        public void xMidYMin() throws ParseException {
            this.align = (short)3;
        }

        public void xMinYMax() throws ParseException {
            this.align = (short)8;
        }

        public void xMinYMid() throws ParseException {
            this.align = (short)5;
        }

        public void xMinYMin() throws ParseException {
            this.align = (short)2;
        }

        public void meet() throws ParseException {
            this.meetOrSlice = 1;
        }

        public void slice() throws ParseException {
            this.meetOrSlice = (short)2;
        }
    }
}

