/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services.logging;

import flex.webtier.services.config.LoggingConfiguration;
import flex.webtier.services.logging.ConsoleLogEventHandler;
import flex.webtier.services.logging.FileLogEventHandler;
import flex.webtier.services.logging.LogEvent;
import flex.webtier.services.logging.LogEventHandler;
import flex.webtier.services.logging.Logger;
import flex.webtier.services.logging.ThreadedLogEventHandler;
import flex.webtier.services.logging.WindowsLogEventHandler;
import java.util.ArrayList;
import java.util.Iterator;

public class LoggerService
implements Logger {
    private static boolean errorEnabled = true;
    private static boolean warningEnabled = true;
    private static boolean infoEnabled = true;
    private static boolean debugEnabled = false;
    private String format;
    private static Logger defaultLogger;
    private static String serverLogFormat;
    private ArrayList handlers = new ArrayList();

    public static synchronized Logger createWindowsDefaultLogger(String logName) {
        if (defaultLogger == null) {
            defaultLogger = new LoggerService();
            ((LoggerService)defaultLogger).setFormat(serverLogFormat);
            if (System.getProperty("flex.platform.CLR") != null) {
                defaultLogger.addLogEventHandler(new WindowsLogEventHandler(logName));
            } else {
                defaultLogger.addLogEventHandler(new ConsoleLogEventHandler());
            }
        }
        return defaultLogger;
    }

    public static synchronized Logger createDefaultLogger() {
        if (defaultLogger == null) {
            defaultLogger = new LoggerService();
            ((LoggerService)defaultLogger).setFormat(serverLogFormat);
            defaultLogger.addLogEventHandler(new ConsoleLogEventHandler());
        }
        return defaultLogger;
    }

    public void addLogEventHandler(LogEventHandler handler) {
        this.handlers.add(handler);
    }

    public boolean isErrorEnabled() {
        return errorEnabled;
    }

    public boolean isWarningEnabled() {
        return warningEnabled;
    }

    public boolean isInfoEnabled() {
        return infoEnabled;
    }

    public boolean isDebugEnabled() {
        return debugEnabled;
    }

    public void logError(String msg) {
        this.logError(msg, null);
    }

    public void logError(Throwable throwable) {
        if (throwable != null) {
            this.logError(throwable.getMessage(), throwable);
        } else {
            this.logError("");
        }
    }

    public void logError(String msg, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.log(new LogEvent(1, msg, throwable));
        }
    }

    public void logWarning(String msg) {
        this.logWarning(msg, null);
    }

    public void logWarning(Throwable throwable) {
        if (throwable != null) {
            this.logWarning(throwable.getMessage(), throwable);
        } else {
            this.logWarning("");
        }
    }

    public void logWarning(String msg, Throwable throwable) {
        if (this.isWarningEnabled()) {
            this.log(new LogEvent(2, msg, throwable));
        }
    }

    public void logInfo(String msg) {
        this.logInfo(msg, null);
    }

    public void logInfo(String msg, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log(new LogEvent(4, msg, throwable));
        }
    }

    public void logDebug(String msg) {
        this.logDebug(msg, null);
    }

    public void logDebug(String msg, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log(new LogEvent(8, msg, throwable));
        }
    }

    public Logger getLoggerService() {
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
        if (format != null) {
            serverLogFormat = format;
        }
    }

    public String getFormat() {
        return this.format != null ? this.format : "{server.date} {log.level} {log.message}{log.exception}";
    }

    public void flush() {
        Iterator i = this.handlers.iterator();
        while (i.hasNext()) {
            LogEventHandler eh = (LogEventHandler)i.next();
            eh.flush();
        }
    }

    public void start() {
        Iterator i = this.handlers.iterator();
        while (i.hasNext()) {
            LogEventHandler handler = (LogEventHandler)i.next();
            handler.init();
            handler.start();
        }
    }

    public void stop() {
        Iterator i = this.handlers.iterator();
        while (i.hasNext()) {
            LogEventHandler handler = (LogEventHandler)i.next();
            handler.stop();
        }
    }

    public static String getServerLogFormat() {
        return serverLogFormat;
    }

    protected void log(LogEvent event) {
        LogEventHandler eh;
        boolean b;
        Iterator i = this.handlers.iterator();
        while (i.hasNext() && (b = (eh = (LogEventHandler)i.next()).log(event))) {
        }
    }

    public void initializeLogger(LoggingConfiguration loggingConfiguration) {
        if (loggingConfiguration.isConsoleEnable() || loggingConfiguration.isFileEnable() || loggingConfiguration.isEventEnable()) {
            ThreadedLogEventHandler threaded = new ThreadedLogEventHandler();
            this.handlers.add(threaded);
            if (loggingConfiguration.isEventEnable()) {
                WindowsLogEventHandler eventLogger = new WindowsLogEventHandler(loggingConfiguration.getEventLogName());
                threaded.addLogEventHandler(eventLogger);
            }
            if (loggingConfiguration.isConsoleEnable()) {
                ConsoleLogEventHandler consoleLogger = new ConsoleLogEventHandler();
                threaded.addLogEventHandler(consoleLogger);
            }
            if (loggingConfiguration.isFileEnable() && loggingConfiguration.getFileName() != null) {
                FileLogEventHandler fileLogger = new FileLogEventHandler();
                fileLogger.setFilename(loggingConfiguration.getFileName());
                fileLogger.setRotationFiles(loggingConfiguration.getFileMaximumBackups());
                String size = loggingConfiguration.getFileMaximumSize();
                if (size.endsWith("B")) {
                    size = size.substring(0, size.length() - 1);
                }
                fileLogger.setRotationSize(size);
                threaded.addLogEventHandler(fileLogger);
            }
            String logLevel = loggingConfiguration.getLogLevel();
            this.setLogLevel(logLevel);
        }
    }

    public void setLogLevel(String logLevel) {
        if (logLevel != null) {
            if (logLevel.equalsIgnoreCase("error")) {
                errorEnabled = true;
                warningEnabled = false;
                infoEnabled = false;
                debugEnabled = false;
            } else if (logLevel.equalsIgnoreCase("warn")) {
                errorEnabled = true;
                warningEnabled = true;
                infoEnabled = false;
                debugEnabled = false;
            } else if (logLevel.equalsIgnoreCase("info")) {
                errorEnabled = true;
                warningEnabled = true;
                infoEnabled = true;
                debugEnabled = false;
            } else if (logLevel.equalsIgnoreCase("debug")) {
                errorEnabled = true;
                warningEnabled = true;
                infoEnabled = true;
                debugEnabled = true;
            }
        }
    }
}

