/*-- Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package scripts
{
	import mx.rpc.remoting.RemoteObject;
   	import mx.rpc.events.FaultEvent;
  	import mx.rpc.events.ResultEvent;
	    		
	public final class AuthenticationManager
	{
		private static var loggedInUserAccount:String = null;
		
		public static function setLoggedInUserAccount(userAccount:String):void {
			loggedInUserAccount = userAccount;
		}
		public static function getLoggedInUserAccount():String {
			return loggedInUserAccount;
		}
		public static function isLoggedInUserAccount(account:String):Boolean {
			return loggedInUserAccount != null && loggedInUserAccount == account; 
		}
		public static function logout():void {
			var accessControlService:RemoteObject = RemotingManager.createAccessControlService();
			accessControlService.unauthenticate.addEventListener(ResultEvent.RESULT, handle_unauthenticate_ResultEvent);					
			accessControlService.addEventListener(FaultEvent.FAULT, handleFaultEvent);
			accessControlService.unauthenticate();
		}
		///
        private static function handleFaultEvent(event:FaultEvent): void {
          	trace(event.message)
          	WindowManager.changeToLoginWindow();
        }
		private static function handle_unauthenticate_ResultEvent(event:ResultEvent):void {
			WindowManager.changeToLoginWindow();
		}
	}
}