/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.jsp;

import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.html.DetectionRenderer;
import flex.webtier.server.j2ee.html.EventsRenderer;
import flex.webtier.server.j2ee.html.HistoryRenderer;
import flex.webtier.server.j2ee.html.HtmlRenderer;
import flex.webtier.server.j2ee.html.SwfRenderer;
import java.io.IOException;
import java.io.PrintWriter;

public class JspRenderer {
    private DetectionRenderer detectionRenderer;
    private EventsRenderer eventsRenderer = new EventsRenderer();
    private HistoryRenderer historyRenderer;
    private HtmlRenderer htmlRenderer = new HtmlRenderer();
    private SwfRenderer swfRenderer = new SwfRenderer();

    public JspRenderer(MxmlContext context) {
        if (context.getJspHeight() != null) {
            context.setHeight(context.getJspHeight());
        }
        if (context.getJspWidth() != null) {
            context.setWidth(context.getJspWidth());
        }
        this.historyRenderer = new HistoryRenderer(context);
        this.detectionRenderer = new DetectionRenderer(context);
    }

    public void render(MxmlContext context) throws IOException {
        PrintWriter output = context.getResponseWriter();
        this.historyRenderer.renderJavaScriptImport(output, context.getFirstHistory());
        this.detectionRenderer.renderTagImport(output, context.getFirstOnPage());
        if (context.hasWarnings() && context.showAllWarnings()) {
            this.htmlRenderer.renderBeginStyle(output);
            this.eventsRenderer.renderEventsStyle(output);
            this.htmlRenderer.renderEndStyle(output);
            this.eventsRenderer.renderEventsScript(output);
            this.eventsRenderer.renderEvents(context, output);
        }
        this.detectionRenderer.renderRequiredInfo(output, context.getFirstDetection());
        this.renderCompiledMxml(context, output);
        this.historyRenderer.renderIframe(context, output, context.getFirstHistory());
    }

    private void renderCompiledMxml(MxmlContext context, PrintWriter output) {
        this.swfRenderer.renderEmbeddedSwf(context, output, SwfRenderer.NO_SCRIPT);
        output.println();
        output.println();
        this.detectionRenderer.renderSwf(context, output);
        output.println();
        output.println();
    }
}

