/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.impl.ICULocaleService;
import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.impl.ICUService;
import com.adobe.agl.text.NumberFormat;
import com.adobe.agl.text.NumberFormatServiceShim;
import com.adobe.agl.util.ULocale;
import java.util.Locale;
import java.util.Set;

class NumberFormatServiceShim
extends NumberFormat.NumberFormatShim {
    private static ICULocaleService service = new NFService();

    NumberFormatServiceShim() {
    }

    Locale[] getAvailableLocales() {
        if (service.isDefault()) {
            return ICUResourceBundle.getAvailableLocales("com/adobe/agl/impl/data/icudt32b");
        }
        return service.getAvailableLocales();
    }

    ULocale[] getAvailableULocales() {
        if (service.isDefault()) {
            return ICUResourceBundle.getAvailableULocales("com/adobe/agl/impl/data/icudt32b");
        }
        return service.getAvailableULocales();
    }

    Object registerFactory(NumberFormat.NumberFormatFactory factory) {
        return service.registerFactory(new NFFactory(factory));
    }

    boolean unregister(Object registryKey) {
        return service.unregisterFactory((ICUService.Factory)registryKey);
    }

    NumberFormat createInstance(ULocale desiredLocale, int choice) {
        ULocale[] actualLoc = new ULocale[1];
        NumberFormat fmt = (NumberFormat)service.get(desiredLocale, choice, actualLoc);
        fmt = (NumberFormat)fmt.clone();
        ULocale uloc = actualLoc[0];
        fmt.setLocale(uloc, uloc);
        return fmt;
    }

    private static class NFService
    extends ICULocaleService {
        NFService() {
            super("NumberFormat");
            class RBNumberFormatFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                private final /* synthetic */ NFService this$0;

                RBNumberFormatFactory(NFService this$0) {
                    this.this$0 = this$0;
                }

                protected Object handleCreate(ULocale loc, int kind, ICUService service) {
                    return NumberFormat.createInstance(loc, kind);
                }
            }
            this.registerFactory(new RBNumberFormatFactory(this));
            this.markDefault();
        }
    }

    private static final class NFFactory
    extends ICULocaleService.LocaleKeyFactory {
        private NumberFormat.NumberFormatFactory delegate;

        NFFactory(NumberFormat.NumberFormatFactory delegate) {
            super(delegate.visible());
            this.delegate = delegate;
        }

        public Object create(ICUService.Key key, ICUService service) {
            if (this.handlesKey(key)) {
                int kind;
                ICULocaleService.LocaleKey lkey = (ICULocaleService.LocaleKey)key;
                ULocale loc = lkey.canonicalLocale();
                Object result = this.delegate.createFormat(loc, kind = lkey.kind());
                if (result == null) {
                    result = service.getKey(key, null, this);
                }
                return result;
            }
            return null;
        }

        protected Set getSupportedIDs() {
            return this.delegate.getSupportedLocaleNames();
        }
    }
}

