/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.managed;

import flex2.compiler.CompilationUnit;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.binding.InterfaceInfo;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.as3.genext.GenerativeClassInfo;
import flex2.compiler.as3.genext.GenerativeSecondPassEvaluator;
import flex2.compiler.as3.managed.ManagedClassInfo;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import java.util.HashMap;
import java.util.Map;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class ManagedSecondPassEvaluator
extends GenerativeSecondPassEvaluator {
    private static final String CODEGEN_TEMPLATE_PATH = "flex2/compiler/as3/managed/";
    private static final String IMANAGED = "IManaged";
    private ManagedClassInfo currentInfo;
    private boolean inClass = false;

    public ManagedSecondPassEvaluator(CompilationUnit unit, Map classMap, TypeAnalyzer typeAnalyzer, String generatedOutputDirectory) {
        super(unit, classMap, typeAnalyzer, generatedOutputDirectory);
    }

    public Value evaluate(Context context, ClassDefinitionNode node) {
        if (!this.evaluatedClasses.contains(node)) {
            this.inClass = true;
            String className = NodeMagic.getClassName(node);
            this.currentInfo = (ManagedClassInfo)this.classMap.get(className);
            if (this.currentInfo != null) {
                InterfaceInfo interfaceInfo;
                MultiName multiName;
                ClassInfo classInfo = this.currentInfo.getClassInfo();
                if (!classInfo.implementsInterface("flash.events", "IEventDispatcher")) {
                    this.currentInfo.setNeedsToImplementIEventDispatcher(true);
                    multiName = new MultiName("flash.events", "IEventDispatcher");
                    interfaceInfo = this.typeAnalyzer.analyzeInterface(context, multiName, classInfo);
                    if (interfaceInfo == null || this.checkForExistingMethods(context, node, classInfo, interfaceInfo)) {
                        return null;
                    }
                    classInfo.addInterfaceMultiName("flash.events", "IEventDispatcher");
                }
                if (!classInfo.implementsInterface("mx.data", IMANAGED)) {
                    this.currentInfo.setNeedsToImplementIManaged(true);
                    multiName = new MultiName("mx.data", IMANAGED);
                    interfaceInfo = this.typeAnalyzer.analyzeInterface(context, multiName, classInfo);
                    if (interfaceInfo == null || this.checkForExistingMethods(context, node, classInfo, interfaceInfo)) {
                        return null;
                    }
                    classInfo.addInterfaceMultiName("mx.data", IMANAGED);
                }
                this.postProcessClassInfo(context, this.currentInfo);
                if (node.statements != null) {
                    node.statements.evaluate(context, this);
                    this.modifySyntaxTree(context, node, this.currentInfo);
                }
                this.currentInfo = null;
            }
            this.inClass = false;
            this.evaluatedClasses.add(node);
        }
        return null;
    }

    public Value evaluate(Context context, FunctionDefinitionNode node) {
        QName qname;
        GenerativeClassInfo.AccessorInfo accessorInfo;
        if (this.inClass && (accessorInfo = this.currentInfo.getAccessor(qname = new QName(NodeMagic.getUserNamespace(node), NodeMagic.getFunctionName(node)))) != null) {
            ManagedSecondPassEvaluator.hideFunction(node, accessorInfo);
            this.registerRenamedAccessor(accessorInfo);
        }
        return null;
    }

    public Value evaluate(Context context, VariableDefinitionNode node) {
        QName qname;
        GenerativeClassInfo.AccessorInfo info;
        if (this.inClass && (info = this.currentInfo.getAccessor(qname = new QName(NodeMagic.getUserNamespace(node), NodeMagic.getVariableName(node)))) != null) {
            ManagedSecondPassEvaluator.hideVariable(node, info);
            this.registerRenamedAccessor(info);
        }
        return null;
    }

    protected String getTemplateName() {
        return "ManagedProperty";
    }

    protected Map getTemplateVars() {
        HashMap<String, ManagedClassInfo> vars = new HashMap<String, ManagedClassInfo>();
        vars.put("managedInfo", this.currentInfo);
        return vars;
    }

    protected String getTemplatePath() {
        return CODEGEN_TEMPLATE_PATH;
    }

    protected String getGeneratedSuffix() {
        return "-managed-generated.as";
    }
}

