/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flex2.compiler.CompilationUnit;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.MultiNameSet;
import flex2.compiler.util.QName;
import flex2.linker.Linkable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CULinkable
implements Linkable {
    private final Set defs = new HashSet();
    private final Set prereqs = new HashSet();
    private final Set deps = new HashSet();
    private final CompilationUnit unit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CULinkable(CompilationUnit unit) {
        this.unit = unit;
        this.defs.addAll(unit.topLevelDefinitions.getStringSet());
        this.addDeps(this.prereqs, unit.inheritance);
        this.addDeps(this.deps, unit.expressions);
        this.addDeps(this.deps, unit.namespaces);
        this.addDeps(this.deps, unit.types);
        this.deps.addAll(unit.extraClasses);
        this.deps.addAll(unit.resourceBundles);
    }

    public String getName() {
        return this.unit.getSource().getName();
    }

    public CompilationUnit getUnit() {
        return this.unit;
    }

    public long getLastModified() {
        return this.unit.getSource().getLastModified();
    }

    public long getSize() {
        return this.unit.bytes.size();
    }

    public boolean hasDefinition(String defName) {
        return this.defs.contains(defName);
    }

    public Iterator getDefinitions() {
        return this.defs.iterator();
    }

    public Iterator getPrerequisites() {
        return this.prereqs.iterator();
    }

    public Iterator getDependencies() {
        return this.deps.iterator();
    }

    public String toString() {
        return this.unit.getSource().getName();
    }

    public void addDep(String val) {
        this.deps.add(val);
    }

    public boolean dependsOn(String s) {
        return this.deps.contains(s) || this.prereqs.contains(s);
    }

    public boolean isNative() {
        return this.unit.getSource().isInternal();
    }

    private void addDeps(Set set, MultiNameSet mns) {
        Iterator it = mns.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof MultiName) {
                MultiName mname = (MultiName)o;
                if (!$assertionsDisabled && mname.getNumQNames() != 1) {
                    throw new AssertionError();
                }
                set.add(mname.getQName(0).toString());
                continue;
            }
            if (!$assertionsDisabled && !(o instanceof QName)) {
                throw new AssertionError();
            }
            set.add(o.toString());
        }
    }

    static {
        $assertionsDisabled = !CULinkable.class.desiredAssertionStatus();
    }
}

