/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.OutlineConsumerAdapter;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.type1.Type1Font;

public class Type1Scaler
implements Scaler {
    protected final Type1Font font;
    protected final ScanConverter scanConverter;
    protected Matrix emToPixel;
    protected ScalerDebugger debugger;

    public Type1Scaler(Type1Font type1Font, ScanConverter scanConverter) {
        this.font = type1Font;
        this.scanConverter = scanConverter;
    }

    public void setScale(double d, double d2, double d3, double d4, double d5) throws InvalidFontException, UnsupportedFontException {
        this.emToPixel = new Matrix(d2, 0.0, 0.0, d3, d4, d5);
    }

    public void getOutline(int n, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidFontException {
        this.font.getGlyphOutline(n, outlineConsumer);
    }

    public void getBitmap(int n, BitmapConsumer bitmapConsumer) throws UnsupportedFontException, InvalidFontException {
        OutlineConsumer2 outlineConsumer2 = this.scanConverter.getOutlineConsumer2();
        OutlineConsumerAdapter outlineConsumerAdapter = new OutlineConsumerAdapter(outlineConsumer2);
        outlineConsumerAdapter.setEmToPixelMatrix(this.emToPixel);
        outlineConsumerAdapter.startOutline();
        this.font.getGlyphOutline(n, outlineConsumerAdapter);
        outlineConsumerAdapter.endOutline();
        this.scanConverter.getBitmap(bitmapConsumer);
    }

    public void setDebugger(ScalerDebugger scalerDebugger) {
        this.debugger = scalerDebugger;
        this.scanConverter.setDebugger(scalerDebugger);
    }
}

