/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class PackageIdentifiersNode
extends Node {
    protected static final int IS_DEFINITION_FLAG = 1;
    public ObjectList<IdentifierNode> list = new ObjectList(5);
    public String pkg_part;
    public String def_part;

    public PackageIdentifiersNode(IdentifierNode identifierNode, int n, boolean bl) {
        super(n);
        this.list.add(identifierNode);
        if (bl) {
            this.flags |= 1;
        }
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    int size() {
        return this.list.size();
    }

    public int pos() {
        return this.list.size() != 0 ? this.list.last().pos() : 0;
    }

    public String toString() {
        return "PackageIdentifiers";
    }

    void clearIdentifierString() {
        if (this.pkg_part != null) {
            this.pkg_part = null;
        }
        if (this.def_part != null) {
            this.def_part = null;
        }
    }

    public String toIdentifierString() {
        if (this.pkg_part == null) {
            boolean bl = (this.flags & 1) != 0;
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                IdentifierNode identifierNode = (IdentifierNode)this.list.get(i);
                if (i == n - 1 && bl) {
                    this.def_part = "";
                    if ("*".equals(identifierNode.name)) continue;
                    this.def_part = identifierNode.name;
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(".");
                }
                stringBuffer.append(identifierNode.toIdentifierString());
            }
            this.pkg_part = stringBuffer.toString();
        }
        return this.pkg_part;
    }
}

