/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.lang.UCharacter;
import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.OTSelectorOnElementAttribute;
import com.adobe.fontengine.font.opentype.OTSelectors;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.LigatureLevel;
import com.adobe.fontengine.inlineformatting.infontformatting.BaseFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LookupsCache;

final class ArabicFormatter
extends BaseFormatter {
    private static final ElementAttribute joiningShape = new ElementAttribute("joiningShape");
    private static final OTSelector initSelector = new OTSelectorOnElementAttribute(joiningShape, JoiningShapes.init, true);
    private static final OTSelector mediSelector = new OTSelectorOnElementAttribute(joiningShape, JoiningShapes.medi, true);
    private static final OTSelector finaSelector = new OTSelectorOnElementAttribute(joiningShape, JoiningShapes.fina, true);
    private static final OTSelector isolSelector = new OTSelectorOnElementAttribute(joiningShape, JoiningShapes.isol, true);
    private static final int[] gsubFeatures = new int[]{Tag.feature_ccmp, Tag.feature_locl, Tag.feature_init, Tag.feature_medi, Tag.feature_fina, Tag.feature_isol, Tag.feature_rtla, Tag.feature_rlig, Tag.feature_liga};
    private static final int[] gposFeatures = new int[]{Tag.feature_kern, Tag.feature_mark, Tag.feature_mkmk};

    ArabicFormatter() {
    }

    protected void setJoiningShape(AttributedRun attributedRun, int n, int n2) {
        int n3 = Integer.MIN_VALUE;
        boolean bl = false;
        int n4 = 0;
        for (int i = n; i < n2 + 1; ++i) {
            JoiningShapes joiningShapes;
            int n5 = i == n2 ? 0 : (attributedRun.getElementStyle(i, ElementAttribute.isGlyph) != Boolean.TRUE ? UCharacter.getIntPropertyValue((int)attributedRun.elementAt(i), (int)4103) : (Integer)attributedRun.getElementStyle(i, ElementAttribute.joiningType));
            if (n5 == 5) continue;
            if (!(n5 != 1 && n5 != 2 && n5 != 4 || n4 != 1 && n4 != 2 && n4 != 3)) {
                joiningShapes = bl ? JoiningShapes.medi : JoiningShapes.init;
                bl = true;
            } else {
                joiningShapes = bl ? JoiningShapes.fina : JoiningShapes.isol;
                bl = false;
            }
            if (n3 != Integer.MIN_VALUE && n4 != 1 && n4 != 0) {
                attributedRun.setElementStyle(n3, joiningShape, joiningShapes);
            }
            n3 = i;
            n4 = n5;
        }
    }

    public int firstPass(AttributedRun attributedRun, int n, int n2) {
        while (n < n2) {
            int n3 = attributedRun.getSubrunLimit(n, n2, ElementAttribute.bidiLevel);
            this.setJoiningShape(attributedRun, n, n3);
            n = n3;
        }
        return super.firstPass(attributedRun, n, n2);
    }

    protected int setGlyphs(AttributedRun attributedRun, int n, int n2) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        Font font = (Font)attributedRun.getElementStyle(n, ElementAttribute.font);
        OpenTypeFont openTypeFont = (OpenTypeFont)((FontImpl)font).getFontData();
        while (n < n2) {
            int n3;
            int n4;
            int n5;
            if (attributedRun.getElementStyle(n, ElementAttribute.isGlyph) == Boolean.TRUE) {
                ++n;
                continue;
            }
            int n6 = attributedRun.elementAt(n);
            if (n6 == 8205 || n6 == 8204) {
                attributedRun.remove(n);
                --n2;
                attributedRun.setInterElementStyleBefore(n, InterElementAttribute.ligatureLevel, LigatureLevel.NONE);
                continue;
            }
            if (CharUtil.isControl(n6)) {
                attributedRun.remove(n);
                --n2;
                continue;
            }
            if ((Integer)attributedRun.getElementStyle(n, ElementAttribute.bidiLevel) % 2 == 1) {
                n6 = UCharacter.getMirror((int)n6);
            }
            if (!CharUtil.isBase(n6) || n + 1 == n2 || attributedRun.getElementStyle(n + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(attributedRun.elementAt(n + 1))) {
                n5 = openTypeFont.getGlyphForChar(n6);
                attributedRun.replace(n, n5);
                attributedRun.setElementStyle(n, ElementAttribute.isGlyph, Boolean.TRUE);
                ++n;
                continue;
            }
            for (n5 = n + 1; n5 < n2 && attributedRun.getElementStyle(n5, ElementAttribute.isGlyph) != Boolean.TRUE && CharUtil.isCombining(attributedRun.elementAt(n5)); ++n5) {
            }
            boolean bl = false;
            int[] nArray = new int[n5 - n];
            int[] nArray2 = new int[n5 - n];
            for (n4 = n; n4 < n5; ++n4) {
                nArray[n4 - n] = attributedRun.elementAt(n4);
                n3 = openTypeFont.getGlyphForChar(nArray[n4 - n]);
                if (n3 == 0) {
                    bl = true;
                }
                nArray2[n4 - n] = n3;
            }
            if (bl && (n4 = CharUtil.compose(nArray, 0, n5 - n)) != -1 && (n3 = openTypeFont.getGlyphForChar(n4)) != 0) {
                attributedRun.replace(n, n5, n3);
                attributedRun.setElementStyle(n, ElementAttribute.isGlyph, Boolean.TRUE);
                n2 -= n5 - n - 1;
                ++n;
                continue;
            }
            for (n4 = n; n4 < n5; ++n4) {
                attributedRun.replace(n4, nArray2[n4 - n]);
                attributedRun.setElementStyle(n, ElementAttribute.isGlyph, Boolean.TRUE);
            }
            n = n5;
        }
        return n2;
    }

    protected int formatOT(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int[][] nArray;
        Integer n3 = (Integer)attributedRun.getElementStyle(n, ElementAttribute.bidiLevel);
        int n4 = ArabicFormatter.getOTScriptTag((Integer)attributedRun.getElementStyle(n, InFontFormatter.scriptAttribute));
        int n5 = ArabicFormatter.getOTLanguageTag((ULocale)attributedRun.getElementStyle(n, ElementAttribute.locale));
        n2 = this.setGlyphs(attributedRun, n, n2);
        if (openTypeFont.gsub != null) {
            nArray = LookupsCache.resolveFeatureTag(openTypeFont.gsub, n4, n5, gsubFeatures);
            n2 = openTypeFont.gsub.applyLookups(nArray[0], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[1], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[2], attributedRun, n, n2, initSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[3], attributedRun, n, n2, mediSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[4], attributedRun, n, n2, finaSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[5], attributedRun, n, n2, isolSelector, openTypeFont.gdef);
            if (n3 % 2 == 1) {
                n2 = openTypeFont.gsub.applyLookups(nArray[6], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
            }
            n2 = openTypeFont.gsub.applyLookups(nArray[7], attributedRun, n, n2, OTSelectors.minimumLigatures, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[8], attributedRun, n, n2, OTSelectors.commonLigatures, openTypeFont.gdef);
        }
        this.posFromAdvanceWidth(attributedRun, openTypeFont, n, n2);
        if (openTypeFont.gpos != null) {
            nArray = LookupsCache.resolveFeatureTag(openTypeFont.gpos, n4, n5, gposFeatures);
            if (bl) {
                if (nArray[0].length != 0) {
                    n2 = openTypeFont.gpos.applyLookups(nArray[0], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
                } else {
                    this.applyKernTable(openTypeFont, attributedRun, n, n2);
                }
            }
            n2 = openTypeFont.gpos.applyLookups(nArray[1], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gpos.applyLookups(nArray[2], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
        } else {
            this.applyKernTable(openTypeFont, attributedRun, n, n2);
        }
        return n2;
    }

    private static class JoiningShapes {
        private String name;
        public static final JoiningShapes init = new JoiningShapes("init");
        public static final JoiningShapes isol = new JoiningShapes("isol");
        public static final JoiningShapes medi = new JoiningShapes("medi");
        public static final JoiningShapes fina = new JoiningShapes("fina");

        private JoiningShapes(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

