/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.http.proxy;

import flex.messaging.FlexContext;
import flex.messaging.log.Log;
import flex.messaging.services.http.httpclient.EasySSLProtocolSocketFactory;
import flex.messaging.services.http.proxy.ProxyContext;
import flex.messaging.services.http.proxy.ProxyException;
import flex.messaging.services.http.proxy.ProxyFilter;
import flex.messaging.services.http.proxy.Target;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class ProxyContextFilter
extends ProxyFilter {
    private static final int RELATIVE_NOT_SUPPORTED = 10704;
    private static final int INVALID_TARGET = 10705;
    private Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);

    public void invoke(ProxyContext context) {
        this.setupInitialProperties(context);
        this.setupTarget(context);
        this.logInfo(context);
        if (this.next != null) {
            this.next.invoke(context);
        }
    }

    protected void setupInitialProperties(ProxyContext context) {
        HttpServletRequest clientRequest = FlexContext.getHttpRequest();
        if (clientRequest != null) {
            String reqURL = clientRequest.getRequestURL().toString();
            int idx = reqURL.indexOf(58);
            String reqProto = reqURL.substring(0, idx);
            context.setClientHttps(reqProto.equalsIgnoreCase("https"));
            String userAgent = clientRequest.getHeader("User-Agent");
            context.setDisableCaching(context.isClientHttps() && userAgent != null && userAgent.indexOf("MSIE") != -1);
        }
    }

    protected void setupTarget(ProxyContext context) {
        String proxyDomain;
        Target target = context.getTarget();
        String source = context.getUrl();
        HttpServletRequest clientRequest = FlexContext.getHttpRequest();
        try {
            target.setUrl(new URL(source));
        }
        catch (MalformedURLException e) {
            try {
                if (clientRequest == null) {
                    ProxyException pe = new ProxyException();
                    pe.setMessage(10704, new Object[]{source});
                    throw pe;
                }
                String baseurl = "http" + (clientRequest.isSecure() ? "s" : "") + "://" + clientRequest.getServerName() + ":" + clientRequest.getServerPort();
                target.setUrl(new URL(baseurl + source));
            }
            catch (MalformedURLException ex) {
                target.setUrl(null);
            }
        }
        if (target.getUrl() == null) {
            ProxyException pe = new ProxyException();
            pe.setMessage(10705, new Object[]{source});
            throw pe;
        }
        target.setHTTPS(target.getUrl().getProtocol().equalsIgnoreCase("https"));
        target.setEncodedPath(target.getUrl().getPath());
        String queryStr = target.getUrl().getQuery();
        if (queryStr != null) {
            target.setEncodedPath(target.getEncodedPath() + "?" + queryStr);
        }
        target.setHostConfig(new HostConfiguration());
        String targetHost = target.getUrl().getHost();
        int targetPort = target.getUrl().getPort();
        Protocol customProtocol = context.getProtocol();
        if (customProtocol != null) {
            target.getHostConfig().setHost(targetHost, targetPort, customProtocol);
        } else if (target.isHTTPS() && context.allowLaxSSL()) {
            target.getHostConfig().setHost(targetHost, targetPort, this.myhttps);
        } else {
            String targetProtocol = target.getUrl().getProtocol();
            target.getHostConfig().setHost(targetHost, targetPort, targetProtocol);
        }
        if (context.getConnectionManager() != null) {
            context.setHttpClient(new HttpClient(context.getConnectionManager()));
        } else {
            context.setHttpClient(new HttpClient());
        }
        boolean localDomain = false;
        boolean localPort = false;
        if (clientRequest != null && (proxyDomain = clientRequest.getServerName()).equalsIgnoreCase(targetHost)) {
            localDomain = true;
            int proxyPort = clientRequest.getServerPort();
            localPort = proxyPort == targetPort;
        }
        context.setLocalDomain(localDomain);
        context.setLocalPort(localPort);
    }

    protected void logInfo(ProxyContext context) {
        if (Log.isInfo()) {
            Target target = context.getTarget();
            String prefix = "-- " + context.getMethod() + " : ";
            int targetPort = target.getUrl().getPort();
            String targetURL = target.getUrl().getProtocol() + "://" + target.getUrl().getHost() + (targetPort == -1 ? "" : ":" + targetPort) + target.getEncodedPath();
            Log.getLogger((String)"Service.HTTP").info(prefix + targetURL);
        }
    }
}

