/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

import flash.fonts.flashtype.ADFAlgnZones;
import flash.fonts.flashtype.ADFTypeSystem;
import flash.fonts.flashtype.FlexADFData;
import flash.swf.builder.types.ZoneRecordBuilder;
import flash.swf.tags.ZoneRecord;
import flash.swf.types.CurvedEdgeRecord;
import flash.swf.types.GlyphEntry;
import flash.swf.types.ShapeRecord;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flash.util.Trace;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;

public class FlashTypeZoneRecordBuilder
extends ZoneRecordBuilder {
    private static final String ZONE_STATE = "ZONESTATE";
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZoneRecord build(char character) {
        ADFAlgnZones.AlgnZoneState state = (ADFAlgnZones.AlgnZoneState)this.fontFace.getProperty(ZONE_STATE);
        if (state == null) {
            state = this.initializeAlignZoneState(this.fontFace.getFamily());
            this.fontFace.setProperty(ZONE_STATE, (Object)state);
        }
        return this.createZoneRecord(state, character);
    }

    public ZoneRecord createZoneRecord(ADFAlgnZones.AlgnZoneState state, char character) {
        ZoneRecord zoneRecord = new ZoneRecord();
        if (character == ' ') {
            zoneRecord.numZoneData = 2;
            zoneRecord.zoneData = new long[]{0L, 0L};
            zoneRecord.zoneMask = 0;
        } else {
            FlexADFData data = new FlexADFData();
            ADFTypeSystem.ADFPath pOnePath = this.getFontOutline(null, data, character);
            try {
                ADFAlgnZones.ADFDetectAlgnZones(null, state, pOnePath);
            }
            catch (Exception e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                throw new RuntimeException("Could not create ZoneTable for character " + character + " in font " + this.fontAlias);
            }
            if (pOnePath.algnZones == null) {
                zoneRecord.numZoneData = 2;
                zoneRecord.zoneData = new long[]{0L, 0L};
                zoneRecord.zoneMask = 0;
            } else {
                zoneRecord.numZoneData = pOnePath.algnZones.length;
                zoneRecord.zoneData = pOnePath.algnZones;
                zoneRecord.zoneMask = pOnePath.algnZonesMask;
            }
        }
        return zoneRecord;
    }

    public ADFTypeSystem.ADFPath getFontOutline(Object libInst, Object fontID, char charCode) {
        FlexADFData data = (FlexADFData)fontID;
        GlyphEntry ge = this.fontBuilder.getGlyph(charCode);
        if (ge == null) {
            ge = this.fontFace.getGlyphEntry(charCode);
        }
        if (!$assertionsDisabled && ge == null) {
            throw new AssertionError((Object)("Glyph entry " + charCode + " not found as expected in map."));
        }
        data.mPath.fontUnitsPerEM = 20480.0f;
        data.mPath.charCode = charCode;
        float xMin = 10000.0f;
        float yMin = 10000.0f;
        float xMax = -10000.0f;
        float yMax = -10000.0f;
        int numCountours = 0;
        int numPenCmds = 0;
        int x = 0;
        int y = 0;
        boolean previousMove = false;
        int prevX = 0;
        int prevY = 0;
        data.mPath.penCmds = new ArrayList(ge.shape.shapeRecords.size() * 2);
        Iterator iterator = ge.shape.shapeRecords.iterator();
        while (iterator.hasNext()) {
            ShapeRecord r = (ShapeRecord)iterator.next();
            if (r == null) continue;
            if (r instanceof StyleChangeRecord) {
                ADFTypeSystem.ADFPenCmd penCmd;
                StyleChangeRecord scr = (StyleChangeRecord)r;
                if (previousMove && x != prevX && y != prevY) {
                    penCmd = new ADFTypeSystem.ADFPenCmd();
                    penCmd.opCode = 1L;
                    penCmd.x = prevX;
                    penCmd.y = prevY * -1;
                    data.mPath.penCmds.add(penCmd);
                    ++numPenCmds;
                }
                x = scr.moveDeltaX;
                y = scr.moveDeltaY;
                previousMove = true;
                prevX = x;
                prevY = y;
                penCmd = new ADFTypeSystem.ADFPenCmd();
                penCmd.opCode = 0L;
                penCmd.x = x;
                penCmd.y = y * -1;
                data.mPath.penCmds.add(penCmd);
                ++numCountours;
                ++numPenCmds;
            } else if (r instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)r;
                ADFTypeSystem.ADFPenCmd penCmd = new ADFTypeSystem.ADFPenCmd();
                penCmd.opCode = 1L;
                penCmd.x = x += ser.deltaX;
                penCmd.y = (y += ser.deltaY) * -1;
                data.mPath.penCmds.add(penCmd);
                ++numPenCmds;
            } else if (r instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)r;
                int cx = x + cer.controlDeltaX;
                int cy = y + cer.controlDeltaY;
                x = cx + cer.anchorDeltaX;
                y = cy + cer.anchorDeltaY;
                ADFTypeSystem.ADFPenCmd penCmd = new ADFTypeSystem.ADFPenCmd();
                penCmd.opCode = 2L;
                penCmd.x = x;
                penCmd.y = y * -1;
                penCmd.cx = cx;
                penCmd.cy = cy * -1;
                data.mPath.penCmds.add(penCmd);
                ++numPenCmds;
                if ((float)cx < xMin) {
                    xMin = cx;
                }
                if ((float)cx > xMax) {
                    xMax = cx;
                }
                if ((float)cy < yMin) {
                    yMin = cy;
                }
                if ((float)cy > yMax) {
                    yMax = cy;
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unknown ShapeRecord: " + r.getClass()));
            }
            if ((float)x < xMin) {
                xMin = x;
            }
            if ((float)x > xMax) {
                xMax = x;
            }
            if ((float)y < yMin) {
                yMin = y;
            }
            if (!((float)y > yMax)) continue;
            yMax = y;
        }
        if (previousMove && x != prevX && y != prevY) {
            ADFTypeSystem.ADFPenCmd penCmd = new ADFTypeSystem.ADFPenCmd();
            penCmd.opCode = 1L;
            penCmd.x = prevX;
            penCmd.y = prevY * -1;
            data.mPath.penCmds.add(penCmd);
            ++numPenCmds;
        }
        data.mPath.glyphMinX = xMin;
        data.mPath.glyphMinY = yMax * -1.0f;
        data.mPath.glyphMaxX = xMax;
        data.mPath.glyphMaxY = yMin * -1.0f;
        data.mPath.numContours = numCountours;
        data.mPath.numPenCmds = numPenCmds;
        return data.mPath;
    }

    private ADFAlgnZones.AlgnZoneState initializeAlignZoneState(String fontName) {
        ADFAlgnZones.AlgnZoneState mpZoneInst;
        long time0 = 0L;
        if (Trace.font) {
            time0 = System.currentTimeMillis();
        }
        Method method = null;
        Method[] methodArr = ((Object)((Object)this)).getClass().getMethods();
        for (int i = 0; i < methodArr.length; ++i) {
            if (!methodArr[i].getName().equals("getFontOutline")) continue;
            method = methodArr[i];
            break;
        }
        try {
            mpZoneInst = (ADFAlgnZones.AlgnZoneState)ADFAlgnZones.ADFInitAlgnZoneDetection(null, new FlexADFData(), null, method, (Object)this);
        }
        catch (Exception e) {
            if (Trace.error) {
                e.printStackTrace();
            }
            throw new RuntimeException("Could not initialize FlashType for font " + fontName);
        }
        if (Trace.font) {
            Trace.trace((String)("FlashType initialization: " + (System.currentTimeMillis() - time0) + "ms"));
        }
        return mpZoneInst;
    }

    static {
        $assertionsDisabled = !FlashTypeZoneRecordBuilder.class.desiredAssertionStatus();
    }
}

