/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.AbstractList;

public abstract class AbstractLongList
extends AbstractList {
    public abstract int size();

    public abstract long getLong(int var1);

    public boolean containsLong(long value) {
        return this.indexOfLong(value) >= 0;
    }

    public int indexOfLong(long value) {
        int i = 0;
        while (i < this.size()) {
            if (this.getLong(i) == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOfLong(long value) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (this.getLong(i) == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Object get(int index) {
        return new Long(this.getLong(index));
    }

    public boolean contains(Object value) {
        return this.containsLong((Long)value);
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    public int indexOf(Object value) {
        return this.indexOfLong((Long)value);
    }

    public int lastIndexOf(Object value) {
        return this.lastIndexOfLong((Long)value);
    }

    public abstract long setLong(int var1, long var2);

    public abstract void addLong(int var1, long var2);

    public abstract long removeLongAt(int var1);

    public abstract void clear();

    public boolean addLong(long value) {
        this.addLong(this.size(), value);
        return true;
    }

    public boolean removeLong(long value) {
        int i = this.indexOfLong(value);
        if (i < 0) {
            return false;
        }
        this.removeLongAt(i);
        return true;
    }

    public Object set(int index, Object value) {
        return new Long(this.setLong(index, (Long)value));
    }

    public boolean add(Object value) {
        return this.addLong((Long)value);
    }

    public void add(int index, Object value) {
        this.addLong(index, (Long)value);
    }

    public Object remove(int index) {
        return new Long(this.removeLongAt(index));
    }

    public boolean remove(Object value) {
        return this.removeLong((Long)value);
    }
}

