/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services.logging;

import flash.util.ExceptionUtil;
import flex.webtier.services.logging.FileLogEventHandler;
import flex.webtier.util.PropertiesUtil;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;

public class LogEvent
implements Serializable {
    static final long serialVersionUID = 5826658332327361868L;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 4;
    public static final int LOG_DEBUG = 8;
    public static final int LOG_METRICS = 16;
    public static final int LOG_USER = 32;
    public static final String DEFAULT_FORMAT = "{server.date} {log.level} {log.message}{log.exception}";
    protected static String lineSeparator;
    private int type;
    private String message;
    private Throwable throwable;
    private Properties props;
    private String format;
    private Date logTime;
    private Throwable logStack;

    public LogEvent(int type, String msg) {
        this(type, msg, null);
    }

    public LogEvent(int type, String msg, Throwable t) {
        this(type, msg, t, null);
    }

    public LogEvent(int type, String msg, Throwable t, Properties props) {
        this.type = type;
        this.message = msg;
        this.throwable = t;
        this.props = props;
        this.logTime = new Date();
        this.logStack = new Exception();
    }

    public int getType() {
        return this.type;
    }

    public boolean isError() {
        return (this.type & 1) != 0;
    }

    public boolean isWarning() {
        return (this.type & 2) != 0;
    }

    public boolean isInfo() {
        return (this.type & 4) != 0;
    }

    public boolean isDebug() {
        return (this.type & 8) != 0;
    }

    public boolean isMetrics() {
        return (this.type & 0x10) != 0;
    }

    public boolean isUser() {
        return (this.type & 0x20) != 0;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFormattedMessage(String f) {
        if (f == null && (f = this.format) == null) {
            f = FileLogEventHandler.expandServerDate(DEFAULT_FORMAT);
        }
        Properties props = this.getVariables(f);
        String msg = PropertiesUtil.expandDynamicVariables(f, this.getLogTime(), props);
        return msg;
    }

    protected String getExceptionString(Throwable t) {
        return ExceptionUtil.exceptionToString((Throwable)t);
    }

    public Properties getVariables(String format) {
        if (format == null) {
            format = FileLogEventHandler.expandServerDate(this.getFormat());
        }
        Properties props = new Properties();
        StringBuffer sb = new StringBuffer();
        this.setType(sb, this.isDebug(), "DEBUG");
        this.setType(sb, this.isInfo(), "INFO");
        this.setType(sb, this.isWarning(), "WARNING");
        this.setType(sb, this.isError(), "ERROR");
        this.setType(sb, this.isMetrics(), "METRICS");
        this.setType(sb, this.isUser(), "USER");
        props.put("log.level", sb.toString());
        props.put("log.logger.className", "");
        props.put("log.logger.fullClassName", "");
        props.put("log.logger.methodName", "");
        props.put("log.logger.sourceFile", "");
        props.put("log.logger.line", "");
        String s = this.getMessage();
        if (s == null) {
            s = "";
        }
        props.put("log.message", s);
        s = "";
        if (this.getThrowable() != null) {
            s = lineSeparator + this.getExceptionString(this.getThrowable());
        }
        props.put("log.exception", s);
        if (format.indexOf("log.logger.") >= 0) {
            s = this.getExceptionString(this.logStack);
            String line = null;
            try {
                BufferedReader in = new BufferedReader(new StringReader(s));
                boolean nextOne = false;
                while ((line = in.readLine()) != null) {
                    if (line.indexOf("jrunx.logger.LoggerService.log") >= 0) {
                        nextOne = true;
                        continue;
                    }
                    if (!nextOne) continue;
                    break;
                }
            }
            catch (Exception ex) {
                line = null;
            }
            if (line != null) {
                String name;
                int n;
                String sourceFile = null;
                String className = null;
                String fullClassName = null;
                String methodName = null;
                String lineNo = null;
                int lastSpace = line.lastIndexOf(" ");
                int openParen = line.indexOf("(");
                int closeParen = line.indexOf(")");
                int colon = line.indexOf(":");
                if (lastSpace < openParen && (n = (name = line.substring(lastSpace + 1, openParen)).lastIndexOf(".")) > 0) {
                    methodName = name.substring(n + 1);
                    fullClassName = name.substring(0, n);
                    className = (n = fullClassName.lastIndexOf(".")) > 0 ? fullClassName.substring(n + 1) : fullClassName;
                }
                if (openParen > 0 && openParen < closeParen) {
                    if (colon > openParen) {
                        sourceFile = line.substring(openParen + 1, colon);
                        lineNo = line.substring(colon + 1, closeParen);
                    } else {
                        sourceFile = line.substring(openParen + 1, closeParen);
                    }
                }
                if (className != null) {
                    props.put("log.logger.className", className);
                }
                if (fullClassName != null) {
                    props.put("log.logger.fullClassName", fullClassName);
                }
                if (methodName != null) {
                    props.put("log.logger.methodName", methodName);
                }
                if (sourceFile != null) {
                    props.put("log.logger.sourceFile", sourceFile);
                }
                if (lineNo != null) {
                    props.put("log.logger.line", lineNo);
                }
            }
        }
        return props;
    }

    private void setType(StringBuffer sb, boolean set, String desc) {
        if (set) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(desc);
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        if (this.format == null) {
            this.format = DEFAULT_FORMAT;
        }
        return this.format;
    }

    public Date getLogTime() {
        return this.logTime;
    }

    public String toString() {
        return this.getMessage();
    }

    static {
        if (lineSeparator == null && (lineSeparator = System.getProperty("line.separator")) == null) {
            lineSeparator = "\n";
        }
    }
}

