/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.model

import com.we_lab_doc.spacecard.model.abstracts.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: March 24, 2008
 */ 
final class WorkCardComment extends Comment  {
	boolean remove() {
		this.workCard?.removeFromComments(this)
		return super.remove()
	}
	/////////////////////////////////////////////
	static WorkCardComment create(String title, String description) {
		return create([title:title,description:description])
	}
	static WorkCardComment create(String description) {
		return create([description:description])
	}
	static WorkCardComment create(params) {
		assert params != null
		def comment = new WorkCardComment(params)
		return comment
	}
	/////////////////////////////////////////////
	static belongsTo   = [workCard:WorkCard]
	/////////////////////////////////////////////
}
