import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class UserTests extends SpaceCardModelTestCase {
	def organizationService
	def roleService	
	
    void testCreateDelete() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		
		def org = Organization.createCompany("test org", "desc")
		assertNotNull org
		assertTrue ModelUtils.save(org)
		def userRole = org.getUserRole()
		assertNotNull userRole

		def user = User.create("hoge", "hogeyama", "hogeo", "h",	
				"hoge", "hoge@hoge.com", false, "hogedesu", userRole)
		assertNotNull user
		assertTrue "1", ModelUtils.save(user)
		def cardHolder = user.createCardHolder("name")
		user.addToCardHolders(cardHolder)
		assertTrue "2", ModelUtils.save(cardHolder)
		assertTrue "3", UserCardHolder.list().size() == 1
		assertNotNull user.deactivate()
		assertFalse user.active
		assertTrue "4", ModelUtils.save(user)
		assertTrue "5", user.getCardHolder("name") != null
		assertTrue "5", user.remove()
//			println "pass = " + user.password

	}
}