/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.svggen.DefaultCachedImageHandler;
import org.apache.batik.svggen.ImageCacher;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class CachedImageHandlerJPEGEncoder
extends DefaultCachedImageHandler {
    public static final String CACHED_JPEG_PREFIX = "jpegImage";
    public static final String CACHED_JPEG_SUFFIX = ".jpg";
    protected String refPrefix = "";

    public CachedImageHandlerJPEGEncoder(String imageDir, String urlRoot) throws SVGGraphics2DIOException {
        this.refPrefix = urlRoot + "/";
        this.setImageCacher(new ImageCacher.External(imageDir, CACHED_JPEG_PREFIX, CACHED_JPEG_SUFFIX));
    }

    public void encodeImage(BufferedImage buf, OutputStream os) throws IOException {
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)os);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(buf);
        param.setQuality(1.0f, false);
        encoder.encode(buf, param);
    }

    public int getBufferedImageType() {
        return 1;
    }

    public String getRefPrefix() {
        return this.refPrefix;
    }
}

