/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.css.dom.CSSOMSVGColor;
import org.apache.batik.css.dom.CSSOMSVGPaint;
import org.apache.batik.css.dom.CSSOMSVGStyleDeclaration;
import org.apache.batik.css.dom.CSSOMStyleDeclaration;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.SVGColorManager;
import org.apache.batik.css.engine.value.svg.SVGPaintManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.svg.SVGAnimatedString;

public abstract class SVGStylableElement
extends SVGOMElement
implements CSSStylableElement {
    protected StyleMap computedStyleMap;

    protected SVGStylableElement() {
    }

    protected SVGStylableElement(String prefix, AbstractDocument owner) {
        super(prefix, owner);
    }

    public StyleMap getComputedStyleMap(String pseudoElement) {
        return this.computedStyleMap;
    }

    public void setComputedStyleMap(String pseudoElement, StyleMap sm) {
        this.computedStyleMap = sm;
    }

    public String getXMLId() {
        return this.getAttributeNS(null, "id");
    }

    public String getCSSClass() {
        return this.getAttributeNS(null, "class");
    }

    public URL getCSSBase() {
        try {
            String bu = XMLBaseSupport.getCascadedXMLBase((Element)((Object)this));
            if (bu == null) {
                return null;
            }
            return new URL(bu);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new InternalError();
        }
    }

    public boolean isPseudoInstanceOf(String pseudoClass) {
        if (pseudoClass.equals("first-child")) {
            Node n;
            for (n = this.getPreviousSibling(); n != null && n.getNodeType() != 1; n = n.getPreviousSibling()) {
            }
            return n == null;
        }
        return false;
    }

    public CSSStyleDeclaration getStyle() {
        Object result = (CSSStyleDeclaration)((Object)this.getLiveAttributeValue(null, "style"));
        if (result == null) {
            CSSEngine eng = ((SVGOMDocument)((Object)this.getOwnerDocument())).getCSSEngine();
            result = new StyleDeclaration(eng);
        }
        return result;
    }

    public CSSValue getPresentationAttribute(String name) {
        Object result = (CSSValue)((Object)this.getLiveAttributeValue(null, name));
        if (result != null) {
            return result;
        }
        CSSEngine eng = ((SVGOMDocument)((Object)this.getOwnerDocument())).getCSSEngine();
        int idx = eng.getPropertyIndex(name);
        if (idx == -1) {
            return null;
        }
        if (idx > 59) {
            if (eng.getValueManagers()[idx] instanceof SVGPaintManager) {
                result = new PresentationAttributePaintValue(eng, name);
            }
            if (eng.getValueManagers()[idx] instanceof SVGColorManager) {
                result = new PresentationAttributeColorValue(eng, name);
            }
        } else {
            switch (idx) {
                case 15: 
                case 45: {
                    result = new PresentationAttributePaintValue(eng, name);
                    break;
                }
                case 19: 
                case 33: 
                case 43: {
                    result = new PresentationAttributeColorValue(eng, name);
                    break;
                }
                default: {
                    result = new PresentationAttributeValue(eng, name);
                }
            }
        }
        this.putLiveAttributeValue(null, name, (LiveAttributeValue)result);
        return result;
    }

    public SVGAnimatedString getClassName() {
        return this.getAnimatedStringAttribute(null, "class");
    }

    public class StyleDeclaration
    extends CSSOMSVGStyleDeclaration
    implements LiveAttributeValue,
    CSSOMStyleDeclaration.ValueProvider,
    CSSOMStyleDeclaration.ModificationHandler,
    CSSEngine.MainPropertyReceiver {
        protected org.apache.batik.css.engine.StyleDeclaration declaration;
        protected boolean mutate;

        public StyleDeclaration(CSSEngine eng) {
            super(null, null, eng);
            this.valueProvider = this;
            this.setModificationHandler(this);
            this.declaration = this.cssEngine.parseStyleDeclaration((CSSStylableElement)SVGStylableElement.this, SVGStylableElement.this.getAttributeNS(null, "style"));
        }

        public Value getValue(String name) {
            int idx = this.cssEngine.getPropertyIndex(name);
            for (int i = 0; i < this.declaration.size(); ++i) {
                if (idx != this.declaration.getIndex(i)) continue;
                return this.declaration.getValue(i);
            }
            return null;
        }

        public boolean isImportant(String name) {
            int idx = this.cssEngine.getPropertyIndex(name);
            for (int i = 0; i < this.declaration.size(); ++i) {
                if (idx != this.declaration.getIndex(i)) continue;
                return this.declaration.getPriority(i);
            }
            return false;
        }

        public String getText() {
            return this.declaration.toString(this.cssEngine);
        }

        public int getLength() {
            return this.declaration.size();
        }

        public String item(int idx) {
            return this.cssEngine.getPropertyName(this.declaration.getIndex(idx));
        }

        public void attrAdded(Attr node, String newv) {
            if (!this.mutate) {
                this.declaration = this.cssEngine.parseStyleDeclaration((CSSStylableElement)SVGStylableElement.this, newv);
            }
        }

        public void attrModified(Attr node, String oldv, String newv) {
            if (!this.mutate) {
                this.declaration = this.cssEngine.parseStyleDeclaration((CSSStylableElement)SVGStylableElement.this, newv);
            }
        }

        public void attrRemoved(Attr node, String oldv) {
            if (!this.mutate) {
                this.declaration = new org.apache.batik.css.engine.StyleDeclaration();
            }
        }

        public void textChanged(String text) throws DOMException {
            this.declaration = this.cssEngine.parseStyleDeclaration((CSSStylableElement)SVGStylableElement.this, text);
            this.mutate = true;
            SVGStylableElement.this.setAttributeNS(null, "style", text);
            this.mutate = false;
        }

        public void propertyRemoved(String name) throws DOMException {
            int idx = this.cssEngine.getPropertyIndex(name);
            for (int i = 0; i < this.declaration.size(); ++i) {
                if (idx != this.declaration.getIndex(i)) continue;
                this.declaration.remove(i);
                this.mutate = true;
                SVGStylableElement.this.setAttributeNS(null, "style", this.declaration.toString(this.cssEngine));
                this.mutate = false;
                return;
            }
        }

        public void setMainProperty(String name, Value v, boolean important) {
            int i;
            int idx = this.cssEngine.getPropertyIndex(name);
            if (idx == -1) {
                return;
            }
            for (i = 0; i < this.declaration.size() && idx != this.declaration.getIndex(i); ++i) {
            }
            if (i < this.declaration.size()) {
                this.declaration.put(i, v, idx, important);
            } else {
                this.declaration.append(v, idx, important);
            }
        }

        public void propertyChanged(String name, String value, String prio) throws DOMException {
            boolean important = prio != null && prio.length() > 0;
            this.cssEngine.setMainProperties((CSSStylableElement)SVGStylableElement.this, (CSSEngine.MainPropertyReceiver)this, name, value, important);
            this.mutate = true;
            SVGStylableElement.this.setAttributeNS(null, "style", this.declaration.toString(this.cssEngine));
            this.mutate = false;
        }
    }

    public class PresentationAttributePaintValue
    extends CSSOMSVGPaint
    implements LiveAttributeValue,
    CSSOMSVGColor.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributePaintValue(CSSEngine eng, String prop) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler((CSSOMSVGColor.ModificationHandler)new CSSOMSVGPaint.AbstractModificationHandler(this, SVGStylableElement.this){
                private final /* synthetic */ SVGStylableElement val$this$0;
                private final /* synthetic */ PresentationAttributePaintValue this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super((CSSOMSVGPaint)this$1);
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String text) throws DOMException {
                    this.this$1.value = this.this$1.cssEngine.parsePropertyValue((CSSStylableElement)PresentationAttributePaintValue.access$200(this.this$1), this.this$1.property, text);
                    this.this$1.mutate = true;
                    PresentationAttributePaintValue.access$200(this.this$1).setAttributeNS(null, this.this$1.property, text);
                    this.this$1.mutate = false;
                }
            });
            this.cssEngine = eng;
            this.property = prop;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, prop);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue((CSSStylableElement)SVGStylableElement.this, prop, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr node, String newv) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue((CSSStylableElement)SVGStylableElement.this, this.property, newv);
            }
        }

        public void attrModified(Attr node, String oldv, String newv) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue((CSSStylableElement)SVGStylableElement.this, this.property, newv);
            }
        }

        public void attrRemoved(Attr node, String oldv) {
            if (!this.mutate) {
                this.value = null;
            }
        }

        static /* synthetic */ SVGStylableElement access$200(PresentationAttributePaintValue x0) {
            return x0.SVGStylableElement.this;
        }
    }

    public class PresentationAttributeColorValue
    extends CSSOMSVGColor
    implements LiveAttributeValue,
    CSSOMSVGColor.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributeColorValue(CSSEngine eng, String prop) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler((CSSOMSVGColor.ModificationHandler)new CSSOMSVGColor.AbstractModificationHandler(this, SVGStylableElement.this){
                private final /* synthetic */ SVGStylableElement val$this$0;
                private final /* synthetic */ PresentationAttributeColorValue this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super((CSSOMSVGColor)this$1);
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String text) throws DOMException {
                    this.this$1.value = this.this$1.cssEngine.parsePropertyValue((CSSStylableElement)PresentationAttributeColorValue.access$100(this.this$1), this.this$1.property, text);
                    this.this$1.mutate = true;
                    PresentationAttributeColorValue.access$100(this.this$1).setAttributeNS(null, this.this$1.property, text);
                    this.this$1.mutate = false;
                }
            });
            this.cssEngine = eng;
            this.property = prop;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, prop);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue((CSSStylableElement)SVGStylableElement.this, prop, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr node, String newv) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue((CSSStylableElement)SVGStylableElement.this, this.property, newv);
            }
        }

        public void attrModified(Attr node, String oldv, String newv) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue((CSSStylableElement)SVGStylableElement.this, this.property, newv);
            }
        }

        public void attrRemoved(Attr node, String oldv) {
            if (!this.mutate) {
                this.value = null;
            }
        }

        static /* synthetic */ SVGStylableElement access$100(PresentationAttributeColorValue x0) {
            return x0.SVGStylableElement.this;
        }
    }

    public class PresentationAttributeValue
    extends CSSOMValue
    implements LiveAttributeValue,
    CSSOMValue.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributeValue(CSSEngine eng, String prop) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler((CSSOMValue.ModificationHandler)new CSSOMValue.AbstractModificationHandler(this, SVGStylableElement.this){
                private final /* synthetic */ SVGStylableElement val$this$0;
                private final /* synthetic */ PresentationAttributeValue this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super((CSSOMValue)this$1);
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String text) throws DOMException {
                    this.this$1.value = this.this$1.cssEngine.parsePropertyValue((CSSStylableElement)PresentationAttributeValue.access$000(this.this$1), this.this$1.property, text);
                    this.this$1.mutate = true;
                    PresentationAttributeValue.access$000(this.this$1).setAttributeNS(null, this.this$1.property, text);
                    this.this$1.mutate = false;
                }
            });
            this.cssEngine = eng;
            this.property = prop;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, prop);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue((CSSStylableElement)SVGStylableElement.this, prop, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr node, String newv) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue((CSSStylableElement)SVGStylableElement.this, this.property, newv);
            }
        }

        public void attrModified(Attr node, String oldv, String newv) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue((CSSStylableElement)SVGStylableElement.this, this.property, newv);
            }
        }

        public void attrRemoved(Attr node, String oldv) {
            if (!this.mutate) {
                this.value = null;
            }
        }

        static /* synthetic */ SVGStylableElement access$000(PresentationAttributeValue x0) {
            return x0.SVGStylableElement.this;
        }
    }
}

