/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.util.Edge;
import flex2.compiler.util.Graph;
import flex2.compiler.util.Vertex;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DependencyGraph
extends Graph {
    private Map map = new HashMap(300);
    private Map vertices = new HashMap(300);

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsVertex(String key) {
        return this.vertices.containsKey(key);
    }

    public void clear() {
        super.clear();
        this.map.clear();
        this.vertices.clear();
    }

    public void addVertex(Vertex v) {
        super.addVertex(v);
        this.vertices.put(v.getWeight(), v);
    }

    public Vertex getVertex(Object weight) {
        return (Vertex)this.vertices.get(weight);
    }

    public void removeVertex(String weight) {
        Vertex v = (Vertex)this.vertices.remove(weight);
        if (v != null) {
            super.removeVertex(v);
        }
    }

    public void addDependency(String name, String dep) {
        Vertex tail = null;
        Vertex head = null;
        head = (Vertex)this.vertices.get(name);
        if (head == null) {
            head = new Vertex(name);
            this.addVertex(head);
        }
        if ((tail = (Vertex)this.vertices.get(dep)) == null) {
            tail = new Vertex(dep);
            this.addVertex(tail);
        }
        this.addEdge(new Edge(tail, head, null));
    }

    public boolean dependencyExists(String name, String dep) {
        Vertex tail = null;
        Vertex head = null;
        head = (Vertex)this.vertices.get(name);
        if (head == null) {
            return false;
        }
        tail = (Vertex)this.vertices.get(dep);
        if (tail == null) {
            return false;
        }
        Set predecessors = head.getPredecessors();
        if (predecessors != null) {
            return predecessors.contains(tail);
        }
        return false;
    }
}

