/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flex.webtier.server.j2ee.HttpCache;
import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.MxmlFilter;
import flex.webtier.server.j2ee.events.XmlOutputHandler;
import flex.webtier.server.j2ee.html.ErrorRenderer;
import flex.webtier.server.j2ee.html.HistoryRenderer;
import flex.webtier.server.j2ee.html.MxmlRenderer;
import flex.webtier.server.j2ee.html.SwfRenderer;
import flex.webtier.services.ServiceFactory;
import flex.webtier.util.J2EEUtil;
import java.io.File;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletContext;

public class RenderFilter
extends MxmlFilter {
    private long maxage = ServiceFactory.getConfigurator().getServerConfiguration().getCacheConfiguration().getHttpMaximumAge();

    public void invoke(MxmlContext context) throws Throwable {
        Vector events = context.getEvents();
        if (this.isXmlRequest(context)) {
            HttpCache.setCacheHeaders(true, this.maxage, context.getLastModifiedTime(), context.getResponse());
            context.getResponse().setContentType("text/xml");
            PrintWriter writer = context.getResponseWriter();
            String mxmlFileName = context.getRequest().getServletPath();
            ServletContext servletContext = context.getServletContext();
            String servletPath = context.getRequest().getServletPath();
            String appRoot = new File(J2EEUtil.getRealPath((String)servletPath, (ServletContext)servletContext)).getParent();
            XmlOutputHandler xmlOutputHandler = new XmlOutputHandler(writer, mxmlFileName, appRoot, events, context.getSourceCodeLoader());
            xmlOutputHandler.output();
        } else if (this.isObjectRequest(context)) {
            HttpCache.setCacheHeaders(true, this.maxage, context.getLastModifiedTime(), context.getResponse());
            context.getResponse().setContentType("application/x-javascript");
            PrintWriter writer = context.getResponseWriter();
            HistoryRenderer historyRenderer = new HistoryRenderer(context);
            historyRenderer.renderJavaScript(writer, true);
            writer.println("<!-- swf content -->");
            SwfRenderer swfRenderer = new SwfRenderer();
            swfRenderer.renderEmbeddedSwf(context, writer, SwfRenderer.SCRIPT);
        } else if (context.hasErrors()) {
            HttpCache.setCacheHeaders(false, 0L, -1L, context.getResponse());
            context.getResponse().setStatus(500);
            ErrorRenderer errorRenderer = new ErrorRenderer();
            errorRenderer.render(context);
        } else {
            HttpCache.setCacheHeaders(true, this.maxage, context.getLastModifiedTime(), context.getResponse());
            MxmlRenderer mxmlRenderer = new MxmlRenderer(context);
            mxmlRenderer.render(context);
        }
    }

    public boolean isObjectRequest(MxmlContext context) {
        boolean objects = false;
        if (context.getRequest().getParameter("objectWrapperJs") != null) {
            objects = true;
        }
        return objects;
    }

    public boolean isXmlRequest(MxmlContext context) {
        boolean errors = false;
        if (context.getRequest().getParameter("errors") != null) {
            errors = true;
        }
        return errors;
    }
}

