/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.util;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.ExceptionLogger;
import flex.webtier.services.config.InvalidConfigurationException;
import flex.webtier.util.Trace;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ServiceUtil {
    public static ServiceFactory setupFlexService(ServletContext context, ServletConfig config) throws ServletException {
        ServiceFactory serviceImpl = null;
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("ServletContext", context);
            properties.put("ServletConfig", config);
            serviceImpl = ServiceFactory.getFactory(properties);
            serviceImpl.start();
        }
        catch (InvalidConfigurationException ice) {
            if (Trace.error) {
                ice.printStackTrace();
            }
            throw new ServletException(ice.getMessage());
        }
        catch (ConfigurationException ce) {
            throw new ServletException(ServiceUtil.getMessage(ce));
        }
        catch (Throwable t) {
            if (Trace.error) {
                t.printStackTrace();
            }
            throw new ServletException(t);
        }
        return serviceImpl;
    }

    public static String getMessage(ConfigurationException e) {
        LocalizationManager lm = ThreadLocalToolkit.getLocalizationManager();
        LocalizationManager localizationManager = new LocalizationManager();
        localizationManager.addLocalizer((ILocalizer)new XLRLocalizer());
        localizationManager.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)localizationManager);
        String message = new ExceptionLogger().getMessage((ILocalizableMessage)e);
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)lm);
        return message;
    }
}

