/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Permission;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;

public final class EmbeddingPermission {
    private static final XUIDComparator comparator = new XUIDComparator();
    private static XUID[] xuidEmbedOKTableAll = new XUID[]{new XUID(1, 11, 1800000), new XUID(1, 11, 1802000), new XUID(1, 11, 1803100), new XUID(1, 11, 1804200), new XUID(1, 11, 1805300), new XUID(1, 11, 1806400), new XUID(1, 11, 1807500), new XUID(1, 11, 1808600), new XUID(1, 11, 1809700), new XUID(1, 11, 1810800), new XUID(1, 11, 1811900), new XUID(1, 11, 1813000), new XUID(1, 11, 1814100), new XUID(1, 11, 1815200), new XUID(1, 11, 1816300), new XUID(1, 11, 1817400), new XUID(1, 11, 1818500), new XUID(1, 11, 1819600), new XUID(1, 11, 1820700), new XUID(1, 11, 1821800), new XUID(1, 11, 1822900), new XUID(1, 11, 1824000), new XUID(1, 11, 1825100), new XUID(1, 11, 1826200), new XUID(1, 11, 1827300), new XUID(1, 11, 1828500), new XUID(1, 11, 1829600), new XUID(1, 11, 1830700), new XUID(1, 11, 1837300), new XUID(1, 11, 1838400), new XUID(1, 11, 0x1C118C), new XUID(1, 11, 2219600), new XUID(1, 11, 2254000), new XUID(1, 11, 0x22C20C), new XUID(1, 11, 2279000), new XUID(1, 11, 2279400), new XUID(1, 11, 2285000), new XUID(1, 11, 2294900), new XUID(1, 11, 2296000), new XUID(1, 11, 2297100), new XUID(1, 11, 2298200), new XUID(1, 11, 2400000), new XUID(1, 11, 2401100), new XUID(1, 11, 2402200), new XUID(1, 11, 2403300), new XUID(1, 11, 2418700), new XUID(1, 11, 2419800), new XUID(1, 11, 2420900), new XUID(1, 11, 2422000), new XUID(1, 11, 2423100), new XUID(1, 11, 2424200), new XUID(1, 11, 2425300), new XUID(1, 11, 2426400), new XUID(1, 11, 2427500), new XUID(1, 11, 2428600), new XUID(1, 11, 2429700), new XUID(1, 11, 2430800), new XUID(1, 11, 2431900), new XUID(1, 11, 2433000), new XUID(1, 11, 2434100), new XUID(1, 11, 2446600), new XUID(1, 11, 2447700), new XUID(1, 11, 2448800), new XUID(1, 11, 2449900), new XUID(1, 11, 2451000), new XUID(1, 11, 2452100), new XUID(1, 11, 2453200), new XUID(1, 11, 2454300), new XUID(1, 11, 2455400), new XUID(1, 11, 2456500), new XUID(1, 11, 2457600), new XUID(1, 11, 2458700), new XUID(1, 11, 2459800), new XUID(1, 11, 2460900), new XUID(1, 11, 2461000), new XUID(1, 11, 2462100), new XUID(1, 11, 2464300), new XUID(1, 11, 2465100), new XUID(1, 11, 2465900), new XUID(1, 11, 2466700), new XUID(1, 11, 2467500), new XUID(1, 11, 2468600), new XUID(1, 11, 2471900), new XUID(1, 11, 2473000), new XUID(1, 11, 2474100), new XUID(1, 11, 2475200), new XUID(1, 11, 2476300), new XUID(1, 11, 2477400), new XUID(1, 11, 2478500), new XUID(1, 11, 2479600), new XUID(1, 11, 2480700), new XUID(1, 11, 2481800), new XUID(1, 11, 2487900), new XUID(1, 11, 2489000), new XUID(1, 11, 2490100), new XUID(1, 11, 2491200), new XUID(1, 11, 2492300), new XUID(1, 11, 2493400), new XUID(1, 11, 2494100), new XUID(1, 11, 2494800), new XUID(1, 11, 2495500), new XUID(1, 11, 2496200), new XUID(1, 11, 2496900), new XUID(1, 11, 2497600), new XUID(1, 11, 2498300), new XUID(1, 11, 2499000), new XUID(203, 1, 100), new XUID(203, 1, 200), new XUID(203, 1, 300), new XUID(203, 1, 400), new XUID(203, 1, 500), new XUID(207, 1104, 3033145), new XUID(207, 1108, 3136975), new XUID(207, 1109, 3138475), new XUID(207, 1111, 3034645), new XUID(207, 1203, 3167015), new XUID(207, 1204, 3036145), new XUID(207, 1206, 3139975), new XUID(207, 1207, 3037645), new XUID(207, 1209, 3141475), new XUID(207, 1211, 3039145), new XUID(207, 1303, 3168515), new XUID(207, 1311, 3271387), new XUID(207, 1504, 3256387), new XUID(207, 1511, 3263887), new XUID(207, 2104, 3040645), new XUID(207, 2108, 3124975), new XUID(207, 2109, 3126475), new XUID(207, 2111, 3042145), new XUID(207, 2203, 3164015), new XUID(207, 2204, 3043645), new XUID(207, 2206, 3127975), new XUID(207, 2207, 3045145), new XUID(207, 2209, 3129475), new XUID(207, 2211, 3046645), new XUID(207, 2303, 3165515), new XUID(207, 2311, 3272887), new XUID(207, 2504, 3257887), new XUID(207, 2511, 3265387), new XUID(207, 3104, 3048145), new XUID(207, 3108, 3142975), new XUID(207, 3109, 3144475), new XUID(207, 3111, 3049645), new XUID(207, 3203, 3170015), new XUID(207, 3204, 3051145), new XUID(207, 3206, 3145975), new XUID(207, 3207, 3052645), new XUID(207, 3209, 3147475), new XUID(207, 3211, 3054145), new XUID(207, 3303, 3171515), new XUID(207, 3311, 3274387), new XUID(207, 3504, 3259387), new XUID(207, 3511, 3266887), new XUID(207, 4104, 3055645), new XUID(207, 4108, 3130975), new XUID(207, 4109, 3132475), new XUID(207, 4111, 3057145), new XUID(207, 4203, 3173015), new XUID(207, 4204, 3058645), new XUID(207, 4206, 3133975), new XUID(207, 4207, 3060145), new XUID(207, 4209, 3135475), new XUID(207, 4211, 3061645), new XUID(207, 4303, 0x307073), new XUID(207, 4311, 3275887), new XUID(207, 4504, 3260887), new XUID(207, 4511, 3268387), new XUID(207, 5104, 3063145), new XUID(207, 5108, 3148975), new XUID(207, 5109, 3150475), new XUID(207, 5111, 3064645), new XUID(207, 5203, 3176015), new XUID(207, 5204, 3066145), new XUID(207, 5206, 3151975), new XUID(207, 5207, 3067645), new XUID(207, 5209, 3153475), new XUID(207, 5211, 3069145), new XUID(207, 5303, 3177515), new XUID(207, 5311, 3277387), new XUID(207, 5504, 3262387), new XUID(207, 5511, 3269887), new XUID(207, 10025, 3290537), new XUID(207, 10026, 3292037), new XUID(207, 10027, 3293537), new XUID(207, 10028, 3295037), new XUID(207, 10029, 3296537), new XUID(207, 10033, 3307037), new XUID(207, 10055, 3308537), new XUID(207, 10077, 3310037), new XUID(207, 10078, 3311537), new XUID(207, 10099, 3313037), new XUID(207, 10210, 3298037), new XUID(207, 10211, 3299537), new XUID(207, 10312, 3301037), new XUID(207, 10314, 3302537), new XUID(207, 10315, 3304037), new XUID(207, 10319, 3305537), new XUID(207, 10910, 3314537), new XUID(207, 11010, 3316037), new XUID(207, 11111, 3317537), new XUID(207, 11313, 3319037), new XUID(207, 11414, 3320537), new XUID(207, 11515, 3322037), new XUID(207, 11717, 3323537), new XUID(207, 12020, 3325037)};
    private static final String[] publicDomainFontNames = new String[]{"BauerBodoni-Black", "BauerBodoni-BlackCond", "BauerBodoni-BlackItalic", "BauerBodoni-Bold", "BauerBodoni-BoldCond", "BauerBodoni-BoldItalic", "BauerBodoni-BoldItalicOsF", "BauerBodoni-BoldOsF", "BauerBodoni-Italic", "BauerBodoni-ItalicOsF", "BauerBodoni-Roman", "BauerBodoni-RomanSC", "BellCentennial-Address", "BellCentennial-BoldListing", "BellCentennial-BoldListingAlt", "BellCentennial-NameAndNumber", "BellCentennial-SubCaption", "BrushScript", "Candida-Bold", "Candida-Italic", "Candida-Roman", "CenturyOldStyle-Bold", "CenturyOldStyle-Italic", "CenturyOldStyle-Regular", "Charme", "Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Folio-Bold", "Folio-BoldCondensed", "Folio-ExtraBold", "Folio-Light", "Folio-Medium", "Futura", "Futura-Bold", "Futura-BoldOblique", "Futura-Book", "Futura-BookOblique", "Futura-CondExtraBoldObl", "Futura-Condensed", "Futura-CondensedBold", "Futura-CondensedBoldOblique", "Futura-CondensedExtraBold", "Futura-CondensedLight", "Futura-CondensedLightOblique", "Futura-CondensedOblique", "Futura-ExtraBold", "Futura-ExtraBoldOblique", "Futura-Heavy", "Futura-HeavyOblique", "Futura-Light", "Futura-LightOblique", "Futura-Oblique", "Hobo", "Impressum-Bold", "Impressum-Italic", "Impressum-Roman", "LetterGothic", "LetterGothic-Bold", "LetterGothic-BoldSlanted", "LetterGothic-Slanted", "NewsGothic", "NewsGothic-Bold", "NewsGothic-BoldOblique", "NewsGothic-Oblique", "OCRA", "OCRB", "Orator", "Orator-Slanted", "PrestigeElite", "PrestigeElite-Bold", "PrestigeElite-BoldSlanted", "PrestigeElite-Slanted", "Serifa-Black", "Serifa-Bold", "Serifa-Italic", "Serifa-Light", "Serifa-LightItalic", "Serifa-Roman", "SimonciniGaramond", "SimonciniGaramond-Bold", "SimonciniGaramond-Italic", "StempelSchneidler-Black", "StempelSchneidler-BlackItalic", "StempelSchneidler-Bold", "StempelSchneidler-BoldItalic", "StempelSchneidler-Italic", "StempelSchneidler-Light", "StempelSchneidler-LightItalic", "StempelSchneidler-MedItalic", "StempelSchneidler-Medium", "StempelSchneidler-Roman", "Stencil", "Weiss", "Weiss-Bold", "Weiss-ExtraBold", "Weiss-Italic"};
    private static final Pattern trademarkAdobe = Pattern.compile("trademark\\s+of\\s+Adobe", 2);
    private static final Pattern adobe = Pattern.compile("Adobe", 2);

    private EmbeddingPermission() {
    }

    public static Permission interpretFSType(int n) {
        if (n == 2) {
            return Permission.RESTRICTED;
        }
        if ((n & 0x200) != 0) {
            return Permission.RESTRICTED;
        }
        if ((n & 8) != 0) {
            return Permission.EDITABLE;
        }
        if ((n & 4) != 0) {
            return Permission.PREVIEW_AND_PRINT;
        }
        if (n == 0) {
            return Permission.INSTALLABLE;
        }
        return Permission.ILLEGAL_VALUE;
    }

    private static String getComparisonFontName(String string) {
        if (string.length() > 7 && string.charAt(6) == '+') {
            boolean bl = true;
            for (int i = 0; i < 6; ++i) {
                if (string.charAt(i) >= 'A' && string.charAt(i) <= 'Z') continue;
                bl = false;
                break;
            }
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer(string);
                return stringBuffer.substring(7);
            }
        }
        return string;
    }

    public static Permission getType1DefaultPermission(String string, String string2) {
        if (string != null) {
            if (trademarkAdobe.matcher(string).find()) {
                return Permission.EDITABLE;
            }
            if (string2 != null) {
                string2 = EmbeddingPermission.getComparisonFontName(string2);
                if (adobe.matcher(string).find() && Arrays.binarySearch(publicDomainFontNames, string2) >= 0) {
                    return Permission.EDITABLE;
                }
            }
        }
        return Permission.PREVIEW_AND_PRINT;
    }

    public static Permission getCIDDefaultPermission(int[] nArray) {
        if (nArray == null || nArray.length < 3) {
            return Permission.RESTRICTED;
        }
        if (Arrays.binarySearch(xuidEmbedOKTableAll, new XUID(nArray[0], nArray[1], nArray[2]), comparator) >= 0) {
            return Permission.PREVIEW_AND_PRINT;
        }
        return Permission.RESTRICTED;
    }

    public static Permission getTrueTypeDefaultPermission() {
        return Permission.PREVIEW_AND_PRINT;
    }

    public static Permission getDefaultWasEmbeddedPermission() {
        return Permission.PREVIEW_AND_PRINT;
    }

    public static Permission getOCFDefaultPermission() {
        return Permission.RESTRICTED;
    }

    public static final class OutlineRestriction {
        public static final OutlineRestriction BITMAP_ONLY = new OutlineRestriction();
        public static final OutlineRestriction OUTLINES_OK = new OutlineRestriction();
        public static final OutlineRestriction UNKNOWN_OUTLINE_RESTRICTION = new OutlineRestriction();

        private OutlineRestriction() {
        }
    }

    public static final class SubsettingRestriction {
        public static final SubsettingRestriction FULL_FONT_ONLY = new SubsettingRestriction();
        public static final SubsettingRestriction SUBSETTING_OK = new SubsettingRestriction();
        public static final SubsettingRestriction UNKNOWN_SUBSETTING_RESTRICTION = new SubsettingRestriction();

        private SubsettingRestriction() {
        }
    }

    private static class XUIDComparator
    implements Comparator {
        private XUIDComparator() {
        }

        public int compare(Object object, Object object2) {
            XUID xUID = (XUID)object;
            XUID xUID2 = (XUID)object2;
            if (xUID.organization != xUID2.organization) {
                return xUID.organization - xUID2.organization;
            }
            if (xUID.uid2 != xUID2.uid2) {
                return xUID.uid2 - xUID2.uid2;
            }
            return xUID.uid3 - xUID2.uid3;
        }
    }

    private static class XUID {
        final int organization;
        final int uid2;
        final int uid3;

        XUID(int n, int n2, int n3) {
            this.organization = n;
            this.uid2 = n2;
            this.uid3 = n3;
        }
    }
}

