/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.pdffont;

import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.postscript.GlyphNamesAccessor;
import com.adobe.fontengine.font.postscript.ScriptHeuristics;
import com.adobe.fontengine.font.postscript.UnicodeCmap;
import com.adobe.fontengine.fontmanagement.PDFSimpleFontValuesAccessor;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public final class PDFSimpleFont
extends FontData {
    private final String fontFamily;
    private final String postscriptName;
    private final Rect fontBBox;
    private final double capHeight;
    private final double xHeight;
    private final double ascent;
    private final double descent;
    private final double leading;
    private final double stemV;
    private final double italicAngle;
    private final int flags;
    private final int weight;
    private final CSS20Attribute.CSSStretchValue stretch;
    private final int numGlyphs;
    private final UnicodeCmap cmap;
    private final double[] gid2width;
    private final String[] gid2name;

    public PDFSimpleFont(PDFSimpleFontValuesAccessor pDFSimpleFontValuesAccessor) throws InvalidFontException, UnsupportedFontException {
        super(null);
        int n;
        this.fontFamily = pDFSimpleFontValuesAccessor.getFontFamily();
        this.postscriptName = pDFSimpleFontValuesAccessor.getPostscriptName();
        this.fontBBox = pDFSimpleFontValuesAccessor.getFontBBox();
        this.capHeight = pDFSimpleFontValuesAccessor.getCapHeight();
        this.ascent = pDFSimpleFontValuesAccessor.getAscent();
        this.descent = pDFSimpleFontValuesAccessor.getDescent();
        this.leading = pDFSimpleFontValuesAccessor.getLeading();
        this.stemV = pDFSimpleFontValuesAccessor.getStemV();
        this.italicAngle = pDFSimpleFontValuesAccessor.getItalicAngle();
        this.flags = pDFSimpleFontValuesAccessor.getFlags();
        this.weight = pDFSimpleFontValuesAccessor.getFontWeight();
        this.stretch = pDFSimpleFontValuesAccessor.getFontStretch();
        this.xHeight = pDFSimpleFontValuesAccessor.getXHeight();
        int[] nArray = new int[257];
        this.gid2name = new String[257];
        int n2 = 0;
        nArray[0] = 0;
        this.gid2name[0] = ".notdef";
        for (n = 0; n < 256; ++n) {
            String string = pDFSimpleFontValuesAccessor.getGlyphName(n);
            if (string == null) continue;
            nArray[++n2] = n;
            this.gid2name[n2] = string;
        }
        this.numGlyphs = n2 + 1;
        this.cmap = UnicodeCmap.computeCmapFromGlyphNames(this.numGlyphs, false, new GlyphNamesAccessor(){

            public String getAGlyphName(int n) throws InvalidFontException, UnsupportedFontException {
                return PDFSimpleFont.this.gid2name[n];
            }
        });
        this.gid2width = new double[this.numGlyphs];
        for (n = 0; n < this.numGlyphs; ++n) {
            this.gid2width[n] = pDFSimpleFontValuesAccessor.getGlyphWidth(nArray[n]);
        }
    }

    public boolean getCoolTypeProportionalRomanFromFontProperties() {
        return (this.flags & 1) != 0;
    }

    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException {
        return (this.flags & 4) != 0;
    }

    public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
        return this.numGlyphs;
    }

    public double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException {
        return 1000.0;
    }

    public double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException {
        return 1000.0;
    }

    protected Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException {
        return this.fontBBox;
    }

    public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
        return this.fontBBox;
    }

    public CoolTypeScript getCoolTypeScript() throws UnsupportedFontException, InvalidFontException {
        return ScriptHeuristics.getCoolTypeScript(this.postscriptName, this.getNumGlyphs(), new GlyphNamesAccessor(){

            public String getAGlyphName(int n) throws InvalidFontException, UnsupportedFontException {
                return PDFSimpleFont.this.gid2name[n];
            }
        });
    }

    private Rect getCoolTypeIdeoEmBoxFromCapHeight() throws InvalidFontException, UnsupportedFontException {
        if (Double.isNaN(this.capHeight)) {
            return null;
        }
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        double d3 = -(d2 - this.capHeight) / 2.0;
        return new Rect(0.0, d3, d, d3 + d2);
    }

    public Rect getCoolTypeIdeoEmBox() throws UnsupportedFontException, InvalidFontException {
        Rect rect = this.getCoolTypeIdeoEmBoxFromCapHeight();
        if (rect != null) {
            return rect;
        }
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        return new Rect(0.0, -0.12 * d2, d, 0.88 * d2);
    }

    public Rect getCoolTypeIcfBox() throws InvalidFontException, UnsupportedFontException {
        return this.getCoolTypeIcfBoxFromIdeoEmBox(this.getCoolTypeIdeoEmBox());
    }

    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        return new LineMetrics(this.ascent, this.descent, this.leading);
    }

    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException {
        return new UnderlineMetrics(-150.0, 50.0);
    }

    public int getGlyphForChar(int n) throws InvalidFontException, UnsupportedFontException {
        return this.cmap.getGlyphForChar(n);
    }

    public Rect getGlyphBBox(int n) throws UnsupportedFontException, InvalidFontException {
        return this.fontBBox;
    }

    public void getGlyphOutline(int n, OutlineConsumer outlineConsumer) throws InvalidFontException, UnsupportedFontException {
        throw new UnsupportedFontException("cannot get outline for PDFSimpleFont");
    }

    public double getHorizontalAdvance(int n) throws InvalidGlyphException, UnsupportedFontException, InvalidFontException {
        return this.gid2width[n];
    }

    public Scaler getScaler(ScanConverter scanConverter) throws InvalidFontException, UnsupportedFontException {
        throw new UnsupportedFontException("getOutlineAccessor not supported for PDFSimpleFont");
    }

    public Permission getEmbeddingPermission(boolean bl) throws InvalidFontException, UnsupportedFontException {
        return Permission.RESTRICTED;
    }

    public PDFFontDescription getPDFFontDescription(Font font) {
        return new PDFSimpleFontXDCFontDescription();
    }

    public XDCFontDescription getXDCFontDescription(Font font) {
        return new PDFSimpleFontXDCFontDescription();
    }

    public Subset createSubset() throws InvalidFontException, UnsupportedFontException {
        throw new UnsupportedFontException("createSubset not meaningful for PDFSimpleFont");
    }

    public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
        throw new UnsupportedFontException("subsetAndStream not meaningful for PDFSimpleFont");
    }

    public PostscriptFontDescription[] getPostscriptFontDescription() throws InvalidFontException, UnsupportedFontException {
        return new PostscriptFontDescription[]{new PostscriptFontDescription(this.postscriptName)};
    }

    protected Set getCSSFamilyNames() throws InvalidFontException, UnsupportedFontException {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.fontFamily != null) {
            hashSet.add(this.fontFamily);
        }
        return hashSet;
    }

    protected String getPreferredCSSFamilyName() throws InvalidFontException, UnsupportedFontException {
        return this.fontFamily;
    }

    protected CSS20Attribute.CSSStretchValue getCSSStretchValue() throws InvalidFontException, UnsupportedFontException {
        return this.stretch;
    }

    protected int getCSSWeight() throws InvalidFontException, UnsupportedFontException {
        return this.weight;
    }

    protected boolean isCSSStyleItalic() throws InvalidFontException, UnsupportedFontException {
        return this.italicAngle != 0.0 || (this.flags & 0x40) != 0;
    }

    protected boolean isCSSStyleNormal() throws InvalidFontException, UnsupportedFontException {
        return !this.isCSSStyleItalic();
    }

    protected boolean isCSSStyleOblique() throws InvalidFontException, UnsupportedFontException {
        return false;
    }

    protected boolean isCSSVariantNormal() throws InvalidFontException, UnsupportedFontException {
        return !this.isCSSVariantSmallCaps();
    }

    protected boolean isCSSVariantSmallCaps() throws InvalidFontException, UnsupportedFontException {
        return (this.flags & 0x20000) != 0;
    }

    public CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException {
        throw new UnsupportedFontException("getSelectionDescription not supported for PDFSimpleFont");
    }

    public SWFFontDescription getSWFFontDescription(boolean bl) throws UnsupportedFontException, InvalidFontException {
        return null;
    }

    class PDFSimpleFontXDCFontDescription
    extends XDCFontDescription {
        PDFSimpleFontXDCFontDescription() {
        }

        public double getAdvance(int n) throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.gid2width[n];
        }

        public String getBase14Name() {
            return null;
        }

        public double getCapHeight() throws UnsupportedFontException, InvalidFontException {
            return PDFSimpleFont.this.capHeight;
        }

        public double getXHeight() throws UnsupportedFontException, InvalidFontException {
            return PDFSimpleFont.this.xHeight;
        }

        public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.fontBBox;
        }

        public String getFontFamily() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.fontFamily;
        }

        public int getGlyphCid(int n) throws UnsupportedFontException, InvalidFontException {
            return -1;
        }

        public String getGlyphName(int n) throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.gid2name[n];
        }

        public double getItalicAngle() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.italicAngle;
        }

        public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.numGlyphs;
        }

        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.postscriptName;
        }

        public ROS getROS() throws UnsupportedFontException, InvalidFontException {
            return null;
        }

        public double getStemV() throws UnsupportedFontException, InvalidFontException {
            return PDFSimpleFont.this.stemV;
        }

        public boolean pdfFontIsTrueType() throws InvalidFontException, UnsupportedFontException {
            return false;
        }

        public boolean isSerifFont() {
            return (PDFSimpleFont.this.flags & 2) != 0;
        }

        public boolean isSmallCapFont() {
            return (PDFSimpleFont.this.flags & 0x20000) != 0;
        }

        public boolean isAllCapFont() throws InvalidFontException, UnsupportedFontException {
            return (PDFSimpleFont.this.flags & 0x10000) != 0;
        }

        public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl) throws UnsupportedFontException {
            throw new UnsupportedFontException("subsetAndStream not meaningful for PDFSimpleFont");
        }

        public void subsetAndStream(SubsetSimpleType1 subsetSimpleType1, OutputStream outputStream) throws UnsupportedFontException {
            throw new UnsupportedFontException("subsetAndStream not meaningful for PDFSimpleFont");
        }

        public void subsetAndStream(SubsetSimpleTrueType subsetSimpleTrueType, OutputStream outputStream) throws UnsupportedFontException {
            throw new UnsupportedFontException("subsetAndStream not meaningful for PDFSimpleFont");
        }

        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            if (PDFSimpleFont.this.isSymbolic()) {
                return new CodePage[0];
            }
            CodePage codePage = null;
            for (int i = 0; i < PDFSimpleFont.this.numGlyphs; ++i) {
                if (PDFSimpleFont.this.gid2name[i].equals("ecircumflex")) {
                    if (codePage == CodePage.ROMAN2) {
                        return new CodePage[0];
                    }
                    codePage = CodePage.ROMAN1;
                    continue;
                }
                if (!PDFSimpleFont.this.gid2name[i].equals("Ccaron") && !PDFSimpleFont.this.gid2name[i].equals("ncaron")) continue;
                if (codePage == CodePage.ROMAN1) {
                    return new CodePage[0];
                }
                codePage = CodePage.ROMAN2;
            }
            if (codePage == null) {
                return new CodePage[0];
            }
            CodePage[] codePageArray = new CodePage[]{codePage};
            return codePageArray;
        }
    }
}

