/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.postscript.GlyphNamesAccessor;
import java.util.regex.Pattern;

public final class ScriptHeuristics {
    static final Pattern cePattern = Pattern.compile(".*[^A-Z]CE[^A-Za-z].*");
    static final Pattern cyrPattern = Pattern.compile(".*[^A-Z]Cyr[^A-Za-z].*");

    private static CoolTypeScript getCoolTypeScriptFromPostscriptName(String string) {
        if (string == null) {
            return null;
        }
        if (cePattern.matcher(string).find()) {
            return CoolTypeScript.EAST_EUROPEAN_ROMAN;
        }
        if (cyrPattern.matcher(string).find()) {
            return CoolTypeScript.CYRILLIC;
        }
        if (string.startsWith("ALBAYAN")) {
            return CoolTypeScript.ARABIC;
        }
        return null;
    }

    private static CoolTypeScript getCoolTypeScriptFromEncodedGlyphComplement(int n, GlyphNamesAccessor glyphNamesAccessor) throws InvalidFontException, UnsupportedFontException {
        if (glyphNamesAccessor == null) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < n; ++i) {
            String string = glyphNamesAccessor.getAGlyphName(i);
            if ("Tcaron".equals(string)) {
                return CoolTypeScript.EAST_EUROPEAN_ROMAN;
            }
            if ("afii10049".equals(string)) {
                return CoolTypeScript.CYRILLIC;
            }
            if (string.startsWith("patah")) {
                if (bl) {
                    return CoolTypeScript.HEBREW;
                }
                bl2 = true;
            }
            if (string.startsWith("shin")) {
                if (bl2) {
                    return CoolTypeScript.HEBREW;
                }
                bl = true;
            }
            if (string.startsWith("fatha")) {
                if (bl3) {
                    return CoolTypeScript.ARABIC;
                }
                bl4 = true;
            }
            if (!string.startsWith("sheen")) continue;
            if (bl4) {
                return CoolTypeScript.ARABIC;
            }
            bl3 = true;
        }
        return null;
    }

    public static CoolTypeScript getCoolTypeScript(String string, int n, GlyphNamesAccessor glyphNamesAccessor) throws InvalidFontException, UnsupportedFontException {
        CoolTypeScript coolTypeScript = ScriptHeuristics.getCoolTypeScriptFromPostscriptName(string);
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        coolTypeScript = ScriptHeuristics.getCoolTypeScriptFromEncodedGlyphComplement(n, glyphNamesAccessor);
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        return CoolTypeScript.ROMAN;
    }
}

