/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import javax.servlet.http.HttpServletResponse;

public class HttpCache {
    private static long NO_CACHE = 946080000000L;

    private static void setNoCacheHeaders(HttpServletResponse response) {
        response.setDateHeader("Expires", NO_CACHE);
        response.setDateHeader("Last-Modified", System.currentTimeMillis());
    }

    public static void setCacheHeaders(boolean cacheEnabled, long maxage, long lastModified, HttpServletResponse response) {
        if (cacheEnabled) {
            response.setDateHeader("Last-Modified", lastModified);
            response.setHeader("Cache-Control", "max-age=" + maxage + ", must-revalidate");
            long expires = System.currentTimeMillis();
            expires -= expires % 1000L;
            response.setDateHeader("Expires", expires += maxage * 1000L);
            response.setHeader("Pragma", "public");
        } else {
            HttpCache.setNoCacheHeaders(response);
        }
    }
}

