/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.html;

import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.html.BaseSwfRenderer;
import flex.webtier.server.j2ee.html.DetectionSettings;
import java.io.PrintWriter;

public class DetectionRenderer
extends BaseSwfRenderer {
    private DetectionSettings detectionSettings;
    private static String SECURE_GO_URL = "https://www.adobe.com/go/getflashplayer";
    private static String GO_URL = "http://www.adobe.com/go/getflashplayer";

    public DetectionRenderer(MxmlContext context) {
        this.detectionSettings = context.getDetectionSettings();
    }

    public void renderTagImport(PrintWriter output, boolean firstOnPage) {
        if (firstOnPage) {
            output.println("<script language='javascript' charset='utf-8' src='" + this.detectionSettings.getTagsJavascript() + "'></script>");
        }
    }

    public void renderRequiredInfo(PrintWriter output, boolean firstOnPage) {
        if (firstOnPage && this.detectionSettings.enabled()) {
            output.println("<script language='javascript' type='text/javascript'>");
            output.println("<!--");
            output.println("// -----------------------------------------------------------------------------");
            output.println("// Globals");
            output.println("// Major version of Flash required");
            output.println("var requiredMajorVersion = " + this.detectionSettings.getMajorVersion() + ";");
            output.println("// Minor version of Flash required");
            output.println("var requiredMinorVersion = " + this.detectionSettings.getMinorVersion() + ";");
            output.println("// Minor version of Flash require");
            output.println("var requiredRevision = " + this.detectionSettings.getVersionRevision() + ";");
            output.println("// -----------------------------------------------------------------------------");
            output.println("// -->");
            output.println("</script>");
        }
    }

    public void renderSwf(MxmlContext context, PrintWriter output) {
        if (this.detectionSettings.enabled() && this.detectionSettings.useExpressInstall()) {
            this.renderSwfWithVersionCheckAndExpressInstall(context, output);
        } else if (this.detectionSettings.enabled()) {
            this.renderSwfWithVersionCheckOnly(context, output);
        } else {
            this.renderSwfOnly(context, output);
        }
    }

    private void renderSwfOnly(MxmlContext context, PrintWriter output) {
        String swf = this.getSwfWebPath(context);
        output.println("<script language=\"JavaScript\" type=\"text/javascript\">");
        output.println("<!--");
        this.runContentSnippet(context, output, swf);
        output.println("// -->");
        output.println("</script>");
    }

    private void renderSwfWithVersionCheckAndExpressInstall(MxmlContext context, PrintWriter output) {
        String application = this.getSwfId(context);
        String swf = this.getSwfWebPath(context);
        String playerProductInstall = this.detectionSettings.getSwfUri();
        String height = context.getHeight();
        String width = context.getWidth();
        String bgcolor = context.getBackgroundColor();
        boolean secure = context.isSecureRequest();
        String activexCodebaseUrl = this.getActivexCodebase(secure);
        String pluginDownloadUrl = this.getPluginDownloadUrl(secure);
        String goUrl = secure ? SECURE_GO_URL : GO_URL;
        output.println("<script language='JavaScript' type='text/javascript'>");
        output.println("<!--");
        output.println("// Version check for the Flash Player that has the ability to start Player Product Install (6.0r65)");
        output.println("var hasProductInstall = DetectFlashVer(6, 0, 65);");
        output.println("");
        output.println("// Version check based upon the values defined in globals");
        output.println("var hasRequestedVersion = DetectFlashVer(requiredMajorVersion, requiredMinorVersion, requiredRevision);");
        output.println("");
        output.println("// Check to see if a player with Flash Product Install is available and the version does not meet the requirements for playback");
        output.println("if ( hasProductInstall && !hasRequestedVersion ) {");
        output.println("// MMdoctitle is the stored document.title value used by the installation process to close the window that started the process");
        output.println("// This is necessary in order to close browser windows that are still utilizing the older version of the player after installation has completed");
        output.println("// DO NOT MODIFY THE FOLLOWING FOUR LINES");
        output.println("// Location visited after installation is complete if installation is required");
        output.println("var MMPlayerType = (isIE == true) ? \"ActiveX\" : \"PlugIn\";");
        output.println("var MMredirectURL = window.location;");
        output.println("document.title = document.title.slice(0, 47) + \" - Flash Player Installation\";");
        output.println("var MMdoctitle = document.title;");
        output.println("");
        output.println("AC_FL_RunContent(");
        output.println("\"src\", \"" + playerProductInstall + "\",");
        output.println("\"FlashVars\", \"MMredirectURL=\"+escape(MMredirectURL)+'&MMplayerType='+MMPlayerType+'&MMdoctitle='+MMdoctitle+\"\",");
        output.println("\"width\", \"" + width + "\",");
        output.println("\"height\", \"" + height + "\",");
        output.println("\"align\", \"middle\",");
        output.println("\"id\", \"" + application + "\",");
        output.println("\"quality\", \"high\",");
        output.println("\"bgcolor\", \"" + bgcolor + "\",");
        output.println("\"name\", \"" + application + "\",");
        output.println("\"allowScriptAccess\",\"sameDomain\",");
        output.println("\"type\", \"application/x-shockwave-flash\",");
        output.println("\"codebase\", \"" + activexCodebaseUrl + "\",");
        output.println("\"pluginspage\", \"" + pluginDownloadUrl + "\"");
        output.println(");");
        output.println("");
        output.println("} else if (hasRequestedVersion) {");
        output.println("// if we've detected an acceptable version");
        output.println("// embed the Flash Content SWF when all tests are passed");
        this.runContentSnippet(context, output, swf);
        output.println("} else {  // flash is too old or we can't detect the plugin");
        if (secure) {
            if (this.detectionSettings.getSecureAlternateContentPage() != null) {
                output.println("document.location.replace(\"" + this.detectionSettings.getSecureAlternateContentPage() + "\");  // insert non-flash content");
            } else if (this.detectionSettings.getSecureAlternateContentInclude() != null) {
                output.println("document.location.replace(\"" + this.detectionSettings.getSecureAlternateContentInclude() + "\");  // insert non-flash content");
            } else {
                output.println("var alternateContent = 'This content requires Adobe Flash Player. <a href=" + goUrl + "/>Get Flash</a>';");
                output.println("document.write(alternateContent);  // insert non-flash content");
            }
        } else if (this.detectionSettings.getAlternateContentPage() != null) {
            output.println("document.location.replace(\"" + this.detectionSettings.getAlternateContentPage() + "\");  // insert non-flash content");
        } else if (this.detectionSettings.getAlternateContentInclude() != null) {
            output.println("document.write(\"" + this.detectionSettings.getAlternateContentInclude() + "\");  // insert non-flash content");
        } else {
            output.println("var alternateContent = 'This content requires Adobe Flash Player. <a href=" + goUrl + "/>Get Flash</a>';");
            output.println("document.write(alternateContent);  // insert non-flash content");
        }
        output.println("}");
        output.println("// -->");
        output.println("</script>");
    }

    private void renderSwfWithVersionCheckOnly(MxmlContext context, PrintWriter output) {
        String swf = this.getSwfWebPath(context);
        boolean secure = context.isSecureRequest();
        String goUrl = secure ? SECURE_GO_URL : GO_URL;
        output.println("<script language='JavaScript' type='text/javascript'>");
        output.println("<!--");
        output.println("// Version check based upon the values entered above in \"Globals\"");
        output.println("var hasRequestedVersion = DetectFlashVer(requiredMajorVersion, requiredMinorVersion, requiredRevision);");
        output.println("");
        output.println("// Check to see if the version meets the requirements for playback");
        output.println("if (hasRequestedVersion) {  // if we've detected an acceptable version");
        output.println("// if we've detected an acceptable version");
        output.println("// embed the Flash Content SWF when all tests are passed");
        this.runContentSnippet(context, output, swf);
        output.println("} else {  // flash is too old or we can't detect the plugin");
        if (secure) {
            if (this.detectionSettings.getSecureAlternateContentPage() != null) {
                output.println("document.location.replace(\"" + this.detectionSettings.getSecureAlternateContentPage() + "\");  // insert non-flash content");
            } else if (this.detectionSettings.getSecureAlternateContentInclude() != null) {
                output.println("document.location.replace(\"" + this.detectionSettings.getSecureAlternateContentInclude() + "\");  // insert non-flash content");
            } else {
                output.println("var alternateContent = 'This content requires Adobe Flash Player. <a href=" + goUrl + "/>Get Flash</a>';");
                output.println("document.write(alternateContent);  // insert non-flash content");
            }
        } else if (this.detectionSettings.getAlternateContentPage() != null) {
            output.println("document.location.replace(\"" + this.detectionSettings.getAlternateContentPage() + "\");  // insert non-flash content");
        } else if (this.detectionSettings.getAlternateContentInclude() != null) {
            output.println("document.write(\"" + this.detectionSettings.getAlternateContentInclude() + "\");  // insert non-flash content");
        } else {
            output.println("var alternateContent = 'This content requires Adobe Flash Player. <a href=" + goUrl + "/>Get Flash</a>';");
            output.println("document.write(alternateContent);  // insert non-flash content");
        }
        output.println("}");
        output.println("// -->");
        output.println("</script>");
    }

    private void runContentSnippet(MxmlContext context, PrintWriter output, String swf) {
        String application = this.getSwfId(context);
        String height = context.getHeight();
        String width = context.getWidth();
        String bgcolor = context.getBackgroundColor();
        String activexCodebaseUrl = this.getActivexCodebase(context.isSecureRequest());
        String pluginDownloadUrl = this.getPluginDownloadUrl(context.isSecureRequest());
        output.println("AC_FL_RunContent(");
        output.println("\"src\", \"" + swf + "\",");
        output.println("\"width\", \"" + width + "\",");
        output.println("\"height\", \"" + height + "\",");
        output.println("\"align\", \"middle\",");
        output.println("\"id\", \"" + application + "\",");
        output.println("\"quality\", \"high\",");
        output.println("\"bgcolor\", \"" + bgcolor + "\",");
        output.println("\"name\", \"" + application + "\",");
        output.println("\"allowScriptAccess\",\"sameDomain\",");
        output.println("\"flashvars\",\"" + this.getFlashVars(context, true) + "\",");
        output.println("\"type\", \"application/x-shockwave-flash\",");
        output.println("\"codebase\", \"" + activexCodebaseUrl + "\",");
        output.println("\"pluginspage\", \"" + pluginDownloadUrl + "\"");
        output.println(");");
    }

    public boolean enabled() {
        return this.detectionSettings.enabled();
    }
}

