/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flash.util.Trace;
import flex.webtier.server.j2ee.cache.CacheHelper;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.Configurator;
import flex.webtier.services.config.InvalidConfigurationException;
import flex.webtier.services.config.LoggingConfiguration;
import flex.webtier.services.extensions.ExtensionManager;
import flex.webtier.services.license.LicenseServiceImpl;
import flex.webtier.services.license.RuntimeDirectoryLoader;
import flex.webtier.services.logging.Logger;
import flex.webtier.services.logging.LoggerService;
import flex.webtier.services.logging.WebtierIntegratedLogger;
import flex.webtier.util.PathResolver;
import flex.webtier.util.ServletPathResolver;
import flex2.compiler.common.LocalFilePathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.URLPathResolver;
import java.beans.Introspector;
import java.io.File;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class J2EEServiceImpl
extends ServiceFactory {
    protected static J2EEServiceImpl services;
    protected static int NOT_STARTED;
    protected static int STARTED;
    protected static int FAILED;
    protected static int STOPPED;
    protected static int status;
    public ServletContext context;
    public ServletConfig config;
    private static int references;
    private Logger logger;
    private CacheHelper cacheHelper;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void init(HashMap properties) {
        if (!$assertionsDisabled && properties.get("ServletContext") == null) {
            throw new AssertionError((Object)"ServletContext must be specified.");
        }
        if (!$assertionsDisabled && !(properties.get("ServletContext") instanceof ServletContext)) {
            throw new AssertionError((Object)"ServletContext must be specified.");
        }
        this.context = (ServletContext)properties.get("ServletContext");
        this.config = (ServletConfig)properties.get("ServletConfig");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        block10: {
            try {
                ++references;
                if (status == NOT_STARTED) {
                    ServiceFactory.setLogger(LoggerService.createDefaultLogger());
                    this.setupToolkit();
                    try {
                        this.setupConfigurator();
                        this.setupMxmlSwfExtension();
                        this.setupLogger();
                        ServiceFactory.getConfigurator().logStoredWarnings();
                        this.setupLicenseService();
                        this.setupExtensionManager();
                        this.setupCacheHelper();
                    }
                    finally {
                        PathResolver.setThreadLocalPathResolver(null);
                        this.resetToolkit();
                    }
                    status = STARTED;
                    break block10;
                }
                if (status == FAILED) {
                    if (Trace.error) {
                        Trace.trace((String)"Invalid Configuration: see previous failures");
                        Thread.dumpStack();
                    }
                    throw new InvalidConfigurationException("Invalid Configuration: see previous failures.");
                }
            }
            catch (Exception e) {
                status = FAILED;
                if (Trace.error) {
                    e.printStackTrace();
                }
                throw e;
            }
        }
    }

    public synchronized void stop() {
        if (!$assertionsDisabled && references <= 0) {
            throw new AssertionError((Object)"References are being tracked incorrectly or services were stopped prematurely.");
        }
        if (!$assertionsDisabled && status == STOPPED) {
            throw new AssertionError((Object)"Services were stopped prematurely.");
        }
        if (status == STARTED && --references <= 0) {
            this.stopLogger();
            this.stopCacheHelper();
            ServiceFactory.destroy();
            Introspector.flushCaches();
            status = STOPPED;
        }
    }

    public void setupConfigurator() throws Exception {
        Configurator configurator = new Configurator();
        String flexDir = PathResolver.getThreadLocalPathResolver().getFlexReadPath();
        String fileName = this.getConfigurationFilename();
        long version = new File(fileName).lastModified();
        configurator.init(flexDir, fileName, version, this.context);
        ServiceFactory.setConfigurator(configurator);
    }

    private String getConfigurationFilename() throws Exception {
        File config;
        String p;
        PathResolver resolver = PathResolver.getThreadLocalPathResolver();
        String configPath = null;
        if (this.config != null && (p = this.config.getInitParameter("webtier.configuration.file")) != null) {
            configPath = p.trim();
        }
        if (configPath == null) {
            configPath = resolver.getFlexReadPath() + File.separator + "flex-webtier-config.xml";
        }
        if ((config = resolver.resolveFile(configPath, false)) == null) {
            throw new InvalidConfigurationException("configuration file, " + configPath + ", not found");
        }
        return config.getCanonicalPath();
    }

    private void setupMxmlSwfExtension() {
        String p;
        if (this.config != null && (p = this.config.getInitParameter("mxml.swf.extension")) != null && p.equalsIgnoreCase("false")) {
            ServiceFactory.setMxmlSwfExtension(false);
        }
    }

    protected void setupExtensionManager() {
        ServiceFactory.setExtensionManager(new ExtensionManager());
    }

    public void setupLicenseService() throws Exception {
        String flexDir = PathResolver.getThreadLocalPathResolver().getFlexReadPath();
        LicenseServiceImpl licenseService = new LicenseServiceImpl(new RuntimeDirectoryLoader(flexDir));
        licenseService.init();
        ServiceFactory.setLicenseService(licenseService);
    }

    public void setupLogger() throws Exception {
        LoggingConfiguration config = ServiceFactory.getConfigurator().getServerConfiguration().getLoggingConfiguration();
        this.logger = new LoggerService();
        this.logger.initializeLogger(config);
        ((LoggerService)this.logger).start();
        ServiceFactory.setLogger(this.logger);
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug("configuration service started.");
            this.logger.logDebug("logger services started.");
        }
    }

    public void stopLogger() {
        ((LoggerService)this.logger).stop();
    }

    public void setupCacheHelper() {
        this.cacheHelper = CacheHelper.getInstance(this.context);
        ServiceFactory.setCacheHelper(this.cacheHelper);
    }

    public void stopCacheHelper() {
        this.cacheHelper.stop();
    }

    private void setupToolkit() {
        PathResolver.setThreadLocalPathResolver(new ServletPathResolver(this.context));
        flex2.compiler.common.PathResolver resolver = new flex2.compiler.common.PathResolver();
        resolver.addSinglePathResolver((SinglePathResolver)new flex.webtier.server.j2ee.ServletPathResolver(this.context));
        resolver.addSinglePathResolver((SinglePathResolver)LocalFilePathResolver.getSingleton());
        resolver.addSinglePathResolver((SinglePathResolver)URLPathResolver.getSingleton());
        ThreadLocalToolkit.setPathResolver((flex2.compiler.common.PathResolver)resolver);
        LocalizationManager localizationManager = new LocalizationManager();
        localizationManager.addLocalizer((ILocalizer)new XLRLocalizer());
        localizationManager.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)localizationManager);
        ThreadLocalToolkit.setLogger((flex2.compiler.Logger)new WebtierIntegratedLogger());
    }

    private void resetToolkit() {
        ThreadLocalToolkit.setLogger(null);
        ThreadLocalToolkit.setLocalizationManager(null);
        ThreadLocalToolkit.setPathResolver(null);
    }

    static {
        $assertionsDisabled = !J2EEServiceImpl.class.desiredAssertionStatus();
        NOT_STARTED = 0;
        STARTED = 1;
        FAILED = 2;
        STOPPED = 3;
        status = NOT_STARTED;
    }
}

