/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services.config;

import flex.webtier.services.config.ConsoleConfiguration;
import flex.webtier.services.config.FileConfiguration;
import flex.webtier.util.PathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationValue;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LoggingConfiguration {
    private static boolean isCLR = System.getProperty("flex.platform.CLR") != null;
    private String logLevel = "info";
    private ConsoleConfiguration consoleConfiguration;
    private FileConfiguration fileConfiguration = new FileConfiguration();
    private boolean eventEnable;
    private String eventLogName;

    public LoggingConfiguration() {
        this.consoleConfiguration = new ConsoleConfiguration();
        if (isCLR) {
            this.setDefaultsCLR();
        } else {
            this.setDefaultsJava();
        }
    }

    private void setDefaultsCLR() {
        this.consoleConfiguration.setEnable(false);
        this.eventEnable = true;
        this.fileConfiguration.setEnable(false);
    }

    private void setDefaultsJava() {
        this.fileConfiguration.setFileName(PathResolver.getThreadLocalPathResolver().getFlexWritePath() + File.separator + "logs" + File.separator + "flex.log");
        this.consoleConfiguration.setEnable(true);
        this.fileConfiguration.setEnable(true);
        this.eventEnable = false;
    }

    public ConsoleConfiguration getConsoleConfiguration() {
        return this.consoleConfiguration;
    }

    public FileConfiguration getFileConfiguration() {
        return this.fileConfiguration;
    }

    public boolean isConsoleEnable() {
        return this.consoleConfiguration.isEnable();
    }

    public boolean isFileEnable() {
        return this.fileConfiguration.isEnable();
    }

    public String getFileName() {
        return this.fileConfiguration.getFileName();
    }

    public String getFileMaximumSize() {
        return this.fileConfiguration.getFileMaximumSize();
    }

    public int getFileMaximumBackups() {
        return this.fileConfiguration.getFileMaximumBackups();
    }

    public void cfgLevel(ConfigurationValue cv, String logLevel) throws ConfigurationException {
        if (!((logLevel = logLevel.trim().toLowerCase()).equals("error") || logLevel.equals("warn") || logLevel.equals("info") || logLevel.equals("debug"))) {
            throw new ConfigurationException("level must be one of error, warn, info, debug", cv.getSource(), cv.getLine());
        }
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isEventEnable() {
        return this.eventEnable;
    }

    public String getEventLogName() {
        return this.eventLogName;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("LoggingConfiguration:");
        pw.println("logLevel = " + this.logLevel);
        pw.println("consoleEnable = " + this.consoleConfiguration.isEnable());
        pw.println("fileEnable = " + this.fileConfiguration.isEnable());
        pw.println("fileName = " + this.fileConfiguration.getFileName());
        pw.println("fileMaximumSize = " + this.fileConfiguration.getFileMaximumSize());
        pw.println("fileMaximumBackups = " + this.fileConfiguration.getFileMaximumBackups());
        return sw.toString();
    }
}

