/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services.logging;

import flex.webtier.services.logging.LogEvent;
import flex.webtier.services.logging.LogEventHandler;
import flex.webtier.util.PropertiesUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Timer;
import java.util.TimerTask;

public class FileLogEventHandler
extends LogEventHandler {
    public static final String DEFAULT_FILENAME = "flex.log";
    public static final String DEFAULT_ROTATION_SIZE = "200k";
    public static final int DEFAULT_ROTATION_FILES = 3;
    public static final long DEFAULT_CLOSE_DELAY = 5000L;
    public static final int UNINITIALIZED = 0;
    public static final int STARTED = 1;
    public static final int STOPPED = 2;
    protected int status = 0;
    protected static String newline;
    protected static int newlineLen;
    protected long closeDelay = 5000L;
    protected long lastWriteTime;
    protected String currentFilename;
    protected PrintWriter out;
    private Timer timer;
    private String filename = "flex.log";
    private int rotationSize;
    private String rotationSizeString = "200k";
    private int rotationFiles = 3;
    private static String localizedDateFormat;
    private static final String _SERVER_DATE = "{server.date}";
    protected boolean scheduled = false;

    public FileLogEventHandler() {
        this.calculateRotationSize();
        this.timer = new Timer();
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getFileSize() {
        return new File(this.filename).length();
    }

    public void setRotationSize(String size) {
        this.rotationSizeString = size;
        this.calculateRotationSize();
    }

    public String getRotationSize() {
        return this.rotationSizeString;
    }

    public int getRotationSizeValue() {
        return this.rotationSize;
    }

    protected void calculateRotationSize() {
        String s = this.rotationSizeString;
        if (s == null) {
            s = DEFAULT_ROTATION_SIZE;
        }
        int multiplier = 1;
        int value = 200;
        if (s.endsWith("k") || s.endsWith("K")) {
            s = s.substring(0, s.length() - 1);
            multiplier = 1024;
        } else if (s.endsWith("m") || s.endsWith("M")) {
            s = s.substring(0, s.length() - 1);
            multiplier = 1024000;
        }
        try {
            value = Integer.parseInt(s);
        }
        catch (Exception ex) {
            multiplier = 1024;
        }
        this.rotationSize = value * multiplier;
    }

    public void setRotationFiles(int files) {
        this.rotationFiles = files;
    }

    public int getRotationFiles() {
        return this.rotationFiles;
    }

    public void setCloseDelay(long delay) {
        this.closeDelay = delay;
    }

    public long getCloseDelay() {
        return this.closeDelay;
    }

    public void start() {
        this.status = 1;
    }

    public synchronized void stop() {
        this.status = 2;
        this.timer.cancel();
        this.closeFile();
    }

    public synchronized boolean logEvent(LogEvent event) {
        block12: {
            if (this.status != 0 && this.status != 2) {
                String msg = event.getFormattedMessage(this.getFormat());
                this.checkForRotation(event, msg);
                if (this.out != null) {
                    try {
                        this.out.println(msg);
                        if (this.closeDelay <= 0L) {
                            this.closeFile();
                            break block12;
                        }
                        this.lastWriteTime = System.currentTimeMillis();
                        if (this.scheduled) break block12;
                        try {
                            this.timer.schedule((TimerTask)new CloseFileTask(), this.closeDelay);
                            this.scheduled = true;
                        }
                        catch (Exception ex) {
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                        try {
                            this.stop();
                        }
                        catch (Exception e) {}
                    }
                } else {
                    try {
                        this.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return true;
    }

    protected void checkForRotation(LogEvent event, String msg) {
        String newFilename = PropertiesUtil.expandDynamicVariables(this.getFilename(), event.getLogTime(), event.getVariables(this.getFormat()));
        if (!newFilename.equals(this.currentFilename)) {
            this.closeFile();
            this.out = this.openFile(newFilename);
        }
        if (this.getRotationSizeValue() > 0) {
            int insertLen = msg.length();
            boolean tooBig = false;
            try {
                long len = new File(this.currentFilename).length();
                if (len + (long)insertLen + (long)newlineLen > (long)this.getRotationSizeValue()) {
                    tooBig = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (tooBig) {
                this.removeFile(this.getRotationName(this.currentFilename, this.rotationFiles));
                for (int i = this.rotationFiles - 1; i > 0; --i) {
                    this.renameFile(this.getRotationName(this.currentFilename, i), this.getRotationName(this.currentFilename, i + 1));
                }
                this.closeFile();
                if (this.rotationFiles > 0) {
                    this.renameFile(this.currentFilename, this.getRotationName(this.currentFilename, 1));
                } else {
                    this.removeFile(this.currentFilename);
                }
                this.out = this.openFile(this.currentFilename);
            }
        }
        if (this.out == null) {
            this.out = this.openFile(this.currentFilename);
        }
    }

    protected void closeFile() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.out = null;
        }
    }

    protected PrintWriter openFile(String fname) {
        PrintWriter out = null;
        try {
            FileOutputStream fos = new FileOutputStream(fname, true);
            out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fos, "UTF8"), true);
            this.currentFilename = fname;
        }
        catch (FileNotFoundException ex) {
            File f = new File(fname);
            String parent = f.getParent();
            if (parent != null) {
                f = new File(parent);
                if (!f.exists() && f.mkdirs()) {
                    out = this.openFile(fname);
                } else {
                    ex.printStackTrace(System.err);
                }
            } else {
                ex.printStackTrace(System.err);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return out;
    }

    protected String getRotationName(String fullpath, int n) {
        int pos = 0;
        if (fullpath.lastIndexOf("/") != -1) {
            String filename = fullpath.substring(fullpath.lastIndexOf("/") + 1);
            if (filename.lastIndexOf(".") != -1) {
                pos = fullpath.lastIndexOf(".");
            }
        } else if (fullpath.lastIndexOf("\\") != -1) {
            String filename = fullpath.substring(fullpath.lastIndexOf("\\") + 1);
            if (filename.lastIndexOf(".") != -1) {
                pos = fullpath.lastIndexOf(".");
            }
        } else {
            pos = fullpath.lastIndexOf(".");
        }
        String name = pos > 0 ? fullpath.substring(0, pos) + "_" + n + fullpath.substring(pos) : fullpath + "_" + n;
        return name;
    }

    protected boolean removeFile(String name) {
        boolean rc = false;
        try {
            rc = new File(name).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    protected boolean renameFile(String name, String newName) {
        boolean rc = false;
        try {
            File newFile = new File(newName);
            rc = new File(name).renameTo(newFile);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return rc;
    }

    public static String expandServerDate(String formatString) {
        int dayPos = 0;
        int monthPos = 0;
        int index = 0;
        if (formatString != null && (index = formatString.indexOf(_SERVER_DATE)) == -1) {
            return formatString;
        }
        if (localizedDateFormat == null) {
            localizedDateFormat = new SimpleDateFormat().toPattern();
            dayPos = localizedDateFormat.indexOf(100);
            monthPos = localizedDateFormat.indexOf(77);
            String string = localizedDateFormat = monthPos < dayPos ? "{date MM/dd HH:mm:ss}" : "{date dd/MM HH:mm:ss}";
        }
        if (formatString == null) {
            return localizedDateFormat;
        }
        return formatString.substring(0, index) + localizedDateFormat + formatString.substring(index + _SERVER_DATE.length());
    }

    public synchronized void scheduleFileClose() {
        this.scheduled = false;
        if (this.out != null) {
            long now = System.currentTimeMillis();
            if (this.lastWriteTime + this.closeDelay <= now) {
                this.closeFile();
            } else {
                try {
                    long ms = this.lastWriteTime + this.closeDelay - now;
                    this.timer.schedule((TimerTask)new CloseFileTask(), ms);
                    this.scheduled = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static {
        localizedDateFormat = null;
        newline = System.getProperty("line.separator");
        if (newline != null) {
            newlineLen = newline.length();
        }
    }

    private class CloseFileTask
    extends TimerTask {
        private CloseFileTask() {
        }

        public void run() {
            FileLogEventHandler.this.scheduleFileClose();
        }
    }
}

