/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.Charset;

public final class Encoding {
    public final CFFByteArray data;
    public final int offset;
    private static final int[] standardEncoding = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 0, 111, 112, 113, 114, 0, 115, 116, 117, 118, 119, 120, 121, 122, 0, 123, 0, 124, 125, 126, 127, 128, 129, 130, 131, 0, 132, 133, 0, 134, 135, 136, 137, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 0, 139, 0, 0, 0, 0, 140, 141, 142, 143, 0, 0, 0, 0, 0, 144, 0, 0, 0, 145, 0, 0, 146, 147, 148, 149, 0, 0, 0, 0};
    private static final int[] expertEncoding = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 229, 230, 0, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 0, 253, 254, 255, 256, 257, 0, 0, 0, 258, 0, 0, 259, 260, 261, 262, 0, 0, 263, 264, 265, 0, 266, 109, 110, 267, 268, 269, 0, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 304, 305, 306, 0, 0, 307, 308, 309, 310, 311, 0, 312, 0, 0, 313, 0, 0, 314, 315, 0, 0, 316, 317, 318, 0, 0, 0, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 0, 0, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};

    Encoding(CFFByteArray cFFByteArray, int n) throws InvalidFontException {
        this.data = n < 2 ? null : cFFByteArray;
        this.offset = n;
    }

    public int charCode2gid(int n, Charset charset) throws InvalidFontException, UnsupportedFontException {
        int n2;
        int n3;
        int n4;
        if (this.data == null) {
            if (this.offset == 0) {
                return charset.sid2gid(standardEncoding[n]);
            }
            if (this.offset == 1) {
                return charset.sid2gid(expertEncoding[n]);
            }
            throw new InvalidFontException("invalid charset offset (" + this.offset + ")");
        }
        int n5 = this.offset;
        int n6 = this.data.getcard8(n5);
        ++n5;
        boolean bl = (n6 & 0x80) != 0;
        switch (n6 &= 0x7F) {
            case 0: {
                n4 = this.data.getcard8(n5++);
                for (n3 = 0; n3 < n4; ++n3) {
                    if ((n2 = this.data.getcard8(n5++)) != n) continue;
                    return n3;
                }
                break;
            }
            case 1: {
                n4 = this.data.getcard8(n5++);
                n3 = 1;
                while (n4 > 0) {
                    n2 = this.data.getcard8(n5++);
                    int n7 = this.data.getcard8(n5++);
                    if (n2 <= n && n <= n2 + n7) {
                        return n3 + (n - n2);
                    }
                    n3 += n7 + 1;
                }
                break;
            }
            default: {
                throw new UnsupportedFontException("CFF charset in format " + n6);
            }
        }
        if (bl) {
            n4 = this.data.getcard8(n5++);
            for (n3 = 0; n3 < n4; ++n3) {
                if ((n2 = this.data.getcard8(n5++)) == n) {
                    return charset.sid2gid(this.data.getcard16(n5));
                }
                n5 += 2;
            }
        }
        return 0;
    }
}

