/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.agl.converters.ByteToCharConverterICU;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public final class Name
extends Table {
    protected Name(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
    }

    protected String getCharset(int n, int n2) {
        if (n == 3) {
            switch (n2) {
                case 0: {
                    return "UTF-16BE";
                }
                case 1: {
                    return "UTF-16BE";
                }
                case 2: {
                    return "windows-932";
                }
                case 3: {
                    return "windows-936";
                }
                case 4: {
                    return "windows-950";
                }
                case 5: {
                    return "windows-949";
                }
                case 6: {
                    return "ms1361";
                }
                case 10: {
                    return "UTF-16BE";
                }
            }
            return null;
        }
        if (n == 1) {
            switch (n2) {
                case 0: {
                    return "MacRoman";
                }
                case 1: {
                    return "MacJapanese";
                }
                case 2: {
                    return "MacChineseTraditional";
                }
                case 3: {
                    return "MacKorean";
                }
                case 4: {
                    return "MacArabic";
                }
                case 5: {
                    return "MacHebrew";
                }
                case 6: {
                    return "MacGreek";
                }
                case 7: {
                    return "MacCyrillic";
                }
                case 8: {
                    return "MacSymbol";
                }
                case 9: {
                    return null;
                }
                case 10: {
                    return null;
                }
                case 11: {
                    return null;
                }
                case 12: {
                    return null;
                }
                case 13: {
                    return null;
                }
                case 14: {
                    return null;
                }
                case 15: {
                    return null;
                }
                case 16: {
                    return null;
                }
                case 17: {
                    return null;
                }
                case 18: {
                    return null;
                }
                case 19: {
                    return null;
                }
                case 20: {
                    return null;
                }
                case 21: {
                    return "MacThai";
                }
                case 22: {
                    return null;
                }
                case 23: {
                    return null;
                }
                case 24: {
                    return null;
                }
                case 25: {
                    return "MacChineseSimplified";
                }
                case 26: {
                    return null;
                }
                case 27: {
                    return null;
                }
                case 28: {
                    return null;
                }
                case 29: {
                    return null;
                }
                case 30: {
                    return null;
                }
                case 31: {
                    return null;
                }
            }
            return null;
        }
        if (n == 0) {
            return "UTF-16BE";
        }
        return null;
    }

    static String bytesToUnicode(byte[] byArray, int n, int n2, String string) throws InvalidFontException, UnsupportedEncodingException, MalformedInputException, UnknownCharacterException {
        int n3;
        ByteToCharConverterICU byteToCharConverterICU = new ByteToCharConverterICU(string);
        byteToCharConverterICU.setSubstitutionMode(false);
        int n4 = byteToCharConverterICU.getMaxCharsPerByte();
        char[] cArray = new char[n2 * n4];
        while (true) {
            try {
                n3 = byteToCharConverterICU.convert(byArray, n, n + n2, cArray, 0, cArray.length);
                byteToCharConverterICU.flush(cArray, 0, cArray.length);
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                byteToCharConverterICU.reset();
                cArray = new char[cArray.length * 2];
                continue;
            }
            break;
        }
        return new String(cArray, 0, n3);
    }

    public String getName(int n, int n2) throws InvalidFontException {
        try {
            return this.getName(3, 1, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getName(int n, int n2, int n3, int n4) throws InvalidFontException, UnsupportedEncodingException {
        String string = this.getCharset(n, n2);
        if (string == null) {
            throw new UnsupportedEncodingException();
        }
        int n5 = this.data.getuint16(2);
        int n6 = this.data.getuint16(4);
        for (int i = 0; i < n5; ++i) {
            try {
                if (this.data.getuint16(6 + 12 * i + 0) != n || this.data.getuint16(6 + 12 * i + 2) != n2 || this.data.getuint16(6 + 12 * i + 4) != n3 && -1 != n3 || this.data.getuint16(6 + 12 * i + 6) != n4) continue;
                int n7 = this.data.getuint16(6 + 12 * i + 8);
                int n8 = n6 + this.data.getuint16(6 + 12 * i + 10);
                return Name.bytesToUnicode(this.data.getBytes(n8, n7), 0, n7, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                continue;
            }
            catch (UnknownCharacterException unknownCharacterException) {
                continue;
            }
            catch (MalformedInputException malformedInputException) {
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasName(int n, int n2, int n3, int n4) throws InvalidFontException {
        int n5 = this.data.getuint16(2);
        for (int i = 0; i < n5; ++i) {
            if (this.data.getuint16(6 + 12 * i + 0) != n && -1 != n || this.data.getuint16(6 + 12 * i + 2) != n2 && -1 != n2 || this.data.getuint16(6 + 12 * i + 4) != n3 && -1 != n3 || this.data.getuint16(6 + 12 * i + 6) != n4 && -1 != n4) continue;
            return true;
        }
        return false;
    }

    private String lookForNames(NameSelector nameSelector, int n, int n2, int n3) throws UnsupportedFontException, InvalidFontException {
        for (int i = 0; i < n2; ++i) {
            String string;
            int n4 = this.data.getuint16(6 + 12 * i + 6);
            if (n4 != n || (string = this.getCharset(this.data.getuint16(6 + 12 * i + 0), this.data.getuint16(6 + 12 * i + 2))) == null) continue;
            int n5 = this.data.getuint16(6 + 12 * i + 8);
            int n6 = n3 + this.data.getuint16(6 + 12 * i + 10);
            try {
                String string2 = Name.bytesToUnicode(this.data.getBytes(n6, n5), 0, n5, string);
                if (!nameSelector.nameFound(string2, this.data.getuint16(6 + 12 * i + 0), this.data.getuint16(6 + 12 * i + 2), this.data.getuint16(6 + 12 * i + 4))) continue;
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                continue;
            }
            catch (UnknownCharacterException unknownCharacterException) {
                continue;
            }
            catch (MalformedInputException malformedInputException) {
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    private int pickFamilyNameSelector(int n) throws InvalidFontException {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = this.data.getuint16(6 + 12 * i + 6);
            if (n3 != 16) continue;
            n2 = 16;
            break;
        }
        return n2;
    }

    String getFirstName(int n) throws InvalidFontException, UnsupportedFontException {
        int n2 = this.data.getuint16(2);
        int n3 = this.data.getuint16(4);
        return this.lookForNames(new NameSelector(){

            public boolean nameFound(String string, int n, int n2, int n3) {
                return true;
            }
        }, n, n2, n3);
    }

    public Set getFamilyNames() throws InvalidFontException, UnsupportedFontException {
        int n = this.data.getuint16(2);
        int n2 = this.data.getuint16(4);
        NameSet nameSet = new NameSet();
        this.lookForNames(nameSet, 16, n, n2);
        this.lookForNames(nameSet, 1, n, n2);
        return nameSet.getSet();
    }

    public String getPreferredCSSFamilyName() throws InvalidFontException, UnsupportedFontException {
        int n = this.data.getuint16(2);
        int n2 = this.data.getuint16(4);
        CSSNameSelector cSSNameSelector = new CSSNameSelector();
        this.lookForNames(cSSNameSelector, 1, n, n2);
        return cSSNameSelector.getName();
    }

    public Set getPostscriptNames() throws InvalidFontException, UnsupportedFontException {
        int n = this.data.getuint16(2);
        int n2 = this.data.getuint16(4);
        NameSet nameSet = new NameSet();
        this.lookForNames(nameSet, 6, n, n2);
        return nameSet.getSet();
    }

    public int selectFamilyNameId() throws InvalidFontException {
        return this.pickFamilyNameSelector(this.data.getuint16(2));
    }

    public void enumerateNames(NameSelector nameSelector, int n) throws InvalidFontException, UnsupportedFontException {
        int n2 = this.data.getuint16(2);
        int n3 = this.data.getuint16(4);
        this.lookForNames(nameSelector, n, n2, n3);
    }

    public void subsetAndStream(Subset subset, Map map) throws UnsupportedFontException, InvalidFontException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.data.getuint16(2);
        int n5 = this.data.getuint16(4);
        for (n = 0; n < n4; ++n) {
            int n6 = this.data.getuint16(6 + 12 * n + 6);
            if (n6 != 0 && n6 != 7) continue;
            ++n2;
            n3 += this.data.getuint16(6 + 12 * n + 8);
        }
        n = 6 + 12 * n2;
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(n + n3);
        oTByteArrayBuilder.setuint32(0, 0);
        oTByteArrayBuilder.setuint16(2, n2);
        oTByteArrayBuilder.setuint16(4, n);
        int n7 = 6;
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            int n9 = this.data.getuint16(6 + 12 * i + 6);
            if (n9 != 0 && n9 != 7) continue;
            int n10 = this.data.getuint16(6 + 12 * i + 8);
            oTByteArrayBuilder.setuint16(n7, this.data.getuint16(6 + 12 * i));
            oTByteArrayBuilder.setuint16(n7 + 2, this.data.getuint16(6 + 12 * i + 2));
            oTByteArrayBuilder.setuint16(n7 + 4, this.data.getuint16(6 + 12 * i + 4));
            oTByteArrayBuilder.setuint16(n7 + 6, n9);
            oTByteArrayBuilder.setuint16(n7 + 8, n10);
            oTByteArrayBuilder.setuint16(n7 + 10, n8);
            n7 += 12;
            try {
                oTByteArrayBuilder.replace(n + n8, this.data, n5 + this.data.getuint16(6 + 12 * i + 10), n10);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InvalidFontException("string " + i + " in name table extends beyond the end of the table");
            }
            n8 += n10;
        }
        map.put(new Integer(1851878757), oTByteArrayBuilder);
    }

    private static class NameSet
    implements NameSelector {
        private Set set = new HashSet();

        NameSet() {
        }

        public boolean nameFound(String string, int n, int n2, int n3) {
            this.set.add(string);
            return false;
        }

        Set getSet() {
            return this.set;
        }
    }

    private static class CSSNameSelector
    implements NameSelector {
        private String currentSelection;
        int currentRanking = selectors.length;
        private static final int[][] selectors = new int[][]{{3, 1, 1033}, {3, 1, -1}, {1, 0, 0}};

        private CSSNameSelector() {
        }

        public boolean nameFound(String string, int n, int n2, int n3) throws InvalidFontException, UnsupportedFontException {
            for (int i = 0; i < selectors.length; ++i) {
                if (n != selectors[i][0] || n2 != selectors[i][1] || n3 != selectors[i][2] && selectors[i][2] != -1 || this.currentRanking <= i) continue;
                this.currentSelection = string;
                this.currentRanking = i;
                return false;
            }
            return false;
        }

        public String getName() {
            return this.currentSelection;
        }
    }

    static interface NameSelector {
        public boolean nameFound(String var1, int var2, int var3, int var4) throws InvalidFontException, UnsupportedFontException;
    }

    public static final class MacintoshEncodingId {
        public static final int ROMAN = 0;
        public static final int JAPANESE = 1;
        public static final int CHINESE_TRADITIONAL = 2;
        public static final int KOREAN = 3;
        public static final int ARABIC = 4;
        public static final int HEBREW = 5;
        public static final int GREEK = 6;
        public static final int RUSSIAN = 7;
        public static final int RSYMBOL = 8;
        public static final int DEVANAGARI = 9;
        public static final int GURMUKHI = 10;
        public static final int GUJARATI = 11;
        public static final int ORIYA = 12;
        public static final int BENGALI = 13;
        public static final int TAMIL = 14;
        public static final int TELUGU = 15;
        public static final int KANNADA = 16;
        public static final int MALAYALAM = 17;
        public static final int SINHALESE = 18;
        public static final int BURMESE = 19;
        public static final int KHMER = 20;
        public static final int THAI = 21;
        public static final int LAOTIAN = 22;
        public static final int GEORGIAN = 23;
        public static final int ARMENIAN = 24;
        public static final int CHINESE_SIMPLIFIED = 25;
        public static final int TIBETAN = 26;
        public static final int MONGOLIAN = 27;
        public static final int GEEZ = 28;
        public static final int SLAVIC = 29;
        public static final int VIETNAMESE = 30;
        public static final int SINDHI = 31;

        private MacintoshEncodingId() {
        }
    }

    public static final class MicrosoftLCID {
        public static final int ALBANIA = 1052;
        public static final int BASQUE = 1069;
        public static final int BYELORUSSIA = 1059;
        public static final int BULGARIA = 1026;
        public static final int CATALAN = 1027;
        public static final int CROATIAN = 1050;
        public static final int CZECH = 1029;
        public static final int DANISH = 1030;
        public static final int DUTCH = 1043;
        public static final int BELGIAN_FLEMISH = 2067;
        public static final int AMERICAN = 1033;
        public static final int BRITISH = 2057;
        public static final int AUSTRALIAN = 3081;
        public static final int CANADIAN = 4105;
        public static final int NEWZEALAND = 5129;
        public static final int IRELAND = 6153;
        public static final int ESTONIA = 1061;
        public static final int FINNISH = 1035;
        public static final int FRENCH = 1036;
        public static final int BELGIAN = 2060;
        public static final int CANADIAN_FRENCH = 3084;
        public static final int SWISS_FRENCH = 4108;
        public static final int LUXEMBOURG_FRENCH = 5132;
        public static final int GERMAN = 1031;
        public static final int SWISS_GERMAN = 2055;
        public static final int AUSTRIAN = 3079;
        public static final int LUXEMBOURG_GERMAN = 4103;
        public static final int LIECHTENSTEIN = 5127;
        public static final int GREEK = 1032;
        public static final int HUNGARIAN = 1038;
        public static final int ICELANDIC = 1039;
        public static final int ITALIAN = 1040;
        public static final int SWISS_ITALIAN = 2064;
        public static final int LATVIA = 1062;
        public static final int LITHUANIA = 1063;
        public static final int NORWEGIAN_BOKMAL = 1044;
        public static final int NORWEGIAN = 2068;
        public static final int POLISH = 1045;
        public static final int PORTUGUESE_BRAZILIAN = 1046;
        public static final int PORTUGUESE = 2070;
        public static final int ROMANIA = 1048;
        public static final int RUSSIAN = 1049;
        public static final int SLOVAK = 1051;
        public static final int SLOVENIA = 1060;
        public static final int SPANISH = 1034;
        public static final int MEXICAN = 2058;
        public static final int SPANISH_MODERN = 3082;
        public static final int SWEDISH = 1053;
        public static final int TURKISH = 1055;
        public static final int UKRAINE = 1058;
        public static final int CHINESE_PRC = 2052;
        public static final int CHINESE_SINGAPORE = 4100;
        public static final int CHINESE_TAIWAN = 1028;
        public static final int CHINESE_HONG_KONG_SAR = 3076;
        public static final int CHINESE_MACAO_SAR = 5124;
        public static final int JAPANESE = 1041;
        public static final int KOREAN = 1042;

        private MicrosoftLCID() {
        }
    }

    public static final class MicrosoftEncodingId {
        public static final int SYMBOL = 0;
        public static final int UTF16_BE_BMP_ONLY = 1;
        public static final int SHIFT_JIS = 2;
        public static final int PRC = 3;
        public static final int BIG5 = 4;
        public static final int WANSUNG = 5;
        public static final int JOHAB = 6;
        public static final int UTF16_BE_FULL = 10;

        private MicrosoftEncodingId() {
        }
    }

    public static final class PlatformId {
        public static final int UNICODE = 0;
        public static final int MACINTOSH = 1;
        public static final int MICROSOFT = 3;

        private PlatformId() {
        }
    }

    public static class PredefinedNames {
        public static final int COPYRIGHT_NOTICE = 0;
        public static final int FONT_FAMILY = 1;
        public static final int FONT_SUBFAMILY = 2;
        public static final int UNIQUE_FONT_IDENTIFIER = 3;
        public static final int FULL_FONT_NAME = 4;
        public static final int VERSION_STRING = 5;
        public static final int POSTSCRIPT_NAME = 6;
        public static final int TRADEMARK = 7;
        public static final int MANUFACTURER = 8;
        public static final int DESIGNER = 9;
        public static final int DESCRIPTION = 10;
        public static final int VENDOR_URL = 11;
        public static final int DESIGNER_URL = 12;
        public static final int LICENSE_DESCRIPTION = 13;
        public static final int LICENSE_URL = 14;
        public static final int PREFERRED_FAMILY = 16;
        public static final int PREFERRED_SUBFAMILY = 17;
        public static final int COMPATIBLE_FULL_NAME = 18;
        public static final int SAMPLE_TEXT = 19;
        public static final int POSTSCRIPT_CID_NAME = 20;

        private PredefinedNames() {
        }
    }
}

