/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class FallbackFontSet
implements Serializable {
    static final long serialVersionUID = 1L;
    private final HashMap fonts = new HashMap();

    public FallbackFontSet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FallbackFontSet(FallbackFontSet fallbackFontSet) {
        FallbackFontSet fallbackFontSet2 = fallbackFontSet;
        synchronized (fallbackFontSet2) {
            Iterator iterator = fallbackFontSet.fonts.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                ArrayList arrayList = new ArrayList();
                this.fonts.put(k, arrayList);
                Iterator iterator2 = ((List)fallbackFontSet.fonts.get(k)).iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(iterator2.next());
                }
            }
        }
    }

    public void addFallbackFonts(ULocale uLocale, Font[] fontArray) {
        for (int i = 0; i < fontArray.length; ++i) {
            this.addFallbackFont(uLocale, fontArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFallbackFont(ULocale uLocale, Font font) {
        FallbackFontSet fallbackFontSet = this;
        synchronized (fallbackFontSet) {
            ArrayList<Font> arrayList = (ArrayList<Font>)this.fonts.get(uLocale);
            if (arrayList == null) {
                arrayList = new ArrayList<Font>();
                this.fonts.put(uLocale, arrayList);
            }
            arrayList.add(font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFallbackFonts(ULocale uLocale) {
        FallbackFontSet fallbackFontSet = this;
        synchronized (fallbackFontSet) {
            return new FallbackFontIterator(uLocale);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof FallbackFontSet)) {
            return false;
        }
        return this.fonts.equals(((FallbackFontSet)object).fonts);
    }

    public int hashCode() {
        return this.fonts.hashCode();
    }

    public boolean isEmpty() {
        return this.fonts.isEmpty();
    }

    public boolean isEmpty(ULocale uLocale) {
        return this.fonts.containsKey(uLocale);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.fonts.keySet().iterator();
        while (iterator.hasNext()) {
            ULocale uLocale = (ULocale)iterator.next();
            stringBuffer.append(uLocale.getDisplayName());
            stringBuffer.append(": ");
            String string = "";
            Iterator iterator2 = ((List)this.fonts.get(uLocale)).iterator();
            while (iterator2.hasNext()) {
                Font font = (Font)iterator2.next();
                stringBuffer.append(string);
                try {
                    PostscriptFontDescription[] postscriptFontDescriptionArray = font.getPostscriptFontDescription();
                    stringBuffer.append("{");
                    String string2 = "";
                    for (int i = 0; i < postscriptFontDescriptionArray.length; ++i) {
                        stringBuffer.append(string2);
                        stringBuffer.append(postscriptFontDescriptionArray[i].toString());
                        string2 = ", ";
                    }
                    stringBuffer.append("}");
                }
                catch (FontException fontException) {
                    stringBuffer.append("<Error loading or interpreting font>");
                }
                stringBuffer.append(string);
                string = ", ";
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private final class FallbackFontIterator
    implements Iterator {
        private ULocale locale;
        private Iterator localeIt;

        public FallbackFontIterator(ULocale uLocale) {
            this.locale = uLocale;
            this.localeIt = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            FallbackFontIterator fallbackFontIterator = this;
            synchronized (fallbackFontIterator) {
                while (this.localeIt != null || this.locale != null) {
                    if (this.localeIt == null) {
                        List list = (List)FallbackFontSet.this.fonts.get(this.locale);
                        if (list != null) {
                            this.localeIt = list.iterator();
                        }
                        this.locale = this.locale.getFallback();
                        continue;
                    }
                    if (this.localeIt.hasNext()) {
                        return true;
                    }
                    this.localeIt = null;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() throws NoSuchElementException {
            FallbackFontIterator fallbackFontIterator = this;
            synchronized (fallbackFontIterator) {
                if (this.hasNext()) {
                    return this.localeIt.next();
                }
            }
            throw new NoSuchElementException();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("cannot remove elements from a FallbackFontIterator");
        }
    }
}

