/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.EventHandler;
import flex2.compiler.mxml.rep.LineNumberMapped;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.init.DynamicPropertyInitializer;
import flex2.compiler.mxml.rep.init.EffectInitializer;
import flex2.compiler.mxml.rep.init.EventInitializer;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.mxml.rep.init.StaticPropertyInitializer;
import flex2.compiler.mxml.rep.init.StyleInitializer;
import flex2.compiler.mxml.rep.init.ValueInitializer;
import flex2.compiler.util.IteratorList;
import flex2.compiler.util.NameFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.iterators.TransformIterator;

public class Model
implements LineNumberMapped {
    private Type type;
    private int xmlLineNumber;
    private String definitionName;
    private String id;
    private boolean idIsAutogenerated = false;
    private boolean isAnonymous = false;
    private MxmlDocument document;
    private Model parent;
    private String parentIndex;
    private boolean inspectable = false;
    private List repeaterParents;
    private Map properties;
    private Map styles;
    private Map effects;
    private Map events;
    private boolean described;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Model(MxmlDocument document, Type type, int line) {
        this(document, type, null, line);
    }

    public Model(MxmlDocument document, Type type, Model parent, int line) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        this.document = document;
        this.type = type;
        this.parent = parent;
        this.setXmlLineNumber(line);
        document.ensureId(this);
        this.setDefinitionName(this.getId());
    }

    public final boolean isDeclared() {
        return !this.isAnonymous && this.document.isDeclared(this);
    }

    public final Type getType() {
        return this.type;
    }

    public final String getDefinitionName() {
        return this.definitionName;
    }

    public final void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id, boolean idIsAutogenerated) {
        this.id = id;
        this.idIsAutogenerated = idIsAutogenerated;
    }

    public final boolean getIdIsAutogenerated() {
        return this.idIsAutogenerated;
    }

    public final boolean getIsAnonymous() {
        return this.isAnonymous;
    }

    public final void setIsAnonymous(boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public final MxmlDocument getDocument() {
        return this.document;
    }

    public final void setParent(Model parent) {
        this.parent = parent;
    }

    public final Model getParent() {
        return this.parent;
    }

    public final void setParentIndex(String index) {
        this.parentIndex = index;
    }

    public final void setParentIndex(int index) {
        this.parentIndex = Integer.toString(index);
    }

    public final String getParentIndex() {
        return this.parentIndex;
    }

    public final int getXmlLineNumber() {
        return this.xmlLineNumber;
    }

    public final void setXmlLineNumber(int xmlLineNumber) {
        this.xmlLineNumber = xmlLineNumber;
    }

    public final boolean getInspectable() {
        return this.inspectable;
    }

    public final void setInspectable(boolean inspectable) {
        this.inspectable = inspectable;
    }

    public final int getRepeaterLevel() {
        return this.getRepeaterParents().size();
    }

    public final List getRepeaterParents() {
        if (this.repeaterParents == null) {
            this.repeaterParents = new ArrayList();
            if (this.parent != null) {
                this.repeaterParents.addAll(this.parent.getRepeaterParents());
                if (StandardDefs.isRepeater(this.parent.getType())) {
                    this.repeaterParents.add(this.parent);
                }
            }
        }
        return this.repeaterParents;
    }

    public void setProperty(String name, Model value) {
        this.setProperty(name, (Object)value, value.getXmlLineNumber());
    }

    public void setProperty(Property property, Object value, int line) {
        StaticPropertyInitializer initializer = new StaticPropertyInitializer(property, value, line);
        (this.properties != null ? this.properties : (this.properties = new LinkedHashMap<String, StaticPropertyInitializer>())).put(property.getName(), initializer);
    }

    public void setDynamicProperty(Type type, String name, Object value, int line) {
        DynamicPropertyInitializer initializer = new DynamicPropertyInitializer(type, name, value, line);
        (this.properties != null ? this.properties : (this.properties = new LinkedHashMap<String, DynamicPropertyInitializer>())).put(name, initializer);
    }

    public void setProperty(String name, Object value, int line) {
        Property property = this.type.getProperty(name);
        if (property != null) {
            this.setProperty(property, value, line);
        } else {
            this.setDynamicProperty(this.type.getTypeTable().objectType, name, value, line);
        }
    }

    public final boolean hasProperty(String name) {
        return this.getProperties().containsKey(name);
    }

    public boolean hasBindings() {
        return this.bindingsOnly(this.getProperties().values().iterator()).hasNext() || this.bindingsOnly(this.getStyles().values().iterator()).hasNext() || this.bindingsOnly(this.getEffects().values().iterator()).hasNext();
    }

    public final Iterator getPropertyInitializerIterator() {
        return this.getPropertyInitializerIterator(true);
    }

    public final Iterator getPropertyInitializerIterator(boolean includeBindings) {
        return includeBindings ? this.getProperties().values().iterator() : this.excludeBindings(this.getProperties().values().iterator());
    }

    public boolean isEmpty() {
        return this.properties == null && this.styles == null && this.effects == null && this.events == null;
    }

    public final Map getProperties() {
        return this.properties != null ? this.properties : Collections.EMPTY_MAP;
    }

    public Object getProperty(String name) {
        ValueInitializer initializer = (ValueInitializer)this.getProperties().get(name);
        return initializer != null ? initializer.getValue() : null;
    }

    public final void setStyle(String name, Object value, int line) {
        Style style = this.type.getStyle(name);
        if (!$assertionsDisabled && style == null) {
            throw new AssertionError((Object)("style '" + name + "' not defined on type '" + this.type.getName() + "'"));
        }
        StyleInitializer styleInitializer = new StyleInitializer(style, value, line);
        (this.styles != null ? this.styles : (this.styles = new LinkedHashMap<String, StyleInitializer>())).put(name, styleInitializer);
    }

    public final Iterator getStyleInitializerIterator() {
        return this.excludeBindings(this.getStyles().values().iterator());
    }

    public final boolean hasStyle(String name) {
        return this.getStyles().containsKey(name);
    }

    private Map getStyles() {
        return this.styles != null ? this.styles : Collections.EMPTY_MAP;
    }

    public final void setEffect(String name, Object value, Type effectType, int line) {
        Effect effect = this.type.getEffect(name);
        if (!$assertionsDisabled && effect == null) {
            throw new AssertionError((Object)("effect '" + name + "' not defined on type '" + this.type.getName() + "'"));
        }
        EffectInitializer effectInitializer = new EffectInitializer(effect, value, effectType, line);
        (this.effects != null ? this.effects : (this.effects = new LinkedHashMap<String, EffectInitializer>())).put(name, effectInitializer);
    }

    public final Iterator getEffectInitializerIterator() {
        return this.excludeBindings(this.getEffects().values().iterator());
    }

    public final boolean hasEffect(String name) {
        return this.getEffects().containsKey(name);
    }

    private final Map getEffects() {
        return this.effects != null ? this.effects : Collections.EMPTY_MAP;
    }

    public String getEffectNames() {
        TransformIterator eventNameIter = new TransformIterator(this.getEffectInitializerIterator(), new Transformer(){

            public Object transform(Object object) {
                return TextGen.quoteWord(((EffectInitializer)object).getName());
            }
        });
        return TextGen.toCommaList((Iterator)eventNameIter);
    }

    public String getEffectEventNames() {
        TransformIterator eventNameIter = new TransformIterator(this.getEffectInitializerIterator(), new Transformer(){

            public Object transform(Object object) {
                return TextGen.quoteWord(((EffectInitializer)object).getEventName());
            }
        });
        return TextGen.toCommaList((Iterator)eventNameIter);
    }

    public Iterator getStyleAndEffectInitializerIterator() {
        return new IteratorChain(this.getStyleInitializerIterator(), this.getEffectInitializerIterator());
    }

    public final void setEvent(Event event, String text, int line) {
        this.document.addImport(NameFormatter.toDot(event.getType().getName()), line);
        EventHandler handler = new EventHandler(this, event, text);
        handler.setXmlLineNumber(line);
        EventInitializer eventInitializer = new EventInitializer(handler);
        (this.events != null ? this.events : (this.events = new LinkedHashMap<String, EventInitializer>())).put(event.getName(), eventInitializer);
    }

    public final Iterator getEventInitializerIterator() {
        return this.getEvents().values().iterator();
    }

    public final boolean hasEvent(String name) {
        return this.getEvents().containsKey(name);
    }

    private final Map getEvents() {
        return this.events != null ? this.events : Collections.EMPTY_MAP;
    }

    public Iterator getSubDefinitionsIterator() {
        IteratorList iterList = new IteratorList();
        Model.addDefinitionIterators(iterList, this.getPropertyInitializerIterator());
        Model.addDefinitionIterators(iterList, this.getStyleInitializerIterator());
        Model.addDefinitionIterators(iterList, this.getEffectInitializerIterator());
        Model.addDefinitionIterators(iterList, this.getEventInitializerIterator());
        return iterList.toIterator();
    }

    protected static void addDefinitionIterators(IteratorList iterList, Iterator initIter) {
        while (initIter.hasNext()) {
            iterList.add(((Initializer)initIter.next()).getDefinitionsIterator());
        }
    }

    protected Iterator excludeBindings(Iterator iter) {
        return this.bindingFilter(iter, false);
    }

    protected Iterator bindingsOnly(Iterator iter) {
        return this.bindingFilter(iter, true);
    }

    protected Iterator bindingFilter(Iterator iter, final boolean include) {
        return new FilterIterator(iter, new Predicate(){

            public boolean evaluate(Object object) {
                return ((Initializer)object).isBinding() == include;
            }
        });
    }

    public final void setDescribed(boolean described) {
        this.described = described;
    }

    public final boolean isDescribed() {
        return this.described;
    }

    static {
        $assertionsDisabled = !Model.class.desiredAssertionStatus();
    }
}

