/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep.init;

import flash.util.StringUtils;
import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.gen.DescriptorGenerator;
import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.Array;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.AtResource;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MovieClip;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.mxml.rep.XML;
import flex2.compiler.mxml.rep.XMLList;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.mxml.rep.init.NamedInitializer;
import flex2.compiler.mxml.rep.init.VisualChildInitializer;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.IteratorList;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.collections.iterators.SingletonIterator;

public abstract class ValueInitializer
implements Initializer {
    protected final Object value;
    protected final int line;
    static final /* synthetic */ boolean $assertionsDisabled;

    ValueInitializer(Object value, int line) {
        this.value = value;
        this.line = line;
    }

    public Object getValue() {
        return this.value;
    }

    public int getLineRef() {
        return this.line;
    }

    public boolean isBinding() {
        return this.value instanceof BindingExpression || this.value instanceof Primitive && ((Primitive)this.value).hasBindings();
    }

    public boolean hasDefinition() {
        if (this.value instanceof Model) {
            Model model = (Model)this.value;
            return model.isDeclared() || !this.modelHasInlineRValue() || this.isInstanceGeneratorOverDefinition();
        }
        if (!$assertionsDisabled && !this.isBinding() && StandardDefs.isInstanceGenerator(this.getLValueType())) {
            throw new AssertionError((Object)("instance generator lvalue has non-Model, non-BindingExpression rvalue (" + this.value.getClass() + ")"));
        }
        return false;
    }

    protected boolean isInstanceGeneratorOverDefinition() {
        Type ltype = this.getLValueType();
        return StandardDefs.isIFactory(ltype) || StandardDefs.isIDeferredInstance(ltype) && !this.rvalueIsClassRef();
    }

    protected boolean rvalueIsClassRef() {
        return this.value instanceof Primitive && ((Primitive)this.value).getType().equals(this.getTypeTable().classType);
    }

    public String getValueExpr() {
        Type lvalueType = this.getLValueType();
        if (StandardDefs.isIDeferredInstance(lvalueType)) {
            if (this.rvalueIsClassRef()) {
                return "new " + NameFormatter.toDot(StandardDefs.CLASS_DEFERREDINSTANCEFROMCLASS) + "(" + this.getInlineRValue() + ")";
            }
            return "new " + NameFormatter.toDot(StandardDefs.CLASS_DEFERREDINSTANCEFROMFUNCTION) + "(" + this.getDefinitionName() + ")";
        }
        return this.hasDefinition() ? this.getDefinitionName() + "()" : this.getInlineRValue();
    }

    protected boolean modelHasInlineRValue() {
        if (!$assertionsDisabled && !(this.value instanceof Model)) {
            throw new AssertionError();
        }
        Model model = (Model)this.value;
        return model instanceof XML || model instanceof XMLList || model instanceof Primitive || model instanceof Array || model.getType().equals(this.getTypeTable().objectType);
    }

    protected String getInlineRValue() {
        if (this.value instanceof Model) {
            if (this.value instanceof Primitive) {
                Primitive primitive = (Primitive)this.value;
                return this.formatExpr(primitive.getType(), primitive.getValue());
            }
            if (this.value instanceof Array) {
                return ValueInitializer.asArrayLiteral((Array)this.value);
            }
            if (this.value instanceof XML) {
                XML xml = (XML)this.value;
                return ValueInitializer.asXmlLiteral(xml);
            }
            if (this.value instanceof XMLList) {
                return ValueInitializer.asXMLList((XMLList)this.value);
            }
            if (((Model)this.value).getType().equals(this.getTypeTable().objectType)) {
                return ValueInitializer.asObjectLiteral((Model)this.value);
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("can't generate inline expr for values of type " + this.value.getClass()));
            }
            return null;
        }
        return this.formatExpr(this.getLValueType(), this.value);
    }

    protected String getDefinitionName() {
        if (!$assertionsDisabled && !this.hasDefinition()) {
            throw new AssertionError((Object)"no definition in getDefinitionName()");
        }
        if (!$assertionsDisabled && !(this.value instanceof Model)) {
            throw new AssertionError((Object)"non-Model value has definition in getDefinitionName()");
        }
        return ((Model)this.value).getDefinitionName() + (((Model)this.value).isDeclared() ? "_i" : "_c");
    }

    protected CodeFragmentList getDefinitionBody() {
        if (!$assertionsDisabled && !this.hasDefinition()) {
            throw new AssertionError((Object)"no definition in getDefinitionBody()");
        }
        if (!$assertionsDisabled && !(this.value instanceof Model)) {
            throw new AssertionError((Object)"non-Model value has definition in getDefinitionBody()");
        }
        String varName = "temp";
        Model self = (Model)this.value;
        Type selfType = self.getType();
        String selfTypeName = NameFormatter.toDot(selfType.getName());
        boolean isDeclared = self.isDeclared();
        String id = isDeclared ? self.getId() : "temp";
        int line = this.getLineRef();
        CodeFragmentList list = new CodeFragmentList();
        list.add("private function ", this.getDefinitionName(), "() : ", selfTypeName, line);
        list.add("{", line);
        if (this.modelHasInlineRValue()) {
            list.add("\tvar ", "temp", " : ", selfTypeName, " = " + this.getInlineRValue() + ";", line);
            if (isDeclared) {
                if (self.getRepeaterLevel() == 0) {
                    list.add("\t", id, " = ", "temp", ";", line);
                } else {
                    ThreadLocalToolkit.log((CompilerMessage)new DeclaredAndProceduralWithinRepeater(), self.getDocument().getSourcePath(), line);
                }
            }
        } else {
            list.add("\tvar ", "temp", " : ", selfTypeName, " = new " + selfTypeName + "();", line);
            if (isDeclared) {
                if (self.getRepeaterLevel() == 0) {
                    list.add("\t", id, " = ", "temp", ";", line);
                } else {
                    ThreadLocalToolkit.log((CompilerMessage)new DeclaredAndProceduralWithinRepeater(), self.getDocument().getSourcePath(), line);
                }
            }
            ValueInitializer.addAssignExprs(list, self.getPropertyInitializerIterator(self.getType().hasDynamic()), "temp");
        }
        ValueInitializer.addAssignExprs(list, self.getStyleInitializerIterator(), "temp");
        ValueInitializer.addAssignExprs(list, self.getEffectInitializerIterator(), "temp");
        ValueInitializer.addAssignExprs(list, self.getEventInitializerIterator(), "temp");
        String effectEventNames = self.getEffectNames();
        if (effectEventNames.length() > 0) {
            list.add("\t", "temp", ".registerEffects([ ", effectEventNames, " ]);", line);
        }
        if (isDeclared && StandardDefs.isIUIComponentWithIdProperty(selfType)) {
            list.add("\t", "temp", ".id = \"", id, "\";", line);
        }
        if (self.hasBindings()) {
            list.add("\t", NameFormatter.toDot(StandardDefs.CLASS_BINDINGMANAGER), ".executeBindings(this, ", TextGen.quoteWord(id), ", " + id + ");", line);
        }
        if (StandardDefs.isIUIComponent(selfType)) {
            if (!$assertionsDisabled && !(self instanceof MovieClip)) {
                throw new AssertionError((Object)"isIUIComponent(selfType) but !(self instanceof MovieClip)");
            }
            list.add("\tif (!", "temp", ".document) ", "temp", ".document = this;", line);
            if (!StandardDefs.isRepeater(selfType)) {
                ValueInitializer.addAssignExprs(list, ((MovieClip)self).getChildInitializerIterator(), "temp");
            } else {
                String docRef;
                list.add("\tvar cd:Array = ", "temp", ".childDescriptors = [", line);
                Iterator childIter = ((MovieClip)self).children().iterator();
                while (childIter.hasNext()) {
                    VisualChildInitializer init = (VisualChildInitializer)childIter.next();
                    DescriptorGenerator.addDescriptorInitializerFragments(list, (MovieClip)init.getValue(), "\t\t");
                    if (!childIter.hasNext()) continue;
                    list.add(",", 0);
                }
                list.add("\t];", line);
                list.add("\tfor (var i:int = 0; i < cd.length; i++) cd[i].document = this;", line);
                Model parent = self.getParent();
                if (parent != null && parent instanceof MovieClip && parent != self.getDocument().getRoot()) {
                    if (!$assertionsDisabled && !self.getParent().isDeclared()) {
                        throw new AssertionError((Object)"Visual non-root parent of repeater not declared");
                    }
                    docRef = parent.getId();
                } else {
                    docRef = "this";
                }
                list.add("\t", "temp", ".initializeRepeater(", docRef, ", true);", line);
            }
        }
        if (self.getType().isAssignableTo(StandardDefs.INTERFACE_IMXMLOBJECT)) {
            String idParam = isDeclared ? TextGen.quoteWord(id) : "null";
            list.add("\t", "temp", ".initialized(this, ", idParam, ")", line);
        }
        list.add("\treturn ", "temp", ";", line);
        list.add("}", line);
        return list;
    }

    public Iterator getDefinitionsIterator() {
        IteratorList iterList = null;
        if (!(!this.hasDefinition() || this.value instanceof Model && ((Model)this.value).isDescribed())) {
            iterList = new IteratorList();
            iterList.add((Iterator)new SingletonIterator((Object)this.getDefinitionBody()));
        }
        if (this.value instanceof Model) {
            (iterList != null ? iterList : (iterList = new IteratorList())).add(((Model)this.value).getSubDefinitionsIterator());
        }
        return iterList != null ? iterList.toIterator() : Collections.EMPTY_LIST.iterator();
    }

    private TypeTable getTypeTable() {
        return this.getLValueType().getTypeTable();
    }

    private static void addAssignExprs(CodeFragmentList list, Iterator initIter, String name) {
        while (initIter.hasNext()) {
            Initializer init = (Initializer)initIter.next();
            list.add("\t", init.getAssignExpr(name), ";", init.getLineRef());
        }
    }

    protected String formatExpr(Type targetType, Object value) {
        if (!$assertionsDisabled && targetType == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        TypeTable typeTable = this.getTypeTable();
        if (value instanceof BindingExpression) {
            if (targetType.equals(typeTable.booleanType) || targetType.equals(typeTable.numberType) || targetType.equals(typeTable.intType) || targetType.equals(typeTable.uintType)) {
                return "undefined";
            }
            return "null";
        }
        if (value instanceof AtEmbed) {
            return ((AtEmbed)value).getPropName();
        }
        if (value instanceof AtResource) {
            return ((AtResource)value).getValueExpression();
        }
        if (targetType.equals(typeTable.stringType)) {
            return StringUtils.formatString((String)((String)value));
        }
        if (targetType.equals(typeTable.booleanType) || targetType.equals(typeTable.numberType) || targetType.equals(typeTable.intType) || targetType.equals(typeTable.uintType)) {
            return value.toString();
        }
        if (targetType.equals(typeTable.objectType) || targetType.equals(typeTable.noType)) {
            if (value instanceof String) {
                return StringUtils.formatString((String)((String)value));
            }
            if (value instanceof Number || value instanceof Boolean) {
                return value.toString();
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("formatExpr: unsupported rvalue type '" + value.getClass() + "' for lvalue type 'Object'"));
            }
        } else {
            if (targetType.equals(typeTable.classType)) {
                return value.toString();
            }
            if (targetType.equals(typeTable.functionType)) {
                return value.toString();
            }
            if (targetType.equals(typeTable.regExpType)) {
                return value.toString();
            }
            if (targetType.equals(typeTable.xmlType)) {
                return ValueInitializer.asXmlLiteral((XML)value);
            }
            if (targetType.equals(typeTable.xmlListType)) {
                return ValueInitializer.asXMLList((XMLList)value);
            }
            if (StandardDefs.isInstanceGenerator(targetType)) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"formatExpr: instance generator lvalue with non-Model lvalue");
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("formatExpr: unsupported lvalue type: " + targetType.getName()));
            }
        }
        return null;
    }

    private static String asArrayLiteral(Array array) {
        ArrayList<String> elements = new ArrayList<String>();
        Iterator iter = array.getElementInitializerIterator();
        while (iter.hasNext()) {
            elements.add(((Initializer)iter.next()).getValueExpr());
        }
        return "[" + TextGen.toCommaList(elements.iterator()) + "]";
    }

    private static String asObjectLiteral(Model model) {
        ArrayList<String> pairs = new ArrayList<String>();
        Iterator iter = model.getPropertyInitializerIterator();
        while (iter.hasNext()) {
            NamedInitializer init = (NamedInitializer)iter.next();
            pairs.add(init.getName() + ": " + init.getValueExpr());
        }
        return "{" + TextGen.toCommaList(pairs.iterator()) + "}";
    }

    private static StringBuffer fixupXMLString(String orig) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < orig.length(); ++i) {
            if (orig.charAt(i) == '\r') continue;
            if (orig.charAt(i) == '\n') {
                result.append("\\n");
                continue;
            }
            if (orig.charAt(i) == '\"') {
                result.append('\\');
            }
            result.append(orig.charAt(i));
        }
        return result;
    }

    private static String asXmlLiteral(XML component) {
        String xml = component.getLiteralXML();
        if (component.getIsE4X()) {
            return xml;
        }
        StringBuffer buf = new StringBuffer(NameFormatter.toDot(StandardDefs.CLASS_XMLUTIL) + ".createXMLDocument(\"");
        buf.append(ValueInitializer.fixupXMLString(xml).toString());
        buf.append("\").firstChild");
        return buf.toString();
    }

    private static String asXMLList(XMLList component) {
        StringBuffer buf = new StringBuffer("<>");
        buf.append(component.getLiteralXML());
        buf.append("</>");
        return buf.toString();
    }

    static {
        $assertionsDisabled = !ValueInitializer.class.desiredAssertionStatus();
    }

    public static class DeclaredAndProceduralWithinRepeater
    extends CompilerMessage.CompilerError {
    }
}

