/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flex2.compiler.io.FileUtil;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipOutputStream;
import flex2.compiler.util.MimeMappings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SwcWriteOnlyArchive
implements SwcArchive {
    protected final OutputStream out;
    protected final String name;
    protected Map files = new HashMap();

    public SwcWriteOnlyArchive(String name, OutputStream out) {
        this.out = out;
        this.name = name;
    }

    public String getLocation() {
        return this.name;
    }

    public void load() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws Exception {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(this.out);
            Iterator it = this.files.values().iterator();
            while (it.hasNext()) {
                VirtualFile f = (VirtualFile)it.next();
                ZipEntry entry = new ZipEntry(f.getName());
                entry.setTime(f.getLastModified());
                zos.putNextEntry(entry);
                BufferedInputStream in = new BufferedInputStream(f.getInputStream());
                FileUtil.streamOutput(in, zos);
                zos.closeEntry();
            }
            zos.flush();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (zos != null) {
                zos.close();
            }
        }
        catch (IOException ioe) {}
    }

    public void close() {
    }

    public Map getFiles() {
        return this.files;
    }

    public VirtualFile getFile(String path) {
        return (VirtualFile)this.files.get(path);
    }

    public void putFile(VirtualFile file) {
        this.files.put(file.getName(), file);
    }

    public void putFile(String path, byte[] data, long lastModified) {
        InMemoryFile file = new InMemoryFile(data, path, MimeMappings.getMimeType(path), lastModified);
        this.files.put(file.getName(), file);
    }

    public long getLastModified() {
        return 0L;
    }
}

