/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SoftRefHashMap
implements Map {
    private Map hashMap = new HashMap();

    public void purge() {
        Map map = this.getMap();
        Set keys = map.keySet();
        if (keys == null) {
            return;
        }
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Reference ref = (Reference)map.get(key);
            if (ref.get() != null) continue;
            i.remove();
        }
    }

    public Object get(Object key) {
        Reference ref = (Reference)this.getMap().get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public Object put(Object key, Object value) {
        Reference answer = this.getMap().put(key, this.createReference(value));
        if (answer != null) {
            return answer.get();
        }
        return null;
    }

    public Collection values() {
        Set wrappedValues = (Set)this.getMap().values();
        TreeSet values = new TreeSet();
        if (wrappedValues == null) {
            return values;
        }
        Iterator i = wrappedValues.iterator();
        while (i.hasNext()) {
            Reference ref = (Reference)i.next();
            if (ref == null) continue;
            values.add(ref.get());
        }
        return values;
    }

    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    public boolean containsValue(Object value) {
        Collection values = this.getMap().values();
        if (values == null) {
            return false;
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Object target;
            Reference ref = (Reference)i.next();
            if (ref == null || (target = ref.get()) != value) continue;
            return true;
        }
        return false;
    }

    public void putAll(Map map) {
        if (map == null || map.size() == 0) {
            return;
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.put(key, map.get(key));
        }
    }

    public Set entrySet() {
        HashSet<Entry> entries = new HashSet<Entry>();
        if (this.size() == 0) {
            return entries;
        }
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = this.get(key);
            Entry entry = new Entry(key, value);
            entries.add(entry);
        }
        return entries;
    }

    public Object remove(Object key) {
        Reference ref = (Reference)this.getMap().remove(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public void clear() {
        this.getMap().clear();
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public Set keySet() {
        return this.getMap().keySet();
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public boolean equals(Object object) {
        return this.getMap().equals(object);
    }

    public int size() {
        return this.getMap().size();
    }

    protected Reference createReference(Object referent) {
        return new SoftReference<Object>(referent);
    }

    protected Map getMap() {
        return this.hashMap;
    }

    class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            this.value = value;
            SoftRefHashMap.this.put(this.key, value);
            return value;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

