/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;

public abstract class AbstractSVGList {
    protected boolean valid;
    protected List itemList;

    protected abstract String getItemSeparator();

    protected abstract SVGItem createSVGItem(Object var1);

    protected abstract void doParse(String var1, ListHandler var2) throws ParseException;

    protected abstract void checkItemType(Object var1) throws SVGException;

    protected abstract String getValueAsString();

    protected abstract void setAttributeValue(String var1);

    protected abstract DOMException createDOMException(short var1, String var2, Object[] var3);

    protected AbstractSVGList() {
    }

    public int getNumberOfItems() {
        this.revalidate();
        if (this.itemList != null) {
            return this.itemList.size();
        }
        return 0;
    }

    public void clear() throws DOMException {
        this.revalidate();
        if (this.itemList != null) {
            this.clear(this.itemList);
            this.resetAttribute();
        }
    }

    protected SVGItem initializeImpl(Object newItem) throws DOMException, SVGException {
        this.checkItemType(newItem);
        if (this.itemList == null) {
            this.itemList = new ArrayList(1);
        } else {
            this.clear(this.itemList);
        }
        SVGItem item = this.removeIfNeeded(newItem);
        this.itemList.add(item);
        item.setParent(this);
        this.resetAttribute();
        return item;
    }

    protected SVGItem getItemImpl(int index) throws DOMException {
        this.revalidate();
        if (index < 0 || this.itemList == null || index >= this.itemList.size()) {
            throw this.createDOMException((short)1, "AbstractSVGList.getItem.OutOfBoundsException", null);
        }
        return (SVGItem)this.itemList.get(index);
    }

    protected SVGItem insertItemBeforeImpl(Object newItem, int index) throws DOMException, SVGException {
        this.checkItemType(newItem);
        this.revalidate();
        if (index < 0) {
            throw this.createDOMException((short)1, "AbstractSVGList.insertItemBefore.OutOfBoundsException", null);
        }
        if (index > this.itemList.size()) {
            index = this.itemList.size();
        }
        SVGItem item = this.removeIfNeeded(newItem);
        this.itemList.add(index, item);
        item.setParent(this);
        this.resetAttribute();
        return item;
    }

    protected SVGItem replaceItemImpl(Object newItem, int index) throws DOMException, SVGException {
        this.checkItemType(newItem);
        this.revalidate();
        if (index < 0 || index >= this.itemList.size()) {
            throw this.createDOMException((short)1, "AbstractSVGList.replaceItem.OutOfBoundsException", null);
        }
        SVGItem item = this.removeIfNeeded(newItem);
        this.itemList.set(index, item);
        item.setParent(this);
        this.resetAttribute();
        return item;
    }

    protected SVGItem removeItemImpl(int index) throws DOMException {
        this.revalidate();
        if (index < 0 || index >= this.itemList.size()) {
            throw this.createDOMException((short)1, "AbstractSVGList.removeItem.OutOfBoundsException", null);
        }
        SVGItem item = (SVGItem)this.itemList.remove(index);
        item.setParent(null);
        this.resetAttribute();
        return item;
    }

    protected SVGItem appendItemImpl(Object newItem) throws DOMException, SVGException {
        this.checkItemType(newItem);
        this.revalidate();
        SVGItem item = this.removeIfNeeded(newItem);
        this.itemList.add(item);
        item.setParent(this);
        if (this.itemList.size() <= 1) {
            this.resetAttribute();
        } else {
            this.resetAttribute(item);
        }
        return item;
    }

    protected SVGItem removeIfNeeded(Object newItem) {
        SVGItem item = null;
        if (newItem instanceof SVGItem) {
            item = (SVGItem)newItem;
            if (item.getParent() != null) {
                item.getParent().removeItem(item);
            }
        } else {
            item = this.createSVGItem(newItem);
        }
        return item;
    }

    protected void revalidate() {
        if (this.valid) {
            return;
        }
        try {
            ListBuilder builder = new ListBuilder();
            this.doParse(this.getValueAsString(), builder);
            if (builder.getList() != null) {
                this.clear(this.itemList);
            }
            this.itemList = builder.getList();
        }
        catch (ParseException e) {
            this.itemList = null;
        }
        this.valid = true;
    }

    protected void setValueAsString(List value) throws DOMException {
        StringBuffer buf = null;
        Iterator it = value.iterator();
        while (it.hasNext()) {
            SVGItem item = (SVGItem)it.next();
            if (buf == null) {
                buf = new StringBuffer(item.getValueAsString());
                continue;
            }
            buf.append(this.getItemSeparator());
            buf.append(item.getValueAsString());
        }
        String finalValue = null;
        finalValue = buf == null ? null : buf.toString();
        this.setAttributeValue(finalValue);
        this.valid = true;
    }

    public void itemChanged() {
        this.resetAttribute();
    }

    protected void resetAttribute() {
        this.setValueAsString(this.itemList);
    }

    protected void resetAttribute(SVGItem item) {
        StringBuffer buf = new StringBuffer(this.getValueAsString());
        buf.append(this.getItemSeparator());
        buf.append(item.getValueAsString());
        this.setAttributeValue(buf.toString());
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
    }

    protected void removeItem(SVGItem item) {
        if (this.itemList.contains(item)) {
            this.itemList.remove(item);
            item.setParent(null);
            this.resetAttribute();
        }
    }

    protected void clear(List list) {
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            SVGItem item = (SVGItem)it.next();
            item.setParent(null);
        }
        list.clear();
    }

    protected class ListBuilder
    implements ListHandler {
        protected List list;

        public List getList() {
            return this.list;
        }

        public void startList() {
            if (this.list == null) {
                this.list = new ArrayList();
            }
        }

        public void item(SVGItem item) {
            item.setParent(AbstractSVGList.this);
            this.list.add(item);
        }

        public void endList() {
        }
    }
}

