/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.converters;

import com.adobe.agl.converters.UErrorCode;
import com.adobe.agl.impl.AliasesEnumeration;
import com.adobe.agl.impl.UConverterAlias;
import com.adobe.agl.impl.UConverterFromUnicodeArgs;
import com.adobe.agl.impl.UConverterLoadArgs;
import com.adobe.agl.impl.UConverterSharedData;
import com.adobe.agl.impl.UConverterToUnicodeArgs;
import com.adobe.agl.impl.UConverterUTF16;
import com.adobe.agl.impl.UConverterUtility;
import com.adobe.agl.impl.UDataMemory;
import java.nio.ByteBuffer;

public class UConverter {
    public static final int U_IS_BIG_ENDIAN = 0;
    public static final int ULOC_FULLNAME_CAPACITY = 56;
    public static final int U_SENTINEL = -1;
    public static final int UCNV_MAX_CONVERTER_NAME_LENGTH = 60;
    public static final int UCNV_MAX_FULL_FILE_NAME_LENGTH = 660;
    public static final int UCNV_SI = 15;
    public static final int UCNV_SO = 14;
    public static final int UCNV_ERROR_BUFFER_LENGTH = 32;
    public static final int UCNV_MAX_SUBCHAR_LEN = 4;
    public static final int UCNV_MAX_CHAR_LEN = 8;
    public static final int UCNV_OPTION_VERSION = 15;
    public static final int UCNV_OPTION_SWAP_LFNL = 16;
    public static final int UCNV_OPTION_MAC = 32;
    public static final int UCNV_HAS_SUPPLEMENTARY = 1;
    public static final int UCNV_HAS_SURROGATES = 2;
    public static final int missingCharMarker = 65535;
    public static final int U16_MAX_LENGTH = 2;
    static final byte UCNV_OPTION_SEP_CHAR = 44;
    public UConverterFromUCallback fromUCharErrorBehaviour;
    public UConverterToUCallback fromCharErrorBehaviour;
    public Object extraInfo;
    public byte[] fromUContextArray;
    public byte[] toUContextArray;
    public UConverterSharedData sharedData;
    public long options;
    public boolean sharedDataIsCached;
    public boolean isCopyLocal;
    public boolean isExtraLocal;
    public boolean useFallback;
    public byte toULength;
    public byte[] toUBytesArray = new byte[7];
    public int toUBytesBegin;
    public long toUnicodeStatus;
    public int mode;
    public long fromUnicodeStatus;
    public int fromUChar32;
    public byte maxBytesPerUChar;
    public byte subCharLen;
    public byte invalidCharLength;
    public byte charErrorBufferLength;
    public byte invalidUCharLength;
    public byte UCharErrorBufferLength;
    public byte subChar1;
    public boolean useSubChar1;
    public byte[] subCharArray = new byte[4];
    public int subCharBegin;
    public byte[] invalidCharBufferArray = new byte[8];
    public int invalidCharBufferBegin;
    public byte[] charErrorBufferArray = new byte[32];
    public int charErrorBufferBegin;
    public char[] invalidUCharBufferArray = new char[2];
    public int invalidUCharBufferBegin;
    public char[] UCharErrorBufferArray = new char[32];
    public int UCharErrorBufferBegin;
    public int preFromUFirstCP;
    public char[] preFromUArray = new char[19];
    public int preFromUBegin;
    public byte[] preToUArray = new byte[31];
    public int preToUBegin;
    public byte preFromULength;
    public byte preToULength;
    public byte preToUFirstLength;
    public static byte[] UCNV_SUB_STOP_ON_ILLEGAL = new byte[]{105};
    public static byte[] UCNV_SKIP_STOP_ON_ILLEGAL = new byte[]{105};

    public static final boolean TO_U_USE_FALLBACK(boolean useFallback) {
        return true;
    }

    public static final boolean UCNV_TO_U_USE_FALLBACK(UConverter cnv) {
        return true;
    }

    public static final boolean IS_PRIVATE_USE(int c) {
        return c - 57344 < 6400 || c - 983040 < 131072;
    }

    public static final boolean FROM_U_USE_FALLBACK(boolean useFallback, int c) {
        return useFallback || UConverter.IS_PRIVATE_USE(c);
    }

    public static final boolean UCNV_FROM_U_USE_FALLBACK(UConverter cnv, int c) {
        return UConverter.FROM_U_USE_FALLBACK(cnv.useFallback, c);
    }

    public static final UConverter ucnv_open(String name, int[] err) {
        if (err == null || UErrorCode.U_FAILURE(err[0])) {
            return null;
        }
        UConverter r = UConverter.ucnv_createConverter(null, name, err);
        return r;
    }

    static UConverter ucnv_createConverter(UConverter myUConverter, String converterName, int[] err) {
        UConverterLookupData stackLookup = new UConverterLookupData();
        if (UErrorCode.U_SUCCESS(err[0])) {
            UConverterSharedData mySharedConverterData = UConverter.ucnv_loadSharedData(converterName, stackLookup, err);
            if (UErrorCode.U_SUCCESS(err[0])) {
                myUConverter = UConverter.ucnv_createConverterFromSharedData(myUConverter, mySharedConverterData, stackLookup.realName, stackLookup.locale.toString(), stackLookup.options, err);
                if (UErrorCode.U_SUCCESS(err[0])) {
                    return myUConverter;
                }
                UConverter.ucnv_unloadSharedDataIfReady(mySharedConverterData);
            }
        }
        return null;
    }

    public static final UConverterSharedData ucnv_loadSharedData(String converterName, UConverterLookupData lookup, int[] err) {
        UConverterLookupData stackLookup = new UConverterLookupData();
        UConverterSharedData mySharedConverterData = null;
        int[] internalErrorCode = new int[]{0};
        long[] pFlags = new long[1];
        if (UErrorCode.U_FAILURE(err[0])) {
            return null;
        }
        if (lookup == null) {
            lookup = stackLookup;
        }
        lookup.locale.delete(0, lookup.locale.length());
        lookup.options = 0L;
        if (converterName == null) {
            lookup.realName = UConverterAlias.ucnv_io_getDefaultConverterName();
            if (lookup.realName == null) {
                err[0] = 2;
                return null;
            }
        } else {
            pFlags[0] = lookup.options;
            UConverter.parseConverterOptions(converterName, lookup.cnvName, lookup.locale, pFlags, err);
            lookup.options = pFlags[0];
            if (UErrorCode.U_FAILURE(err[0])) {
                return null;
            }
            lookup.realName = UConverterAlias.ucnv_io_getConverterName(lookup.cnvName.toString(), internalErrorCode);
            if (UErrorCode.U_FAILURE(internalErrorCode[0]) || lookup.realName == null) {
                lookup.realName = lookup.cnvName.toString();
            }
        }
        if (!lookup.realName.contentEquals(lookup.cnvName)) {
            pFlags[0] = lookup.options;
            UConverter.parseConverterOptions(lookup.realName, lookup.cnvName, lookup.locale, pFlags, err);
            lookup.options = pFlags[0];
            lookup.realName = new String(lookup.cnvName);
        }
        if ((mySharedConverterData = UConverterSharedData.getAlgorithmicTypeFromName(lookup.realName)) == null) {
            UConverterLoadArgs args = new UConverterLoadArgs();
            args.nestedLoads = 1;
            args.options = lookup.options;
            args.pkg = null;
            args.name = lookup.realName;
            mySharedConverterData = UConverterSharedData.ucnv_load(args, err);
            if (UErrorCode.U_FAILURE(err[0]) || mySharedConverterData == null) {
                return null;
            }
        }
        return mySharedConverterData;
    }

    public static final UConverter ucnv_createConverterFromSharedData(UConverter myUConverter, UConverterSharedData mySharedConverterData, String realName, String locale, long options, int[] err) {
        boolean isCopyLocal;
        if (myUConverter == null) {
            myUConverter = new UConverter();
            if (myUConverter == null) {
                err[0] = 7;
                return null;
            }
            isCopyLocal = false;
        } else {
            isCopyLocal = true;
        }
        myUConverter.isCopyLocal = isCopyLocal;
        myUConverter.isExtraLocal = false;
        myUConverter.sharedData = mySharedConverterData;
        myUConverter.options = options;
        myUConverter.fromCharErrorBehaviour = new UCNV_TO_U_CALLBACK_SUBSTITUTE();
        myUConverter.fromUCharErrorBehaviour = new UCNV_FROM_U_CALLBACK_SUBSTITUTE();
        myUConverter.toUnicodeStatus = myUConverter.sharedData.toUnicodeStatus;
        myUConverter.maxBytesPerUChar = myUConverter.sharedData.staticData.maxBytesPerChar;
        myUConverter.subChar1 = myUConverter.sharedData.staticData.subChar1;
        myUConverter.subCharLen = myUConverter.sharedData.staticData.subCharLen;
        UConverterUtility.uprv_memcpy(myUConverter.subCharArray, myUConverter.subCharBegin, myUConverter.sharedData.staticData.subChar, 0, (int)myUConverter.subCharLen);
        myUConverter.preFromUFirstCP = -1;
        if (myUConverter != null) {
            myUConverter.sharedData.open(myUConverter, realName, locale, options, err);
            if (UErrorCode.U_FAILURE(err[0])) {
                myUConverter.ucnv_close();
                return null;
            }
        }
        return myUConverter;
    }

    public static final String ucnv_getName(UConverter converter, int[] err) {
        if (UErrorCode.U_FAILURE(err[0])) {
            return null;
        }
        String temp = converter.sharedData.getName(converter);
        if (temp != null) {
            return temp;
        }
        return converter.sharedData.staticData.name;
    }

    static void parseConverterOptions(String inName, StringBuffer cnvName, StringBuffer locale, long[] pFlags, int[] err) {
        char c;
        long len = 0L;
        int inNameIndex = 0;
        boolean cnvNameIndex = false;
        inName = inName.concat("\u0000");
        cnvName.delete(0, cnvName.length());
        locale.delete(0, locale.length());
        while ((c = inName.charAt(inNameIndex)) != '\u0000' && c != ',') {
            if (++len >= 60L) {
                err[0] = 1;
                return;
            }
            cnvName.append(c);
            ++inNameIndex;
        }
        while ((c = inName.charAt(inNameIndex)) != '\u0000') {
            if (c == ',') {
                ++inNameIndex;
            }
            if (UConverterUtility.uprv_strncmp(inName.getBytes(), inNameIndex, "locale=", 7) == 0) {
                StringBuffer dest = locale;
                inNameIndex += 7;
                len = 0L;
                while ((c = inName.charAt(inNameIndex)) != '\u0000' && c != ',') {
                    ++inNameIndex;
                    if (++len >= 56L) {
                        err[0] = 1;
                        locale.delete(0, locale.length());
                        return;
                    }
                    dest.append(c);
                }
                continue;
            }
            if (UConverterUtility.uprv_strncmp(inName.getBytes(), inNameIndex, "version=", 8) == 0) {
                c = inName.charAt(inNameIndex += 8);
                if (c == '\u0000') {
                    pFlags[0] = pFlags[0] & 0xFFFFFFFFFFFFFFF0L;
                    return;
                }
                if (c - 48 >= 10 || c - 48 < 0) continue;
                pFlags[0] = pFlags[0] & 0xFFFFFFFFFFFFFFF0L | (long)(c - 48);
                ++inNameIndex;
                continue;
            }
            if (UConverterUtility.uprv_strncmp(inName.getBytes(), inNameIndex, "swaplfnl", 8) == 0) {
                inNameIndex += 8;
                pFlags[0] = pFlags[0] | 0x10L;
                continue;
            }
            if (UConverterUtility.uprv_strncmp(inName.getBytes(), inNameIndex, "mac", 3) == 0) {
                inNameIndex += 3;
                pFlags[0] = pFlags[0] | 0x20L;
                continue;
            }
            while ((c = inName.charAt(inNameIndex++)) != '\u0000' && c != ',') {
            }
            if (c != '\u0000') continue;
            return;
        }
    }

    public static final void ucnv_unloadSharedDataIfReady(UConverterSharedData sharedData) {
        if (sharedData != null && sharedData.referenceCounter != -1) {
            UConverter.ucnv_unload(sharedData);
        }
    }

    static final void ucnv_unload(UConverterSharedData sharedData) {
        if (sharedData != null) {
            if (sharedData.referenceCounter > 0) {
                --sharedData.referenceCounter;
            }
            if (sharedData.referenceCounter > 0 || !sharedData.sharedDataCached) {
                // empty if block
            }
        }
    }

    public final void ucnv_close() {
        UConverterToUnicodeArgs toUArgs = new UConverterToUnicodeArgs(true, null, null, 0, 0, null, 0, 0, null, 0);
        UConverterFromUnicodeArgs fromUArgs = new UConverterFromUnicodeArgs(true, null, null, 0, 0, null, 0, 0, null, 0);
        int[] errorCode = new int[]{0};
        toUArgs.converter = fromUArgs.converter = this;
        this.fromCharErrorBehaviour.call(this.toUContextArray, toUArgs, null, 0, 0, 4, errorCode);
        errorCode[0] = 0;
        this.fromUCharErrorBehaviour.call(this.fromUContextArray, fromUArgs, null, 0, 0, 0, 4, errorCode);
        this.sharedData.close(this);
        if (this.sharedData.referenceCounter != -1) {
            UConverter.ucnv_unloadSharedDataIfReady(this.sharedData);
        }
    }

    public void ucnv_setToUCallBack(UConverterToUCallback newAction, byte[] newContext, UConverterToUCallback[] oldAction, byte[][] oldContext, int[] err) {
        if (UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (oldAction != null) {
            oldAction[0] = this.fromCharErrorBehaviour;
        }
        this.fromCharErrorBehaviour = newAction;
        if (oldContext != null) {
            oldContext[0] = this.toUContextArray;
        }
        this.toUContextArray = newContext;
    }

    public void ucnv_setFromUCallBack(UConverterFromUCallback newAction, byte[] newContext, UConverterFromUCallback[] oldAction, byte[][] oldContext, int[] err) {
        if (UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (oldAction != null) {
            oldAction[0] = this.fromUCharErrorBehaviour;
        }
        this.fromUCharErrorBehaviour = newAction;
        if (oldContext != null) {
            oldContext[0] = this.fromUContextArray;
        }
        this.fromUContextArray = newContext;
    }

    public static final void ucnv_cbFromUWriteBytes(UConverterFromUnicodeArgs args, byte[] sourceArray, int sourceBegin, int length, int offsetIndex, int[] err) {
        if (UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        int[] targetBegin_param = new int[]{args.targetBegin};
        int[] offsetsBegin_param = new int[]{args.offsetsBegin};
        UConverter.ucnv_fromUWriteBytes(args.converter, sourceArray, sourceBegin, length, args.targetArray, targetBegin_param, args.targetLimit, args.offsetsArray, offsetsBegin_param, offsetIndex, err);
        args.targetBegin = targetBegin_param[0];
        args.offsetsBegin = offsetsBegin_param[0];
    }

    static final void ucnv_cbFromUWriteUChars(UConverterFromUnicodeArgs args, char[] sourceArray, int[] sourceBegin, int sourceLimit, int offsetIndex, int[] err) {
        if (UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        byte[] oldTargetArray = args.targetArray;
        int[] targetBegin = new int[]{args.targetBegin};
        args.converter.ucnv_fromUnicode(args.targetArray, targetBegin, args.targetLimit, sourceArray, sourceBegin, sourceLimit, false, err);
        args.targetBegin = targetBegin[0];
        if (args.offsetsArray != null) {
            for (int oldTargetIndex = args.targetBegin; args.targetBegin != oldTargetIndex; ++oldTargetIndex) {
                args.offsetsArray[args.offsetsBegin++] = offsetIndex;
            }
        }
        if (err[0] == 15) {
            byte[] newTargetArray = null;
            int[] err2 = new int[]{0};
            int errBuffLen = args.converter.charErrorBufferLength;
            int newTargetIndex = errBuffLen;
            int newTargetLimit = args.converter.charErrorBufferArray.length;
            if (newTargetIndex >= newTargetLimit) {
                err[0] = 5;
                return;
            }
            args.converter.charErrorBufferLength = 0;
            int[] newTarget_param = new int[]{newTargetIndex};
            args.converter.ucnv_fromUnicode(newTargetArray, newTarget_param, newTargetLimit, sourceArray, sourceBegin, sourceLimit, false, err2);
            newTargetIndex = newTarget_param[0];
            args.converter.charErrorBufferLength = (byte)(newTargetIndex - args.converter.charErrorBufferBegin);
            if (newTargetIndex >= newTargetLimit || err2[0] == 15) {
                err[0] = 5;
                return;
            }
        }
    }

    public static final void ucnv_cbFromUWriteSub(UConverterFromUnicodeArgs args, int offsetIndex, int[] err) {
        if (UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (args.converter.subChar1 != 0 && args.converter.invalidUCharBufferArray[0] <= '\u00ff') {
            byte[] args_converter_subChar1_param = new byte[]{args.converter.subChar1};
            UConverter.ucnv_cbFromUWriteBytes(args, new byte[]{args.converter.subChar1}, 0, 1, offsetIndex, err);
        } else {
            UConverter.ucnv_cbFromUWriteBytes(args, args.converter.subCharArray, args.converter.subCharBegin, args.converter.subCharLen, offsetIndex, err);
        }
    }

    static final void ucnv_cbToUWriteUChars(UConverterToUnicodeArgs args, char[] sourceArray, int sourceBegin, int length, int offsetIndex, int[] err) {
        if (UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        int[] targetBegin_param = new int[]{args.targetBegin};
        int[] offsetsBegin_param = new int[]{args.offsetsBegin};
        UConverter.ucnv_toUWriteUChars(args.converter, sourceArray, sourceBegin, length, args.targetArray, targetBegin_param, args.targetLimit, args.offsetsArray, offsetsBegin_param, offsetIndex, err);
        args.targetBegin = targetBegin_param[0];
        args.offsetsBegin = offsetsBegin_param[0];
    }

    static final void ucnv_cbToUWriteSub(UConverterToUnicodeArgs args, int offsetIndex, int[] err) {
        char kSubstituteChar1 = '\u001a';
        char kSubstituteChar = '\ufffd';
        if (args.converter.invalidCharLength == 1 && args.converter.subChar1 != 0) {
            UConverter.ucnv_cbToUWriteUChars(args, new char[]{kSubstituteChar1}, 0, 1, offsetIndex, err);
        } else {
            UConverter.ucnv_cbToUWriteUChars(args, new char[]{kSubstituteChar}, 0, 1, offsetIndex, err);
        }
    }

    public static final void ucnv_fromUWriteBytes(UConverter cnv, byte[] bytesArray, int bytesBegin, int length, byte[] targetArray, int[] targetBegin, int targetLimit, int[] offsetsArray, int[] offsetsBegin, int sourceIndex, int[] pErrorCode) {
        byte[] tArray = targetArray;
        int tIndex = targetBegin[0];
        int oIndex = offsetsBegin[0];
        int[] oArray = offsetsArray;
        if (offsetsArray == null) {
            while (length > 0 && tIndex < targetLimit) {
                tArray[tIndex++] = bytesArray[bytesBegin++];
                --length;
            }
        } else {
            while (length > 0 && tIndex < targetLimit) {
                tArray[tIndex++] = bytesArray[bytesBegin++];
                oArray[oIndex++] = sourceIndex;
                --length;
            }
            offsetsBegin[0] = oIndex;
        }
        targetBegin[0] = tIndex;
        if (length > 0) {
            if (cnv != null) {
                tArray = cnv.charErrorBufferArray;
                cnv.charErrorBufferLength = (byte)length;
                do {
                    tArray[tIndex++] = bytesArray[bytesBegin++];
                } while (--length > 0);
            }
            pErrorCode[0] = 15;
        }
    }

    public static final void ucnv_toUWriteUChars(UConverter cnv, char[] ucharsArray, int ucharsBegin, int length, char[] targetArray, int[] targetBegin, int targetLimit, int[] offsetsArray, int[] offsetsBegin, int sourceIndex, int[] pErrorCode) {
        char[] tArray = targetArray;
        int tIndex = targetBegin[0];
        int oIndex = offsetsBegin[0];
        int[] oArray = offsetsArray;
        if (offsetsArray == null) {
            while (length > 0 && tIndex < targetLimit) {
                tArray[tIndex++] = ucharsArray[ucharsBegin++];
                --length;
            }
        } else {
            while (length > 0 && tIndex < targetLimit) {
                tArray[tIndex++] = ucharsArray[ucharsBegin++];
                oArray[oIndex++] = sourceIndex;
                --length;
            }
            offsetsBegin[0] = oIndex;
        }
        targetBegin[0] = tIndex;
        if (length > 0) {
            if (cnv != null) {
                tArray = cnv.UCharErrorBufferArray;
                cnv.UCharErrorBufferLength = (byte)length;
                do {
                    tArray[tIndex++] = ucharsArray[ucharsBegin++];
                } while (--length > 0);
            }
            pErrorCode[0] = 15;
        }
    }

    public final void ucnv_toUWriteCodePoint(int c, char[] targetArray, int[] targetBegin, int targetLimit, int[] offsetsArray, int[] offsetsBegin, int sourceIndex, int[] pErrorCode) {
        char[] tArray = targetArray;
        int tIndex = targetBegin[0];
        if (tIndex < targetLimit) {
            if (c <= 65535) {
                tArray[tIndex++] = (char)c;
                c = -1;
            } else {
                tArray[tIndex++] = UConverterUTF16.U16_LEAD(c);
                c = UConverterUTF16.U16_TRAIL(c);
                if (tIndex < targetLimit) {
                    tArray[tIndex++] = (char)c;
                    c = -1;
                }
            }
            int oIndex = offsetsBegin[0];
            int[] oArray = offsetsArray;
            if (offsetsArray != null) {
                oArray[oIndex++] = sourceIndex;
                if (targetBegin[0] + 1 < tIndex) {
                    oArray[oIndex++] = sourceIndex;
                }
                offsetsBegin[0] = oIndex;
            }
        }
        targetBegin[0] = tIndex;
        if (c >= 0) {
            int i = 0;
            int[] I = new int[]{i};
            UConverterUTF16.U16_APPEND_UNSAFE(this.UCharErrorBufferArray, I, c);
            i = I[0];
            this.UCharErrorBufferLength = (byte)i;
            pErrorCode[0] = 15;
        }
    }

    /*
     * Unable to fully structure code
     */
    final void _fromUnicodeWithCallback(UConverterFromUnicodeArgs pArgs, int[] err) {
        replayArray = new char[19];
        replayArrayIndex = 0;
        realSourceArrayIndex = 0;
        sArray = pArgs.sourceArray;
        sArrayIndex = pArgs.sourceBegin;
        tArray = pArgs.targetArray;
        tArrayIndex = pArgs.targetBegin;
        offsetsArray = pArgs.offsetsArray;
        offsetsArrayIndex = pArgs.offsetsBegin;
        sourceIndex = 0;
        if (offsetsArray == null) {
            // empty if block
        }
        if (this.preFromULength >= 0) {
            realSourceArray = null;
            realSourceLimit = 0;
            realFlush = false;
            realSourceIndex = 0;
        } else {
            realSourceArray = pArgs.sourceArray;
            realSourceArrayIndex = pArgs.sourceBegin;
            realSourceLimit = pArgs.sourceLimit;
            realFlush = pArgs.flush;
            realSourceIndex = sourceIndex;
            UConverterUtility.uprv_memcpy(replayArray, replayArrayIndex, this.preFromUArray, 0, -this.preFromULength * 2);
            pArgs.sourceArray = replayArray;
            pArgs.sourceBegin = replayArrayIndex;
            pArgs.sourceLimit = replayArrayIndex - this.preFromULength;
            pArgs.flush = false;
            sourceIndex = -1;
            this.preFromULength = 0;
        }
        block0: while (true) {
            this.sharedData.fromUnicode(pArgs, err);
            converterSawEndOfInput = UErrorCode.U_SUCCESS(err[0]) != false && pArgs.flush != false && pArgs.sourceBegin == pArgs.sourceLimit && this.fromUChar32 == 0;
            calledCallback = false;
            errorInputLength = 0;
            while (true) {
                if (offsetsArray != null) {
                    length = pArgs.targetBegin - tArrayIndex;
                    if (length > 0) {
                        pArgs.offsetsBegin = offsetsArrayIndex += length;
                    }
                    if (sourceIndex >= 0) {
                        sourceIndex += pArgs.sourceBegin - sArrayIndex;
                    }
                }
                if (this.preFromULength < 0) {
                    if (realSourceArray == null) {
                        realSourceArray = pArgs.sourceArray;
                        realSourceArrayIndex = pArgs.sourceBegin;
                        realSourceLimit = pArgs.sourceLimit;
                        realFlush = pArgs.flush;
                        realSourceIndex = sourceIndex;
                        UConverterUtility.uprv_memcpy(replayArray, replayArrayIndex, this.preFromUArray, 0, -this.preFromULength * 2);
                        pArgs.sourceArray = replayArray;
                        pArgs.sourceBegin = replayArrayIndex;
                        pArgs.sourceLimit = replayArrayIndex - this.preFromULength;
                        pArgs.flush = false;
                        if ((sourceIndex += this.preFromULength) < 0) {
                            sourceIndex = -1;
                        }
                        this.preFromULength = 0;
                    } else {
                        err[0] = 5;
                    }
                }
                sArray = pArgs.sourceArray;
                sArrayIndex = pArgs.sourceBegin;
                tArray = pArgs.targetArray;
                tArrayIndex = pArgs.targetBegin;
                if (UErrorCode.U_SUCCESS(err[0])) {
                    if (sArrayIndex < pArgs.sourceLimit) continue block0;
                    if (realSourceArray != null) {
                        pArgs.sourceArray = realSourceArray;
                        pArgs.sourceBegin = realSourceArrayIndex;
                        pArgs.sourceLimit = realSourceLimit;
                        pArgs.flush = realFlush;
                        sourceIndex = realSourceIndex;
                        realSourceArray = null;
                        continue block0;
                    }
                    if (pArgs.flush && this.fromUChar32 != 0) {
                        err[0] = 11;
                        calledCallback = false;
                    } else {
                        if (pArgs.flush) {
                            if (converterSawEndOfInput) ** break;
                            continue block0;
                            this._reset(2, false);
                        }
                        return;
                    }
                }
                if (calledCallback || (e = err[0]) == 15 || e != 10 && e != 12 && e != 11) {
                    if (realSourceArray != null) {
                        length = pArgs.sourceLimit - pArgs.sourceBegin;
                        if (length > 0) {
                            UConverterUtility.uprv_memcpy(this.preFromUArray, 0, pArgs.sourceArray, pArgs.sourceBegin, length * 2);
                            this.preFromULength = (byte)(-length);
                        }
                        pArgs.sourceArray = realSourceArray;
                        pArgs.sourceBegin = realSourceArrayIndex;
                        pArgs.sourceLimit = realSourceLimit;
                        pArgs.flush = realFlush;
                    }
                    return;
                }
                codePoint = this.fromUChar32;
                errorInputLength = 0;
                I = new int[]{errorInputLength};
                UConverterUTF16.U16_APPEND_UNSAFE(this.invalidUCharBufferArray, I, codePoint);
                errorInputLength = I[0];
                this.invalidUCharLength = (byte)errorInputLength;
                this.fromUChar32 = 0;
                this.fromUCharErrorBehaviour.call(this.fromUContextArray, pArgs, this.invalidUCharBufferArray, this.invalidUCharBufferBegin, errorInputLength, codePoint, err[0] == 10 ? 0 : 1, err);
                calledCallback = true;
            }
            break;
        }
    }

    final void ucnv_fromUnicode(byte[] targetArray, int[] targetBegin, int targetLimit, char[] sourceArray, int[] sourceBegin, int sourceLimit, boolean flush, int[] err) {
        Object offsetsArray = null;
        int offsetsArrayIndex = 0;
        UConverterFromUnicodeArgs args = new UConverterFromUnicodeArgs();
        if (err == null || UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (targetArray == null || sourceArray == null) {
            err[0] = 1;
            return;
        }
        char[] sArray = sourceArray;
        int sArrayIndex = sourceBegin[0];
        byte[] tArray = targetArray;
        int tArrayIndex = targetBegin[0];
        if (sourceLimit < sArrayIndex || targetLimit < tArrayIndex) {
            err[0] = 1;
            return;
        }
        if ((long)(sourceLimit - sArrayIndex) > 0x3FFFFFFFL && sourceLimit > sArrayIndex || (long)(targetLimit - tArrayIndex) > Integer.MAX_VALUE && targetLimit > tArrayIndex) {
            err[0] = 1;
            return;
        }
        if (this.charErrorBufferLength > 0) {
            byte[] overflowArray = this.charErrorBufferArray;
            int overflowArrayIndex = this.charErrorBufferBegin;
            byte length = this.charErrorBufferLength;
            byte i = 0;
            do {
                if (tArrayIndex == targetLimit) {
                    int j = 0;
                    do {
                        overflowArray[j++] = overflowArray[i++];
                    } while (i < length);
                    this.charErrorBufferLength = (byte)j;
                    targetBegin[0] = tArrayIndex;
                    err[0] = 15;
                    return;
                }
                tArray[tArrayIndex++] = overflowArray[i++];
                if (offsetsArray == null) continue;
                offsetsArray[offsetsArrayIndex++] = -1;
            } while (i < length);
            this.charErrorBufferLength = 0;
        }
        if (!flush && sArrayIndex == sourceLimit && this.preFromULength >= 0) {
            targetBegin[0] = tArrayIndex;
            return;
        }
        args.converter = this;
        args.flush = flush;
        args.offsetsArray = offsetsArray;
        args.offsetsBegin = offsetsArrayIndex;
        args.sourceArray = sArray;
        args.sourceBegin = sArrayIndex;
        args.sourceLimit = sourceLimit;
        args.targetArray = tArray;
        args.targetBegin = tArrayIndex;
        args.targetLimit = targetLimit;
        this._fromUnicodeWithCallback(args, err);
        sourceBegin[0] = args.sourceBegin;
        targetBegin[0] = args.targetBegin;
    }

    public int ucnv_getMaxCharSize() {
        return this.maxBytesPerUChar;
    }

    public int ucnv_getMinCharSize() {
        return this.sharedData.staticData.minBytesPerChar;
    }

    public void ucnv_resetToUnicode() {
        this._reset(1, true);
    }

    public void ucnv_resetFromUnicode() {
        this._reset(2, true);
    }

    void _reset(int choice, boolean callCallback) {
        if (callCallback) {
            UConverterToUnicodeArgs toUArgs = new UConverterToUnicodeArgs(true, null, null, 0, 0, null, 0, 0, null, 0);
            UConverterFromUnicodeArgs fromUArgs = new UConverterFromUnicodeArgs(true, null, null, 0, 0, null, 0, 0, null, 0);
            int[] errorCode = new int[]{0};
            toUArgs.converter = fromUArgs.converter = this;
            if (choice <= 1) {
                errorCode[0] = 0;
                this.fromCharErrorBehaviour.call(this.toUContextArray, toUArgs, null, 0, 0, 3, errorCode);
            }
            if (choice != 1) {
                errorCode[0] = 0;
                this.fromUCharErrorBehaviour.call(this.fromUContextArray, fromUArgs, null, 0, 0, 0, 3, errorCode);
            }
        }
        if (choice <= 1) {
            this.toUnicodeStatus = this.sharedData.toUnicodeStatus;
            this.mode = 0;
            this.toULength = 0;
            this.UCharErrorBufferLength = 0;
            this.invalidCharLength = 0;
            this.preToULength = 0;
        }
        if (choice != 1) {
            this.fromUnicodeStatus = 0L;
            this.fromUChar32 = 0;
            this.charErrorBufferLength = 0;
            this.invalidUCharLength = 0;
            this.preFromUFirstCP = -1;
            this.preFromULength = 0;
        }
        this.sharedData.reset(this, choice);
    }

    /*
     * Unable to fully structure code
     */
    void _toUnicodeWithCallback(UConverterToUnicodeArgs pArgs, int[] err) {
        replayArray = new byte[31];
        replayBegin = 0;
        realSourceBegin = 0;
        s = pArgs.sourceBegin;
        t = pArgs.targetBegin;
        offsets = pArgs.offsetsArray;
        sourceIndex = 0;
        if (offsets == null) {
            // empty if block
        }
        if (this.preToULength >= 0) {
            realSourceArray = null;
            realSourceLimit = 0;
            realFlush = false;
            realSourceIndex = 0;
        } else {
            realSourceArray = pArgs.sourceArray;
            realSourceBegin = pArgs.sourceBegin;
            realSourceLimit = pArgs.sourceLimit;
            realFlush = pArgs.flush;
            realSourceIndex = sourceIndex;
            UConverterUtility.uprv_memcpy(replayArray, replayBegin, this.preToUArray, this.preToUBegin, (int)(-this.preToULength));
            pArgs.sourceArray = replayArray;
            pArgs.sourceBegin = replayBegin;
            pArgs.sourceLimit = replayBegin - this.preToULength;
            pArgs.flush = false;
            sourceIndex = -1;
            this.preToULength = 0;
        }
        block0: while (true) {
            if (UErrorCode.U_SUCCESS(err[0])) {
                this.sharedData.toUnicode(pArgs, err);
                converterSawEndOfInput = UErrorCode.U_SUCCESS(err[0]) != false && pArgs.flush != false && pArgs.sourceBegin == pArgs.sourceLimit && this.toULength == 0;
            } else {
                converterSawEndOfInput = false;
            }
            calledCallback = false;
            errorInputLength = 0;
            while (true) {
                if (offsets != null) {
                    // empty if block
                }
                if (this.preToULength < 0) {
                    if (realSourceArray == null) {
                        realSourceArray = pArgs.sourceArray;
                        realSourceBegin = pArgs.sourceBegin;
                        realSourceLimit = pArgs.sourceLimit;
                        realFlush = pArgs.flush;
                        realSourceIndex = sourceIndex;
                        UConverterUtility.uprv_memcpy(replayArray, replayBegin, this.preToUArray, this.preToUBegin, (int)(-this.preToULength));
                        pArgs.sourceArray = replayArray;
                        pArgs.sourceLimit = replayBegin - this.preToULength;
                        pArgs.flush = false;
                        if ((sourceIndex += this.preToULength) < 0) {
                            sourceIndex = -1;
                        }
                        this.preToULength = 0;
                    } else {
                        err[0] = 5;
                    }
                }
                s = pArgs.sourceBegin;
                t = pArgs.targetBegin;
                if (UErrorCode.U_SUCCESS(err[0])) {
                    if (s < pArgs.sourceLimit) continue block0;
                    if (realSourceArray != null) {
                        pArgs.sourceBegin = realSourceBegin;
                        pArgs.sourceLimit = realSourceLimit;
                        pArgs.flush = realFlush;
                        sourceIndex = realSourceIndex;
                        realSourceArray = null;
                        continue block0;
                    }
                    if (pArgs.flush && this.toULength > 0) {
                        err[0] = 11;
                        calledCallback = false;
                    } else {
                        if (pArgs.flush) {
                            if (converterSawEndOfInput) ** break;
                            continue block0;
                            this._reset(1, false);
                        }
                        return;
                    }
                }
                if (calledCallback || (e = err[0]) == 15 || e != 10 && e != 12 && e != 11 && e != 18 && e != 19) {
                    if (realSourceArray != null) {
                        length = pArgs.sourceLimit - pArgs.sourceBegin;
                        if (length > 0) {
                            UConverterUtility.uprv_memcpy(this.preToUArray, this.preToUBegin, pArgs.sourceArray, pArgs.sourceBegin, length);
                            this.preToULength = (byte)(-length);
                        }
                        pArgs.sourceArray = realSourceArray;
                        pArgs.sourceBegin = realSourceBegin;
                        pArgs.sourceLimit = realSourceLimit;
                        pArgs.flush = realFlush;
                    }
                    return;
                }
                this.invalidCharLength = this.toULength;
                errorInputLength = this.invalidCharLength;
                if (errorInputLength > 0) {
                    UConverterUtility.uprv_memcpy(this.invalidCharBufferArray, this.invalidCharBufferBegin, this.toUBytesArray, this.toUBytesBegin, (int)errorInputLength);
                }
                this.toULength = 0;
                this.fromCharErrorBehaviour.call(this.toUContextArray, pArgs, this.invalidCharBufferArray, this.invalidCharBufferBegin, errorInputLength, err[0] == 10 || err[0] == 19 ? 0 : 1, err);
                calledCallback = true;
            }
            break;
        }
    }

    final void ucnv_toUnicode(char[] target, int[] targetBegin, int targetLimit, byte[] source, int[] sourceBegin, int sourceLimit, boolean flush, int[] err) {
        Object offsets = null;
        UConverterToUnicodeArgs args = new UConverterToUnicodeArgs();
        if (err == null || UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (target == null || source == null) {
            err[0] = 1;
            return;
        }
        int s = sourceBegin[0];
        int t = targetBegin[0];
        if (sourceLimit < s || targetLimit < t) {
            err[0] = 1;
            return;
        }
        if (this.UCharErrorBufferLength > 0) {
            char[] overflow = null;
            overflow = this.UCharErrorBufferArray;
            byte length = this.UCharErrorBufferLength;
            byte i = 0;
            do {
                if (t == targetLimit) {
                    int j = 0;
                    do {
                        overflow[j++] = overflow[i++];
                    } while (i < length);
                    this.UCharErrorBufferLength = (byte)j;
                    targetBegin[0] = t;
                    err[0] = 15;
                    return;
                }
                target[t++] = overflow[i++];
                if (offsets == null) continue;
            } while (i < length);
            this.UCharErrorBufferLength = 0;
        }
        if (!flush && s == sourceLimit && this.preToULength >= 0) {
            targetBegin[0] = t;
            return;
        }
        args.converter = this;
        args.flush = flush;
        args.offsetsArray = offsets;
        args.sourceArray = source;
        args.sourceBegin = s;
        args.sourceLimit = sourceLimit;
        args.targetArray = target;
        args.targetBegin = t;
        args.targetLimit = targetLimit;
        this._toUnicodeWithCallback(args, err);
        sourceBegin[0] = args.sourceBegin;
        targetBegin[0] = args.targetBegin;
    }

    public void ucnv_isValidSubstChars(byte[] mySubChar, int[] err) {
        int len = mySubChar.length;
        if (UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (len > this.sharedData.staticData.maxBytesPerChar || len < this.sharedData.staticData.minBytesPerChar) {
            err[0] = 1;
            return;
        }
    }

    public void ucnv_setSubstChars(byte[] mySubChar, byte len, int[] err) {
        if (UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (len > this.sharedData.staticData.maxBytesPerChar || len < this.sharedData.staticData.minBytesPerChar) {
            err[0] = 1;
            return;
        }
        UConverterUtility.uprv_memcpy(this.subCharArray, 0, mySubChar, 0, (int)len);
        this.subCharBegin = 0;
        this.subCharLen = len;
        this.subChar1 = 0;
    }

    public void ucnv_getSubstChars(byte[] mySubChar, byte[] len, int[] err) {
        if (UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (len[0] < this.subCharLen) {
            err[0] = 8;
            return;
        }
        UConverterUtility.uprv_memcpy(mySubChar, 0, this.subCharArray, this.subCharBegin, (int)this.subCharLen);
        len[0] = this.subCharLen;
    }

    public final void ucnv_getInvalidChars(byte[] errBytes, int[] len, int[] err) {
        if (err == null || UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (len == null || errBytes == null) {
            err[0] = 1;
            return;
        }
        if (len[0] < this.invalidCharLength) {
            err[0] = 8;
            return;
        }
        byte by = this.invalidCharLength;
        len[0] = by;
        if (by > 0) {
            UConverterUtility.uprv_memcpy(errBytes, 0, this.invalidCharBufferArray, this.invalidCharBufferBegin, len[0]);
        }
    }

    public void ucnv_getInvalidUChars(char[] errChars, int[] len, int[] err) {
        if (err == null || UErrorCode.U_FAILURE(err[0])) {
            return;
        }
        if (len == null || errChars == null) {
            err[0] = 1;
            return;
        }
        if (len[0] < this.invalidUCharLength) {
            err[0] = 8;
            return;
        }
        byte by = this.invalidUCharLength;
        len[0] = by;
        if (by > 0) {
            System.arraycopy(this.invalidUCharBufferArray, 0, errChars, 0, len[0]);
        }
    }

    public static int ucnv_countAliases(String alias, int[] pErrorCode) {
        return UConverterAlias.ucnv_io_countAliases(alias, pErrorCode);
    }

    public static int ucnv_countAvailable() {
        int[] err = new int[]{0};
        return UConverterAlias.ucnv_io_countAvailableConverters(err);
    }

    public static String ucnv_getAlias(String alias, int n, int[] pErrorCode) {
        return UConverterAlias.ucnv_io_getAlias(alias, n, pErrorCode);
    }

    public static String ucnv_getAvailableName(int n) {
        if (0 <= n && n <= 65535) {
            int[] err = new int[]{0};
            String name = UConverterAlias.ucnv_io_getAvailableConverter(n, err);
            if (UErrorCode.U_SUCCESS(err[0])) {
                return name;
            }
        }
        return null;
    }

    public static int ucnv_countStandards() {
        int[] err = new int[]{0};
        return UConverterAlias.ucnv_io_countStandards(err);
    }

    public static String ucnv_getStandard(int n, int[] pErrorCode) {
        return UConverterAlias.ucnv_io_getStandard(n, pErrorCode);
    }

    public static String ucnv_getStandardName(String alias, String standard, int[] pErrorCode) {
        return UConverterAlias.ucnv_io_getStandardName(alias, standard, pErrorCode);
    }

    public static AliasesEnumeration ucnv_openStandardNames(String alias, String standard, int[] pErrorCode) {
        return UConverterAlias.ucnv_io_openStandardNames(alias, standard, pErrorCode);
    }

    static final UDataMemory udata_openChoice(byte[] path, byte[] type, byte[] nameArray, long nameArrayIndex, UDataMemoryIsAcceptable isAcceptable, byte[] context, int[] pErrorCode) {
        if (pErrorCode == null || UErrorCode.U_FAILURE(pErrorCode[0])) {
            return null;
        }
        if (nameArray == null || nameArray[(int)nameArrayIndex] == 0 || isAcceptable == null) {
            pErrorCode[0] = 1;
            return null;
        }
        return null;
    }

    static final int udata_getHeaderSize(DataHeader udh) {
        if (udh == null) {
            return 0;
        }
        if (udh.info.isBigEndian == 0) {
            return udh.dataHeader.headerSize;
        }
        int x = udh.dataHeader.headerSize;
        return x << 8 | x >> 8;
    }

    static final ByteBuffer udata_getMemory(UDataMemory pData) {
        if (pData != null && pData.pHeaderArray != null) {
            return pData.pHeaderArray;
        }
        return null;
    }

    class UDataInfo {
        int size;
        int reservedWord;
        short isBigEndian;
        short charsetFamily;
        short sizeofUChar;
        short reservedByte;
        short[] dataFormat = new short[4];
        short[] formatVersion = new short[4];
        short[] dataVersion = new short[4];

        UDataInfo() {
        }
    }

    class UDataOffsetTOC {
        long count;
        UDataOffsetTOCEntry[] entry = new UDataOffsetTOCEntry[2];

        UDataOffsetTOC() {
        }
    }

    class UDataOffsetTOCEntry {
        long nameOffset;
        long dataOffset;

        UDataOffsetTOCEntry() {
        }
    }

    class DataHeader {
        MappedData dataHeader;
        UDataInfo info;

        DataHeader() {
        }
    }

    class MappedData {
        int headerSize;
        short magic1;
        short magic2;

        MappedData() {
        }
    }

    public static class UCNV_TO_U_CALLBACK_SKIP
    implements UConverterToUCallback {
        public void call(byte[] context, UConverterToUnicodeArgs toArgs, byte[] codeUnitsArray, int codeUnitsArrayBegin, int length, int reason, int[] err) {
            if (context == null) {
                if (reason <= 2) {
                    err[0] = 0;
                    return;
                }
            } else if (context[0] == 105) {
                if (reason != 0) {
                    return;
                }
                err[0] = 0;
                return;
            }
        }
    }

    public static class UCNV_FROM_U_CALLBACK_SKIP
    implements UConverterFromUCallback {
        public void call(byte[] contextArray, UConverterFromUnicodeArgs fromUArgs, char[] codeUnitsArray, int codeUnitsArrayBegin, int length, int codePoint, int reason, int[] err) {
            if (contextArray == null) {
                if (reason <= 2) {
                    err[0] = 0;
                    return;
                }
            } else if (contextArray[0] == 105) {
                if (reason != 0) {
                    return;
                }
                err[0] = 0;
                return;
            }
        }
    }

    public static class UCNV_TO_U_CALLBACK_STOP
    implements UConverterToUCallback {
        public void call(byte[] contextArray, UConverterToUnicodeArgs toUArgs, byte[] codePointsArray, int codePointsArrayBegin, int length, int reason, int[] err) {
        }
    }

    public static class UCNV_FROM_U_CALLBACK_STOP
    implements UConverterFromUCallback {
        public void call(byte[] contextArray, UConverterFromUnicodeArgs fromUArgs, char[] codeUnitsArray, int codeUnitsBegin, int length, int codePoint, int reason, int[] err) {
        }
    }

    public static class UCNV_FROM_U_CALLBACK_SUBSTITUTE
    implements UConverterFromUCallback {
        public void call(byte[] contextArray, UConverterFromUnicodeArgs fromArgs, char[] codeUnitsArray, int codeUnitsBegin, int length, int codePoint, int reason, int[] err) {
            if (contextArray == null) {
                if (reason > 2) {
                    return;
                }
                err[0] = 0;
                UConverter.ucnv_cbFromUWriteSub(fromArgs, 0, err);
                return;
            }
            if ((char)contextArray[0] == 'i') {
                if (reason != 0) {
                    return;
                }
                err[0] = 0;
                UConverter.ucnv_cbFromUWriteSub(fromArgs, 0, err);
                return;
            }
        }
    }

    public static class UCNV_TO_U_CALLBACK_SUBSTITUTE
    implements UConverterToUCallback {
        public void call(byte[] contextArray, UConverterToUnicodeArgs toArgs, byte[] codeUnitsArray, int codeUnitsBegin, int length, int reason, int[] err) {
            if (contextArray == null) {
                if (reason > 2) {
                    return;
                }
                err[0] = 0;
                UConverter.ucnv_cbToUWriteSub(toArgs, 0, err);
                return;
            }
            if ((char)contextArray[0] == 'i') {
                if (reason != 0) {
                    return;
                }
                err[0] = 0;
                UConverter.ucnv_cbToUWriteSub(toArgs, 0, err);
                return;
            }
        }
    }

    class USetAdder {
        USetAdd add;
        USetAddRange addRange;
        USetAddString addString;

        USetAdder() {
        }
    }

    static interface USetAddString {
    }

    static interface USetAddRange {
    }

    static interface USetAdd {
    }

    class UConverterUnicodeSet {
        public static final int UCNV_ROUNDTRIP_SET = 0;
        public static final int UCNV_SET_COUNT = 1;

        UConverterUnicodeSet() {
        }
    }

    static interface UConverterToUCallback {
        public void call(byte[] var1, UConverterToUnicodeArgs var2, byte[] var3, int var4, int var5, int var6, int[] var7);
    }

    static interface UConverterFromUCallback {
        public void call(byte[] var1, UConverterFromUnicodeArgs var2, char[] var3, int var4, int var5, int var6, int var7, int[] var8);
    }

    static interface UDataMemoryIsAcceptable {
        public boolean call(byte[] var1, byte[] var2, byte[] var3, UDataInfo var4);
    }

    static final class UConverterCallbackReason {
        public static final int UCNV_UNASSIGNED = 0;
        public static final int UCNV_ILLEGAL = 1;
        public static final int UCNV_IRREGULAR = 2;
        public static final int UCNV_RESET = 3;
        public static final int UCNV_CLOSE = 4;
        public static final int UCNV_CLONE = 5;

        UConverterCallbackReason() {
        }
    }

    static class UConverterLookupData {
        StringBuffer cnvName = new StringBuffer(60);
        StringBuffer locale = new StringBuffer(56);
        String realName;
        long options;

        UConverterLookupData() {
        }
    }
}

