/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.impl.ICUBinary;
import com.adobe.agl.impl.ICUDebug;
import com.adobe.agl.impl.UConverterSharedData;
import com.adobe.agl.impl.UConverterStaticData;
import com.adobe.agl.impl.UConverterUtility;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class UConverterDataReader
implements ICUBinary.Authenticate {
    private static final boolean debug = ICUDebug.enabled("UConverterDataReader");
    private DataInputStream dataInputStream;
    private byte[] unicodeVersion;
    private ByteBuffer skipBytes;
    private static final byte[] DATA_FORMAT_ID = new byte[]{99, 110, 118, 116};
    private static final byte[] DATA_FORMAT_VERSION = new byte[]{6};
    private static final int UNSIGNED_SHORT_MASK = 65535;
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;

    protected UConverterDataReader(InputStream inputStream) throws IOException {
        if (debug) {
            System.out.println("Bytes in inputStream " + inputStream.available());
        }
        this.unicodeVersion = ICUBinary.readHeader(inputStream, DATA_FORMAT_ID, this);
        if (debug) {
            System.out.println("Bytes left in inputStream " + inputStream.available());
        }
        this.dataInputStream = new DataInputStream(inputStream);
        if (debug) {
            System.out.println("Bytes left in dataInputStream " + this.dataInputStream.available());
        }
    }

    protected void readStaticData(UConverterStaticData sd) throws IOException {
        sd.structSize = this.dataInputStream.readInt();
        byte[] name = new byte[60];
        this.dataInputStream.read(name);
        sd.name = new String(name, 0, UConverterUtility.uprv_strlen(name, 0));
        sd.codepage = this.dataInputStream.readInt();
        sd.platform = this.dataInputStream.readByte();
        sd.conversionType = this.dataInputStream.readByte();
        sd.minBytesPerChar = this.dataInputStream.readByte();
        sd.maxBytesPerChar = this.dataInputStream.readByte();
        this.dataInputStream.read(sd.subChar);
        sd.subCharLen = this.dataInputStream.readByte();
        sd.hasToUnicodeFallback = this.dataInputStream.readByte();
        sd.hasFromUnicodeFallback = this.dataInputStream.readByte();
        sd.unicodeMask = (short)this.dataInputStream.readUnsignedByte();
        sd.subChar1 = this.dataInputStream.readByte();
        this.dataInputStream.read(sd.reserved);
    }

    protected void readMBCSHeader(UConverterSharedData._MBCSHeader h) throws IOException {
        this.dataInputStream.read(h.version);
        h.countStates = this.dataInputStream.readInt();
        h.countToUFallbacks = this.dataInputStream.readInt();
        h.offsetToUCodeUnits = this.dataInputStream.readInt();
        h.offsetFromUTable = this.dataInputStream.readInt();
        h.offsetFromUBytes = this.dataInputStream.readInt();
        h.flags = this.dataInputStream.readInt();
        h.fromUBytesLength = this.dataInputStream.readInt();
    }

    protected void readMBCSTable(int[][] stateTableArray, UConverterSharedData._MBCSToUFallback[] toUFallbacksArray, char[] unicodeCodeUnitsArray, char[] fromUnicodeTableArray, byte[] fromUnicodeBytesArray) throws IOException {
        int i;
        for (i = 0; i < stateTableArray.length; ++i) {
            for (int j = 0; j < stateTableArray[i].length; ++j) {
                stateTableArray[i][j] = this.dataInputStream.readInt();
            }
        }
        for (i = 0; i < toUFallbacksArray.length; ++i) {
            toUFallbacksArray[i].offset = this.dataInputStream.readInt();
            toUFallbacksArray[i].codePoint = this.dataInputStream.readInt();
        }
        for (i = 0; i < unicodeCodeUnitsArray.length; ++i) {
            unicodeCodeUnitsArray[i] = this.dataInputStream.readChar();
        }
        for (i = 0; i < fromUnicodeTableArray.length; ++i) {
            fromUnicodeTableArray[i] = this.dataInputStream.readChar();
        }
        for (i = 0; i < fromUnicodeBytesArray.length; ++i) {
            fromUnicodeBytesArray[i] = this.dataInputStream.readByte();
        }
    }

    protected String readBaseTableName() throws IOException {
        char c;
        StringBuffer name = new StringBuffer();
        while ((c = (char)this.dataInputStream.readByte()) != '\u0000') {
            name.append(c);
        }
        return name.toString();
    }

    protected ByteBuffer readExtIndexes(int skip) throws IOException {
        this.dataInputStream.skipBytes(skip);
        int n = this.dataInputStream.readInt();
        int[] indexes = new int[n];
        indexes[0] = n;
        for (int i = 1; i < n; ++i) {
            indexes[i] = this.dataInputStream.readInt();
        }
        ByteBuffer b = ByteBuffer.allocate(indexes[31]);
        for (int i = 0; i < n; ++i) {
            b.putInt(indexes[i]);
        }
        byte[] arr = b.array();
        int pos = b.position();
        int rem = b.remaining();
        int nread = this.dataInputStream.read(b.array(), b.position(), b.remaining());
        return b;
    }

    protected byte[] readExtTables(int n) throws IOException {
        byte[] tables = new byte[n];
        this.dataInputStream.read(tables);
        return tables;
    }

    public byte[] getDataFormatVersion() {
        return DATA_FORMAT_VERSION;
    }

    public boolean isDataVersionAcceptable(byte[] version) {
        return version[0] == DATA_FORMAT_VERSION[0];
    }

    public byte[] getUnicodeVersion() {
        return this.unicodeVersion;
    }
}

