/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Block;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntList;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlowGraphEmitter
extends Emitter {
    private boolean hasLeader;
    private ObjectList<Block> blocks = new ObjectList();
    private ObjectList<Node> defs = new ObjectList();
    private int cur_block;
    private int def_count;
    private boolean show_blocks;
    private int within_try_block;
    private Context cx;
    protected int max_temp_count;
    protected int cur_temp_count;
    protected int max_stack;
    protected int cur_stack;
    protected char max_params;
    protected String scriptname;
    protected IntList if_addrs = new IntList();
    protected IntList else_addrs = new IntList();
    protected IntList loopbegin_addrs = new IntList();
    protected ObjectList<IntList> break_addrs = new ObjectList();
    protected ObjectList<IntList> continue_addrs = new ObjectList();
    protected IntList switchbegin_addrs = new IntList();
    protected ObjectList<IntList> case_addrs = new ObjectList();
    protected IntList default_addrs = new IntList();
    protected IntList seen_default_case = new IntList();
    protected int current_with_count;
    protected IntList with_count = new IntList();
    protected IntList try_addrs = new IntList();
    protected ObjectList<IntList> catch_addrs = new ObjectList();
    static final int scopes_register = 0;
    static final int obj_register = 1;
    static final int args_register = 2;
    public IntList stackDepthStack = new IntList();
    public boolean show_instructions;
    public boolean show_linenums;
    public boolean show_stacknames;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void EnterBlock() {
        if (this.hasLeader) {
            this.hasLeader = false;
            if (this.cur_block != this.blocks.size() - 1 && !$assertionsDisabled) {
                throw new Error();
            }
            this.blocks.add(this.cx.newBlock());
            ++this.cur_block;
        }
    }

    public BitSet NewDef(Node node) {
        BitSet bitSet = null;
        if (this.def_count >= 1000) {
            for (Block block : this.blocks) {
                block.def_bits = null;
            }
        } else {
            bitSet = BitSet.set(null, this.def_count, true);
            if (this.defs.size() <= this.def_count) {
                this.defs.resize(this.def_count + 1);
            }
            this.defs.set(this.def_count, node);
            Block block = (Block)this.blocks.get(this.cur_block);
            block.def_bits = BitSet.set(block.def_bits, this.def_count, true);
        }
        ++this.def_count;
        return bitSet;
    }

    public ObjectList<Node> GetDefs(BitSet bitSet) {
        ObjectList<Node> objectList = new ObjectList<Node>();
        int n = BitSet.nextSetBit(bitSet, 0);
        while (n >= 0) {
            objectList.add((Node)this.defs.get(n));
            n = BitSet.nextSetBit(bitSet, n + 1);
        }
        return objectList;
    }

    public int GetBlock() {
        if (!this.hasLeader) {
            this.hasLeader = true;
        }
        return this.cur_block;
    }

    public Block getBlock() {
        return (Block)this.blocks.get(this.cur_block);
    }

    public void AddStmtToBlock(String string) {
        if (!this.hasLeader) {
            this.hasLeader = true;
            if (this.show_blocks) {
                ((Block)this.blocks.get((int)this.cur_block)).stmts = new StringBuffer().append("\n    ").append(string).toString();
            }
        }
    }

    public void EnterTerminalBlock() {
        this.EnterBlock();
        ((Block)this.blocks.get((int)this.cur_block)).is_terminal = true;
        this.AddStmtToBlock("terminal block for return");
        this.EnterBlock();
    }

    public boolean blockIsTerminal(int n) {
        return ((Block)this.blocks.get((int)n)).is_terminal;
    }

    public void AddEdge(int n, int n2) {
        int n3;
        if (((Block)this.blocks.get((int)n)).is_terminal) {
            return;
        }
        IntList intList = ((Block)this.blocks.get((int)n)).succs;
        int n4 = intList.size();
        for (n3 = 0; n3 < n4 && intList.get(n3) != n2; ++n3) {
        }
        if (n3 == n4) {
            intList.add(n2);
        }
        IntList intList2 = ((Block)this.blocks.get((int)n2)).preds;
        n4 = intList2.size();
        for (n3 = 0; n3 < n4 && intList2.get(n3) != n; ++n3) {
        }
        if (n3 == n4) {
            intList2.add(n);
        }
    }

    public ObjectList<Block> GetBlocks() {
        return this.blocks;
    }

    public void InitGraph() {
        this.blocks.clear();
        this.cur_block = 0;
        this.hasLeader = true;
        this.blocks.add(this.cx.newBlock());
    }

    public void calcGenAndKill(Context context) {
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        int n = this.blocks.size();
        for (int i = 0; i < n; ++i) {
            Block block = (Block)this.blocks.get(i);
            BitSet bitSet3 = block.def_bits;
            int n2 = BitSet.nextSetBit(bitSet3, 0);
            while (n2 >= 0) {
                Slot slot;
                Node node = (Node)this.defs.get(n2);
                if (node != null && (slot = node.getRef(context).getSlot(context, -78)) != null) {
                    bitSet = BitSet.set(null, n2, true);
                    bitSet2 = slot.getDefBits() != null ? BitSet.xor(slot.getDefBits(), bitSet) : bitSet;
                }
                block.gen_bits = BitSet.reset_set(block.gen_bits, bitSet2, bitSet);
                block.kill_bits = BitSet.reset_set(block.kill_bits, bitSet, bitSet2);
                n2 = BitSet.nextSetBit(bitSet3, n2 + 1);
            }
        }
    }

    public void calcInAndOut(Context context) {
        int n;
        int n2 = this.blocks.size();
        for (n = 0; n < n2; ++n) {
            Block block = (Block)this.blocks.get(n);
            block.in_bits = null;
            block.out_bits = BitSet.copy(block.gen_bits);
        }
        do {
            n = 0;
            int n3 = this.blocks.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Block block = (Block)this.blocks.get(n2);
                int n4 = 0;
                for (int i = 0; i < block.preds.size(); ++i) {
                    Block block2 = (Block)this.blocks.get(block.preds.get(i));
                    block.in_bits = BitSet.set(block.in_bits, block2.out_bits);
                    if (block.preds.get(i) == 0 || block2.preds.size() != 0) continue;
                    ++n4;
                }
                if (n4 == block.preds.size() && !block.is_terminal) {
                    block.is_terminal = true;
                    block.preds.clear();
                    n = 1;
                }
                BitSet bitSet = BitSet.copy(block.in_bits);
                if (BitSet.equals(block.out_bits, bitSet = BitSet.reset_set(bitSet, block.kill_bits, block.gen_bits))) continue;
                n = 1;
                block.out_bits = bitSet;
            }
        } while (n != 0);
    }

    public void printBlocks(Context context) {
        int n = this.blocks.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Block block = (Block)this.blocks.get(i);
            System.out.print(new StringBuffer().append("\nB").append(i).append(": Pred {").toString());
            for (n2 = 0; n2 < block.preds.size(); ++n2) {
                System.out.print(new StringBuffer().append(" B").append(block.preds.get(n2)).toString());
            }
            System.out.print(" } Succ {");
            for (n2 = 0; n2 < block.succs.size(); ++n2) {
                System.out.print(new StringBuffer().append(" B").append(block.succs.get(n2)).toString());
            }
            System.out.print(" } Def {");
            BitSet bitSet = block.def_bits;
            int n3 = BitSet.nextSetBit(bitSet, 0);
            while (n3 >= 0) {
                System.out.print(new StringBuffer().append(" d").append(n3).toString());
                n3 = BitSet.nextSetBit(bitSet, n3 + 1);
            }
            System.out.print(" } Gen {");
            bitSet = block.gen_bits;
            n3 = BitSet.nextSetBit(bitSet, 0);
            while (n3 >= 0) {
                System.out.print(new StringBuffer().append(" d").append(n3).toString());
                n3 = BitSet.nextSetBit(bitSet, n3 + 1);
            }
            System.out.print(" } Kill {");
            bitSet = block.kill_bits;
            n3 = BitSet.nextSetBit(bitSet, 0);
            while (n3 >= 0) {
                System.out.print(new StringBuffer().append(" d").append(n3).toString());
                n3 = BitSet.nextSetBit(bitSet, n3 + 1);
            }
            System.out.print(" } In {");
            bitSet = block.in_bits;
            n3 = BitSet.nextSetBit(bitSet, 0);
            while (n3 >= 0) {
                System.out.print(new StringBuffer().append(" d").append(n3).toString());
                n3 = BitSet.nextSetBit(bitSet, n3 + 1);
            }
            System.out.print(" } Out {");
            bitSet = block.out_bits;
            n3 = BitSet.nextSetBit(bitSet, 0);
            while (n3 >= 0) {
                System.out.print(new StringBuffer().append(" d").append(n3).toString());
                n3 = BitSet.nextSetBit(bitSet, n3 + 1);
            }
            System.out.print(" }");
            System.out.print(block.stmts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFlowGraph(Context context, String string, String string2) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new StringBuffer().append(string).append(".").append(string2).append(".dot").toString()));
            bufferedWriter.write("\ndigraph cfg {");
            bufferedWriter.write("\nratio=fill");
            bufferedWriter.write("\nranksep=.25");
            bufferedWriter.write("\nnodesep=.2");
            bufferedWriter.write("\nrankdir=LR");
            bufferedWriter.write("\nedge [arrowsize=.7,labeldistance=1.0,labelangle=-45,labelfontsize=9]");
            bufferedWriter.write("\nnode [fontsize=9,shape=box,width=.2,height=.2]");
            for (int i = 0; i < this.blocks.size(); ++i) {
                bufferedWriter.write(new StringBuffer().append("\nB").append(i).append("[label=\"B").append(i).append("\"]").toString());
                for (int j = 0; j < ((Block)this.blocks.get((int)i)).succs.size(); ++j) {
                    bufferedWriter.write(new StringBuffer().append("\nB").append(i).append(" . B").append(((Block)this.blocks.get((int)i)).succs.get(j)).append("[weight=2]").toString());
                }
            }
            bufferedWriter.write("\n}");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void StartClass(String string) {
    }

    public void FinishClass(Context context, QName qName, QName qName2, boolean bl) {
    }

    @Override
    public void StartProgram(String string) {
    }

    @Override
    public void FinishProgram(Context context, String string, int n) {
    }

    @Override
    public void StartMethod(String string, int n, int n2, int n3, boolean bl, int n4) {
        if (this.show_instructions) {
            System.out.print(new StringBuffer().append("\n// ++StartMethod ").append(string).append(", ").append(n).append(", ").append(n2).toString());
        }
        this.InitGraph();
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
        this.max_temp_count = 0;
        this.cur_temp_count = 0;
    }

    @Override
    public int FinishMethod(Context context, String string, TypeInfo typeInfo, ObjectList<TypeInfo> objectList, ObjectValue objectValue, int n, int n2, String string2, boolean bl, boolean bl2, String[] stringArray) {
        if (this.show_instructions) {
            System.out.print(new StringBuffer().append("\n// --FinishMethod ").append(string).toString());
        }
        if (!this.hasLeader) {
            this.blocks.removeLast();
            --this.cur_block;
        }
        this.calcGenAndKill(context);
        this.calcInAndOut(context);
        if (this.show_blocks) {
            System.out.print(new StringBuffer().append("\n").append(string).append(":").toString());
            this.printBlocks(context);
        }
        return 0;
    }

    public void MakeDispatchMethod(Context context) {
    }

    @Override
    public int allocateTemp() {
        int n = this.cur_temp_count++;
        if (this.cur_temp_count > this.max_temp_count) {
            this.max_temp_count = this.cur_temp_count;
        }
        return n - 1;
    }

    @Override
    public void freeTemp(int n) {
        --this.cur_temp_count;
    }

    @Override
    public int getTempCount() {
        return this.max_temp_count;
    }

    public void stack(int n) {
        this.cur_stack += n;
        if (this.cur_stack > this.max_stack) {
            this.max_stack = this.cur_stack;
        }
    }

    public void saveStackDepth() {
        this.stackDepthStack.add(this.cur_stack);
    }

    public void restoreStackDepth() {
        this.cur_stack = this.stackDepthStack.removeLast();
    }

    @Override
    public int getIP() {
        return 0;
    }

    @Override
    public void Break(int n) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(new StringBuffer().append(" Break target ").append(n).toString());
        }
        if (n >= 0 && n < this.break_addrs.size()) {
            this.AddStmtToBlock("Break");
            ((IntList)this.break_addrs.get(n)).add(this.cur_block);
        }
        this.EnterBlock();
    }

    @Override
    public void Continue(int n) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(new StringBuffer().append(" Continue ").append(n).toString());
        }
        if (n >= 0 && n < this.continue_addrs.size()) {
            this.AddStmtToBlock("Continue");
            ((IntList)this.continue_addrs.get(n)).add(this.cur_block);
        }
        this.EnterBlock();
    }

    @Override
    public void CaseLabel(boolean bl) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            if (bl) {
                System.out.print(" CaseLabel default");
            } else {
                System.out.print(" CaseLabel");
            }
        }
        this.EnterBlock();
        if (this.case_addrs.last().size() != 0) {
            this.AddEdge(this.cur_block - 1, this.cur_block);
        }
        if (bl) {
            if (this.seen_default_case.last() == 0) {
                this.default_addrs.add(this.cur_block);
                this.case_addrs.last().add(this.cur_block);
                this.seen_default_case.set(this.seen_default_case.size() - 1, 1);
            }
        } else {
            this.case_addrs.last().add(this.cur_block);
        }
    }

    @Override
    public void Try(boolean bl) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" Try");
        }
        ++this.within_try_block;
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
        this.try_addrs.add(this.cur_block);
        this.catch_addrs.add(new IntList());
    }

    @Override
    public void CatchClausesBegin() {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" CatchClausesBegin");
        }
    }

    @Override
    public void Catch(TypeValue typeValue, QName qName) {
        this.EnterBlock();
        this.catch_addrs.last().add(this.cur_block);
    }

    @Override
    public void CatchClausesEnd() {
        int n;
        Object object;
        if (this.show_linenums) {
            object = new int[1];
            int[] nArray = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, (int[])object, nArray);
            System.out.print(new StringBuffer().append("\n[Ln ").append((int)object[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" CatchClausesEnd");
        }
        if (this.within_try_block > 0) {
            --this.within_try_block;
        }
        this.EnterBlock();
        object = this.catch_addrs.last();
        int n2 = this.try_addrs.last();
        int n3 = ((IntList)object).at(0);
        for (n = n2; n < n3; ++n) {
            int n4 = ((IntList)object).size();
            for (int i = 0; i < n4; ++i) {
                this.AddEdge(n, ((IntList)object).at(i));
            }
        }
        for (n = n2; n < this.cur_block; ++n) {
            this.AddEdge(n, this.cur_block);
        }
    }

    @Override
    public void FinallyClauseEnd() {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" FinallyClauseEnd");
        }
        this.try_addrs.pop_back();
        this.catch_addrs.pop_back();
    }

    @Override
    public void Throw() {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" Throw");
        }
        if (this.within_try_block == 0) {
            this.AddStmtToBlock("Throw");
            this.EnterTerminalBlock();
        }
    }

    @Override
    public void SwitchTable() {
        Object object;
        if (this.show_linenums) {
            int[] nArray = new int[1];
            object = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, (int[])object);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" SwitchTable");
        }
        this.AddStmtToBlock("SwitchTable");
        int n = this.default_addrs.last();
        this.default_addrs.removeLast();
        this.AddEdge(this.cur_block, n);
        object = this.case_addrs.removeLast();
        for (int i = 0; i < ((IntList)object).size(); ++i) {
            this.AddEdge(this.cur_block, ((IntList)object).get(i));
        }
        this.EnterBlock();
    }

    @Override
    public void If(int n) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" If");
        }
        this.AddStmtToBlock("If");
        this.if_addrs.add(this.GetBlock());
        this.saveStackDepth();
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
    }

    @Override
    public void PatchIf(int n) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" PatchIf");
        }
        this.restoreStackDepth();
        int n2 = this.if_addrs.last();
        this.if_addrs.removeLast();
        this.EnterBlock();
        this.AddEdge(n2, this.cur_block);
    }

    @Override
    public void Else() {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" Else");
        }
        this.else_addrs.add(this.GetBlock());
        this.EnterBlock();
    }

    @Override
    public void PatchBreak(int n) {
        Object object;
        if (this.show_linenums) {
            object = new int[1];
            int[] nArray = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, (int[])object, nArray);
            System.out.print(new StringBuffer().append("\n[Ln ").append((int)object[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(new StringBuffer().append(" PatchBreak ").append(n).toString());
        }
        object = this.break_addrs.removeLast();
        while (((IntList)object).size() != 0) {
            int n2 = ((IntList)object).last();
            this.AddEdge(n2, this.cur_block);
            ((IntList)object).removeLast();
        }
    }

    @Override
    public void PatchContinue(int n) {
        Object object;
        if (this.show_linenums) {
            object = new int[1];
            int[] nArray = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, (int[])object, nArray);
            System.out.print(new StringBuffer().append("\n[Ln ").append((int)object[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(new StringBuffer().append(" PatchContinue ").append(n).toString());
        }
        object = this.continue_addrs.removeLast();
        while (((IntList)object).size() != 0) {
            int n2 = ((IntList)object).last();
            this.AddEdge(n2, this.cur_block);
            ((IntList)object).removeLast();
        }
    }

    @Override
    public void PatchElse(int n) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" PatchElse");
        }
        int n2 = this.else_addrs.last();
        this.else_addrs.removeLast();
        this.EnterBlock();
        this.AddEdge(n2, this.cur_block);
        this.AddEdge(this.cur_block - 1, this.cur_block);
    }

    @Override
    public void Return(int n) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" Return");
        }
        this.AddStmtToBlock("Return");
        if (this.within_try_block == 0) {
            this.EnterTerminalBlock();
        }
    }

    @Override
    public void LabelStatementBegin() {
        this.break_addrs.add(new IntList());
    }

    @Override
    public void LabelStatementEnd(int n) {
        this.PatchBreak(n);
    }

    @Override
    public void LoopBegin() {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" LoopBegin");
        }
        this.AddStmtToBlock("LoopBegin");
        this.break_addrs.add(new IntList());
        this.continue_addrs.add(new IntList());
        this.loopbegin_addrs.add(this.cur_block + 1);
        this.with_count.add(this.current_with_count);
        this.EnterBlock();
    }

    @Override
    public void LoopEnd(int n) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" LoopEnd");
        }
        this.AddEdge(this.cur_block, this.loopbegin_addrs.last());
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
        this.loopbegin_addrs.removeLast();
        this.with_count.pop_back();
    }

    @Override
    public void PatchLoopBegin(int n) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(new StringBuffer().append(" PatchLoopBegin ").append(n).toString());
        }
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
        this.AddEdge(this.loopbegin_addrs.last() - 1, this.cur_block);
    }

    @Override
    public void PatchSwitchBegin(int n) {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(new StringBuffer().append(" PatchSwitchBegin ").append(n).toString());
        }
        int n2 = this.switchbegin_addrs.last();
        this.seen_default_case.removeLast();
        this.switchbegin_addrs.removeLast();
        this.EnterBlock();
        this.AddEdge(n2, this.cur_block);
    }

    @Override
    public void SwitchBegin() {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            System.out.print(new StringBuffer().append("\n[Ln ").append(nArray[0]).append("]").toString());
        }
        if (this.show_instructions) {
            System.out.print(" SwitchBegin");
        }
        this.AddStmtToBlock("SwitchBegin");
        this.seen_default_case.add(0);
        this.case_addrs.add(new IntList());
        this.break_addrs.add(new IntList());
        this.continue_addrs.add(new IntList());
        this.switchbegin_addrs.add(this.GetBlock());
        this.EnterBlock();
    }

    public FlowGraphEmitter(Context context, String string, boolean bl) {
        this.cx = context;
        this.scriptname = string;
        this.def_count = 0;
        this.cur_block = 0;
        this.hasLeader = true;
        this.show_instructions = false;
        this.show_linenums = false;
        this.show_blocks = bl;
        this.within_try_block = 0;
        this.InitGraph();
        this.EnterBlock();
    }

    @Override
    public ByteList emit(ByteList byteList) {
        return byteList;
    }

    static {
        $assertionsDisabled = true;
    }
}

