/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import macromedia.abc.ByteArray;
import macromedia.abc.ByteArrayPool;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.Decoder;
import macromedia.abc.DecoderException;
import macromedia.abc.Visitor;
import macromedia.asc.util.IntList;
import macromedia.asc.util.IntegerPool;

public class Encoder
implements Visitor {
    private ConstantPool pool;
    private int majorVersion;
    private int minorVersion;
    private int poolIndex;
    private int opcodePass;
    private int exPass;
    private boolean disableDebugging;
    private boolean removeMetadata;
    private boolean peepHole;
    private HashSet<String> keep_metadata = new HashSet();
    private BytecodeBuffer2 methodInfo;
    private ByteArrayPool2 metadataInfo;
    private BytecodeBuffer2 classInfo;
    private BytecodeBuffer2 scriptInfo;
    private BytecodeBuffer2 methodBodies;
    private BytecodeBuffer3 opcodes;
    private BytecodeBuffer exceptions;
    private BytecodeBuffer currentBuffer;
    private ConstantPool[] pools;
    static final int W = 8;
    int[] window = new int[8];
    int window_size = 0;
    int head = 0;
    boolean reachable = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Encoder(int n, int n2) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.poolIndex = 0;
        this.peepHole = false;
        this.disableDebugging = false;
        this.removeMetadata = false;
    }

    public void enablePeepHole() {
        this.peepHole = true;
    }

    public void disableDebugging() {
        this.disableDebugging = true;
        this.pool.history.disableDebugging();
    }

    public void removeMetadata() {
        this.removeMetadata = true;
    }

    public void addMetadataToKeep(String string) {
        this.keep_metadata.add(string);
    }

    public void addConstantPools(ConstantPool[] constantPoolArray) throws DecoderException {
        this.pools = constantPoolArray;
        this.pool = ConstantPool.merge(constantPoolArray);
        if (this.disableDebugging) {
            this.pool.history.disableDebugging();
        }
    }

    public void test() throws DecoderException {
        int n = this.pools.length;
        for (int i = 0; i < n; ++i) {
        }
    }

    public void configure(Decoder[] decoderArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[decoderArray.length];
        int n4 = nArray.length;
        for (n = 0; n < n4; ++n) {
            n2 += decoderArray[n].methodInfo.estimatedSize;
            nArray[n] = decoderArray[n].methodInfo.size();
            n3 += nArray[n];
        }
        this.methodInfo = new BytecodeBuffer2(n2, nArray);
        this.methodInfo.writeU32(n3);
        n2 = 0;
        n3 = 0;
        nArray = new int[decoderArray.length];
        n4 = nArray.length;
        for (n = 0; n < n4; ++n) {
            n2 += decoderArray[n].metadataInfo.estimatedSize;
            nArray[n] = decoderArray[n].metadataInfo.size();
            n3 += nArray[n];
        }
        this.metadataInfo = new ByteArrayPool2(this, nArray);
        n2 = 0;
        n3 = 0;
        nArray = new int[decoderArray.length];
        n4 = nArray.length;
        for (n = 0; n < n4; ++n) {
            n2 += decoderArray[n].classInfo.estimatedSize;
            nArray[n] = decoderArray[n].classInfo.size();
            n3 += nArray[n];
        }
        this.classInfo = new BytecodeBuffer2(n2, nArray);
        this.classInfo.writeU32(n3);
        n2 = 0;
        n3 = 0;
        nArray = new int[decoderArray.length];
        n4 = nArray.length;
        for (n = 0; n < n4; ++n) {
            n2 += decoderArray[n].scriptInfo.estimatedSize;
            nArray[n] = decoderArray[n].scriptInfo.size();
            n3 += nArray[n];
        }
        this.scriptInfo = new BytecodeBuffer2(n2, nArray);
        this.scriptInfo.writeU32(n3);
        n2 = 0;
        n3 = 0;
        nArray = new int[decoderArray.length];
        n4 = nArray.length;
        for (n = 0; n < n4; ++n) {
            n2 += decoderArray[n].methodBodies.estimatedSize;
            nArray[n] = decoderArray[n].methodBodies.size();
            n3 += nArray[n];
        }
        this.methodBodies = new BytecodeBuffer2(n2, nArray);
        this.methodBodies.writeU32(n3);
        this.opcodes = new BytecodeBuffer3(decoderArray, 4096);
        this.exceptions = new BytecodeBuffer(4096);
    }

    public void useConstantPool(int n) {
        this.poolIndex = n;
    }

    public byte[] toABC() {
        int n = this.pool.in.size() + this.methodInfo.size() + this.metadataInfo.size() + this.classInfo.size() + this.scriptInfo.size() + this.methodBodies.size();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            byteArrayOutputStream.write((byte)this.minorVersion);
            byteArrayOutputStream.write((byte)(this.minorVersion >> 8));
            byteArrayOutputStream.write((byte)this.majorVersion);
            byteArrayOutputStream.write((byte)(this.majorVersion >> 8));
            this.pool.writeTo(byteArrayOutputStream);
            this.methodInfo.writeTo(byteArrayOutputStream);
            this.metadataInfo.writeTo(byteArrayOutputStream);
            this.classInfo.writeTo(byteArrayOutputStream);
            this.scriptInfo.writeTo(byteArrayOutputStream);
            this.methodBodies.writeTo(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void methodInfo(int n, int[] nArray, int n2, int n3, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n4;
        int n5;
        if (nArray == null) {
            this.methodInfo.writeU32(0L);
        } else {
            this.methodInfo.writeU32(nArray.length);
        }
        this.methodInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        int n6 = n5 = nArray == null ? 0 : nArray.length;
        for (n4 = 0; n4 < n5; ++n4) {
            this.methodInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 6, nArray[n4]));
        }
        this.methodInfo.writeU32(this.disableDebugging ? 0L : (long)this.pool.history.getIndex(this.poolIndex, 3, n2));
        if (this.disableDebugging) {
            n3 &= 0xFFFFFF7F;
        }
        this.methodInfo.writeU8(n3);
        if ((n3 & 8) != 0) {
            if (nArray2 == null) {
                this.methodInfo.writeU32(0L);
            } else {
                this.methodInfo.writeU32(nArray2.length);
            }
        }
        int n7 = n5 = nArray2 == null ? 0 : nArray2.length;
        for (n4 = 0; n4 < n5; ++n4) {
            int n8 = -1;
            switch (nArray3[n4]) {
                case 1: {
                    n8 = 3;
                    break;
                }
                case 3: {
                    n8 = 0;
                    break;
                }
                case 4: {
                    n8 = 1;
                    break;
                }
                case 6: {
                    n8 = 2;
                    break;
                }
                case 5: 
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    n8 = 4;
                    break;
                }
                case 7: 
                case 9: 
                case 13: 
                case 14: {
                    n8 = 6;
                    break;
                }
                case 21: {
                    n8 = 5;
                }
            }
            int n9 = 0;
            switch (nArray3[n4]) {
                case 0: 
                case 10: 
                case 11: 
                case 12: {
                    n9 = nArray2[n4];
                    break;
                }
                default: {
                    if (n8 == -1) {
                        System.out.println("writing MethodInfo: don't know what constant type it is... " + nArray3[n4] + "," + nArray2[n4]);
                    }
                    n9 = this.pool.history.getIndex(this.poolIndex, n8, nArray2[n4]);
                }
            }
            this.methodInfo.writeU32(n9);
            this.methodInfo.writeU8(nArray3[n4]);
        }
        if ((n3 & 0x80) != 0 && nArray4 != null) {
            for (n4 = 0; n4 < nArray4.length; ++n4) {
                this.methodInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 3, n));
            }
        }
    }

    public void metadataInfo(int n, int n2, int[] nArray, int[] nArray2) {
        try {
            int n3;
            int n4;
            String string = this.pools[this.poolIndex].getString(n2);
            if (this.removeMetadata && !this.keep_metadata.contains(string)) {
                return;
            }
            BytecodeBuffer bytecodeBuffer = new BytecodeBuffer(6);
            bytecodeBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 3, n2));
            if (nArray == null) {
                bytecodeBuffer.writeU32(0L);
            } else {
                bytecodeBuffer.writeU32(nArray.length);
            }
            int n5 = n4 = nArray == null ? 0 : nArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                bytecodeBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 3, nArray[n3]));
            }
            int n6 = n4 = nArray2 == null ? 0 : nArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                bytecodeBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 3, nArray2[n3]));
            }
            this.metadataInfo.addByteArray(this.poolIndex, n, bytecodeBuffer);
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    public void startInstance(int n, int n2, boolean bl, boolean bl2, boolean bl3, int[] nArray, int n3, int n4) {
        int n5;
        this.classInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        this.classInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n2));
        int n6 = 0;
        n6 = bl2 ? n6 | 2 : n6;
        n6 = !bl ? n6 | 1 : n6;
        n6 = bl3 ? n6 | 4 : n6;
        n6 = n4 != 0 ? n6 | 8 : n6;
        this.classInfo.writeU8(n6);
        if (n4 != 0) {
            this.classInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 4, n4));
        }
        if (nArray == null) {
            this.classInfo.writeU32(0L);
        } else {
            this.classInfo.writeU32(nArray.length);
        }
        int n7 = n5 = nArray == null ? 0 : nArray.length;
        for (int i = 0; i < n5; ++i) {
            this.classInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 6, nArray[i]));
        }
        this.classInfo.writeU32(this.methodInfo.getIndex(this.poolIndex, n3));
        this.currentBuffer = this.classInfo;
    }

    public void endInstance() {
        this.currentBuffer = null;
    }

    public void startClass(int n, int n2) {
        this.classInfo.writeU32(this.methodInfo.getIndex(this.poolIndex, n2));
        this.currentBuffer = this.classInfo;
    }

    public void endClass() {
        this.currentBuffer = null;
    }

    public void startScript(int n) {
        this.scriptInfo.writeU32(this.methodInfo.getIndex(this.poolIndex, n));
        this.currentBuffer = this.scriptInfo;
    }

    public void endScript() {
        this.currentBuffer = null;
    }

    public void startMethodBody(int n, int n2, int n3, int n4, int n5, int n6, long l) {
        this.methodBodies.writeU32(this.methodInfo.getIndex(this.poolIndex, n));
        this.methodBodies.writeU32(n2);
        this.methodBodies.writeU32(n3);
        this.methodBodies.writeU32(n4);
        this.methodBodies.writeU32(n5);
        this.currentBuffer = this.methodBodies;
        this.opcodePass = 1;
        this.exPass = 1;
    }

    public void endMethodBody() {
        this.currentBuffer = null;
        this.opcodes.clear();
        this.exceptions.clear();
    }

    public void startOpcodes(int n) {
    }

    public void endOpcodes() {
        if (this.opcodePass == 1) {
            this.opcodePass = 2;
        } else if (this.opcodePass == 2) {
            this.methodBodies.writeU32(this.opcodes.size());
            this.methodBodies.writeBytes(this.opcodes, 0, this.opcodes.size());
        }
    }

    public void exception(long l, long l2, long l3, int n, int n2) {
        if (this.exPass == 2) {
            this.exceptions.writeU32(this.opcodes.getOffset(l));
            this.exceptions.writeU32(this.opcodes.getOffset(l2));
            this.exceptions.writeU32(this.opcodes.getOffset(l3));
            this.exceptions.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
            if (this.minorVersion != 15) {
                this.exceptions.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n2));
            }
        }
    }

    public void startExceptions(int n) {
        if (this.exPass == 2) {
            this.exceptions.writeU32(n);
        }
    }

    public void endExceptions() {
        if (this.exPass == 1) {
            ++this.exPass;
        } else if (this.exPass == 2) {
            this.methodBodies.writeBytes(this.exceptions, 0, this.exceptions.size());
        }
    }

    public void traitCount(int n) {
        this.currentBuffer.writeU32(n);
    }

    private void encodeMetaData(int n, IntList intList) {
        if ((n >> 4 & 4) != 0) {
            int n2;
            if (intList == null) {
                this.currentBuffer.writeU32(0L);
            } else {
                this.currentBuffer.writeU32(intList.size());
            }
            int n3 = n2 = intList == null ? 0 : intList.size();
            for (int i = 0; i < n2; ++i) {
                this.currentBuffer.writeU32(intList.get(i));
            }
        }
    }

    private IntList trimMetadata(int[] nArray) {
        IntList intList = new IntList();
        int n = nArray != null ? nArray.length : 0;
        for (int i = 0; i < n; ++i) {
            int n2 = this.metadataInfo.getIndex(this.poolIndex, nArray[i]);
            if (n2 == -1) continue;
            intList.add(n2);
        }
        return intList;
    }

    public void slotTrait(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n2));
        IntList intList = this.trimMetadata(nArray);
        if ((n >> 4 & 4) != 0 && intList.size() == 0) {
            n &= 0xFFFFFFBF;
        }
        this.currentBuffer.writeU8(n);
        this.currentBuffer.writeU32(n3);
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n4));
        int n7 = -1;
        switch (n6) {
            case 1: {
                n7 = 3;
                break;
            }
            case 3: {
                n7 = 0;
                break;
            }
            case 4: {
                n7 = 1;
                break;
            }
            case 6: {
                n7 = 2;
                break;
            }
            case 5: 
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n7 = 4;
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 14: {
                n7 = 6;
                break;
            }
            case 21: {
                n7 = 5;
            }
        }
        int n8 = 0;
        switch (n6) {
            case 0: 
            case 10: 
            case 11: 
            case 12: {
                n8 = n5;
                break;
            }
            default: {
                if (n7 == -1) {
                    System.out.println("writing slotTrait: don't know what constant type it is... " + n6 + "," + n5);
                }
                n8 = this.pool.history.getIndex(this.poolIndex, n7, n5);
            }
        }
        this.currentBuffer.writeU32(n8);
        if (n5 != 0) {
            this.currentBuffer.writeU8(n6);
        }
        this.encodeMetaData(n, intList);
    }

    public void methodTrait(int n, int n2, int n3, int n4, int[] nArray) {
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n2));
        IntList intList = this.trimMetadata(nArray);
        if ((n >> 4 & 4) != 0 && intList.size() == 0) {
            n &= 0xFFFFFFBF;
        }
        this.currentBuffer.writeU8(n);
        this.currentBuffer.writeU32(n3);
        this.currentBuffer.writeU32(this.methodInfo.getIndex(this.poolIndex, n4));
        this.encodeMetaData(n, intList);
    }

    public void classTrait(int n, int n2, int n3, int n4, int[] nArray) {
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n2));
        IntList intList = this.trimMetadata(nArray);
        if ((n >> 4 & 4) != 0 && intList.size() == 0) {
            n &= 0xFFFFFFBF;
        }
        this.currentBuffer.writeU8(n);
        this.currentBuffer.writeU32(n3);
        this.currentBuffer.writeU32(this.classInfo.getIndex(this.poolIndex, n4));
        this.encodeMetaData(n, intList);
    }

    public void functionTrait(int n, int n2, int n3, int n4, int[] nArray) {
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n2));
        IntList intList = this.trimMetadata(nArray);
        if ((n >> 4 & 4) != 0 && intList.size() == 0) {
            n &= 0xFFFFFFBF;
        }
        this.currentBuffer.writeU8(n);
        this.currentBuffer.writeU32(n3);
        this.currentBuffer.writeU32(this.methodInfo.getIndex(this.poolIndex, n4));
        this.encodeMetaData(n, intList);
    }

    void clearWindow() {
        for (int i = 0; i < 8; ++i) {
            this.window[i] = 0;
        }
        this.window_size = 0;
    }

    void beginop(int n) {
        this.window[this.head] = this.opcodes.size();
        this.head = this.head + 1 & 7;
        if (this.window_size < 8) {
            ++this.window_size;
        }
        this.opcodes.writeU8(n);
    }

    int opat(int n) {
        int n2;
        if (this.peepHole && n <= this.window_size && (n2 = this.window[this.head - n & 7]) < this.opcodes.size()) {
            return this.opcodes.readU8(n2);
        }
        return 0;
    }

    void setOpcodeAt(int n, int n2) {
        int n3;
        if (!$assertionsDisabled && !this.peepHole) {
            throw new Error();
        }
        if (n <= this.window_size && (n3 = this.window[this.head - n & 7]) < this.opcodes.size()) {
            this.opcodes.writeU8(n3, n2);
        }
    }

    int readByteAt(int n) {
        if (n <= this.window_size) {
            int n2 = 1 + this.window[this.head - n & 7];
            return (byte)this.opcodes.readU8(n2);
        }
        return 0;
    }

    int readIntAt(int n) {
        if (n <= this.window_size) {
            int n2 = 1 + this.window[this.head - n & 7];
            return (int)this.opcodes.readU32(n2);
        }
        return 0;
    }

    void rewind(int n) {
        int n2 = this.head - n & 7;
        int n3 = this.window[n2];
        int n4 = this.opcodes.size();
        this.opcodes.delete(n4 - n3);
        this.head = n2;
        this.window_size -= n;
    }

    public void target(int n) {
        if (this.opcodePass == 1) {
            this.opcodes.mapOffsets(n);
            this.clearWindow();
        }
    }

    public void OP_returnvoid() {
        if (this.opcodePass == 1) {
            this.beginop(71);
        }
    }

    public void OP_returnvalue() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            if (this.opat(1) == 33) {
                this.rewind(1);
                this.OP_returnvoid();
                return;
            }
            this.beginop(72);
        }
    }

    public void OP_nop() {
        if (this.opcodePass == 1) {
            this.beginop(2);
        }
    }

    public void OP_bkpt() {
        if (this.opcodePass == 1) {
            this.beginop(1);
        }
    }

    public void OP_timestamp() {
        if (this.opcodePass == 1) {
            this.beginop(243);
        }
    }

    public void OP_debugline(int n) {
        if (this.opcodePass == 1 && !this.disableDebugging) {
            this.beginop(240);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_bkptline() {
        if (this.opcodePass == 1) {
            this.beginop(242);
        }
    }

    public void OP_debug(int n, int n2, int n3, int n4) {
        if (this.opcodePass == 1 && !this.disableDebugging) {
            this.beginop(239);
            this.opcodes.writeU8(n);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 3, n2));
            this.opcodes.writeU8(n3);
            this.opcodes.writeU32(n4);
        }
    }

    public void OP_debugfile(int n) {
        if (this.opcodePass == 1 && !this.disableDebugging) {
            this.beginop(241);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 3, n));
        }
    }

    public void OP_jump(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(16);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_pushnull() {
        if (this.opcodePass == 1) {
            this.beginop(32);
        }
    }

    public void OP_pushundefined() {
        if (this.opcodePass == 1) {
            this.beginop(33);
        }
    }

    public void OP_pushstring(int n) {
        if (this.opcodePass == 1) {
            this.beginop(44);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 3, n));
        }
    }

    public void OP_pushnamespace(int n) {
        if (this.opcodePass == 1) {
            this.beginop(49);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 4, n));
        }
    }

    public void OP_pushint(int n) {
        if (this.opcodePass == 1) {
            this.beginop(45);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 0, n));
        }
    }

    public void OP_pushuint(int n) {
        if (this.opcodePass == 1) {
            this.beginop(46);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 1, n));
        }
    }

    public void OP_pushdouble(int n) {
        if (this.opcodePass == 1) {
            this.beginop(47);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 2, n));
        }
    }

    public void OP_getlocal(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 99 && this.readIntAt(1) == n) {
                this.rewind(1);
                this.OP_dup();
                this.OP_setlocal(n);
                return;
            }
            this.beginop(98);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_pushtrue() {
        if (this.opcodePass == 1) {
            this.beginop(38);
        }
    }

    public void OP_pushfalse() {
        if (this.opcodePass == 1) {
            this.beginop(39);
        }
    }

    public void OP_pushnan() {
        if (this.opcodePass == 1) {
            this.beginop(40);
        }
    }

    public void OP_pop() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 70: {
                    this.setOpcodeAt(1, 79);
                    return;
                }
                case 69: {
                    this.setOpcodeAt(1, 78);
                    return;
                }
            }
            this.beginop(41);
        }
    }

    public void OP_dup() {
        if (this.opcodePass == 1) {
            this.beginop(42);
        }
    }

    public void OP_swap() {
        if (this.opcodePass == 1) {
            this.beginop(43);
        }
    }

    public void OP_convert_s() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            switch (this.opat(1)) {
                case 44: 
                case 112: 
                case 133: 
                case 149: {
                    return;
                }
            }
            if (this.opat(2) == 44 && this.opat(1) == 160) {
                return;
            }
            this.beginop(112);
        }
    }

    public void OP_esc_xelem() {
        if (this.opcodePass == 1) {
            this.beginop(113);
        }
    }

    public void OP_esc_xattr() {
        if (this.opcodePass == 1) {
            this.beginop(114);
        }
    }

    public void OP_checkfilter() {
        if (this.opcodePass == 1) {
            this.beginop(120);
        }
    }

    public void OP_convert_d() {
        if (this.opcodePass == 1) {
            this.beginop(117);
        }
    }

    public void OP_convert_b() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 38: 
                case 39: 
                case 106: 
                case 118: 
                case 150: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    return;
                }
            }
            this.beginop(118);
        }
    }

    public void OP_convert_o() {
        if (this.opcodePass == 1) {
            this.beginop(119);
        }
    }

    public void OP_negate() {
        if (this.opcodePass == 1) {
            this.beginop(144);
        }
    }

    public void OP_negate_i() {
        if (this.opcodePass == 1) {
            this.beginop(196);
        }
    }

    public void OP_increment() {
        if (this.opcodePass == 1) {
            this.beginop(145);
        }
    }

    public void OP_increment_i() {
        if (this.opcodePass == 1) {
            this.beginop(192);
        }
    }

    public void OP_inclocal(int n) {
        if (this.opcodePass == 1) {
            this.beginop(146);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_kill(int n) {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 71: 
                case 72: {
                    return;
                }
            }
            this.beginop(8);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_inclocal_i(int n) {
        if (this.opcodePass == 1) {
            this.beginop(194);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_decrement() {
        if (this.opcodePass == 1) {
            this.beginop(147);
        }
    }

    public void OP_decrement_i() {
        if (this.opcodePass == 1) {
            this.beginop(193);
        }
    }

    public void OP_declocal(int n) {
        if (this.opcodePass == 1) {
            this.beginop(148);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_declocal_i(int n) {
        if (this.opcodePass == 1) {
            this.beginop(195);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_typeof() {
        if (this.opcodePass == 1) {
            this.beginop(149);
        }
    }

    public void OP_not() {
        if (this.opcodePass == 1) {
            this.beginop(150);
        }
    }

    public void OP_bitnot() {
        if (this.opcodePass == 1) {
            this.beginop(151);
        }
    }

    public void OP_setlocal(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(2) == 98 && this.readIntAt(2) == n && this.opat(1) == 192) {
                this.rewind(2);
                this.OP_inclocal_i(n);
                return;
            }
            if (this.opat(2) == 98 && this.readIntAt(2) == n && this.opat(1) == 145) {
                this.rewind(2);
                this.OP_inclocal(n);
                return;
            }
            this.beginop(99);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_add() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(160);
        }
    }

    public void OP_add_i() {
        if (this.opcodePass == 1) {
            this.beginop(197);
        }
    }

    public void OP_subtract() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 36 && this.readByteAt(1) == 1) {
                this.rewind(1);
                this.OP_decrement();
                return;
            }
            this.beginop(161);
        }
    }

    public void OP_subtract_i() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 36 && this.readIntAt(1) == 1) {
                this.rewind(1);
                this.OP_decrement_i();
                return;
            }
            this.beginop(198);
        }
    }

    public void OP_multiply() {
        if (this.opcodePass == 1) {
            this.beginop(162);
        }
    }

    public void OP_multiply_i() {
        if (this.opcodePass == 1) {
            this.beginop(199);
        }
    }

    public void OP_divide() {
        if (this.opcodePass == 1) {
            this.beginop(163);
        }
    }

    public void OP_modulo() {
        if (this.opcodePass == 1) {
            this.beginop(164);
        }
    }

    public void OP_lshift() {
        if (this.opcodePass == 1) {
            this.beginop(165);
        }
    }

    public void OP_rshift() {
        if (this.opcodePass == 1) {
            this.beginop(166);
        }
    }

    public void OP_urshift() {
        if (this.opcodePass == 1) {
            this.beginop(167);
        }
    }

    public void OP_bitand() {
        if (this.opcodePass == 1) {
            this.beginop(168);
        }
    }

    public void OP_bitor() {
        if (this.opcodePass == 1) {
            this.beginop(169);
        }
    }

    public void OP_bitxor() {
        if (this.opcodePass == 1) {
            this.beginop(170);
        }
    }

    public void OP_equals() {
        if (this.opcodePass == 1) {
            this.beginop(171);
        }
    }

    public void OP_strictequals() {
        if (this.opcodePass == 1) {
            this.beginop(172);
        }
    }

    public void OP_lookupswitch(int n, int[] nArray, int n2, int n3) {
        block3: {
            block2: {
                if (this.opcodePass != 1) break block2;
                this.opcodes.mapOffsets(n2);
                this.beginop(27);
                this.opcodes.mapOffsets(n2 + 1);
                this.opcodes.writeS24(n);
                this.opcodes.writeU32(nArray == null || nArray.length == 0 ? 0L : (long)(nArray.length - 1));
                int n4 = nArray.length;
                for (int i = 0; i < n4; ++i) {
                    this.opcodes.mapOffsets(n3 + 3 * i);
                    this.opcodes.writeS24(nArray[i]);
                }
                break block3;
            }
            if (this.opcodePass != 2) break block3;
            this.opcodes.updateOffset(n2 + 1, n2, n2 + n);
            int n5 = nArray.length;
            for (int i = 0; i < n5; ++i) {
                this.opcodes.updateOffset(n3 + 3 * i, n2, n2 + nArray[i]);
            }
        }
    }

    public void OP_iftrue(int n, int n2) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 118) {
                this.rewind(1);
            }
            if (this.opat(1) == 38) {
                this.rewind(1);
                this.OP_jump(n, n2);
                return;
            }
            this.beginop(17);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_iffalse(int n, int n2) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 118) {
                this.rewind(1);
            }
            if (this.opat(2) == 172 && this.opat(1) == 150) {
                this.rewind(2);
                this.OP_ifstricteq(n, n2);
                return;
            }
            if (this.opat(2) == 171 && this.opat(1) == 150) {
                this.rewind(2);
                this.OP_ifeq(n, n2);
                return;
            }
            if (this.opat(1) == 150) {
                this.rewind(1);
                this.OP_iftrue(n, n2);
                return;
            }
            if (this.opat(1) == 39) {
                this.rewind(1);
                this.OP_jump(n, n2);
                return;
            }
            this.beginop(18);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifeq(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(19);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifne(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(20);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifstricteq(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(25);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifstrictne(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(26);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_iflt(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(21);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifle(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(22);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifgt(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(23);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifge(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(24);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_lessthan() {
        if (this.opcodePass == 1) {
            this.beginop(173);
        }
    }

    public void OP_lessequals() {
        if (this.opcodePass == 1) {
            this.beginop(174);
        }
    }

    public void OP_greaterthan() {
        if (this.opcodePass == 1) {
            this.beginop(175);
        }
    }

    public void OP_greaterequals() {
        if (this.opcodePass == 1) {
            this.beginop(176);
        }
    }

    public void OP_newobject(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130 && n >= 1) {
                this.rewind(1);
            }
            this.beginop(85);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_newarray(int n) {
        if (this.opcodePass == 1) {
            this.beginop(86);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_getproperty(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 93 && this.readIntAt(1) == this.pool.history.getIndex(this.poolIndex, 6, n)) {
                this.rewind(1);
                this.OP_getlex(n);
                return;
            }
            this.beginop(102);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_setproperty(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(97);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_initproperty(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(104);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_getdescendants(int n) {
        if (this.opcodePass == 1) {
            this.beginop(89);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_findpropstrict(int n) {
        if (this.opcodePass == 1) {
            this.beginop(93);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_findproperty(int n) {
        if (this.opcodePass == 1) {
            this.beginop(94);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_finddef(int n) {
        if (this.opcodePass == 1) {
            this.beginop(95);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_getlex(int n) {
        if (this.opcodePass == 1) {
            this.beginop(96);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_nextname() {
        if (this.opcodePass == 1) {
            this.beginop(30);
        }
    }

    public void OP_nextvalue() {
        if (this.opcodePass == 1) {
            this.beginop(35);
        }
    }

    public void OP_hasnext() {
        if (this.opcodePass == 1) {
            this.beginop(31);
        }
    }

    public void OP_hasnext2(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(50);
            this.opcodes.writeU32(n);
            this.opcodes.writeU32(n2);
        }
    }

    public void OP_deleteproperty(int n) {
        if (this.opcodePass == 1) {
            this.beginop(106);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_setslot(int n) {
        if (this.opcodePass == 1) {
            this.beginop(109);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_getslot(int n) {
        if (this.opcodePass == 1) {
            this.beginop(108);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_setglobalslot(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(111);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_getglobalslot(int n) {
        if (this.opcodePass == 1) {
            this.beginop(110);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_call(int n) {
        if (this.opcodePass == 1) {
            this.beginop(65);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_construct(int n) {
        if (this.opcodePass == 1) {
            this.beginop(66);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_newfunction(int n) {
        if (this.opcodePass == 1) {
            this.beginop(64);
            this.opcodes.writeU32(this.methodInfo.getIndex(this.poolIndex, n));
        }
    }

    public void OP_newclass(int n) {
        if (this.opcodePass == 1) {
            this.beginop(88);
            this.opcodes.writeU32(this.classInfo.getIndex(this.poolIndex, n));
        }
    }

    public void OP_callstatic(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(68);
            this.opcodes.writeU32(this.methodInfo.getIndex(this.poolIndex, n));
            this.opcodes.writeU32(n2);
        }
    }

    public void OP_callmethod(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(67);
            this.opcodes.writeU32(this.methodInfo.getIndex(this.poolIndex, n));
            this.opcodes.writeU32(n2);
        }
    }

    public void OP_callproperty(int n, int n2) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(70);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
            this.opcodes.writeU32(n2);
        }
    }

    public void OP_callproplex(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(76);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
            this.opcodes.writeU32(n2);
        }
    }

    public void OP_constructprop(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(74);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
            this.opcodes.writeU32(n2);
        }
    }

    public void OP_callsuper(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(69);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
            this.opcodes.writeU32(n2);
        }
    }

    public void OP_getsuper(int n) {
        if (this.opcodePass == 1) {
            this.beginop(4);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_setsuper(int n) {
        if (this.opcodePass == 1) {
            this.beginop(5);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_constructsuper(int n) {
        if (this.opcodePass == 1) {
            this.beginop(73);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_pushshort(int n) {
        if (this.opcodePass == 1) {
            if (this.peepHole && n >= -128 && n <= 127) {
                this.OP_pushbyte(n);
                return;
            }
            this.beginop(37);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_astype(int n) {
        if (this.opcodePass == 1) {
            this.beginop(134);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_astypelate() {
        if (this.opcodePass == 1) {
            this.beginop(135);
        }
    }

    public void OP_coerce(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 128 && this.readIntAt(1) == this.pool.history.getIndex(this.poolIndex, 6, n)) {
                return;
            }
            this.beginop(128);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_coerce_b() {
        if (this.opcodePass == 1) {
            this.beginop(129);
        }
    }

    public void OP_coerce_o() {
        if (this.opcodePass == 1) {
            this.beginop(137);
        }
    }

    public void OP_coerce_a() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                return;
            }
            this.beginop(130);
        }
    }

    public void OP_coerce_i() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 36: 
                case 37: 
                case 45: 
                case 115: 
                case 131: 
                case 151: 
                case 165: 
                case 166: 
                case 168: 
                case 169: 
                case 170: 
                case 192: 
                case 193: 
                case 197: 
                case 198: 
                case 199: {
                    return;
                }
            }
            this.beginop(131);
        }
    }

    public void OP_coerce_u() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 116: 
                case 136: 
                case 167: {
                    return;
                }
            }
            this.beginop(136);
        }
    }

    public void OP_coerce_d() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 117: 
                case 132: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    return;
                }
            }
            this.beginop(132);
        }
    }

    public void OP_coerce_s() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 44: 
                case 112: 
                case 133: 
                case 149: {
                    return;
                }
            }
            if (this.opat(2) == 44 && this.opat(1) == 160) {
                return;
            }
            this.beginop(133);
        }
    }

    public void OP_istype(int n) {
        if (this.opcodePass == 1) {
            this.beginop(178);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
        }
    }

    public void OP_istypelate() {
        if (this.opcodePass == 1) {
            this.beginop(179);
        }
    }

    public void OP_pushbyte(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 36 && this.readByteAt(1) == n || this.opat(1) == 42 && this.opat(2) == 36 && this.readByteAt(2) == n) {
                this.OP_dup();
                return;
            }
            this.beginop(36);
            this.opcodes.writeU8(n);
        }
    }

    public void OP_getscopeobject(int n) {
        if (this.opcodePass == 1) {
            this.beginop(101);
            this.opcodes.writeU8(n);
        }
    }

    public void OP_pushscope() {
        if (this.opcodePass == 1) {
            this.beginop(48);
        }
    }

    public void OP_popscope() {
        if (this.opcodePass == 1) {
            this.beginop(29);
        }
    }

    public void OP_convert_i() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 36: 
                case 37: 
                case 45: 
                case 115: 
                case 131: 
                case 165: 
                case 166: 
                case 168: 
                case 169: 
                case 170: 
                case 192: 
                case 193: 
                case 197: 
                case 198: 
                case 199: {
                    return;
                }
            }
            this.beginop(115);
        }
    }

    public void OP_convert_u() {
        if (this.opcodePass == 1) {
            this.beginop(116);
        }
    }

    public void OP_throw() {
        if (this.opcodePass == 1) {
            this.beginop(3);
        }
    }

    public void OP_instanceof() {
        if (this.opcodePass == 1) {
            this.beginop(177);
        }
    }

    public void OP_in() {
        if (this.opcodePass == 1) {
            this.beginop(180);
        }
    }

    public void OP_dxns(int n) {
        if (this.opcodePass == 1) {
            this.beginop(6);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 3, n));
        }
    }

    public void OP_dxnslate() {
        if (this.opcodePass == 1) {
            this.beginop(7);
        }
    }

    public void OP_ifnlt(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(12);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifnle(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(13);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifngt(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(14);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_ifnge(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(15);
            this.opcodes.writeS24(n);
            this.opcodes.mapOffsets(n2);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(n2 + n);
        }
    }

    public void OP_pushwith() {
        if (this.opcodePass == 1) {
            this.beginop(28);
        }
    }

    public void OP_newactivation() {
        if (this.opcodePass == 1) {
            this.beginop(87);
        }
    }

    public void OP_newcatch(int n) {
        if (this.opcodePass == 1) {
            this.beginop(90);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_deldescendants() {
        if (this.opcodePass == 1) {
            this.beginop(91);
        }
    }

    public void OP_getglobalscope() {
        if (this.opcodePass == 1) {
            this.beginop(100);
        }
    }

    public void OP_getlocal0() {
        if (this.opcodePass == 1) {
            this.beginop(208);
        }
    }

    public void OP_getlocal1() {
        if (this.opcodePass == 1) {
            this.beginop(209);
        }
    }

    public void OP_getlocal2() {
        if (this.opcodePass == 1) {
            this.beginop(210);
        }
    }

    public void OP_getlocal3() {
        if (this.opcodePass == 1) {
            this.beginop(211);
        }
    }

    public void OP_setlocal0() {
        if (this.opcodePass == 1) {
            this.beginop(212);
        }
    }

    public void OP_setlocal1() {
        if (this.opcodePass == 1) {
            if (this.opat(2) == 209 && this.opat(1) == 192) {
                this.rewind(2);
                this.OP_inclocal_i(1);
                return;
            }
            if (this.opat(2) == 209 && this.opat(1) == 145) {
                this.rewind(2);
                this.OP_inclocal(1);
                return;
            }
            this.beginop(213);
        }
    }

    public void OP_setlocal2() {
        if (this.opcodePass == 1) {
            if (this.opat(2) == 210 && this.opat(1) == 192) {
                this.rewind(2);
                this.OP_inclocal_i(2);
                return;
            }
            if (this.opat(2) == 210 && this.opat(1) == 145) {
                this.rewind(2);
                this.OP_inclocal(2);
                return;
            }
            this.beginop(214);
        }
    }

    public void OP_setlocal3() {
        if (this.opcodePass == 1) {
            if (this.opat(2) == 211 && this.opat(1) == 192) {
                this.rewind(2);
                this.OP_inclocal_i(3);
                return;
            }
            if (this.opat(2) == 211 && this.opat(1) == 145) {
                this.rewind(2);
                this.OP_inclocal(3);
                return;
            }
            this.beginop(215);
        }
    }

    public void OP_label() {
        if (this.opcodePass == 1) {
            this.beginop(9);
        }
    }

    public void OP_pushconstant(int n) {
        if (this.opcodePass == 1) {
            this.beginop(34);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_callsupervoid(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(78);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
            this.opcodes.writeU32(n2);
        }
    }

    public void OP_callpropvoid(int n, int n2) {
        if (this.opcodePass == 1) {
            this.beginop(79);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 6, n));
            this.opcodes.writeU32(n2);
        }
    }

    static {
        $assertionsDisabled = true;
    }

    class BytecodeBuffer3
    extends BytecodeBuffer {
        Map<Integer, Integer> offsets;
        Decoder[] decoders;

        BytecodeBuffer3(Decoder[] decoderArray, int n) {
            super(n);
            this.offsets = new HashMap<Integer, Integer>();
            this.decoders = decoderArray;
        }

        void mapOffsets(long l) {
            Integer n = IntegerPool.getNumber((int)l);
            Integer n2 = IntegerPool.getNumber(this.size());
            this.offsets.put(IntegerPool.getNumber(n), IntegerPool.getNumber(n2));
        }

        long getOffset(long l) {
            Integer n = this.offsets.get(IntegerPool.getNumber((int)l));
            if (n != null) {
                return n.intValue();
            }
            System.out.println("getOffset: can't match " + l + " with a new offset ");
            System.out.println(this.offsets);
            return 0L;
        }

        void updateOffset(long l) {
            Integer n = this.offsets.get(IntegerPool.getNumber((int)l));
            Integer n2 = this.offsets.get(IntegerPool.getNumber(this.decoders[Encoder.this.poolIndex].pos()));
            if (n != null && n2 != null) {
                this.writeS24(n2 - 3, n - n2);
            }
        }

        void updateOffset(long l, long l2, long l3) {
            Integer n = this.offsets.get(IntegerPool.getNumber((int)l3));
            Integer n2 = this.offsets.get(IntegerPool.getNumber((int)l2));
            Integer n3 = this.offsets.get(IntegerPool.getNumber((int)l));
            if (n != null && n2 != null && n3 != null) {
                this.writeS24(n3, n - n2);
            } else {
                if (n == null) {
                    System.out.println("updateOffset2: can't match i " + l3 + " with a new offset");
                }
                if (n2 == null) {
                    System.out.println("updateOffset2: can't match p " + l2 + " with a new offset");
                }
                if (n3 == null) {
                    System.out.println("updateOffset2: can't match s " + l + " with a new offset");
                }
                System.out.println(this.offsets);
            }
        }

        public void clear() {
            super.clear();
            this.offsets.clear();
        }
    }

    class BytecodeBuffer2
    extends BytecodeBuffer {
        private int[] sizes;
        int estimatedSize;

        BytecodeBuffer2(int n, int[] nArray) {
            super(n);
            this.sizes = nArray;
            this.estimatedSize = n;
        }

        int getIndex(int n, int n2) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n3 += this.sizes[i];
            }
            return n3 += n2;
        }
    }

    class ByteArrayPool2
    extends ByteArrayPool {
        int size = 0;
        private int[] sizes;
        private Map<Integer, Integer> indexes;
        final /* synthetic */ Encoder this$0;

        /*
         * WARNING - void declaration
         */
        ByteArrayPool2(Encoder encoder, int[] nArray) {
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.sizes = arg1;
            this.indexes = new HashMap<Integer, Integer>();
        }

        int addByteArray(int n, int n2, BytecodeBuffer bytecodeBuffer) {
            int n3 = this.contains(bytecodeBuffer, 0, bytecodeBuffer.size());
            if (n3 == -1) {
                n3 = this.store(bytecodeBuffer, 0, bytecodeBuffer.size());
                this.size += bytecodeBuffer.size();
            }
            this.indexes.put(IntegerPool.getNumber(this.calcIndex(n, n2)), IntegerPool.getNumber(n3 - 1));
            return n3;
        }

        private int calcIndex(int n, int n2) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n3 += this.sizes[i];
            }
            return n3 += n2;
        }

        int getIndex(int n, int n2) {
            int n3 = this.calcIndex(n, n2);
            Integer n4 = this.indexes.get(IntegerPool.getNumber(n3));
            return n4 != null ? n4 : -1;
        }

        int size() {
            return this.size;
        }

        void writeTo(BytecodeBuffer bytecodeBuffer) {
            Object object;
            Object object2;
            TreeMap treeMap = new TreeMap();
            Iterator iterator = this.map.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = this.map.get(object2);
                treeMap.put(object, object2);
            }
            bytecodeBuffer.writeU32(treeMap.size() == 0 ? 0L : (long)treeMap.size());
            iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                object = (ByteArray)treeMap.get(object2);
                bytecodeBuffer.writeBytes(((ByteArray)object).b, ((ByteArray)object).start, ((ByteArray)object).end);
            }
        }

        void writeTo(OutputStream outputStream) throws IOException {
            BytecodeBuffer bytecodeBuffer = new BytecodeBuffer(this.size());
            this.writeTo(bytecodeBuffer);
            bytecodeBuffer.writeTo(outputStream);
        }
    }
}

