/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import macromedia.abc.AbcParser;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.semantics.CodeGenerator;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.UnresolvedNamespace;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.Names;
import macromedia.asc.util.StringPrintWriter;
import macromedia.asc.util.graph.Algorithms;
import macromedia.asc.util.graph.DependencyGraph;
import macromedia.asc.util.graph.Graph;
import macromedia.asc.util.graph.Vertex;
import macromedia.asc.util.graph.Visitor;

public class BatchCompiler {
    private static List<File> file;
    private static List<Context> cx;
    private static List<ActionBlockEmitter> emitter;
    private static List<ProgramNode> node;
    private static List<FlowAnalyzer> fa;
    private static Set<Pair> inheritance;
    private static Set<Pair> type;
    private static ContextStatics s;

    public static void main(String[] stringArray) throws Throwable {
        long l = System.currentTimeMillis();
        BatchCompiler.init(stringArray);
        int n = 0;
        int n2 = file.size();
        while (n < n2) {
            BatchCompiler.parse(n, n2);
            BatchCompiler.fa_part1(n, n2);
            BatchCompiler.resolveInheritance(n, n2);
            n = n2;
            n2 = file.size();
            if (n < n2) continue;
            BatchCompiler.sortInheritance();
            BatchCompiler.fa_part2();
            BatchCompiler.resolveType();
            n = n2;
            n2 = file.size();
            if (n < n2) continue;
            BatchCompiler.importType();
            BatchCompiler.ce();
            BatchCompiler.cg();
            BatchCompiler.resolveExpression();
            n = n2;
            n2 = file.size();
        }
        BatchCompiler.clear();
        System.err.println("Files: " + file.size() + " Time: " + (System.currentTimeMillis() - l) + "ms");
    }

    private static void init(String[] stringArray) throws Throwable {
        int n;
        TypeValue.init();
        ObjectValue.init();
        s = new ContextStatics();
        file = new ArrayList<File>(stringArray.length);
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            File file = new File(stringArray[n]);
            if (!file.exists() || !file.isFile()) continue;
            BatchCompiler.file.add(file.getCanonicalFile());
        }
        cx = new ArrayList<Context>(file.size());
        n2 = file.size();
        for (n = 0; n < n2; ++n) {
            cx.add(new Context(s));
        }
        emitter = new ArrayList<ActionBlockEmitter>(file.size());
        n2 = file.size();
        for (n = 0; n < n2; ++n) {
            emitter.add(new ActionBlockEmitter(cx.get(n), file.get(n).getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, false));
        }
        node = new ArrayList<ProgramNode>(file.size());
        fa = new ArrayList<FlowAnalyzer>(file.size());
        inheritance = new HashSet<Pair>();
        type = new HashSet<Pair>();
    }

    private static void parse(int n, int n2) throws Throwable {
        for (int i = n; i < n2; ++i) {
            cx.get(i).setEmitter(emitter.get(i));
            cx.get(i).setScriptName(file.get(i).getName());
            cx.get(i).setPath(file.get(i).getParent());
            if (file.get(i).getName().endsWith(".as")) {
                node.add(new Parser(cx.get(i), new FileInputStream(file.get(i)), file.get(i).getPath(), null).parseProgram());
            } else {
                node.add(new AbcParser(cx.get(i), file.get(i).getPath()).parseAbc());
            }
            BatchCompiler.cx.get((int)i).getNodeFactory().pkg_defs.clear();
        }
    }

    private static void fa_part1(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (cx.get(i).errorCount() != 0 || BatchCompiler.node.get((int)i).state != 1) continue;
            cx.get(i).pushScope(new ObjectValue(cx.get(i), new GlobalBuilder(), null));
            FlowGraphEmitter flowGraphEmitter = new FlowGraphEmitter(cx.get(i), file.get(i).getPath(), false);
            fa.add(new FlowAnalyzer(flowGraphEmitter));
            node.get(i).evaluate(cx.get(i), fa.get(i));
            cx.get(i).popScope();
        }
    }

    private static void resolveInheritance(int n, int n2) throws Throwable {
        for (int i = n; i < n2; ++i) {
            Iterator<ReferenceValue> iterator = BatchCompiler.node.get((int)i).fa_unresolved.iterator();
            while (iterator.hasNext()) {
                int n3;
                ReferenceValue referenceValue = iterator.next();
                boolean bl = false;
                int n4 = n3 = referenceValue.getImmutableNamespaces() != null ? referenceValue.getImmutableNamespaces().size() : 0;
                for (int j = 0; j < n3; ++j) {
                    Pair pair;
                    QName qName = new QName((ObjectValue)referenceValue.getImmutableNamespaces().get(j), referenceValue.name);
                    int n5 = BatchCompiler.findClass(qName);
                    if (n5 == -1) continue;
                    if (i != n5 && !inheritance.contains(pair = new Pair(i, n5))) {
                        inheritance.add(pair);
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                System.err.println(referenceValue.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            BatchCompiler.node.get((int)i).fa_unresolved.clear();
        }
    }

    private static void sortInheritance() throws Throwable {
        ArrayList<ProgramNode> arrayList;
        Object object;
        Object object2;
        Object object3 = inheritance.iterator();
        while (object3.hasNext()) {
            Pair pair = object3.next();
            if (pair.processed) continue;
            fa.get(pair.i).inheritSlots(BatchCompiler.node.get((int)pair.where).frame, BatchCompiler.node.get((int)pair.i).frame, BatchCompiler.node.get((int)pair.i).frame.builder, cx.get(pair.i));
            pair.processed = true;
        }
        object3 = new DependencyGraph();
        int n = node.size();
        for (int i = 0; i < n; ++i) {
            object2 = file.get(i).getPath();
            ((DependencyGraph)object3).put((String)object2, Boxing.valueOf(i));
            if (!((DependencyGraph)object3).containsVertex((String)object2)) {
                ((DependencyGraph)object3).addVertex(new Vertex<String>((String)object2));
            }
            object = inheritance.iterator();
            while (object.hasNext()) {
                arrayList = object.next();
                if (((Pair)((Object)arrayList)).i != i) continue;
                ((DependencyGraph)object3).addDependency((String)object2, file.get(((Pair)((Object)arrayList)).where).getPath());
            }
        }
        final ArrayList arrayList2 = new ArrayList(node.size());
        Algorithms.topologicalSort((Graph)object3, new Visitor<String>((DependencyGraph)object3){
            final /* synthetic */ DependencyGraph val$g;
            {
                this.val$g = dependencyGraph;
            }

            @Override
            public void visit(Vertex<String> vertex) {
                String string = vertex.getWeight();
                arrayList2.add(this.val$g.get(string));
            }
        });
        if (node.size() > arrayList2.size()) {
            int n2 = node.size();
            for (n = 0; n < n2; ++n) {
                int n3;
                for (n3 = 0; n3 < arrayList2.size() && (Integer)arrayList2.get(n3) != n; ++n3) {
                }
                if (n3 != arrayList2.size()) continue;
                arrayList = file.get(n).getPath();
                System.out.println(arrayList + " in circular reference");
            }
        } else {
            int n4;
            int n5;
            ArrayList<File> arrayList3 = new ArrayList<File>(file.size());
            object2 = new ArrayList(cx.size());
            object = new ArrayList(emitter.size());
            arrayList = new ArrayList<ProgramNode>(node.size());
            ArrayList<FlowAnalyzer> arrayList4 = new ArrayList<FlowAnalyzer>(fa.size());
            int n6 = arrayList2.size();
            for (int i = 0; i < n6; ++i) {
                n5 = (Integer)arrayList2.get(i);
                arrayList3.add(file.get(n5));
                object2.add(cx.get(n5));
                object.add(emitter.get(n5));
                arrayList.add(node.get(n5));
                arrayList4.add(fa.get(n5));
            }
            file = arrayList3;
            cx = object2;
            emitter = object;
            node = arrayList;
            fa = arrayList4;
            Iterator<Pair> iterator = type.iterator();
            block6: while (iterator.hasNext()) {
                Pair pair = iterator.next();
                n4 = arrayList2.size();
                for (n5 = 0; n5 < n4; ++n5) {
                    if ((Integer)arrayList2.get(n5) != pair.i) continue;
                    pair.i = n5;
                    break;
                }
                n4 = arrayList2.size();
                for (n5 = 0; n5 < n4; ++n5) {
                    if ((Integer)arrayList2.get(n5) != pair.where) continue;
                    pair.where = n5;
                    continue block6;
                }
            }
            iterator = inheritance.iterator();
            block9: while (iterator.hasNext()) {
                Pair pair = iterator.next();
                n4 = arrayList2.size();
                for (n5 = 0; n5 < n4; ++n5) {
                    if ((Integer)arrayList2.get(n5) != pair.i) continue;
                    pair.i = n5;
                    break;
                }
                n4 = arrayList2.size();
                for (n5 = 0; n5 < n4; ++n5) {
                    if ((Integer)arrayList2.get(n5) != pair.where) continue;
                    pair.where = n5;
                    continue block9;
                }
            }
        }
    }

    private static void fa_part2() {
        int n = file.size();
        for (int i = 0; i < n; ++i) {
            if (cx.get(i).errorCount() != 0 || BatchCompiler.node.get((int)i).state != 2) continue;
            cx.get(i).pushScope(BatchCompiler.node.get((int)i).frame);
            node.get(i).evaluate(cx.get(i), fa.get(i));
            cx.get(i).popScope();
        }
    }

    private static void resolveType() throws Throwable {
        Pair pair;
        int n;
        QName qName;
        int n2;
        int n3;
        boolean bl;
        ReferenceValue referenceValue;
        Iterator<ReferenceValue> iterator;
        int n4;
        int n5 = node.size();
        for (n4 = 0; n4 < n5; ++n4) {
            iterator = BatchCompiler.node.get((int)n4).ce_unresolved.iterator();
            while (iterator.hasNext()) {
                referenceValue = iterator.next();
                bl = false;
                int n6 = n3 = referenceValue.getImmutableNamespaces() != null ? referenceValue.getImmutableNamespaces().size() : 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    qName = new QName((ObjectValue)referenceValue.getImmutableNamespaces().get(n2), referenceValue.name);
                    n = BatchCompiler.findClass(qName);
                    if (n == -1) continue;
                    if (n4 != n && !type.contains(pair = new Pair(n4, n))) {
                        type.add(pair);
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                System.err.println(referenceValue.toMultiName() + " in " + file.get(n4) + " not resolved");
            }
            BatchCompiler.node.get((int)n4).ce_unresolved.clear();
        }
        n5 = node.size();
        for (n4 = 0; n4 < n5; ++n4) {
            iterator = BatchCompiler.node.get((int)n4).body_unresolved.iterator();
            while (iterator.hasNext()) {
                referenceValue = iterator.next();
                bl = false;
                int n7 = n3 = referenceValue.getImmutableNamespaces() != null ? referenceValue.getImmutableNamespaces().size() : 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    qName = new QName((ObjectValue)referenceValue.getImmutableNamespaces().get(n2), referenceValue.name);
                    n = BatchCompiler.findClass(qName);
                    if (n == -1) continue;
                    if (n4 != n && !type.contains(pair = new Pair(n4, n))) {
                        type.add(pair);
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                System.err.println(referenceValue.toMultiName() + " in " + file.get(n4) + " not resolved");
            }
            BatchCompiler.node.get((int)n4).body_unresolved.clear();
        }
        n5 = node.size();
        for (n4 = 0; n4 < n5; ++n4) {
            iterator = BatchCompiler.node.get((int)n4).ns_unresolved.iterator();
            while (iterator.hasNext()) {
                referenceValue = iterator.next();
                bl = false;
                int n8 = n3 = referenceValue.getImmutableNamespaces() != null ? referenceValue.getImmutableNamespaces().size() : 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    qName = new QName((ObjectValue)referenceValue.getImmutableNamespaces().get(n2), referenceValue.name);
                    n = BatchCompiler.findDefinition(qName);
                    if (n == -1) continue;
                    if (n4 != n && !type.contains(pair = new Pair(n4, n))) {
                        type.add(pair);
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                System.err.println(referenceValue.toMultiName() + " in " + file.get(n4) + " not resolved");
            }
            BatchCompiler.node.get((int)n4).ns_unresolved.clear();
        }
    }

    private static void importType() throws Throwable {
        Iterator<Pair> iterator = type.iterator();
        while (iterator.hasNext()) {
            Pair pair = iterator.next();
            if (pair.processed) continue;
            if (!inheritance.contains(pair)) {
                fa.get(pair.i).inheritSlots(BatchCompiler.node.get((int)pair.where).frame, BatchCompiler.node.get((int)pair.i).frame, BatchCompiler.node.get((int)pair.i).frame.builder, cx.get(pair.i));
            }
            pair.processed = true;
        }
    }

    private static void ce() {
        int n = file.size();
        for (int i = 0; i < n; ++i) {
            if (cx.get(i).errorCount() != 0 || !file.get(i).getName().endsWith(".as") || emitter.get(i) == null) continue;
            cx.get(i).pushScope(BatchCompiler.node.get((int)i).frame);
            ConstantEvaluator constantEvaluator = new ConstantEvaluator(cx.get(i));
            node.get(i).evaluate(cx.get(i), constantEvaluator);
            cx.get(i).popScope();
        }
    }

    private static void cg() throws Throwable {
        int n = file.size();
        for (int i = 0; i < n; ++i) {
            if (cx.get(i).errorCount() != 0 || !file.get(i).getName().endsWith(".as") || emitter.get(i) == null) continue;
            cx.get(i).setEmitter(emitter.get(i));
            cx.get(i).pushScope(BatchCompiler.node.get((int)i).frame);
            CodeGenerator codeGenerator = new CodeGenerator(cx.get(i).getEmitter());
            node.get(i).evaluate(cx.get(i), codeGenerator);
            ByteList byteList = new ByteList();
            cx.get(i).getEmitter().emit(byteList);
            emitter.set(i, null);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(file.get(i).getParentFile(), file.get(i).getName().substring(0, file.get(i).getName().length() - "as".length()) + "abc"));
            System.err.println(file.get(i).getName() + ": " + byteList.size());
            fileOutputStream.write(byteList.toByteArray());
            fileOutputStream.flush();
            fileOutputStream.close();
            cx.get(i).popScope();
        }
    }

    private static void resolveExpression() throws Throwable {
        int n = node.size();
        for (int i = 0; i < n; ++i) {
            Iterator<ReferenceValue> iterator = BatchCompiler.node.get((int)i).rt_unresolved.iterator();
            while (iterator.hasNext()) {
                int n2;
                ReferenceValue referenceValue = iterator.next();
                boolean bl = false;
                int n3 = n2 = referenceValue.getImmutableNamespaces() != null ? referenceValue.getImmutableNamespaces().size() : 0;
                for (int j = 0; j < n2; ++j) {
                    QName qName = new QName((ObjectValue)referenceValue.getImmutableNamespaces().get(j), referenceValue.name);
                    if (qName.ns instanceof UnresolvedNamespace && ((UnresolvedNamespace)qName.ns).resolved) {
                        bl = true;
                        break;
                    }
                    int n4 = BatchCompiler.findDefinition(qName);
                    if (n4 == -1) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                System.err.println(referenceValue.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            BatchCompiler.node.get((int)i).rt_unresolved.clear();
        }
    }

    private static void clear() {
        s.clear();
        ObjectValue.clear();
        TypeValue.clear();
    }

    private static int findDefinition(QName qName) throws Throwable {
        int n = node.size();
        for (int i = 0; i < n; ++i) {
            Names names = BatchCompiler.node.get((int)i).frame.builder.getNames();
            for (int j = 0; j < 4; ++j) {
                if (!names.containsKey(qName.name, qName.ns, j)) continue;
                return i;
            }
        }
        return BatchCompiler.searchClasspath(qName);
    }

    private static int findClass(QName qName) throws Throwable {
        int n = node.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = BatchCompiler.node.get((int)i).clsdefs != null ? BatchCompiler.node.get((int)i).clsdefs.size() : 0;
            for (int j = 0; j < n2; ++j) {
                ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)BatchCompiler.node.get((int)i).clsdefs.get(j);
                if (!classDefinitionNode.cframe.builder.classname.equals(qName)) continue;
                return i;
            }
        }
        return BatchCompiler.searchClasspath(qName);
    }

    private static int searchClasspath(QName qName) throws Throwable {
        String string = qName.ns.name.replace('.', File.separatorChar) + File.separatorChar + qName.name;
        File file = new File(string + ".as");
        if (file.exists() && file.isFile()) {
            file = file.getCanonicalFile();
            Context context = new Context(s);
            int n = BatchCompiler.file.indexOf(file);
            if (n == -1) {
                BatchCompiler.file.add(file);
                cx.add(context);
                emitter.add(new ActionBlockEmitter(context, file.getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, false));
                n = BatchCompiler.file.size() - 1;
            }
            return n;
        }
        return -1;
    }

    static class Pair {
        int i;
        int where;
        boolean processed;

        Pair(int n, int n2) {
            this.i = n;
            this.where = n2;
            this.processed = false;
        }

        public boolean equals(Object object) {
            if (object instanceof Pair) {
                return this.i == ((Pair)object).i && this.where == ((Pair)object).where;
            }
            return false;
        }

        public int hashCode() {
            return (17 + this.i) * 17 + this.where;
        }
    }
}

