/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;

public class SetExpressionNode
extends SelectorNode {
    public ArgumentListNode args;
    public TypeInfo value_type;
    public boolean is_constinit;
    public boolean is_initializer;
    public BitSet gen_bits;
    public boolean void_result;

    public ReferenceValue getRef(Context context) {
        return this.ref;
    }

    public SetExpressionNode(Node node, ArgumentListNode argumentListNode) {
        this.expr = node;
        this.args = argumentListNode;
        this.ref = null;
        this.gen_bits = null;
        this.void_result = false;
        this.is_constinit = false;
        this.is_initializer = false;
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    public void voidResult() {
        this.void_result = true;
        this.expr.voidResult();
    }

    public boolean isSetExpression() {
        return true;
    }

    public boolean isQualified() {
        QualifiedIdentifierNode qualifiedIdentifierNode;
        QualifiedIdentifierNode qualifiedIdentifierNode2 = qualifiedIdentifierNode = this.expr instanceof QualifiedIdentifierNode ? (QualifiedIdentifierNode)this.expr : null;
        return qualifiedIdentifierNode != null ? qualifiedIdentifierNode.qualifier != null : false;
    }

    public boolean isAttributeIdentifier() {
        return this.expr instanceof IdentifierNode ? ((IdentifierNode)this.expr).isAttr() : false;
    }

    public boolean isAny() {
        return this.expr instanceof IdentifierNode ? ((IdentifierNode)this.expr).isAny() : false;
    }

    public BitSet getGenBits() {
        return this.gen_bits;
    }

    public BitSet getKillBits() {
        if (this.ref != null && this.ref.slot != null) {
            if (this.ref.slot.getDefBits() != null) {
                return BitSet.xor(this.ref.slot.getDefBits(), this.gen_bits);
            }
            return this.gen_bits;
        }
        return null;
    }

    public String toString() {
        return "SetExpression";
    }

    public boolean hasSideEffect() {
        return true;
    }
}

