/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

public class ADFMathUtils {
    static final int ADF_N_EXP_BITS = 5;
    static final int ADF_N_MAN_BITS = 10;
    static final int ADF_MAX_EXP_VAL = 31;
    static final int ADF_EXP_BIAS = 16;
    static final int ADF_SGN_MASK = 32768;
    static final int ADF_EXP_MASK = 31744;
    static final int ADF_MAN_MASK = 1023;
    static final int ADF_MAN_SCALE = 1024;

    static float ADF_ABS(float a) {
        return a < 0.0f ? -a : a;
    }

    static float ADF_MIN(float a, float b) {
        return a < b ? a : b;
    }

    static float ADF_MAX(float a, float b) {
        return a > b ? a : b;
    }

    static void ADF_SERIALIZE_U16(long[] pDstU8, int arrNum, int shift1, int shift2, int srcU16) {
        int n = arrNum;
        pDstU8[n] = pDstU8[n] + (long)((srcU16 & 0xFF) << shift1);
        int n2 = arrNum;
        pDstU8[n2] = pDstU8[n2] + (long)(srcU16 >> 8 << shift2);
    }

    static long ADF_DESERIALIZE_U16(long[] pSrcU8, int arrNum, int shift1, int shift2) {
        long lsByte = pSrcU8[arrNum] >> shift1 & 0xFFL;
        long msByte = pSrcU8[arrNum] >> shift2 & 0xFFL;
        return msByte << 8 | lsByte;
    }

    static int ADF_SERIALIZE_U32(int srcU32) {
        int num = srcU32 & 0xFF;
        num += (srcU32 >> 8 & 0xFF) << 8;
        num += (srcU32 >> 16 & 0xFF) << 16;
        return num += (srcU32 >> 24 & 0xFF) << 24;
    }

    static int ADF_DESERIALIZE_U32(int pSrcU8) {
        int byte0 = pSrcU8 & 0xFF;
        int byte1 = pSrcU8 >> 8 & 0xFF;
        int byte2 = pSrcU8 >> 16 & 0xFF;
        int byte3 = pSrcU8 >> 24 & 0xFF;
        return byte3 << 24 | byte2 << 16 | byte1 << 8 | byte0;
    }

    static ADFPackF32Result ADFPackF32(float value) {
        ADFPackF32Result result = new ADFPackF32Result();
        if (value == 0.0f) {
            result.packedValue = 0;
            return result;
        }
        FloatingPointValue fVal = new FloatingPointValue(value);
        ADFMathUtils.frexp(fVal);
        double mantissa = fVal.mantissa;
        int exp = fVal.exp;
        int biasedExp = exp + 16;
        if (biasedExp < 0) {
            result.packedValue = 0;
            result.tooSmall = true;
            return result;
        }
        if (biasedExp > 31) {
            result.tooLarge = true;
            return result;
        }
        if (mantissa >= 0.0) {
            result.packedValue = 0;
        } else {
            mantissa *= -1.0;
            result.packedValue = 32768;
        }
        result.packedValue |= biasedExp << 10;
        result.packedValue |= (char)(mantissa * 1024.0);
        return result;
    }

    static float ADFUnpackF32(long value) {
        double sign = (value & 0x8000L) == 1L ? -1.0 : 1.0;
        int exp = (int)((value & 0x7C00L) >> 10) - 16;
        double mantissa = (double)(value & 0x3FFL) / 1024.0;
        FloatingPointValue fVal = new FloatingPointValue(mantissa, exp);
        ADFMathUtils.ldexp(fVal);
        return (float)(sign * fVal.value);
    }

    static RootValue ADFGetRealQuadraticRoots(double c) {
        return ADFMathUtils.ADFGetRealQuadraticRoots(new double[]{c, 0.0, 0.0});
    }

    static RootValue ADFGetRealQuadraticRoots(double[] c) {
        double A = c[2];
        double B = c[1];
        double C = c[0];
        if (A == 0.0) {
            if (B == 0.0) {
                return new RootValue(0);
            }
            RootValue val = new RootValue(1);
            val.roots = new double[]{-C / B};
            return val;
        }
        double d = B * B - 4.0 * A * C;
        if (d == 0.0) {
            RootValue val = new RootValue(1);
            val.roots = new double[]{-0.5 * B / A};
            return val;
        }
        if (d > 0.0) {
            d = Math.sqrt(d);
            double q = (-B + (B < 0.0 ? -d : d)) * 0.5;
            RootValue val = new RootValue(2);
            val.roots = new double[]{q / A, C / q};
            return val;
        }
        return new RootValue(0);
    }

    static RootValue ADFGetRealCubicRoots(double[] c) {
        if (c[3] == 0.0) {
            return ADFMathUtils.ADFGetRealQuadraticRoots(c);
        }
        if (c[0] == 0.0) {
            RootValue val = ADFMathUtils.ADFGetRealQuadraticRoots(c[1]);
            double[] newArr = new double[val.num + 1];
            if (val.roots != null) {
                System.arraycopy(val.roots, 0, newArr, 0, val.num);
            }
            newArr[val.num] = 0.0;
            val.roots = newArr;
            ++val.num;
            return val;
        }
        double oneThird = 0.3333333333333333;
        double inv = 1.0 / c[3];
        double A = c[2] * inv;
        double B = c[1] * inv;
        double C = c[0] * inv;
        double sub = A * oneThird;
        double ASqu = A * A;
        double q = (2.0 * A * ASqu / 27.0 - A * B * oneThird + C) * 0.5;
        double p = (-ASqu * oneThird + B) * oneThird;
        double pCube = p * p * p;
        double D = q * q + pCube;
        if (D == 0.0) {
            if (q == 0.0) {
                RootValue val = new RootValue(1);
                val.roots = new double[]{0.0 - sub};
                return val;
            }
            double u = q > 0.0 ? -Math.pow(q, oneThird) : Math.pow(-q, oneThird);
            RootValue val = new RootValue(2);
            val.roots = new double[]{2.0 * u - sub, -u - sub};
            return val;
        }
        if (D < 0.0) {
            double oneThirdPI = 1.0471975511965979;
            double phi = Math.acos(-q / Math.sqrt(-pCube)) * oneThird;
            double temp = 2.0 * Math.sqrt(-p);
            RootValue val = new RootValue(3);
            val.roots = new double[]{temp * Math.cos(phi) - sub, -temp * Math.cos(phi + oneThirdPI) - sub, -temp * Math.cos(phi - oneThirdPI) - sub};
            return val;
        }
        double d = Math.sqrt(D);
        double u = d - q < 0.0 ? -Math.pow(-(d - q), oneThird) : Math.pow(d - q, oneThird);
        double v = d + q < 0.0 ? -Math.pow(-(d + q), oneThird) : Math.pow(d + q, oneThird);
        RootValue val = new RootValue(1);
        val.roots = new double[]{u - v - sub};
        return val;
    }

    public static void frexp(FloatingPointValue val) {
        long longBits = Double.doubleToLongBits(val.value);
        if (val.value == 0.0) {
            val.exp = 0;
            val.mantissa = 0.0;
        } else {
            val.mantissa = Double.longBitsToDouble(0x800FFFFFFFFFFFFFL & longBits | 0x3FE0000000000000L);
            val.exp = (int)(((0x7FF0000000000000L & longBits) >> 52) - 1022L);
        }
    }

    public static void ldexp(FloatingPointValue val) {
        val.value = val.mantissa * Math.pow(2.0, val.exp);
    }

    public static class FloatingPointValue {
        public double value;
        public double mantissa;
        public int exp;

        public FloatingPointValue(double value) {
            this.value = value;
        }

        public FloatingPointValue(double mantissa, int exp) {
            this.mantissa = mantissa;
            this.exp = exp;
        }
    }

    static class RootValue {
        int num;
        double[] roots;

        RootValue(int n) {
            this.num = n;
        }
    }

    static class ADFPackF32Result {
        int packedValue;
        boolean tooSmall;
        boolean tooLarge;

        ADFPackF32Result() {
        }
    }
}

